#ifndef Test_h
#include "Test.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef std_fstream
#define std_fstream
#include <fstream>
#endif

using namespace doctorj;

static void spew(const string& name, AstItem* const item, int indent = 0)
{
    while (--indent >= 0) {
        cout << "    ";
    }
    cout << name << " = " << item->type() << " (" << item->text() << ")" << endl;
}

class JavaSymbolReaderTest : public Test 
{
public:
    JavaSymbolReaderTest();
    virtual void run();
    virtual void testBasic();
    virtual void testCmdLine(int argc, char** argv);
    virtual void testSingleFile(const string& fname);
};

JavaSymbolReaderTest::JavaSymbolReaderTest() : Test(true)
{
}

void JavaSymbolReaderTest::testSingleFile(const string& fname)
{
    vector<char*> files;
    files.push_back(const_cast<char*>(fname.c_str()));
    AstProject project(1.3, files);
    
    JavaSymbolReader jsr;
    AstCompilationUnit* cu = project.getCompilationUnit(0);
    JavaSymbolTable*    st = jsr.processCompilationUnit(cu);

    st->printAll(cout);
}

void JavaSymbolReaderTest::testBasic()
{
    // write out a file
    string cname("JSymTestLocalVariable");
    string fname("/tmp/" + cname + ".java");
    ofstream of(fname.c_str());
    of << "public class " << cname << " {" << endl;
    of << "    public " << cname << "(int a) {" << endl;
    of << "        int i = 4;" << endl;
    of << "    }" << endl;
    of << "}" << endl;
    of.close();

    testSingleFile(fname);
}

void JavaSymbolReaderTest::testCmdLine(int argc, char** argv)
{
    for (int i = 1; i < argc; ++i) {
        cout << "testCmdLine... #" << i << ": " << argv[i] << endl;
        string str(argv[i]);
        testSingleFile(str);
    }
}

void JavaSymbolReaderTest::run() 
{
    testBasic();
}

int main(int argc, char** argv) 
{
    JavaSymbolReaderTest t;
    t.run();
    if (argc > 0) {
        t.testCmdLine(argc, argv);
    }
    cout << "symbol reader test results: " << t << endl;
    return t.nerrors();
}
