#ifndef DoctorJ_h
#define DoctorJ_h

#ifndef App_h
#include "App.h"
#endif

#ifndef SyntaxAnalyzer_h
#include "SyntaxAnalyzer.h"
#endif

#ifndef DocumentationAnalyzerApp_h
#include "DocumentationAnalyzerApp.h"
#endif

#ifndef StatisticsAnalyzerApp_h
#include "StatisticsAnalyzerApp.h"
#endif

#ifndef AstPrinter_h
#include "AstPrinter.h"
#endif

namespace doctorj 
{
    class DoctorJ : public App
    {
    public:
        DoctorJ();

        virtual ~DoctorJ();

        virtual void addOptions(yagol::AppOptionSet* const opts);

        virtual void execute(AstProject* const proj);

    private:

        bool checkDoc_;
        
        bool checkStats_;

        bool checkSyntax_;

        bool printAST_;

        DocumentationAnalyzerApp docChecker_;
    
        StatisticsAnalyzerApp statsAnalyzer_;

        SyntaxAnalyzerApp syntaxAnalyzer_;
        
        AstPrinter astPrinter_;

    };
}

#endif //! DoctorJ_h
