#ifndef InnerTypeStatistics_h
#define InnerTypeStatistics_h

#ifndef Statistics_h
#include "Statistics.h"
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

using namespace std;

namespace doctorj
{
    class InnerTypeStatistics : public Statistics
    {
    public:

        InnerTypeStatistics(const string& name, int nLines);

        virtual ~InnerTypeStatistics();

        void addStaticMethod(int nLines);

        void addInstanceMethod(int nLines);

        void addStaticField();

        void addInstanceField();

        void addStaticFields(int count);

        void addInstanceFields(int count);

        int getStaticMethodsCount() const;

        int getInstanceMethodsCount() const;

        int getStaticFieldsCount() const;

        int getInstanceFieldsCount() const;

        int getConcreteClassesCount() const;

        int getAbstractClassesCount() const;

        int getInterfacesCount() const;

        vector<int> getMethods() const;

        virtual const vector<InnerTypeStatistics*>& innerTypes() const;

        virtual void addInnerType(InnerTypeStatistics* const cts);

    private:
        
        vector<InnerTypeStatistics*> containedTypes_;

        string name_;

        vector<int> methods_;

        int nStaticMethods_;

        int nInstanceMethods_;

        int nStaticFields_;

        int nInstanceFields_;

    };
}

#endif //! InnerTypeStatistics_h
