#ifndef ProjectStatistics_h
#include "ProjectStatistics.h"
#endif

#ifndef CompilationUnitStatistics_h
#include "CompilationUnitStatistics.h"
#endif

using namespace doctorj;

ProjectStatistics::ProjectStatistics()
{
}

ProjectStatistics::~ProjectStatistics()
{
    vector<CompilationUnitStatistics*>::iterator it   = cus_.begin();
    vector<CompilationUnitStatistics*>::iterator stop = cus_.end();
    while (it != stop) {
        CompilationUnitStatistics* cus = *it;
        delete cus;
        ++it;
    }
}

int ProjectStatistics::getFilesCount() const
{
    return cus_.size();
}

const vector<CompilationUnitStatistics*>& ProjectStatistics::getCompilationUnitsStatistics() const
{
    return cus_;
}

void ProjectStatistics::addCompilationUnit(CompilationUnitStatistics* const cu)
{
    cus_.push_back(cu);
}
