#ifndef ErrorAbstractModifierUsedForInterface_h
#include "ErrorAbstractModifierUsedForInterface.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

using namespace doctorj;

REGISTER_DESCRIPTION(ErrorAbstractModifierUsedForInterface);

ErrorAbstractModifierUsedForInterface::ErrorAbstractModifierUsedForInterface()
{
}

ErrorAbstractModifierUsedForInterface::ErrorAbstractModifierUsedForInterface(Reporter* const reporter, AstInterfaceDeclaration* const id) :
        SyntaxError(reporter, id->getIdentifier()), 
     interface_(id->getIdentifier()->text())
{
}

ErrorAbstractModifierUsedForInterface::~ErrorAbstractModifierUsedForInterface()
{
}

string ErrorAbstractModifierUsedForInterface::title() const
{
    return "Abstract Specified for Interface";
}

void ErrorAbstractModifierUsedForInterface::writeDescription(ostream& os) const
{
    os << "The abstract modifier is redundant for an interface." << endl;
}

string ErrorAbstractModifierUsedForInterface::message() const
{
    return "interface '" + interface_ + "' was unnecessarily specified as abstract";
}
