#ifndef ErrorExplicitBooleanInConditional_h
#define ErrorExplicitBooleanInConditional_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class AstEqualityExpression;

    class ErrorExplicitBooleanInConditional : public SyntaxError 
    {
    public:
        
        ErrorExplicitBooleanInConditional();

        /**
         * Creates the error.
         */
        ErrorExplicitBooleanInConditional(Reporter* const reporter, AstEqualityExpression* const ee);

        virtual ~ErrorExplicitBooleanInConditional();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

        /**
         * Returns the type, capitalized.
         */
        virtual string getType() const = 0;

    };

}

#endif //! ErrorExplicitBooleanInConditional_h
