#ifndef ErrorIfStatementsReversed_h
#define ErrorIfStatementsReversed_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj
{
    class AstIfThenElseStatement;

    class ErrorIfStatementsReversed : public SyntaxError
    {
    public:
        ErrorIfStatementsReversed();

        ErrorIfStatementsReversed(Reporter* const reporter, 
                                  AstIfThenElseStatement* const stmt);

        virtual ~ErrorIfStatementsReversed();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    };

}

#endif //! ErrorIfStatementsReversed_h
