#ifndef ErrorMethodPackageAccess_h
#define ErrorMethodPackageAccess_h

#ifndef ErrorPackageAccess_h
#include "ErrorPackageAccess.h"
#endif

namespace doctorj 
{
    class AstMethodHeader;

    class ErrorMethodPackageAccess : public ErrorPackageAccess 
    {
    public:
        ErrorMethodPackageAccess();

        /**
         * Creates the error for the method.
         */
        ErrorMethodPackageAccess(Reporter* const reporter, AstMethodHeader* const mh);

        virtual ~ErrorMethodPackageAccess();

        /**
         * Returns what type of thing this refers to, in lowercase format.
         */
        virtual string typeAsLowercase() const;

        /**
         * Returns what type of thing this refers to, in capitalized format.
         */
        virtual string typeAsCapitalized() const;
        
    };
}

#endif //! ErrorMethodPackageAccess_h
