#ifndef ErrorModifiersOutOfOrder_h
#include "ErrorModifiersOutOfOrder.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

using namespace doctorj;

REGISTER_DESCRIPTION(ErrorModifiersOutOfOrder);

ErrorModifiersOutOfOrder::ErrorModifiersOutOfOrder()
{
}

ErrorModifiersOutOfOrder::ErrorModifiersOutOfOrder(Reporter* const reporter, AstItem* const item, 
                                                   AstItem* const current,
                                                   AstItem* const previous) :
        SyntaxError(reporter, item), current_(current), previous_(previous)
{
}

ErrorModifiersOutOfOrder::~ErrorModifiersOutOfOrder()
{
}

string ErrorModifiersOutOfOrder::title() const
{
    return "Modifiers Out of Order";
}

void ErrorModifiersOutOfOrder::writeDescription(ostream& os) const
{
    os << "The modifiers are not in the preferred order:" << endl;
    os << "     - access"    << endl;
    os << "     - static"    << endl;
    os << "     - final"     << endl;
    os << "     - transient" << endl;
    os << "     - volatile"  << endl;
}

string ErrorModifiersOutOfOrder::message() const
{
    return "modifiers not in the preferred order: " + current_->text() + " should precede " + previous_->text();
}
