#ifndef ErrorNoBreakInCaseStatement_h
#define ErrorNoBreakInCaseStatement_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class ErrorNoBreakInCaseStatement : public SyntaxError 
    {
    public:
        
        ErrorNoBreakInCaseStatement();

        /**
         * Creates the error.
         */
        ErrorNoBreakInCaseStatement(Reporter* const reporter, AstItem* const item);

        virtual ~ErrorNoBreakInCaseStatement();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    };

}

#endif //! ErrorNoBreakInCaseStatement_h
