#ifndef ErrorNoDefaultCase_h
#define ErrorNoDefaultCase_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class ErrorNoDefaultCase : public SyntaxError 
    {
    public:
        
        ErrorNoDefaultCase();

        /**
         * Creates the error.
         */
        ErrorNoDefaultCase(Reporter* const reporter, AstItem* const item);

        virtual ~ErrorNoDefaultCase();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    };

}

#endif //! ErrorNoDefaultCase_h
