#ifndef ErrorUninitializedStaticField_h
#include "ErrorUninitializedStaticField.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

using namespace doctorj;

REGISTER_DESCRIPTION(ErrorUninitializedStaticField);

ErrorUninitializedStaticField::ErrorUninitializedStaticField()
{
}

ErrorUninitializedStaticField::ErrorUninitializedStaticField(Reporter* const reporter, AstVariableDeclarator* const vd) :
        SyntaxError(reporter, vd), name_(vd->name())
{
}

ErrorUninitializedStaticField::~ErrorUninitializedStaticField()
{
}

string ErrorUninitializedStaticField::title() const
{
    return "Uninitialized Static Field";
}

void ErrorUninitializedStaticField::writeDescription(ostream& os) const
{
    os << "Static field is not initialized in declaration." << endl;
}

string ErrorUninitializedStaticField::message() const
{
    return "static field '" + name_ + "' is not initialized in the declaration";
}
