#ifndef ErrorUnnecessaryImport_h
#define ErrorUnnecessaryImport_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class AstImportDeclaration;

    class ErrorUnnecessaryImport : public SyntaxError 
    {
    public:
        
        ErrorUnnecessaryImport();

        /**
         * Creates the error.
         */
        ErrorUnnecessaryImport(Reporter* const reporter, AstImportDeclaration* const id);
        
        virtual ~ErrorUnnecessaryImport();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    private:

    };

}

#endif //! ErrorUnnecessaryImport_h
