#ifndef ErrorUselessThisInMethodInvocation_h
#include "ErrorUselessThisInMethodInvocation.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

using namespace doctorj;

REGISTER_DESCRIPTION(ErrorUselessThisInMethodInvocation);

ErrorUselessThisInMethodInvocation::ErrorUselessThisInMethodInvocation()
{
}

ErrorUselessThisInMethodInvocation::ErrorUselessThisInMethodInvocation(Reporter* const reporter, AstMethodInvocationPrimary* const mi) 
        : SyntaxError(reporter, mi), name_(mi->getIdentifier()->text())
{
}

ErrorUselessThisInMethodInvocation::~ErrorUselessThisInMethodInvocation()
{
}

string ErrorUselessThisInMethodInvocation::title() const
{
    return "Useless Use of This in Method Invocation";
}

void ErrorUselessThisInMethodInvocation::writeDescription(ostream& os) const
{
    os << "Useless use of this in method invocation. The statement has no effect." << endl;
}

string ErrorUselessThisInMethodInvocation::message() const
{
    return "method '" + name_ + "' does not require usage of 'this'";
}
