#ifndef NameChecker_h
#define NameChecker_h

#ifndef std_string
#define std_string
#include <string>
#endif

using namespace std;

namespace doctorj
{
    class AstLeaf;
    class Reporter;
    class AstVariableDeclaratorList;
    class Error;

    class NameChecker
    {
    public:
        NameChecker(Reporter* const rep,
                    AstVariableDeclaratorList* const vdl,
                    bool isStatic,
                    bool isFinal,
                    AstLeaf* const access);
        
        virtual ~NameChecker();

        virtual void check() const;

        AstVariableDeclaratorList* getVariableDeclaratorList() const;

        Reporter* getReporter() const;

        bool isStatic() const;
        
        bool isFinal() const;
        
        AstLeaf* getAccess() const;

    protected:
        template <class ErrorType>
        void runCheck(const string& pattern) const;

    private:
        AstVariableDeclaratorList* variableList_;

        Reporter* reporter_;

        bool isStatic_;
        
        bool isFinal_;
        
        AstLeaf* access_;
    };

}

#endif //! NameChecker_h
