#ifndef RuleImproperSequence_h
#include "RuleImproperSequence.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorImproperSequence_h
#include "ErrorImproperSequence.h"
#endif

#ifndef SequenceChecker_h
#include "SequenceChecker.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

RuleImproperSequence::RuleImproperSequence(Reporter* const reporter) : Rule(reporter)
{
    seqChk_ = SequenceChecker::get();
}

RuleImproperSequence::~RuleImproperSequence()
{
}


void RuleImproperSequence::process(AstInterfaceMemberDeclarationList* const im)
{
    SYNLOG("");

    SequenceChecker* sc = SequenceChecker::get();
    int nTypes = im->getInterfaceMemberDeclarationCount();
    AstItem* previous = NULL;
    for (int i = 0; i < nTypes; ++i) {
        AstNode* member = im->getInterfaceMemberDeclaration(i);
        compare(previous, member);
        previous = member;
    }

    traverse(im);
}

void RuleImproperSequence::process(AstClassBodyDeclarationList* const cb)
{
    SYNLOG("");

    SYNLOG("checking class body declaration type order ...");
    SequenceChecker* sc = SequenceChecker::get();
    int nTypes = cb->getClassBodyDeclarationCount();
    AstItem* previous = NULL;
    for (int i = 0; i < nTypes; ++i) {
        AstItem* item = cb->getClassBodyDeclaration(i);
        compare(previous, item);
        previous = item;
    }

    traverse(cb);
}

void RuleImproperSequence::compare(AstItem* const previous, AstItem* const current)
{
    SYNLOG(string("checking ") + current->type() + " against " + (previous ? previous->type() : "<<null>>"));

    if (!seqChk_->shouldFollow(current, previous)) {
        AstItem* dispItem = JavaItem::primaryItem(current);
        ErrorImproperSequence* err = new ErrorImproperSequence(reporter(), dispItem, previous, current);
        err->process();
    }
}
