#ifndef RuleNoDefaultCase_h
#include "RuleNoDefaultCase.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef ErrorNoDefaultCase_h
#include "ErrorNoDefaultCase.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

using namespace std;
using namespace doctorj;

RuleNoDefaultCase::RuleNoDefaultCase(Reporter* const reporter) : Rule(reporter)
{
}

RuleNoDefaultCase::~RuleNoDefaultCase()
{
}

void RuleNoDefaultCase::process(AstSwitchStatement* const ss)
{
    SYNLOG("");

    AstSwitchLabelDefault* sldef = JavaSwitchStatement::getFirstSwitchLabelDefault(ss);

    if (!sldef) {
        ErrorNoDefaultCase* err = new ErrorNoDefaultCase(reporter(), ss);
        err->process();
    }
    
    traverse(ss);
}
