#ifndef RuleObjectSubclassesCompared_h
#include "RuleObjectSubclassesCompared.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorObjectSubclassesCompared_h
#include "ErrorObjectSubclassesCompared.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef Reporter_h
#include "Reporter.h"
#endif

using namespace std;
using namespace doctorj;

// static AstItem* gleanType(AstItem* const vd)
// {
//     if (AstVariableDeclaratorAssign* assn = dynamic_cast<AstVariableDeclaratorAssign*>(vd)) {
//         SYNLOG("found assignment");
//         AstItem* vinit = assn->getVariableInitializer();
//         SYNLOGF("var init = %s", vinit->type().c_str());
//         if (AstClassInstanceCreationExpressionNameExprNoBody* cinst = dynamic_cast<AstClassInstanceCreationExpressionNameExprNoBody*>(vinit)) {
//             SYNLOG("got class instance creation expression (name, expr, no body)");
//             AstName* name = cinst->getName();
//             SYNLOGF("name = %s", name->text().c_str());
//             // return name->text();
//             return name;
//         }
// //         else if (AstStringLiteral* slit = dynamic_cast<AstStringLiteral*>(vinit)) {
// //             SYNLOG("got string literal");
// //             return "java.lang.String";
// //         }
//         else {
//             SYNLOG("did NOT got class instance creation expression (name, expr, no body)");
//             return vinit;
//         }
//     }
//     else {
//         SYNLOG("did NOT find assignment");
//         return NULL;
//     }
// }

RuleObjectSubclassesCompared::RuleObjectSubclassesCompared(Reporter* const reporter) : Rule(reporter)
{
}

RuleObjectSubclassesCompared::~RuleObjectSubclassesCompared()
{
}

void RuleObjectSubclassesCompared::process(AstEqualityExpression* const ee)
{
    SYNLOG("");

    AstItem* varType = NULL;

    AstItem* lhs = ee->getLhsExpression();
    AstName* lname = dynamic_cast<AstName*>(lhs);
    SYNLOGF("LNAME = %p", (void*)lname);
    SYNLOGF("LNAME type = %s", lname ? lname->type().c_str() : "<<none>>");
    varType = lname ? JavaSymbol::getVariableType(lname) : NULL;

    if (!varType) {
        AstItem* rhs = ee->getRhsExpression();
        AstName* rname = dynamic_cast<AstName*>(rhs);
        SYNLOGF("RNAME = %p", (void*)lname);
        SYNLOGF("RNAME type = %s", rname ? rname->type().c_str() : "<<none>>");
        varType = rname ? JavaSymbol::getVariableType(rname) : NULL;
    }
    
    if (varType) {
        SYNLOGF("type: %s", varType->type().c_str());
        SYNLOGF("type text: %s", varType->text().c_str());
        
        if (JavaGrammar::isPrimitiveType(varType)) {
            SYNLOG("type is primitive");
        }
        else {
            if (dynamic_cast<AstEqualityExpressionEq*>(ee)) {
                ErrorObjectSubclassesComparedWithEqEq* err = new ErrorObjectSubclassesComparedWithEqEq(reporter(), ee, varType->text());
                err->process();
            }
            else {
                ErrorObjectSubclassesComparedWithNotEq* err = new ErrorObjectSubclassesComparedWithNotEq(reporter(), ee, varType->text());
                err->process();
            }
        }
    }
    else {
        SYNLOG("no type found during lookup");
    }

    traverse(ee);
}

void RuleObjectSubclassesCompared::process(AstEqualityExpressionEq* const ee)
{
    process((AstEqualityExpression*)ee);
}

void RuleObjectSubclassesCompared::process(AstEqualityExpressionNe* const ee)
{
    process((AstEqualityExpression*)ee);
}

