#ifndef RuleUnreferencedImport_h
#define RuleUnreferencedImport_h

#ifndef Rule_h
#include "Rule.h"
#endif

#ifndef ImportList_h
#include "ImportList.h"
#endif

namespace doctorj
{
    class AstImportDeclaration;

    class RuleUnreferencedImport : public Rule
    {
    public:
        RuleUnreferencedImport(Reporter* const reporter);

        virtual ~RuleUnreferencedImport();

        // only traverse on those with imports.

        virtual void process(AstCompilationUnit* const cu);

        virtual void process(AstCompilationUnitEmpty* const cu);

        virtual void process(AstCompilationUnitImp* const cu);

        virtual void process(AstCompilationUnitImpTypes* const cu);

        virtual void process(AstCompilationUnitPkg* const cu);

        virtual void process(AstCompilationUnitPkgImp* const cu);

        virtual void process(AstCompilationUnitPkgImpTypes* const cu);

        virtual void process(AstCompilationUnitPkgTypes* const cu);

        virtual void process(AstCompilationUnitTypes* const cu);

        virtual void process(AstName* const name);

    private:
        ImportList imports_;

    };
}

#endif //! RuleUnreferencedImport_h
