#ifndef SequenceOrder_h
#define SequenceOrder_h

#ifndef std_string
#define std_string
#include <string>
#endif

using namespace std;

namespace doctorj
{
    class SequenceOrder
    {
    public:
        friend ostream& operator<<(ostream& os, const SequenceOrder& so);

        SequenceOrder();

        SequenceOrder(const string& access,
                      const string& finality,
                      const string& ownership,
                      const string& type,
                      const string& name);

        virtual ~SequenceOrder();

        /**
         * Returns the level of "matchness" that the parameters have against
         * this one.
         */
        virtual int matchValue(const string& access,
                               const string& finality,
                               const string& ownership,
                               const string& type,
                               const string& name) const;

    private:

        string access_;

        string finality_;

        string ownership_;

        string type_;
        
        string name_;

    };
        
}

#endif //! SequenceOrder_h
