#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleExplicitFalseInConditional_h
#include "RuleExplicitFalseInConditional.h"
#endif

#ifndef ErrorExplicitFalseInConditional_h
#include "ErrorExplicitFalseInConditional.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleExplicitFalseInConditional";

class RuleExplicitFalseInConditionalTest : 
    public RuleTest<ruleName, RuleExplicitFalseInConditional, ErrorExplicitFalseInConditional>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        std::vector<std::string> vec0;
        vec0.push_back("class RuleExplicitFalseInConditional {");
        vec0.push_back("    void foo(bool b) {");
        vec0.push_back("        if (b == false) {"); 
        vec0.push_back("        }"); 
        vec0.push_back("    }");
        vec0.push_back("}");
        contents->push_back(vec0);
                
        std::vector<std::string> vec1;
        vec1.push_back("class RuleExplicitFalseInConditional {");
        vec1.push_back("    void foo(bool b) {");
        vec1.push_back("        if (false == b) {"); 
        vec1.push_back("        }"); 
        vec1.push_back("    }");
        vec1.push_back("}");
        contents->push_back(vec1);
                
        std::vector<std::string> vec2;
        vec2.push_back("class RuleExplicitFalseInConditional {");
        vec2.push_back("    void foo(bool b) {");
        vec2.push_back("        if (b == (false)) {"); 
        vec2.push_back("        }"); 
        vec2.push_back("    }");
        vec2.push_back("}");
        contents->push_back(vec2);
    }
    
};

int main(int argc, char** argv) 
{
    RuleExplicitFalseInConditionalTest t;
    t.run();
    cout << "explicit false in test results: " << t << endl;
    return t.nerrors();
}
