#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleExplicitSuperCall_h
#include "RuleExplicitSuperCall.h"
#endif

#ifndef ErrorExplicitSuperCall_h
#include "ErrorExplicitSuperCall.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleExplicitSuperCall";

class RuleExplicitSuperCallTest : 
    public RuleTest<ruleName, RuleExplicitSuperCall, ErrorExplicitSuperCall>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleExplicitSuperCall {");
            vec.push_back("    RuleExplicitSuperCall() {");
            vec.push_back("        super();"); 
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleExplicitSuperCall {");
            vec.push_back("    RuleExplicitSuperCall() {");
            vec.push_back("        super(5);");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
    }

    virtual int errorsExpected(int num) const { 
        return num < 1 ? 1 : 0; 
    }

};

int main(int argc, char** argv) 
{
    RuleExplicitSuperCallTest t;
    t.run();
    cout << "explicit super call rule test results: " << t << endl;
    return t.nerrors();
}
