#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleGenericExceptionSpecification_h
#include "RuleGenericExceptionSpecification.h"
#endif

#ifndef ErrorGenericExceptionSpecification_h
#include "ErrorGenericExceptionSpecification.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleGenericExceptionSpecification";

class RuleGenericExceptionSpecificationTest : 
    public RuleTest<ruleName, RuleGenericExceptionSpecification, ErrorGenericExceptionSpecification>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleGenericExceptionSpecification {");
            vec.push_back("    RuleGenericExceptionSpecification() throws Exception {");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleGenericExceptionSpecification {");
            vec.push_back("    RuleGenericExceptionSpecification() throws java.lang.Exception {");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleGenericExceptionSpecification {");
            vec.push_back("    RuleGenericExceptionSpecification() throws Throwable {");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleGenericExceptionSpecification {");
            vec.push_back("    RuleGenericExceptionSpecification() throws java.lang.Throwable {");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleGenericExceptionSpecification {");
            vec.push_back("    RuleGenericExceptionSpecification() throws java.io.IOException {");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
    }

    virtual int errorsExpected(int num) const { 
        return num < 4 ? 1 : 0; 
    }

};

int main(int argc, char** argv) 
{
    RuleGenericExceptionSpecificationTest t;
    t.run();
    cout << "loose exception specification rule test results: " << t << endl;
    return t.nerrors();
}
