#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleMethodPackageAccess_h
#include "RuleMethodPackageAccess.h"
#endif

#ifndef ErrorMethodPackageAccess_h
#include "ErrorMethodPackageAccess.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleMethodPackageAccess";

class RuleMethodPackageAccessTest : 
    public RuleTest<ruleName, RuleMethodPackageAccess, ErrorMethodPackageAccess>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        {
            std::vector<std::string> vec;
            vec.push_back("class RuleMethodPackageAccess {");
            vec.push_back("    void foo() {");
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("interface RuleMethodPackageAccess {");
            vec.push_back("    void foo();");
            vec.push_back("}");
            contents->push_back(vec);
        }

        {
            std::vector<std::string> vec;
            vec.push_back("class RuleMethodPackageAccess {");
            vec.push_back("    abstract void foo();");
            vec.push_back("}");
            contents->push_back(vec);
        }
    }

    virtual int errorsExpected(int num) const { 
        return num < 3 ? 1 : 0; 
    }

};

int main(int argc, char** argv) 
{
    RuleMethodPackageAccessTest t;
    t.run();
    cout << "method package access rule test results: " << t << endl;
    return t.nerrors();
}
