#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RulePublicField_h
#include "RulePublicField.h"
#endif

#ifndef ErrorPublicField_h
#include "ErrorPublicField.h"
#endif

using namespace doctorj;

char ruleName[] = "RulePublicField";

class RulePublicFieldTest : 
    public RuleTest<ruleName, RulePublicField, ErrorPublicField>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        {
            std::vector<std::string> vec;
            vec.push_back("class RulePublicField {");
            vec.push_back("    public int foo;");
            vec.push_back("}");
            contents->push_back(vec);
        }
                
        {
            std::vector<std::string> vec;
            vec.push_back("class RulePublicField {");
            vec.push_back("    int foo;");
            vec.push_back("}");
            contents->push_back(vec);
        }
    }

    virtual int errorsExpected(int num) const { 
        return num < 1 ? 1 : 0; 
    }

};

int main(int argc, char** argv) 
{
    RulePublicFieldTest t;
    t.run();
    cout << "public field rule test results: " << t << endl;
    return t.nerrors();
}
