#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleUnreferencedImport_h
#include "RuleUnreferencedImport.h"
#endif

#ifndef ErrorUnreferencedImport_h
#include "ErrorUnreferencedImport.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleUnreferencedImport";

class RuleUnreferencedImportTest : 
    public RuleTest<ruleName, RuleUnreferencedImport, ErrorUnreferencedImport>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        {
            std::vector<std::string> vec;
            vec.push_back("import java.io.File;");
            vec.push_back("import java.io.IOStream;");
            vec.push_back("");
            vec.push_back("class RuleUnreferencedImport {");
            vec.push_back("    File f() {");
            vec.push_back("        return null;"); 
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
        
        {
            std::vector<std::string> vec;
            vec.push_back("import java.io.*;");
            vec.push_back("");
            vec.push_back("class RuleUnreferencedImport {");
            vec.push_back("    java.io.File f() {");
            vec.push_back("        return null;"); 
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }

        {
            std::vector<std::string> vec;
            vec.push_back("import java.io.*;");
            vec.push_back("import java.util.Vector;");
            vec.push_back("import java.text.*;");
            vec.push_back("");
            vec.push_back("class RuleUnreferencedImport {");
            vec.push_back("    java.io.File f() {");
            vec.push_back("        return null;"); 
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
        
        {
            std::vector<std::string> vec;
            vec.push_back("import java.io.File;");
            vec.push_back("");
            vec.push_back("class RuleUnreferencedImport {");
            vec.push_back("    File f() {");
            vec.push_back("        return null;"); 
            vec.push_back("    }");
            vec.push_back("}");
            contents->push_back(vec);
        }
    }

    virtual int errorsExpected(int num) const 
    { 
        switch (num) {
            case 0:  return 1;
            case 1:  return 1;
            case 2:  return 3;
            default: return 0;
        }
    }

};

int main(int argc, char** argv) 
{
    RuleUnreferencedImportTest t;
    t.run();
    cout << "unreferenced import rule test results: " << t << endl;
    return t.nerrors();
}
