#ifndef FileByteStream_h
#include "FileByteStream.h"
#endif

#include <iostream>

using namespace doctorj;
using namespace std;

FileByteStream::FileByteStream(const string& name) : buffer_(NULL), bufptr_(NULL), bufend_(NULL)
{
    file_ = fopen(name.c_str(), "rb");
    if (!file_) {
        cerr << "errors opening file: " << name << endl;
    }
}

FileByteStream::FileByteStream(FILE* file) : file_(file), buffer_(NULL), bufptr_(NULL), bufend_(NULL)
{
}

FileByteStream::~FileByteStream()
{
    if (buffer_) {
        delete [] buffer_;
    }
    
    if (file_) {
        fclose(file_);
    }
}

u1 FileByteStream::getU1()
{
    if (bufptr_ >= bufend_) {
        read(1024);
    }
    return *bufptr_++;
}

void FileByteStream::skip(int n)
{
    if (bufend_ - bufptr_ < n) {
        // 
        read(1024);
    }
    bufptr_ += n;
}

bool FileByteStream::read(int nBytes, int offset, int whence)
{
    int rc = fseek(file_, offset, whence);
    if (rc == 0) {
        return read(nBytes);
    }
    else {
        cerr << "problems seeking in the zip file!" << endl;
        return false;
    }
}

bool FileByteStream::read(int nBytes)
{
//     cout << "reading " << nBytes << " bytes ..." << endl;
    if (buffer_) {
        delete [] buffer_;
        buffer_ = NULL;
    }

    bufptr_ = buffer_ = new char[nBytes];
    int rd = fread(buffer_, sizeof(char), nBytes, file_);
    bufend_ = bufptr_ + rd;

//     cout << "read " << rd << " bytes." << endl;

    return true;
}

char* FileByteStream::position() const
{
    return bufptr_;
}


FILE* FileByteStream::file() const
{
    return file_;
}

char* FileByteStream::getBytes(int nBytes)
{
    char* bytes = new char[nBytes];
    if (bufend_ - bufptr_ < nBytes) {
        int nCopy = bufend_ - bufptr_;
        
        // yikes. Need to shift things around a bit.
        memcpy(bytes, bufptr_, nCopy);
        read(1024);
        // now we're reset
        memcpy(bytes + nCopy, bufptr_, nBytes - nCopy);

        bufptr_ += (nBytes - nCopy);
    }
    else {
        memcpy(bytes, bufptr_, nBytes);
        bufptr_ += nBytes;
    }

    return bytes;
}



FileByteStreamBigEndian::FileByteStreamBigEndian(const string& name) : FileByteStream(name)
{
}

FileByteStreamBigEndian::FileByteStreamBigEndian(FILE* file) : FileByteStream(file)
{
}

FileByteStreamBigEndian::~FileByteStreamBigEndian()
{
}

u2 FileByteStreamBigEndian::getU2()
{
    u4 hi = getU1();
    u4 lo = getU1();
    return (hi << 8) + lo;
}

u4 FileByteStreamBigEndian::getU4()
{
    u4 val = getU1();
    val = (val << 8) + getU1();
    val = (val << 8) + getU1();
    val = (val << 8) + getU1();
    return val;
}


FileByteStreamLittleEndian::FileByteStreamLittleEndian(const string& name) : FileByteStream(name)
{
}

FileByteStreamLittleEndian::FileByteStreamLittleEndian(FILE* file) : FileByteStream(file)
{
}

FileByteStreamLittleEndian::~FileByteStreamLittleEndian()
{
}

u2 FileByteStreamLittleEndian::getU2()
{
    u4 val = getU1();
    val |= (((u4) getU1()) << 8);

    return val;
}

u4 FileByteStreamLittleEndian::getU4()
{
    u4 val = getU1();
    val |= (((u4) getU1()) << 8);
    val |= (((u4) getU1()) << 16);
    val |= (((u4) getU1()) << 24);

    return val;
}
