#ifndef Log_h
#define Log_h

#ifndef std_string
#define std_string
#include <string>
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

namespace doctorj
{
    /**
     * The logging mechanism. All kids love log.
     */
    class Log
    {
    public:
        static int ALL;
        
        static void setEnabled(int id = ALL);

        static void setDisabled(int id = ALL);

        static void setWidths(int fileWidth, int lineWidth, int funcWidth);

        static void log(int id, const std::string& fileName, int line, const std::string& funcName, const std::string& msg);

        static void logfmt(int id, const std::string& fileName, int line, const std::string& funcName, const char* const fmt, ...);

        static bool isEnabled(int id);

    private:
        static bool allEnabled;

        static bool allDisabled;

        static int fileWidth;

        static int lineWidth;

        static int funcWidth;

        static std::vector<int> enabledIds;

        static std::vector<int> disabledIds;

    };
}

// __PRETTY_FUNCTION__ works only with GCC, as far as I know (which isn't far):
#define LOG(id, msg) { doctorj::Log::log(id, __FILE__, __LINE__, __PRETTY_FUNCTION__, msg); }
#define LOGF(id, fmt, args...) { doctorj::Log::logfmt(id, __FILE__, __LINE__, __PRETTY_FUNCTION__, fmt, args); }

#endif //! Log_h
