#ifndef RCFile_h
#define RCFile_h

#ifndef std_string
#define std_string
#include <string>
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

using namespace std;

/**
 * A collection of string/string pairs, retaining the order in which the values
 * were added to the map.
 */
class RCMap
{
public:
    virtual ~RCMap();

    /**
     * Returns the number of items in the list.
     */
    virtual int count() const;

    /**
     * Returns the nth item.
     */
    virtual pair<string, string> get(int i) const;

    /**
     * Adds the given key and value.
     */
    virtual void add(const string& key, const string& value);

    /**
     * Removes any values associated with the given key.
     */
    virtual void remove(const string& key);

    /**
     * Returns whether the given key exists in the map.
     */
    virtual bool has(const string& key) const;

    /**
     * Returns the index of the given key, or -1 if none.
     */
    virtual int index(const string& key) const;

private:
    vector<pair<string, string> > contents_;

};


/**
 * Emulates the Java properties file functionality.
 */
class RCFile
{
public:
    /**
     * Reads the given file into a set of name/value pairs, both as strings.
     */
    RCFile(const string& filename);

    virtual ~RCFile();

    /**
     * Returns the number of name/value pairs.
     */
    virtual int count() const;

    /**
     * Returns the name/value at the given index.
     */
    virtual pair<string, string> get(int i) const;

    /**
     * Returns the value for the given name, or an empty string if not found.
     */
    virtual string get(const string& name) const;

    /**
     * Returns the value for the given name, or an empty string if not found.
     */
    virtual string operator[](const string& name) const;

    /**
     * Returns whether there is a value for the given name.
     */
    virtual bool hasValue(const string& name) const;

    virtual string filename() const;

private:
    RCMap contents_;

    string filename_;
    
};

#endif //! RCFile_h
