#ifndef RegExp_h
#include "RegExp.h"
#endif

using namespace doctorj;

const string RegExp::UPPERS("[A-Z]");
const string RegExp::DOWNERS("[a-z]");
const string RegExp::NUMBERS("[0-9]");

ostream& doctorj::operator<<(ostream& os, const RegExp& rhs)
{
    os << rhs.pattern();
    return os;
}

RegExp::RegExp(const string& pat) : pattern_(pat)
{
    if (regcomp(&reg_, pat.c_str(), REG_EXTENDED) != 0) {
        cerr << "could not compile regular expression from: '" << pat << "'" << endl;;
    }
}

RegExp::~RegExp() 
{
    regfree(&reg_);
}

bool RegExp::match(const string& str) const
{
    int status = regexec(&reg_, str.c_str(), (size_t)0, NULL, 0);
    return status == 0;
}

string RegExp::pattern() const {
    return pattern_;
}
