#ifndef Test_h
#include "Test.h"
#endif

#ifndef DebugOptions_h
#include "DebugOptions.h"
#endif

using namespace doctorj;
using namespace std;

class DebugOptionsTest : public Test 
{
public:
    DebugOptionsTest();
    virtual void run();
};


DebugOptionsTest::DebugOptionsTest() : Test(true)
{
}

void DebugOptionsTest::run() 
{
#ifdef DEBUGGING
    DebugOptions* opts = DebugOptions::get();
    opts->add(new DebugOption('a', "the first option"));
    opts->add(new DebugOption('b', "the second option"));
    TESTEQ(opts->allChars(), "ab", "the characters");

    TESTEQ(opts->isEnabled('a'), false, "whether a is enabled");
    TESTEQ(opts->isEnabled('b'), false, "whether b is enabled");
    TESTEQ(opts->isEnabled(), false, "whether any option is enabled");

    opts->set("a");
    TESTEQ(opts->isEnabled('a'), true, "whether a is enabled");
    TESTEQ(opts->isEnabled('b'), false, "whether b is enabled");
    TESTEQ(opts->isEnabled(), true, "whether any option is enabled");

    opts->set("b");
    TESTEQ(opts->isEnabled('a'), false, "whether a is enabled");
    TESTEQ(opts->isEnabled('b'), true, "whether b is enabled");
    TESTEQ(opts->isEnabled(), true, "whether any option is enabled");

    opts->set("");
    TESTEQ(opts->isEnabled('a'), false, "whether a is enabled");
    TESTEQ(opts->isEnabled('b'), false, "whether b is enabled");
    TESTEQ(opts->isEnabled(), true, "whether any option is enabled");

    opts->set("ab");
    TESTEQ(opts->isEnabled('a'), true, "whether a is enabled");
    TESTEQ(opts->isEnabled('b'), true, "whether b is enabled");
    TESTEQ(opts->isEnabled(), true, "whether any option is enabled");
#endif
}

int main(int argc, char** argv) 
{
    DebugOptionsTest t;
    t.run();
    cout << "debug options set test results: " << t << endl;
    return t.nerrors();
}
