#ifndef Test_h
#include "Test.h"
#endif

#ifndef File_h
#include "File.h"
#endif

using namespace doctorj;


class FileNameTest : public Test 
{
public:
    FileNameTest();
    virtual void run();
};


FileNameTest::FileNameTest() : Test(true)
{
}

void FileNameTest::run() 
{
    TESTEQ(FileName::extension("foo.java"), "java", "extension (static)");
    TESTEQ(FileName::basename("foo.java"), "foo", "basename (static)");

    FileName fj("foo.java");
    TESTEQ(fj.extension(), "java", "extension (instance)");  
    TESTEQ(fj.basename(),  "foo",  "basename (instance)");
    
    TESTEQ(FileName::extension("foo.bar.java"), "java",    "extension (static)");
    TESTEQ(FileName::basename("foo.bar.java"),  "foo.bar", "basename (static)");

    FileName fbj("foo.bar.java");
    TESTEQ(fbj.extension(), "java", "extension (instance)");  
    TESTEQ(fbj.basename(),  "foo.bar",  "basename (instance)");
    
    TESTEQ(FileName::extension("foo"), "", "extension (static)");
    TESTEQ(FileName::basename("foo"), "foo", "basename (static)");

    FileName f("foo");
    TESTEQ(f.extension(), "", "extension (instance)");  
    TESTEQ(f.basename(), "foo",  "basename (instance)");
}

int main(int argc, char** argv) 
{
    FileNameTest t;
    t.run();
    cout << "string utilities test results: " << t << endl;
    return t.nerrors();
}
