#ifndef Test_h
#include "Test.h"
#endif

#ifndef Log_h
#include "Log.h"
#endif

using namespace doctorj;

class LogTest : public Test 
{
public:
    LogTest();
    virtual void run();
};


LogTest::LogTest() : Test(true)
{
}

void LogTest::run() 
{
    Log::setEnabled(Log::ALL);
    LOG(3, "Greetings");
    bool en3 = Log::isEnabled(3);
    TESTEQ(true, en3, "test of explicit enabled set");

    bool en1 = Log::isEnabled(1);
    TESTEQ(true, en1, "test of implicit enabled set");
    LOG(1, "Salud");

    Log::setDisabled(2);
    bool en2 = Log::isEnabled(2);
    TESTEQ(false, en2, "test of explicit disable set");
    LOG(2, "You shouldn't see this");

    Log::setDisabled(Log::ALL);
    en2 = Log::isEnabled(2);
    TESTEQ(false, en2, "test of implicit disable set");
    LOG(2, "Nor should you see this");

    // a bit gauche to change widths after already displaying messages:
    Log::setWidths(14, 7, 21);

    en3 = Log::isEnabled(3);
    TESTEQ(true, en3, "test of explicit enabled set overriding implicit disable set");
    LOG(3, "Hello, and goodbye");

    LOGF(3, "%s, and %s", "hola", "adios");
}

int main(int argc, char** argv) 
{
    LogTest t;
    t.run();
    cout << "log test results: " << t << endl;
    return t.nerrors();
}
