#ifndef Test_h
#include "Test.h"
#endif

#ifndef StringEdit_h
#include "StringEdit.h"
#endif

using namespace doctorj;

class StringEditDeleteLinesTest : public Test 
{
public:
    StringEditDeleteLinesTest();
    virtual void run();
};

StringEditDeleteLinesTest::StringEditDeleteLinesTest() : Test(true)
{
}

void StringEditDeleteLinesTest::run() 
{
    {
        //            01234 56789 01234
        char*  str = "this\nis a\ntest";
        char*  start = str;
        char*  end = str + strlen(str);
        char*  from = str + 8;
        char*  to = str + 9;
        char*  realpos = str + 4;
        int    len = 5;

        StringEditDeleteLines del(from, to, start, end);

        TESTEQ((void*)realpos, (void*)del.position(), "delete position");
        TESTEQ(len, del.length(), "delete length");
    }

    {
        //            01234 56789 01234
        char*  str = "this\nis a\ntest";
        char*  start = str;
        char*  end = str + strlen(str);
        char*  from = str + 2;
        char*  to = str + 9;
        char*  realpos = str;
        int    len = 9;

        StringEditDeleteLines del(from, to, start, end);

        TESTEQ((void*)realpos, (void*)del.position(), "delete position");
        TESTEQ(len, del.length(), "delete length");
    }

    {
        //            01234 56789 01234
        char*  str = "this\nis a\ntest";
        char*  start = str;
        char*  end = str + strlen(str);
        char*  from = str + 12;
        char*  to = str + 188;  // nasty
        char*  realpos = str + 9;
        int    len = 5;

        StringEditDeleteLines del(from, to, start, end);

        TESTEQ((void*)realpos, (void*)del.position(), "delete position");
        TESTEQ(len, del.length(), "delete length");
    }

    {
        //            01234 56789 01234
        char*  str = "this\nis a\ntest";
        char*  start = str - 3456789; // vicious
        char*  end = str + strlen(str);
        char*  from = str + 12;
        char*  to = str + 188;
        char*  realpos = str + 9;
        int    len = 5;

        StringEditDeleteLines del(from, to, start, end);

        TESTEQ((void*)realpos, (void*)del.position(), "delete position");
        TESTEQ(len, del.length(), "delete length");
    }
}

int main(int argc, char** argv) 
{
    StringEditDeleteLinesTest t;
    t.run();
    cout << "string edit delete lines test results: " << t << endl;
    return t.nerrors();
}
