#ifndef Test_h
#include "Test.h"
#endif

#ifndef StringUtilities_h
#include "StringUtilities.h"
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

#ifndef std_iterator
#define std_iterator
#include <iterator>
#endif

using namespace doctorj;

class StringUtilitiesTest : public Test 
{
public:
    StringUtilitiesTest();
    virtual void run();
};


StringUtilitiesTest::StringUtilitiesTest() : Test(true)
{
}

void StringUtilitiesTest::run() 
{
    string jparts[] = { "this", "is", "a", "test" };
    string jstr = StringUtilities::join("--", jparts, sizeof(jparts) / sizeof(jparts[0]));
    TESTEQ(jstr, "this--is--a--test", "join");
    
    cout << "no limit" << endl;
    vector<string> strvec0 = StringUtilities::split("this.is.a.test", ".");
    copy(strvec0.begin(), strvec0.end(), ostream_iterator<string>(cout, "--"));
    cout << endl;
    TESTEQ(strvec0.size(), 4U, "no limit on number of splits");

    cout << "limit == 1" << endl;
    vector<string> strvec1 = StringUtilities::split("this.is.a.test", ".", 1);
    copy(strvec1.begin(), strvec1.end(), ostream_iterator<string>(cout, "--"));
    cout << endl;
    TESTEQ(strvec1.size(), 1U, "number of splits limited to 1");

    cout << "limit == 2" << endl;
    vector<string> strvec2 = StringUtilities::split("this.is.a.test", ".", 2);
    copy(strvec2.begin(), strvec2.end(), ostream_iterator<string>(cout, "--"));
    cout << endl;
    TESTEQ(strvec2.size(), 2U, "number of splits limited to 2");

    TESTEQ(StringUtilities::startsWith("this.is.a.test", "this"), true, "starts with (true)");
    TESTEQ(StringUtilities::startsWith("this.is.a.test", "that"), false, "starts with (false)");

    TESTEQ(StringUtilities::endsWith("this.is.a.test", "test"), true, "ends with (true)");
    TESTEQ(StringUtilities::endsWith("this.is.a.test", "exam"), false, "ends with (false)");

    TEST(StringUtilities::toString<string>(string("hello")) == string("hello"), "string to string");
    string s;
    StringUtilities::fromString("hello", s);
    TEST(s == string("hello"), "string from string");

    TEST(StringUtilities::toString(int(1)) == "1", "integer to string");
    int i;
    StringUtilities::fromString("1", i);
    TEST(i == 1, "integer from string");

    TEST(StringUtilities::toString(double(3.14)) == "3.14", "double to string");
    double d;
    StringUtilities::fromString("3.14", d);
    TEST(d == 3.14, "double from string");

    TEST(StringUtilities::toString(float(2.818)) == "2.818", "float to string");
    float f;
    StringUtilities::fromString("2.818", f);
    TEST(f == float(2.818), "float from string");

    // empty string -- should get back zero
    //!!! TEST(StringUtilities::fromString<double>(string("")) == 0, "double from empty string");
    //!!! TEST(StringUtilities::fromString<float>(string("")) == 0, "float from empty string");
    //!!! TEST(StringUtilities::fromString<int>(string("")) == 0, "int from empty string");

    string s1("ABACABA");
    StringUtilities::subst(&s1, "A", "XYZ");
    TEST(s1.substr(0, 3) == "XYZ", "substitution of XYZ for first A");
    TEST(s1.substr(4, 3) == "XYZ", "substitution of XYZ for second A");
    TEST(s1.substr(8, 3) == "XYZ", "substitution of XYZ for third A");
    TEST(s1.substr(12, 3) == "XYZ", "substitution of XYZ for last (fourth) A");

    TEST(StringUtilities::startsWith(string("this is a string"), string("this")), "good one");
    TEST(!StringUtilities::startsWith(string("this is a string"), string("his")), "bad one");

    string s2("this has things to be deleted");
    StringUtilities::subst(&s2, "thi", "");
    cout << "s2: '" << s2 << "'" << endl;
}

int main(int argc, char** argv) 
{
    StringUtilitiesTest t;
    t.run();
    cout << "string utilities test results: " << t << endl;
    return t.nerrors();
}
