#ifndef Test_h
#include "Test.h"
#endif

#ifndef ZipFile_h
#include "ZipFile.h"
#endif

#ifndef Platform_h
#include "Platform.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

using namespace doctorj;

class ZipFileTest : public Test 
{
public:
    ZipFileTest(int argc, char** argv);
    virtual void run();

    virtual void testZipFile(char* const name);

private:
    int argc_;
    char** argv_;
};


ZipFileTest::ZipFileTest(int argc, char** argv) : Test(true), argc_(argc), argv_(argv)
{
}

void ZipFileTest::testZipFile(char* const name)
{
    if (Platform::isReadableFile(name)) {
        struct timeval tv;
        gettimeofday(&tv, NULL);
        srand(tv.tv_usec % 10);

        ZipFile zf(name);
        vector<string> names = zf.entryNames();
        int nNames = names.size();
        // test about 25% of the files
        for (int ti = 0; ti < nNames / 2; ++ti) {
            int ni = (int)((double)nNames * rand() / (RAND_MAX + 1.0));
            string name = names[ni];
            char* bytes  = NULL;

            zf.getBytes(name, &bytes);
            // int   nBytes = zf.getBytes(name, &bytes);

            // cout << nBytes << "\t" << name << endl;
        }
    }
    else {
        cout << name << ": file not readable" << endl;
    }
}

void ZipFileTest::run() 
{
    if (argc_ == 1) {
        testZipFile("/usr/local/jdk-1.1.8-3/lib/classes.zip");
    }
    else {
        for (int i = 1; i < argc_; ++i) {
            testZipFile(argv_[i]);
        }
    }
}

int main(int argc, char** argv) 
{
    ZipFileTest t(argc, argv);
    t.run();
    cout << "unzip test results: " << t << endl;
    return t.nerrors();
}
