#ifndef Test_h
#include "Test.h"
#endif

#ifndef RCFile_h
#include "RCFile.h"
#endif

#ifndef std_fstream
#define std_fstream
#include <fstream>
#endif

#ifndef yagol_unistd_h
#define yagol_unistd_h
#include <unistd.h>
#endif

using namespace std;

class RCFileTest : public Test 
{
public:
    RCFileTest();
    virtual void run();
};

RCFileTest::RCFileTest() : Test(true)
{
}

void RCFileTest::run() 
{
    char* name = "test.rc";
    ofstream out(name);
    out << "# properties for the view classes" << endl;
    out << "" << endl;
    out << "# menu items" << endl;
    out << "" << endl;
    out << "menu.About.label   =   About This Application" << endl;
    out << "menu.About.shortcut  =  A" << endl;
    out << "" << endl;
    out << "menu.Author.label  =      Author" << endl;
    out << "" << endl;
    out << "menu.ColorScheme.label =   Color Scheme" << endl;
    out << "menu.ColorScheme.shortcut =        C" << endl;
    out << "" << endl;
    out << "help.Exiting.label=Exiting" << endl;
    out << "help.Exiting.html=<html>\\n\\" << endl;
    out << "<p>\\n\\" << endl;
    out << "To close the GUI, go to <b>Exit</b>.  The\\n\\" << endl;
    out << "<b>Hide GUI</b> option actually exits\\n\\" << endl;
    out << "the application in the prototype, so that option\\n\\" << endl;
    out << "exists only to highlight the difference between\\n\\" << endl;
    out << "exiting the application and merely hiding the GUI.\\n\\" << endl;
    out << "</html>" << endl;
    out << "" << endl;
    out << "menu.Configure.label=Configure" << endl;
    out << "menu.Configure.shortcut=o" << endl;
    out << "" << endl;
    out << "" << endl;
    out.close();
    
    RCFile r(name);
    string mcssc = r.get("menu.ColorScheme.shortcut");
    TESTEQ(mcssc, "C", "access via get method");

    string hel = r["help.Exiting.label"];
    TESTEQ(hel, "Exiting", "access via index operator");

    string isnt = r.get("this doesn't exist");
    TESTEQ(isnt, "", "access of nonexisting field");

    string noexiste = r["This.Doesn't.Exist.Either"];
    TESTEQ(noexiste, "", "access of nonexisting field via index operator");

    string mcssc2 = r.get("menu.ColorScheme.shortcut");
    TESTEQ(mcssc2, "C", "access");

    // a file that doesn't exist
    RCFile missing("IDoubtThisFileExists");
    string mcssc3 = missing.get("menu.ColorScheme.shortcut");

    // shouldn't have anything
    TESTEQ(mcssc3, "", "access via get method");

    unlink(name);
}

int main(int argc, char** argv) 
{
    RCFileTest t;
    t.run();
    cout << "rc reader test results: " << t << endl;
    return t.nerrors();
}
