#ifndef Test_h
#include "Test.h"
#endif

#ifndef Yagol_h
#include "Yagol.h"
#endif

class YagolOptionBooleanTest : public Test 
{
public:
    YagolOptionBooleanTest();
    virtual void run();
};

YagolOptionBooleanTest::YagolOptionBooleanTest() : Test(true)
{
}

void YagolOptionBooleanTest::run() 
{
    bool v(false);
    yagol::OptionGeneric<bool> gob("gob1", "yagol option boolean #1", &v);
    TESTEQ(gob.defaultValue(), v, "default value appropriately set");

    {
        char* args[] = { "--gob1" };
        const int NARGS = sizeof(args) / sizeof(args[0]);

        int pos = 0;

        bool match = gob.tagMatches(string(string(args[pos]), 2));
        TESTEQ(match, true, "successful match of argument");

        int nArgs = gob.consume("gob1", pos, NARGS, args);
        TESTEQ(nArgs, 1, "proper number of arguments consumed");
        TESTEQ(v, true, "boolean set to true");

        gob.setValue("false");
        TESTEQ(v, false, "boolean set to false");

        gob.setValue("true");
        TESTEQ(v, true, "boolean set to true");

        gob.setValue("yes");
        TESTEQ(v, true, "boolean set to true from yes");

        gob.setValue("no");
        TESTEQ(v, false, "boolean set to false from no");
    }

    {
        v = true;               // just to make sure
        char* args[] = { "--nogob1" };
        const int NARGS = sizeof(args) / sizeof(args[0]);
        int pos = 0;
        bool match = gob.tagMatches(string(string(args[pos]), 2));
        TESTEQ(match, true, "successful match of argument");
        int nArgs = gob.consume("nogob1", pos, NARGS, args);
        TESTEQ(nArgs, 1, "proper number of arguments consumed");
        TESTEQ(v, false, "boolean set to false");
    }

    {
        char* args[] = { "dummy", "--gob1" };
        const int NARGS = sizeof(args) / sizeof(args[0]);
        int pos = 0;
        bool match = gob.tagMatches(string(string(args[pos]), 2));
        TESTEQ(match, false, "unsuccessful match of argument");

        pos = 1;
        match = gob.tagMatches(string(string(args[pos]), 2));
        TESTEQ(match, true, "successful match of argument");
        int nArgs = gob.consume("gob1", pos, NARGS, args);
        TESTEQ(nArgs, 1, "proper number of arguments consumed");
        TESTEQ(v, true, "boolean set to true");
    }
}

int main(int argc, char** argv) 
{
    YagolOptionBooleanTest t;
    t.run();
    cout << "yagol option boolean test results: " << t << endl;
    t.writeReport(cout);
    return t.nerrors();
}
