#ifndef Test_h
#include "Test.h"
#endif

#ifndef Yagol_h
#include "Yagol.h"
#endif

class YagolOptionMultiValuesTest : public Test 
{
public:
    YagolOptionMultiValuesTest();
    virtual void run();
};

YagolOptionMultiValuesTest::YagolOptionMultiValuesTest() : Test(true)
{
}

void YagolOptionMultiValuesTest::run() 
{
    {
        vector<string> strs;
        yagol::OptionMultiValues<vector<string> > strsopt("strs", "list of strings", &strs);

        char* args[] = { "--strs", "one", "two", "three", "--end-of-strs", "notused1", "notused2" };
        const int NARGS = sizeof(args) / sizeof(args[0]);
        int pos = 0;
        int nArgs = strsopt.consume("strs", pos, NARGS, args);
        
        TESTEQ(nArgs, 5, "proper number of arguments consumed list");
        TESTEQ(strs.size(), (unsigned int)3, "three strings in the list");
        
        TESTEQ(strs[0], "one",   "first string in the list");
        TESTEQ(strs[1], "two",   "second string in the list");
        TESTEQ(strs[2], "three", "third string in the list");
    }

    {
        vector<int> ints;
        yagol::OptionMultiValues<vector<int> > intsopt("ints", "list of integers", &ints);

        char* args[] = { "--ints", "1", "2", "4", "8", "--end-of-ints" };
        const int NARGS = sizeof(args) / sizeof(args[0]);
        int pos = 0;
        int nArgs = intsopt.consume("ints", pos, NARGS, args);

        TESTEQ(nArgs, 6, "proper number of arguments consumed list");
        TESTEQ(ints.size(), (unsigned int)4, "four integers in the list");

        TESTEQ(ints[0], 1, "first integer in the list");
        TESTEQ(ints[1], 2, "second integer in the list");
        TESTEQ(ints[2], 4, "third integer in the list");
        TESTEQ(ints[3], 8, "fourth integer in the list");
    }
}

int main(int argc, char** argv) 
{
    YagolOptionMultiValuesTest t;
    t.run();
    cout << "yagol option multi values test results: " << t << endl;
    t.writeReport(cout);
    return t.nerrors();
}
