/*
 * Decompiled with CFR 0.152.
 */
package org.dojotoolkit.shrinksafe;

import java.util.Map;
import org.dojotoolkit.shrinksafe.DebugData;

public class ReplacedTokens {
    private int[] parents = null;
    private Map replacements = null;
    private Map lookup = null;
    private DebugData debugData = null;

    public ReplacedTokens(Map map, int[] nArray, Map map2, DebugData debugData) {
        this.replacements = map;
        this.parents = nArray;
        this.lookup = map2;
        this.debugData = debugData;
    }

    public String find(String string) {
        String string2 = null;
        if (this.replacements != null) {
            string2 = (String)this.replacements.get(string);
        }
        if (string2 == null) {
            for (int i = this.parents.length; i > 0; --i) {
                int n = this.parents[i - 1];
                ReplacedTokens replacedTokens = (ReplacedTokens)this.lookup.get(new Integer(n));
                if (replacedTokens.replacements != null && (string2 = (String)replacedTokens.replacements.get(string)) != null) break;
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public String printDebugData() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.debugData != null) {
            stringBuffer.append("Start:" + this.debugData.start);
            stringBuffer.append(' ');
            stringBuffer.append("End:" + this.debugData.end);
            stringBuffer.append(' ');
            stringBuffer.append("Compressed Start:" + this.debugData.compressedStart);
            stringBuffer.append(' ');
            stringBuffer.append("Compressed End:" + this.debugData.compressedEnd);
            stringBuffer.append(' ');
            if (this.debugData.paramAndVarNames != null) {
                stringBuffer.append("Params and Vars: [");
                for (String string : this.debugData.paramAndVarNames) {
                    stringBuffer.append(string);
                    stringBuffer.append(' ');
                }
                stringBuffer.append("]\n");
            }
            if (this.replacements != null && this.replacements.size() > 0) {
                stringBuffer.append("\t");
                stringBuffer.append("Replacements:\n");
                for (String string : this.replacements.keySet()) {
                    String string2;
                    if (string.equals(string2 = (String)this.replacements.get(string))) continue;
                    stringBuffer.append("\t\t");
                    stringBuffer.append('[');
                    stringBuffer.append(string);
                    stringBuffer.append(']');
                    stringBuffer.append(" replaced with ");
                    stringBuffer.append('[');
                    stringBuffer.append(string2);
                    stringBuffer.append(']');
                    stringBuffer.append('\n');
                }
                stringBuffer.append("\n");
            }
            for (int i = this.parents.length; i > 0; --i) {
                int n = this.parents[i - 1];
                ReplacedTokens replacedTokens = (ReplacedTokens)this.lookup.get(new Integer(n));
                if (replacedTokens.replacements == null || replacedTokens.replacements.size() <= 0) continue;
                stringBuffer.append("\t");
                stringBuffer.append("Parent Replacements level [" + i + "]:\n");
                for (String string : replacedTokens.replacements.keySet()) {
                    String string3;
                    if (string.equals(string3 = (String)replacedTokens.replacements.get(string))) continue;
                    stringBuffer.append("\t\t");
                    stringBuffer.append('[');
                    stringBuffer.append(string);
                    stringBuffer.append(']');
                    stringBuffer.append(" replaced with ");
                    stringBuffer.append('[');
                    stringBuffer.append(string3);
                    stringBuffer.append(']');
                    stringBuffer.append('\n');
                }
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public String toJson() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        if (this.debugData != null) {
            stringBuffer.append("start: " + this.debugData.start);
            stringBuffer.append(", ");
            stringBuffer.append("end: " + this.debugData.end);
            stringBuffer.append(", ");
            stringBuffer.append("compressedStart: " + this.debugData.compressedStart);
            stringBuffer.append(", ");
            stringBuffer.append("compressedEnd: " + this.debugData.compressedEnd);
            stringBuffer.append(", ");
            stringBuffer.append("replacements: {");
            if (this.replacements != null && this.replacements.size() > 0) {
                stringBuffer.append(ReplacedTokens.replacementsToJson(this.replacements));
            }
            stringBuffer.append('}');
            if (this.parents.length > 0) {
                stringBuffer.append(", ");
                stringBuffer.append("parentReplacements: [");
            }
            int n = 1;
            for (int i = 0; i < this.parents.length; ++i) {
                stringBuffer.append('{');
                int n2 = this.parents[i];
                ReplacedTokens replacedTokens = (ReplacedTokens)this.lookup.get(new Integer(n2));
                if (replacedTokens.replacements != null && replacedTokens.replacements.size() > 0) {
                    stringBuffer.append(ReplacedTokens.replacementsToJson(replacedTokens.replacements));
                }
                stringBuffer.append('}');
                if (n++ >= this.parents.length) continue;
                stringBuffer.append(", ");
            }
            if (this.parents.length > 0) {
                stringBuffer.append("]");
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String replacementsToJson(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        for (String string : map.keySet()) {
            String string2 = (String)map.get(string);
            stringBuffer.append("\"" + string2 + '\"');
            stringBuffer.append(" : ");
            stringBuffer.append("\"" + string + "\"");
            if (n++ >= map.size()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }
}

