// This code conforms with the UFC specification version 2.0.0
// and was automatically generated by FFC version 0.9.10.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          True
//   swig_binary:                    'swig'
//   swig_path:                      ''

#include "CahnHilliard3D.h"

/// Constructor
cahnhilliard3d_finite_element_0::cahnhilliard3d_finite_element_0() : ufc::finite_element()
{
    // Do nothing
}

/// Destructor
cahnhilliard3d_finite_element_0::~cahnhilliard3d_finite_element_0()
{
    // Do nothing
}

/// Return a string identifying the finite element
const char* cahnhilliard3d_finite_element_0::signature() const
{
    return "FiniteElement('Discontinuous Lagrange', Cell('tetrahedron', Space(3)), 0, None)";
}

/// Return the cell shape
ufc::shape cahnhilliard3d_finite_element_0::cell_shape() const
{
    return ufc::tetrahedron;
}

/// Return the topological dimension of the cell shape
unsigned int cahnhilliard3d_finite_element_0::topological_dimension() const
{
    return 3;
}

/// Return the geometric dimension of the cell shape
unsigned int cahnhilliard3d_finite_element_0::geometric_dimension() const
{
    return 3;
}

/// Return the dimension of the finite element function space
unsigned int cahnhilliard3d_finite_element_0::space_dimension() const
{
    return 1;
}

/// Return the rank of the value space
unsigned int cahnhilliard3d_finite_element_0::value_rank() const
{
    return 0;
}

/// Return the dimension of the value space for axis i
unsigned int cahnhilliard3d_finite_element_0::value_dimension(unsigned int i) const
{
    return 1;
}

/// Evaluate basis function i at given point in cell
void cahnhilliard3d_finite_element_0::evaluate_basis(unsigned int i,
                                   double* values,
                                   const double* coordinates,
                                   const ufc::cell& c) const
{
    // Extract vertex coordinates
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute sub determinants
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Compute constants
    
    // Get coordinates and map to the reference (FIAT) element
    
    
    // Reset values.
    *values = 0.000000000000000;
    
    // Array of basisvalues.
    double basisvalues[1] = {0.000000000000000};
    
    // Declare helper variables.
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    
    // Table(s) of coefficients.
    static const double coefficients0[1] = \
    {1.000000000000000};
    
    // Compute value(s).
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    }// end loop over 'r'
}

/// Evaluate all basis functions at given point in cell
void cahnhilliard3d_finite_element_0::evaluate_basis_all(double* values,
                                       const double* coordinates,
                                       const ufc::cell& c) const
{
    // Element is constant, calling evaluate_basis.
    evaluate_basis(0, values, coordinates, c);
}

/// Evaluate order n derivatives of basis function i at given point in cell
void cahnhilliard3d_finite_element_0::evaluate_basis_derivatives(unsigned int i,
                                               unsigned int n,
                                               double* values,
                                               const double* coordinates,
                                               const ufc::cell& c) const
{
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    
    // Get coordinates and map to the reference (FIAT) element
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    
    // Array of basisvalues.
    double basisvalues[1] = {0.000000000000000};
    
    // Declare helper variables.
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    
    // Table(s) of coefficients.
    static const double coefficients0[1] = \
    {1.000000000000000};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[1][1] = \
    {{0.000000000000000}};
    
    static const double dmats1[1][1] = \
    {{0.000000000000000}};
    
    static const double dmats2[1][1] = \
    {{0.000000000000000}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      derivatives[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[1][1] = \
    {{1.000000000000000}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[1][1] = \
    {{1.000000000000000}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 1; t++)
      {
        for (unsigned int u = 0; u < 1; u++)
        {
          dmats[t][u] = 0.000000000000000;
          if (t == u)
          {
          dmats[t][u] = 1.000000000000000;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.000000000000000;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 2)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 1; s++)
      {
        for (unsigned int t = 0; t < 1; t++)
        {
          derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] combinations[r];
    }// end loop over 'r'
    delete [] combinations;
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
}

/// Evaluate order n derivatives of all basis functions at given point in cell
void cahnhilliard3d_finite_element_0::evaluate_basis_derivatives_all(unsigned int n,
                                                   double* values,
                                                   const double* coordinates,
                                                   const ufc::cell& c) const
{
    // Element is constant, calling evaluate_basis_derivatives.
    evaluate_basis_derivatives(0, n, values, coordinates, c);
}

/// Evaluate linear functional for dof i on the function f
double cahnhilliard3d_finite_element_0::evaluate_dof(unsigned int i,
                                   const ufc::function& f,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.250000000000000*x[2][0] + 0.250000000000000*x[3][0];
      y[1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.250000000000000*x[2][1] + 0.250000000000000*x[3][1];
      y[2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.250000000000000*x[2][2] + 0.250000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.000000000000000;
}

/// Evaluate linear functionals for all dofs on the function f
void cahnhilliard3d_finite_element_0::evaluate_dofs(double* values,
                                  const ufc::function& f,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.250000000000000*x[2][0] + 0.250000000000000*x[3][0];
    y[1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.250000000000000*x[2][1] + 0.250000000000000*x[3][1];
    y[2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.250000000000000*x[2][2] + 0.250000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
}

/// Interpolate vertex values from dof values
void cahnhilliard3d_finite_element_0::interpolate_vertex_values(double* vertex_values,
                                              const double* dof_values,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
    vertex_values[3] = dof_values[0];
}

/// Map coordinate xhat from reference cell to coordinate x in cell
void cahnhilliard3d_finite_element_0::map_from_reference_cell(double* x,
                                            const double* xhat,
                                            const ufc::cell& c) const
{
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
}

/// Map from coordinate x in cell to coordinate xhat in reference cell
void cahnhilliard3d_finite_element_0::map_to_reference_cell(double* xhat,
                                          const double* x,
                                          const ufc::cell& c) const
{
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
}

/// Return the number of sub elements (for a mixed element)
unsigned int cahnhilliard3d_finite_element_0::num_sub_elements() const
{
    return 0;
}

/// Create a new finite element for sub element i (for a mixed element)
ufc::finite_element* cahnhilliard3d_finite_element_0::create_sub_element(unsigned int i) const
{
    return 0;
}

/// Create a new class instance
ufc::finite_element* cahnhilliard3d_finite_element_0::create() const
{
    return new cahnhilliard3d_finite_element_0();
}


/// Constructor
cahnhilliard3d_finite_element_1::cahnhilliard3d_finite_element_1() : ufc::finite_element()
{
    // Do nothing
}

/// Destructor
cahnhilliard3d_finite_element_1::~cahnhilliard3d_finite_element_1()
{
    // Do nothing
}

/// Return a string identifying the finite element
const char* cahnhilliard3d_finite_element_1::signature() const
{
    return "FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)";
}

/// Return the cell shape
ufc::shape cahnhilliard3d_finite_element_1::cell_shape() const
{
    return ufc::tetrahedron;
}

/// Return the topological dimension of the cell shape
unsigned int cahnhilliard3d_finite_element_1::topological_dimension() const
{
    return 3;
}

/// Return the geometric dimension of the cell shape
unsigned int cahnhilliard3d_finite_element_1::geometric_dimension() const
{
    return 3;
}

/// Return the dimension of the finite element function space
unsigned int cahnhilliard3d_finite_element_1::space_dimension() const
{
    return 4;
}

/// Return the rank of the value space
unsigned int cahnhilliard3d_finite_element_1::value_rank() const
{
    return 0;
}

/// Return the dimension of the value space for axis i
unsigned int cahnhilliard3d_finite_element_1::value_dimension(unsigned int i) const
{
    return 1;
}

/// Evaluate basis function i at given point in cell
void cahnhilliard3d_finite_element_1::evaluate_basis(unsigned int i,
                                   double* values,
                                   const double* coordinates,
                                   const ufc::cell& c) const
{
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    *values = 0.000000000000000;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.000000000000000, 0.223606797749979};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
}

/// Evaluate all basis functions at given point in cell
void cahnhilliard3d_finite_element_1::evaluate_basis_all(double* values,
                                       const double* coordinates,
                                       const ufc::cell& c) const
{
    // Helper variable to hold values of a single dof.
    double dof_values = 0.000000000000000;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 4; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
}

/// Evaluate order n derivatives of basis function i at given point in cell
void cahnhilliard3d_finite_element_1::evaluate_basis_derivatives(unsigned int i,
                                               unsigned int n,
                                               double* values,
                                               const double* coordinates,
                                               const ufc::cell& c) const
{
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.000000000000000, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
}

/// Evaluate order n derivatives of all basis functions at given point in cell
void cahnhilliard3d_finite_element_1::evaluate_basis_derivatives_all(unsigned int n,
                                                   double* values,
                                                   const double* coordinates,
                                                   const ufc::cell& c) const
{
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 4; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
}

/// Evaluate linear functional for dof i on the function f
double cahnhilliard3d_finite_element_1::evaluate_dof(unsigned int i,
                                   const ufc::function& f,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.000000000000000;
}

/// Evaluate linear functionals for all dofs on the function f
void cahnhilliard3d_finite_element_1::evaluate_dofs(double* values,
                                  const ufc::function& f,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
}

/// Interpolate vertex values from dof values
void cahnhilliard3d_finite_element_1::interpolate_vertex_values(double* vertex_values,
                                              const double* dof_values,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
}

/// Map coordinate xhat from reference cell to coordinate x in cell
void cahnhilliard3d_finite_element_1::map_from_reference_cell(double* x,
                                            const double* xhat,
                                            const ufc::cell& c) const
{
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
}

/// Map from coordinate x in cell to coordinate xhat in reference cell
void cahnhilliard3d_finite_element_1::map_to_reference_cell(double* xhat,
                                          const double* x,
                                          const ufc::cell& c) const
{
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
}

/// Return the number of sub elements (for a mixed element)
unsigned int cahnhilliard3d_finite_element_1::num_sub_elements() const
{
    return 0;
}

/// Create a new finite element for sub element i (for a mixed element)
ufc::finite_element* cahnhilliard3d_finite_element_1::create_sub_element(unsigned int i) const
{
    return 0;
}

/// Create a new class instance
ufc::finite_element* cahnhilliard3d_finite_element_1::create() const
{
    return new cahnhilliard3d_finite_element_1();
}


/// Constructor
cahnhilliard3d_finite_element_2::cahnhilliard3d_finite_element_2() : ufc::finite_element()
{
    // Do nothing
}

/// Destructor
cahnhilliard3d_finite_element_2::~cahnhilliard3d_finite_element_2()
{
    // Do nothing
}

/// Return a string identifying the finite element
const char* cahnhilliard3d_finite_element_2::signature() const
{
    return "MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) })";
}

/// Return the cell shape
ufc::shape cahnhilliard3d_finite_element_2::cell_shape() const
{
    return ufc::tetrahedron;
}

/// Return the topological dimension of the cell shape
unsigned int cahnhilliard3d_finite_element_2::topological_dimension() const
{
    return 3;
}

/// Return the geometric dimension of the cell shape
unsigned int cahnhilliard3d_finite_element_2::geometric_dimension() const
{
    return 3;
}

/// Return the dimension of the finite element function space
unsigned int cahnhilliard3d_finite_element_2::space_dimension() const
{
    return 8;
}

/// Return the rank of the value space
unsigned int cahnhilliard3d_finite_element_2::value_rank() const
{
    return 1;
}

/// Return the dimension of the value space for axis i
unsigned int cahnhilliard3d_finite_element_2::value_dimension(unsigned int i) const
{
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
}

/// Evaluate basis function i at given point in cell
void cahnhilliard3d_finite_element_2::evaluate_basis(unsigned int i,
                                   double* values,
                                   const double* coordinates,
                                   const ufc::cell& c) const
{
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    values[0] = 0.000000000000000;
    values[1] = 0.000000000000000;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.000000000000000, 0.223606797749979};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.000000000000000, 0.223606797749979};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
}

/// Evaluate all basis functions at given point in cell
void cahnhilliard3d_finite_element_2::evaluate_basis_all(double* values,
                                       const double* coordinates,
                                       const ufc::cell& c) const
{
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.000000000000000, 0.000000000000000};
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 8; r++)
    {
      evaluate_basis(r, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
}

/// Evaluate order n derivatives of basis function i at given point in cell
void cahnhilliard3d_finite_element_2::evaluate_basis_derivatives(unsigned int i,
                                               unsigned int n,
                                               double* values,
                                               const double* coordinates,
                                               const ufc::cell& c) const
{
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.000000000000000, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.000000000000000, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
}

/// Evaluate order n derivatives of all basis functions at given point in cell
void cahnhilliard3d_finite_element_2::evaluate_basis_derivatives_all(unsigned int n,
                                                   double* values,
                                                   const double* coordinates,
                                                   const ufc::cell& c) const
{
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[2*num_derivatives];
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      dof_values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 8; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
}

/// Evaluate linear functional for dof i on the function f
double cahnhilliard3d_finite_element_2::evaluate_dof(unsigned int i,
                                   const ufc::function& f,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation.
    double vals[2];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 6:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 7:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    }
    
    return 0.000000000000000;
}

/// Evaluate linear functionals for all dofs on the function f
void cahnhilliard3d_finite_element_2::evaluate_dofs(double* values,
                                  const ufc::function& f,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation.
    double vals[2];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[4] = vals[1];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[5] = vals[1];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[6] = vals[1];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[7] = vals[1];
}

/// Interpolate vertex values from dof values
void cahnhilliard3d_finite_element_2::interpolate_vertex_values(double* vertex_values,
                                              const double* dof_values,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[2] = dof_values[1];
    vertex_values[4] = dof_values[2];
    vertex_values[6] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[4];
    vertex_values[3] = dof_values[5];
    vertex_values[5] = dof_values[6];
    vertex_values[7] = dof_values[7];
}

/// Map coordinate xhat from reference cell to coordinate x in cell
void cahnhilliard3d_finite_element_2::map_from_reference_cell(double* x,
                                            const double* xhat,
                                            const ufc::cell& c) const
{
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
}

/// Map from coordinate x in cell to coordinate xhat in reference cell
void cahnhilliard3d_finite_element_2::map_to_reference_cell(double* xhat,
                                          const double* x,
                                          const ufc::cell& c) const
{
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
}

/// Return the number of sub elements (for a mixed element)
unsigned int cahnhilliard3d_finite_element_2::num_sub_elements() const
{
    return 2;
}

/// Create a new finite element for sub element i (for a mixed element)
ufc::finite_element* cahnhilliard3d_finite_element_2::create_sub_element(unsigned int i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_finite_element_1();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_finite_element_1();
        break;
      }
    }
    
    return 0;
}

/// Create a new class instance
ufc::finite_element* cahnhilliard3d_finite_element_2::create() const
{
    return new cahnhilliard3d_finite_element_2();
}

/// Constructor
cahnhilliard3d_dofmap_0::cahnhilliard3d_dofmap_0() : ufc::dofmap()
{
    _global_dimension = 0;
}

/// Destructor
cahnhilliard3d_dofmap_0::~cahnhilliard3d_dofmap_0()
{
    // Do nothing
}

/// Return a string identifying the dofmap
const char* cahnhilliard3d_dofmap_0::signature() const
{
    return "FFC dofmap for FiniteElement('Discontinuous Lagrange', Cell('tetrahedron', Space(3)), 0, None)";
}

/// Return true iff mesh entities of topological dimension d are needed
bool cahnhilliard3d_dofmap_0::needs_mesh_entities(unsigned int d) const
{
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return true;
        break;
      }
    }
    
    return false;
}

/// Initialize dofmap for mesh (return true iff init_cell() is needed)
bool cahnhilliard3d_dofmap_0::init_mesh(const ufc::mesh& m)
{
    _global_dimension = m.num_entities[3];
    return false;
}

/// Initialize dofmap for given cell
void cahnhilliard3d_dofmap_0::init_cell(const ufc::mesh& m,
                              const ufc::cell& c)
{
    // Do nothing
}

/// Finish initialization of dofmap for cells
void cahnhilliard3d_dofmap_0::init_cell_finalize()
{
    // Do nothing
}

/// Return the topological dimension of the associated cell shape
unsigned int cahnhilliard3d_dofmap_0::topological_dimension() const
{
    return 3;
}

/// Return the geometric dimension of the associated cell shape
unsigned int cahnhilliard3d_dofmap_0::geometric_dimension() const
{
    return 3;
}

/// Return the dimension of the global finite element function space
unsigned int cahnhilliard3d_dofmap_0::global_dimension() const
{
    return _global_dimension;
}

/// Return the dimension of the local finite element function space for a cell
unsigned int cahnhilliard3d_dofmap_0::local_dimension(const ufc::cell& c) const
{
    return 1;
}

/// Return the maximum dimension of the local finite element function space
unsigned int cahnhilliard3d_dofmap_0::max_local_dimension() const
{
    return 1;
}

/// Return the number of dofs on each cell facet
unsigned int cahnhilliard3d_dofmap_0::num_facet_dofs() const
{
    return 0;
}

/// Return the number of dofs associated with each cell entity of dimension d
unsigned int cahnhilliard3d_dofmap_0::num_entity_dofs(unsigned int d) const
{
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 1;
        break;
      }
    }
    
    return 0;
}

/// Tabulate the local-to-global mapping of dofs on a cell
void cahnhilliard3d_dofmap_0::tabulate_dofs(unsigned int* dofs,
                                  const ufc::mesh& m,
                                  const ufc::cell& c) const
{
    dofs[0] = c.entity_indices[3][0];
}

/// Tabulate the local-to-local mapping from facet dofs to cell dofs
void cahnhilliard3d_dofmap_0::tabulate_facet_dofs(unsigned int* dofs,
                                        unsigned int facet) const
{
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
}

/// Tabulate the local-to-local mapping of dofs on entity (d, i)
void cahnhilliard3d_dofmap_0::tabulate_entity_dofs(unsigned int* dofs,
                                  unsigned int d, unsigned int i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
}

/// Tabulate the coordinates of all dofs on a cell
void cahnhilliard3d_dofmap_0::tabulate_coordinates(double** coordinates,
                                         const ufc::cell& c) const
{
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.250000000000000*x[2][0] + 0.250000000000000*x[3][0];
    coordinates[0][1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.250000000000000*x[2][1] + 0.250000000000000*x[3][1];
    coordinates[0][2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.250000000000000*x[2][2] + 0.250000000000000*x[3][2];
}

/// Return the number of sub dofmaps (for a mixed element)
unsigned int cahnhilliard3d_dofmap_0::num_sub_dofmaps() const
{
    return 0;
}

/// Create a new dofmap for sub dofmap i (for a mixed element)
ufc::dofmap* cahnhilliard3d_dofmap_0::create_sub_dofmap(unsigned int i) const
{
    return 0;
}

/// Create a new class instance
ufc::dofmap* cahnhilliard3d_dofmap_0::create() const
{
    return new cahnhilliard3d_dofmap_0();
}

/// Constructor
cahnhilliard3d_dofmap_1::cahnhilliard3d_dofmap_1() : ufc::dofmap()
{
    _global_dimension = 0;
}

/// Destructor
cahnhilliard3d_dofmap_1::~cahnhilliard3d_dofmap_1()
{
    // Do nothing
}

/// Return a string identifying the dofmap
const char* cahnhilliard3d_dofmap_1::signature() const
{
    return "FFC dofmap for FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)";
}

/// Return true iff mesh entities of topological dimension d are needed
bool cahnhilliard3d_dofmap_1::needs_mesh_entities(unsigned int d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
}

/// Initialize dofmap for mesh (return true iff init_cell() is needed)
bool cahnhilliard3d_dofmap_1::init_mesh(const ufc::mesh& m)
{
    _global_dimension = m.num_entities[0];
    return false;
}

/// Initialize dofmap for given cell
void cahnhilliard3d_dofmap_1::init_cell(const ufc::mesh& m,
                              const ufc::cell& c)
{
    // Do nothing
}

/// Finish initialization of dofmap for cells
void cahnhilliard3d_dofmap_1::init_cell_finalize()
{
    // Do nothing
}

/// Return the topological dimension of the associated cell shape
unsigned int cahnhilliard3d_dofmap_1::topological_dimension() const
{
    return 3;
}

/// Return the geometric dimension of the associated cell shape
unsigned int cahnhilliard3d_dofmap_1::geometric_dimension() const
{
    return 3;
}

/// Return the dimension of the global finite element function space
unsigned int cahnhilliard3d_dofmap_1::global_dimension() const
{
    return _global_dimension;
}

/// Return the dimension of the local finite element function space for a cell
unsigned int cahnhilliard3d_dofmap_1::local_dimension(const ufc::cell& c) const
{
    return 4;
}

/// Return the maximum dimension of the local finite element function space
unsigned int cahnhilliard3d_dofmap_1::max_local_dimension() const
{
    return 4;
}

/// Return the number of dofs on each cell facet
unsigned int cahnhilliard3d_dofmap_1::num_facet_dofs() const
{
    return 3;
}

/// Return the number of dofs associated with each cell entity of dimension d
unsigned int cahnhilliard3d_dofmap_1::num_entity_dofs(unsigned int d) const
{
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
}

/// Tabulate the local-to-global mapping of dofs on a cell
void cahnhilliard3d_dofmap_1::tabulate_dofs(unsigned int* dofs,
                                  const ufc::mesh& m,
                                  const ufc::cell& c) const
{
    dofs[0] = c.entity_indices[0][0];
    dofs[1] = c.entity_indices[0][1];
    dofs[2] = c.entity_indices[0][2];
    dofs[3] = c.entity_indices[0][3];
}

/// Tabulate the local-to-local mapping from facet dofs to cell dofs
void cahnhilliard3d_dofmap_1::tabulate_facet_dofs(unsigned int* dofs,
                                        unsigned int facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
}

/// Tabulate the local-to-local mapping of dofs on entity (d, i)
void cahnhilliard3d_dofmap_1::tabulate_entity_dofs(unsigned int* dofs,
                                  unsigned int d, unsigned int i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
}

/// Tabulate the coordinates of all dofs on a cell
void cahnhilliard3d_dofmap_1::tabulate_coordinates(double** coordinates,
                                         const ufc::cell& c) const
{
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[0][2] = x[0][2];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[1][2] = x[1][2];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[2][2] = x[2][2];
    coordinates[3][0] = x[3][0];
    coordinates[3][1] = x[3][1];
    coordinates[3][2] = x[3][2];
}

/// Return the number of sub dofmaps (for a mixed element)
unsigned int cahnhilliard3d_dofmap_1::num_sub_dofmaps() const
{
    return 0;
}

/// Create a new dofmap for sub dofmap i (for a mixed element)
ufc::dofmap* cahnhilliard3d_dofmap_1::create_sub_dofmap(unsigned int i) const
{
    return 0;
}

/// Create a new class instance
ufc::dofmap* cahnhilliard3d_dofmap_1::create() const
{
    return new cahnhilliard3d_dofmap_1();
}

/// Constructor
cahnhilliard3d_dofmap_2::cahnhilliard3d_dofmap_2() : ufc::dofmap()
{
    _global_dimension = 0;
}

/// Destructor
cahnhilliard3d_dofmap_2::~cahnhilliard3d_dofmap_2()
{
    // Do nothing
}

/// Return a string identifying the dofmap
const char* cahnhilliard3d_dofmap_2::signature() const
{
    return "FFC dofmap for MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) })";
}

/// Return true iff mesh entities of topological dimension d are needed
bool cahnhilliard3d_dofmap_2::needs_mesh_entities(unsigned int d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
}

/// Initialize dofmap for mesh (return true iff init_cell() is needed)
bool cahnhilliard3d_dofmap_2::init_mesh(const ufc::mesh& m)
{
    _global_dimension = 2.000000000000000*m.num_entities[0];
    return false;
}

/// Initialize dofmap for given cell
void cahnhilliard3d_dofmap_2::init_cell(const ufc::mesh& m,
                              const ufc::cell& c)
{
    // Do nothing
}

/// Finish initialization of dofmap for cells
void cahnhilliard3d_dofmap_2::init_cell_finalize()
{
    // Do nothing
}

/// Return the topological dimension of the associated cell shape
unsigned int cahnhilliard3d_dofmap_2::topological_dimension() const
{
    return 3;
}

/// Return the geometric dimension of the associated cell shape
unsigned int cahnhilliard3d_dofmap_2::geometric_dimension() const
{
    return 3;
}

/// Return the dimension of the global finite element function space
unsigned int cahnhilliard3d_dofmap_2::global_dimension() const
{
    return _global_dimension;
}

/// Return the dimension of the local finite element function space for a cell
unsigned int cahnhilliard3d_dofmap_2::local_dimension(const ufc::cell& c) const
{
    return 8;
}

/// Return the maximum dimension of the local finite element function space
unsigned int cahnhilliard3d_dofmap_2::max_local_dimension() const
{
    return 8;
}

/// Return the number of dofs on each cell facet
unsigned int cahnhilliard3d_dofmap_2::num_facet_dofs() const
{
    return 6;
}

/// Return the number of dofs associated with each cell entity of dimension d
unsigned int cahnhilliard3d_dofmap_2::num_entity_dofs(unsigned int d) const
{
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
}

/// Tabulate the local-to-global mapping of dofs on a cell
void cahnhilliard3d_dofmap_2::tabulate_dofs(unsigned int* dofs,
                                  const ufc::mesh& m,
                                  const ufc::cell& c) const
{
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
    dofs[4] = offset + c.entity_indices[0][0];
    dofs[5] = offset + c.entity_indices[0][1];
    dofs[6] = offset + c.entity_indices[0][2];
    dofs[7] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
}

/// Tabulate the local-to-local mapping from facet dofs to cell dofs
void cahnhilliard3d_dofmap_2::tabulate_facet_dofs(unsigned int* dofs,
                                        unsigned int facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 6;
      dofs[5] = 7;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 6;
      dofs[5] = 7;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 7;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
        break;
      }
    }
    
}

/// Tabulate the local-to-local mapping of dofs on entity (d, i)
void cahnhilliard3d_dofmap_2::tabulate_entity_dofs(unsigned int* dofs,
                                  unsigned int d, unsigned int i) const
{
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 6;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 7;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
}

/// Tabulate the coordinates of all dofs on a cell
void cahnhilliard3d_dofmap_2::tabulate_coordinates(double** coordinates,
                                         const ufc::cell& c) const
{
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[0][2] = x[0][2];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[1][2] = x[1][2];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[2][2] = x[2][2];
    coordinates[3][0] = x[3][0];
    coordinates[3][1] = x[3][1];
    coordinates[3][2] = x[3][2];
    coordinates[4][0] = x[0][0];
    coordinates[4][1] = x[0][1];
    coordinates[4][2] = x[0][2];
    coordinates[5][0] = x[1][0];
    coordinates[5][1] = x[1][1];
    coordinates[5][2] = x[1][2];
    coordinates[6][0] = x[2][0];
    coordinates[6][1] = x[2][1];
    coordinates[6][2] = x[2][2];
    coordinates[7][0] = x[3][0];
    coordinates[7][1] = x[3][1];
    coordinates[7][2] = x[3][2];
}

/// Return the number of sub dofmaps (for a mixed element)
unsigned int cahnhilliard3d_dofmap_2::num_sub_dofmaps() const
{
    return 2;
}

/// Create a new dofmap for sub dofmap i (for a mixed element)
ufc::dofmap* cahnhilliard3d_dofmap_2::create_sub_dofmap(unsigned int i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_dofmap_1();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_dofmap_1();
        break;
      }
    }
    
    return 0;
}

/// Create a new class instance
ufc::dofmap* cahnhilliard3d_dofmap_2::create() const
{
    return new cahnhilliard3d_dofmap_2();
}

/// Constructor
cahnhilliard3d_cell_integral_0_0::cahnhilliard3d_cell_integral_0_0() : ufc::cell_integral()
{
    // Do nothing
}

/// Destructor
cahnhilliard3d_cell_integral_0_0::~cahnhilliard3d_cell_integral_0_0()
{
    // Do nothing
}

/// Tabulate the tensor for the contribution from a local cell
void cahnhilliard3d_cell_integral_0_0::tabulate_tensor(double* A,
                                    const double * const * w,
                                    const ufc::cell& c) const
{
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Cell Volume.
    
    // Compute circumradius.
    
    
    // Array of quadrature weights.
    static const double W14[14] = {0.003174603174603, 0.003174603174603, 0.003174603174603, 0.003174603174603, 0.003174603174603, 0.003174603174603, 0.014764970790497, 0.014764970790497, 0.014764970790497, 0.014764970790497, 0.022139791114265, 0.022139791114265, 0.022139791114265, 0.022139791114265};
    // Quadrature points on the UFC reference element: (0.000000000000000, 0.500000000000000, 0.500000000000000), (0.500000000000000, 0.000000000000000, 0.500000000000000), (0.500000000000000, 0.500000000000000, 0.000000000000000), (0.500000000000000, 0.000000000000000, 0.000000000000000), (0.000000000000000, 0.500000000000000, 0.000000000000000), (0.000000000000000, 0.000000000000000, 0.500000000000000), (0.698419704324387, 0.100526765225204, 0.100526765225204), (0.100526765225204, 0.100526765225204, 0.100526765225204), (0.100526765225204, 0.100526765225204, 0.698419704324387), (0.100526765225204, 0.698419704324387, 0.100526765225204), (0.056881379520423, 0.314372873493192, 0.314372873493192), (0.314372873493192, 0.314372873493192, 0.314372873493192), (0.314372873493192, 0.314372873493192, 0.056881379520423), (0.314372873493192, 0.056881379520423, 0.314372873493192)
    
    // Value of basis functions at quadrature points.
    static const double FE1_C0[14][4] = \
    {{0.000000000000000, 0.000000000000000, 0.500000000000000, 0.500000000000000},
    {0.000000000000000, 0.500000000000000, 0.000000000000000, 0.500000000000000},
    {0.000000000000000, 0.500000000000000, 0.500000000000000, 0.000000000000000},
    {0.500000000000000, 0.500000000000000, 0.000000000000000, 0.000000000000000},
    {0.500000000000000, 0.000000000000000, 0.500000000000000, 0.000000000000000},
    {0.500000000000000, 0.000000000000000, 0.000000000000000, 0.500000000000000},
    {0.100526765225204, 0.698419704324386, 0.100526765225205, 0.100526765225205},
    {0.698419704324386, 0.100526765225204, 0.100526765225205, 0.100526765225205},
    {0.100526765225204, 0.100526765225204, 0.100526765225205, 0.698419704324386},
    {0.100526765225204, 0.100526765225204, 0.698419704324386, 0.100526765225205},
    {0.314372873493192, 0.056881379520423, 0.314372873493192, 0.314372873493192},
    {0.056881379520423, 0.314372873493192, 0.314372873493192, 0.314372873493192},
    {0.314372873493192, 0.314372873493192, 0.314372873493192, 0.056881379520423},
    {0.314372873493192, 0.314372873493192, 0.056881379520423, 0.314372873493192}};
    
    // Array of non-zero columns
    static const unsigned int nzc0[4] = {0, 1, 2, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc4[4] = {4, 5, 6, 7};
    
    static const double FE1_C0_D001[14][2] = \
    {{-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000}};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc3[2] = {0, 1};
    
    // Array of non-zero columns
    static const unsigned int nzc2[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc6[2] = {4, 6};
    
    // Array of non-zero columns
    static const unsigned int nzc7[2] = {4, 5};
    
    // Array of non-zero columns
    static const unsigned int nzc5[2] = {4, 7};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 64; r++)
    {
      A[r] = 0.000000000000000;
    }// end loop over 'r'
    // Number of operations to compute geometry constants: 93.
    double G[15];
    G[0] =  - det*w[1][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12);
    G[1] =  - det*w[1][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22);
    G[2] =  - det*w[1][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12);
    G[3] = det*w[2][0]*w[3][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02);
    G[4] = det*w[2][0]*w[3][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22);
    G[5] = det*w[2][0]*w[3][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12);
    G[6] =  - det*w[1][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22);
    G[7] =  - det*w[1][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22);
    G[8] = det*w[2][0]*w[3][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22);
    G[9] = det*w[2][0]*w[3][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22);
    G[10] = det*w[2][0]*w[3][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12);
    G[11] =  - det*w[1][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02);
    G[12] = -2.000000000000000e+02*det;
    G[13] = -1.200000000000000e+03*det;
    G[14] = 1.200000000000000e+03*det;
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 5404
    for (unsigned int ip = 0; ip < 14; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.000000000000000;
      
      // Total number of operations to compute function values = 8
      for (unsigned int r = 0; r < 4; r++)
      {
        F0 += FE1_C0[ip][r]*w[0][nzc0[r]];
      }// end loop over 'r'
      
      // Number of operations to compute ip constants: 18
      double I[14];
      // Number of operations: 1
      I[0] = G[0]*W14[ip];
      
      // Number of operations: 1
      I[1] = G[1]*W14[ip];
      
      // Number of operations: 1
      I[2] = G[2]*W14[ip];
      
      // Number of operations: 1
      I[3] = G[3]*W14[ip];
      
      // Number of operations: 1
      I[4] = G[4]*W14[ip];
      
      // Number of operations: 1
      I[5] = G[5]*W14[ip];
      
      // Number of operations: 1
      I[6] = G[6]*W14[ip];
      
      // Number of operations: 1
      I[7] = G[7]*W14[ip];
      
      // Number of operations: 1
      I[8] = G[8]*W14[ip];
      
      // Number of operations: 1
      I[9] = G[9]*W14[ip];
      
      // Number of operations: 1
      I[10] = G[10]*W14[ip];
      
      // Number of operations: 1
      I[11] = G[11]*W14[ip];
      
      // Number of operations: 5
      I[12] = W14[ip]*(G[12] + F0*(G[14] + F0*G[13]));
      
      // Number of operations: 1
      I[13] = W14[ip]*det;
      
      
      // Number of operations for primary indices: 216
      for (unsigned int j = 0; j < 2; j++)
      {
        for (unsigned int k = 0; k < 2; k++)
        {
          // Number of operations to compute entry: 3
          A[nzc6[j]*8 + nzc2[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[0];
          // Number of operations to compute entry: 3
          A[nzc5[j]*8 + nzc3[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[1];
          // Number of operations to compute entry: 3
          A[nzc7[j]*8 + nzc2[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[2];
          // Number of operations to compute entry: 3
          A[nzc3[j]*8 + nzc7[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[3];
          // Number of operations to compute entry: 3
          A[nzc1[j]*8 + nzc6[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[4];
          // Number of operations to compute entry: 3
          A[nzc3[j]*8 + nzc6[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[5];
          // Number of operations to compute entry: 3
          A[nzc5[j]*8 + nzc1[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[6];
          // Number of operations to compute entry: 3
          A[nzc6[j]*8 + nzc1[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[7];
          // Number of operations to compute entry: 3
          A[nzc6[j]*8 + nzc3[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[2];
          // Number of operations to compute entry: 3
          A[nzc1[j]*8 + nzc5[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[8];
          // Number of operations to compute entry: 3
          A[nzc3[j]*8 + nzc5[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[9];
          // Number of operations to compute entry: 3
          A[nzc2[j]*8 + nzc5[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[4];
          // Number of operations to compute entry: 3
          A[nzc7[j]*8 + nzc1[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[1];
          // Number of operations to compute entry: 3
          A[nzc1[j]*8 + nzc7[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[9];
          // Number of operations to compute entry: 3
          A[nzc5[j]*8 + nzc2[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[7];
          // Number of operations to compute entry: 3
          A[nzc2[j]*8 + nzc6[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[10];
          // Number of operations to compute entry: 3
          A[nzc2[j]*8 + nzc7[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[5];
          // Number of operations to compute entry: 3
          A[nzc7[j]*8 + nzc3[k]] += FE1_C0_D001[ip][j]*FE1_C0_D001[ip][k]*I[11];
        }// end loop over 'k'
      }// end loop over 'j'
      
      // Number of operations for primary indices: 144
      for (unsigned int j = 0; j < 4; j++)
      {
        for (unsigned int k = 0; k < 4; k++)
        {
          // Number of operations to compute entry: 3
          A[nzc4[j]*8 + nzc0[k]] += FE1_C0[ip][j]*FE1_C0[ip][k]*I[12];
          // Number of operations to compute entry: 3
          A[nzc0[j]*8 + nzc0[k]] += FE1_C0[ip][j]*FE1_C0[ip][k]*I[13];
          // Number of operations to compute entry: 3
          A[nzc4[j]*8 + nzc4[k]] += FE1_C0[ip][j]*FE1_C0[ip][k]*I[13];
        }// end loop over 'k'
      }// end loop over 'j'
    }// end loop over 'ip'
}

/// Tabulate the tensor for the contribution from a local cell
/// using the specified reference cell quadrature points/weights
void cahnhilliard3d_cell_integral_0_0::tabulate_tensor(double* A,
                     const double * const * w,
                     const ufc::cell& c,
                     unsigned int num_quadrature_points,
                     const double * const * quadrature_points,
                     const double* quadrature_weights) const
{
    throw std::runtime_error("Quadrature version of tabulate_tensor not yet implemented (introduced in UFC 2.0).");
}

/// Constructor
cahnhilliard3d_cell_integral_1_0::cahnhilliard3d_cell_integral_1_0() : ufc::cell_integral()
{
    // Do nothing
}

/// Destructor
cahnhilliard3d_cell_integral_1_0::~cahnhilliard3d_cell_integral_1_0()
{
    // Do nothing
}

/// Tabulate the tensor for the contribution from a local cell
void cahnhilliard3d_cell_integral_1_0::tabulate_tensor(double* A,
                                    const double * const * w,
                                    const ufc::cell& c) const
{
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Cell Volume.
    
    // Compute circumradius.
    
    
    // Array of quadrature weights.
    static const double W14[14] = {0.003174603174603, 0.003174603174603, 0.003174603174603, 0.003174603174603, 0.003174603174603, 0.003174603174603, 0.014764970790497, 0.014764970790497, 0.014764970790497, 0.014764970790497, 0.022139791114265, 0.022139791114265, 0.022139791114265, 0.022139791114265};
    // Quadrature points on the UFC reference element: (0.000000000000000, 0.500000000000000, 0.500000000000000), (0.500000000000000, 0.000000000000000, 0.500000000000000), (0.500000000000000, 0.500000000000000, 0.000000000000000), (0.500000000000000, 0.000000000000000, 0.000000000000000), (0.000000000000000, 0.500000000000000, 0.000000000000000), (0.000000000000000, 0.000000000000000, 0.500000000000000), (0.698419704324387, 0.100526765225204, 0.100526765225204), (0.100526765225204, 0.100526765225204, 0.100526765225204), (0.100526765225204, 0.100526765225204, 0.698419704324387), (0.100526765225204, 0.698419704324387, 0.100526765225204), (0.056881379520423, 0.314372873493192, 0.314372873493192), (0.314372873493192, 0.314372873493192, 0.314372873493192), (0.314372873493192, 0.314372873493192, 0.056881379520423), (0.314372873493192, 0.056881379520423, 0.314372873493192)
    
    // Value of basis functions at quadrature points.
    static const double FE1_C0[14][4] = \
    {{0.000000000000000, 0.000000000000000, 0.500000000000000, 0.500000000000000},
    {0.000000000000000, 0.500000000000000, 0.000000000000000, 0.500000000000000},
    {0.000000000000000, 0.500000000000000, 0.500000000000000, 0.000000000000000},
    {0.500000000000000, 0.500000000000000, 0.000000000000000, 0.000000000000000},
    {0.500000000000000, 0.000000000000000, 0.500000000000000, 0.000000000000000},
    {0.500000000000000, 0.000000000000000, 0.000000000000000, 0.500000000000000},
    {0.100526765225204, 0.698419704324386, 0.100526765225205, 0.100526765225205},
    {0.698419704324386, 0.100526765225204, 0.100526765225205, 0.100526765225205},
    {0.100526765225204, 0.100526765225204, 0.100526765225205, 0.698419704324386},
    {0.100526765225204, 0.100526765225204, 0.698419704324386, 0.100526765225205},
    {0.314372873493192, 0.056881379520423, 0.314372873493192, 0.314372873493192},
    {0.056881379520423, 0.314372873493192, 0.314372873493192, 0.314372873493192},
    {0.314372873493192, 0.314372873493192, 0.314372873493192, 0.056881379520423},
    {0.314372873493192, 0.314372873493192, 0.056881379520423, 0.314372873493192}};
    
    // Array of non-zero columns
    static const unsigned int nzc0[4] = {0, 1, 2, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc4[4] = {4, 5, 6, 7};
    
    static const double FE1_C0_D001[14][2] = \
    {{-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000}};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc3[2] = {0, 1};
    
    // Array of non-zero columns
    static const unsigned int nzc2[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc6[2] = {4, 6};
    
    // Array of non-zero columns
    static const unsigned int nzc7[2] = {4, 5};
    
    // Array of non-zero columns
    static const unsigned int nzc5[2] = {4, 7};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 8; r++)
    {
      A[r] = 0.000000000000000;
    }// end loop over 'r'
    // Number of operations to compute geometry constants: 177.
    double G[21];
    G[0] = det*w[3][0]*w[4][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22);
    G[1] = det*w[3][0]*w[4][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22);
    G[2] = det*w[3][0]*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22);
    G[3] = det*w[3][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22 - w[4][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22));
    G[4] = det*w[3][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22 - w[4][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22));
    G[5] = det*w[3][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22 - w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[6] =  - det*w[2][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22);
    G[7] =  - det*w[2][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02);
    G[8] =  - det*w[2][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12);
    G[9] = det*w[3][0]*w[4][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12);
    G[10] = det*w[3][0]*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12);
    G[11] = det*w[3][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12 - w[4][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12));
    G[12] = det*w[3][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12 - w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[13] =  - det*w[2][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22);
    G[14] =  - det*w[2][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22);
    G[15] =  - det*w[2][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12);
    G[16] = det*w[3][0]*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02);
    G[17] = det*w[3][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02 - w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[18] = -4.000000000000000e+02*det;
    G[19] = 6.000000000000000e+02*det;
    G[20] = -2.000000000000000e+02*det;
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 2310
    for (unsigned int ip = 0; ip < 14; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.000000000000000;
      double F1 = 0.000000000000000;
      double F2 = 0.000000000000000;
      double F3 = 0.000000000000000;
      double F4 = 0.000000000000000;
      double F5 = 0.000000000000000;
      double F6 = 0.000000000000000;
      double F7 = 0.000000000000000;
      double F8 = 0.000000000000000;
      double F9 = 0.000000000000000;
      double F10 = 0.000000000000000;
      double F11 = 0.000000000000000;
      
      // Total number of operations to compute function values = 36
      for (unsigned int r = 0; r < 2; r++)
      {
        F0 += FE1_C0_D001[ip][r]*w[0][nzc7[r]];
        F1 += FE1_C0_D001[ip][r]*w[0][nzc6[r]];
        F2 += FE1_C0_D001[ip][r]*w[0][nzc5[r]];
        F3 += FE1_C0_D001[ip][r]*w[1][nzc7[r]];
        F4 += FE1_C0_D001[ip][r]*w[1][nzc6[r]];
        F5 += FE1_C0_D001[ip][r]*w[1][nzc5[r]];
        F8 += FE1_C0_D001[ip][r]*w[0][nzc3[r]];
        F9 += FE1_C0_D001[ip][r]*w[0][nzc2[r]];
        F10 += FE1_C0_D001[ip][r]*w[0][nzc1[r]];
      }// end loop over 'r'
      
      // Total number of operations to compute function values = 24
      for (unsigned int r = 0; r < 4; r++)
      {
        F6 += FE1_C0[ip][r]*w[0][nzc0[r]];
        F7 += FE1_C0[ip][r]*w[1][nzc0[r]];
        F11 += FE1_C0[ip][r]*w[0][nzc4[r]];
      }// end loop over 'r'
      
      // Number of operations to compute ip constants: 65
      double I[8];
      // Number of operations: 12
      I[0] = W14[ip]*(F0*G[0] + F1*G[1] + F2*G[2] + F3*G[3] + F4*G[4] + F5*G[5]);
      
      // Number of operations: 6
      I[1] = W14[ip]*(F10*G[6] + F8*G[7] + F9*G[8]);
      
      // Number of operations: 12
      I[2] = W14[ip]*(F0*G[9] + F1*G[10] + F2*G[1] + F3*G[11] + F4*G[12] + F5*G[4]);
      
      // Number of operations: 6
      I[3] = W14[ip]*(F10*G[13] + F8*G[6] + F9*G[14]);
      
      // Number of operations: 6
      I[4] = W14[ip]*(F10*G[14] + F8*G[8] + F9*G[15]);
      
      // Number of operations: 12
      I[5] = W14[ip]*(F0*G[16] + F1*G[9] + F2*G[0] + F3*G[17] + F4*G[11] + F5*G[3]);
      
      // Number of operations: 3
      I[6] = W14[ip]*det*(F6 - F7);
      
      // Number of operations: 8
      I[7] = W14[ip]*(F11*det + F6*(G[20] + F6*(G[19] + F6*G[18])));
      
      
      // Number of operations for primary indices: 24
      for (unsigned int j = 0; j < 2; j++)
      {
        // Number of operations to compute entry: 2
        A[nzc1[j]] += FE1_C0_D001[ip][j]*I[0];
        // Number of operations to compute entry: 2
        A[nzc7[j]] += FE1_C0_D001[ip][j]*I[1];
        // Number of operations to compute entry: 2
        A[nzc2[j]] += FE1_C0_D001[ip][j]*I[2];
        // Number of operations to compute entry: 2
        A[nzc5[j]] += FE1_C0_D001[ip][j]*I[3];
        // Number of operations to compute entry: 2
        A[nzc6[j]] += FE1_C0_D001[ip][j]*I[4];
        // Number of operations to compute entry: 2
        A[nzc3[j]] += FE1_C0_D001[ip][j]*I[5];
      }// end loop over 'j'
      
      // Number of operations for primary indices: 16
      for (unsigned int j = 0; j < 4; j++)
      {
        // Number of operations to compute entry: 2
        A[nzc0[j]] += FE1_C0[ip][j]*I[6];
        // Number of operations to compute entry: 2
        A[nzc4[j]] += FE1_C0[ip][j]*I[7];
      }// end loop over 'j'
    }// end loop over 'ip'
}

/// Tabulate the tensor for the contribution from a local cell
/// using the specified reference cell quadrature points/weights
void cahnhilliard3d_cell_integral_1_0::tabulate_tensor(double* A,
                     const double * const * w,
                     const ufc::cell& c,
                     unsigned int num_quadrature_points,
                     const double * const * quadrature_points,
                     const double* quadrature_weights) const
{
    throw std::runtime_error("Quadrature version of tabulate_tensor not yet implemented (introduced in UFC 2.0).");
}

/// Constructor
cahnhilliard3d_form_0::cahnhilliard3d_form_0() : ufc::form()
{
    // Do nothing
}

/// Destructor
cahnhilliard3d_form_0::~cahnhilliard3d_form_0()
{
    // Do nothing
}

/// Return a string identifying the form
const char* cahnhilliard3d_form_0::signature() const
{
    return "Form([Integral(Sum(Sum(Product(Constant(Cell('tetrahedron', Space(3)), 2), IndexSum(Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((Index(0),), {Index(0): 3})), MultiIndex((FixedIndex(0),), {})), MultiIndex((Index(0),), {Index(0): 3})), MultiIndex((Index(1),), {Index(1): 3})), Indexed(ComponentTensor(Product(Constant(Cell('tetrahedron', Space(3)), 3), Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 1), MultiIndex((Index(2),), {Index(2): 3})), MultiIndex((FixedIndex(1),), {}))), MultiIndex((Index(2),), {Index(2): 3})), MultiIndex((Index(1),), {Index(1): 3}))), MultiIndex((Index(1),), {Index(1): 3}))), Product(Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 1), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})))), Sum(Product(IntValue(-1, (), (), {}), Product(Constant(Cell('tetrahedron', Space(3)), 1), IndexSum(Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((Index(3),), {Index(3): 3})), MultiIndex((FixedIndex(1),), {})), MultiIndex((Index(3),), {Index(3): 3})), MultiIndex((Index(4),), {Index(4): 3})), Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 1), MultiIndex((Index(5),), {Index(5): 3})), MultiIndex((FixedIndex(0),), {})), MultiIndex((Index(5),), {Index(5): 3})), MultiIndex((Index(4),), {Index(4): 3}))), MultiIndex((Index(4),), {Index(4): 3})))), Sum(Product(Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(1),), {FixedIndex(1): 2})), Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 1), MultiIndex((FixedIndex(1),), {FixedIndex(1): 2}))), Product(IntValue(-1, (), (), {}), Product(Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(1),), {FixedIndex(1): 2})), Sum(Sum(Product(Power(Sum(IntValue(1, (), (), {}), Product(IntValue(-1, (), (), {}), Variable(Indexed(Coefficient(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), Label(0)))), IntValue(2, (), (), {})), Product(IntValue(100, (), (), {}), Product(IntValue(2, (), (), {}), Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 1), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2}))))), Product(Product(IntValue(100, (), (), {}), Product(IntValue(2, (), (), {}), Variable(Indexed(Coefficient(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), Label(0)))), Product(Product(IntValue(2, (), (), {}), Product(IntValue(-1, (), (), {}), Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 1), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})))), Sum(IntValue(1, (), (), {}), Product(IntValue(-1, (), (), {}), Variable(Indexed(Coefficient(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), Label(0))))))), Sum(Product(Product(IntValue(100, (), (), {}), Power(Variable(Indexed(Coefficient(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), Label(0)), IntValue(2, (), (), {}))), Product(IntValue(-2, (), (), {}), Product(IntValue(-1, (), (), {}), Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 1), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2}))))), Product(Product(IntValue(100, (), (), {}), Product(Product(IntValue(2, (), (), {}), Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 1), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2}))), Variable(Indexed(Coefficient(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), Label(0)))), Product(IntValue(-2, (), (), {}), Sum(IntValue(1, (), (), {}), Product(IntValue(-1, (), (), {}), Variable(Indexed(Coefficient(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), Label(0))))))))))))), Measure('cell', 0, None))])";
}

/// Return the rank of the global tensor (r)
unsigned int cahnhilliard3d_form_0::rank() const
{
    return 2;
}

/// Return the number of coefficients (n)
unsigned int cahnhilliard3d_form_0::num_coefficients() const
{
    return 4;
}

/// Return the number of cell domains
unsigned int cahnhilliard3d_form_0::num_cell_domains() const
{
    return 1;
}

/// Return the number of exterior facet domains
unsigned int cahnhilliard3d_form_0::num_exterior_facet_domains() const
{
    return 0;
}

/// Return the number of interior facet domains
unsigned int cahnhilliard3d_form_0::num_interior_facet_domains() const
{
    return 0;
}

/// Create a new finite element for argument function i
ufc::finite_element* cahnhilliard3d_form_0::create_finite_element(unsigned int i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    case 4:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    case 5:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new dofmap for argument function i
ufc::dofmap* cahnhilliard3d_form_0::create_dofmap(unsigned int i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    case 4:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    case 5:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new cell integral on sub domain i
ufc::cell_integral* cahnhilliard3d_form_0::create_cell_integral(unsigned int i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new exterior facet integral on sub domain i
ufc::exterior_facet_integral* cahnhilliard3d_form_0::create_exterior_facet_integral(unsigned int i) const
{
    return 0;
}

/// Create a new interior facet integral on sub domain i
ufc::interior_facet_integral* cahnhilliard3d_form_0::create_interior_facet_integral(unsigned int i) const
{
    return 0;
}

/// Constructor
cahnhilliard3d_form_1::cahnhilliard3d_form_1() : ufc::form()
{
    // Do nothing
}

/// Destructor
cahnhilliard3d_form_1::~cahnhilliard3d_form_1()
{
    // Do nothing
}

/// Return a string identifying the form
const char* cahnhilliard3d_form_1::signature() const
{
    return "Form([Integral(Sum(Sum(Product(Constant(Cell('tetrahedron', Space(3)), 3), IndexSum(Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((Index(0),), {Index(0): 3})), MultiIndex((FixedIndex(0),), {})), MultiIndex((Index(0),), {Index(0): 3})), MultiIndex((Index(1),), {Index(1): 3})), Indexed(ComponentTensor(Sum(Product(Constant(Cell('tetrahedron', Space(3)), 4), Indexed(SpatialDerivative(Coefficient(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((Index(2),), {Index(2): 3})), MultiIndex((FixedIndex(1),), {}))), Product(Indexed(SpatialDerivative(Coefficient(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 1), MultiIndex((Index(2),), {Index(2): 3})), MultiIndex((FixedIndex(1),), {})), Sum(IntValue(1, (), (), {}), Product(IntValue(-1, (), (), {}), Constant(Cell('tetrahedron', Space(3)), 4))))), MultiIndex((Index(2),), {Index(2): 3})), MultiIndex((Index(1),), {Index(1): 3}))), MultiIndex((Index(1),), {Index(1): 3}))), Sum(Product(Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), Variable(Indexed(Coefficient(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), Label(0))), Product(IntValue(-1, (), (), {}), Product(Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), Indexed(Coefficient(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 1), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})))))), Sum(Product(IntValue(-1, (), (), {}), Product(Constant(Cell('tetrahedron', Space(3)), 2), IndexSum(Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((Index(3),), {Index(3): 3})), MultiIndex((FixedIndex(1),), {})), MultiIndex((Index(3),), {Index(3): 3})), MultiIndex((Index(4),), {Index(4): 3})), Indexed(ComponentTensor(Indexed(SpatialDerivative(Coefficient(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((Index(5),), {Index(5): 3})), MultiIndex((FixedIndex(0),), {})), MultiIndex((Index(5),), {Index(5): 3})), MultiIndex((Index(4),), {Index(4): 3}))), MultiIndex((Index(4),), {Index(4): 3})))), Sum(Product(Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(1),), {FixedIndex(1): 2})), Indexed(Coefficient(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(1),), {FixedIndex(1): 2}))), Product(IntValue(-1, (), (), {}), Product(Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(1),), {FixedIndex(1): 2})), Sum(Product(Power(Sum(IntValue(1, (), (), {}), Product(IntValue(-1, (), (), {}), Variable(Indexed(Coefficient(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), Label(0)))), IntValue(2, (), (), {})), Product(IntValue(100, (), (), {}), Product(IntValue(2, (), (), {}), Variable(Indexed(Coefficient(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), Label(0))))), Product(Product(IntValue(100, (), (), {}), Power(Variable(Indexed(Coefficient(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), Label(0)), IntValue(2, (), (), {}))), Product(IntValue(-2, (), (), {}), Sum(IntValue(1, (), (), {}), Product(IntValue(-1, (), (), {}), Variable(Indexed(Coefficient(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (2,) }), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2})), Label(0)))))))))))), Measure('cell', 0, None))])";
}

/// Return the rank of the global tensor (r)
unsigned int cahnhilliard3d_form_1::rank() const
{
    return 1;
}

/// Return the number of coefficients (n)
unsigned int cahnhilliard3d_form_1::num_coefficients() const
{
    return 5;
}

/// Return the number of cell domains
unsigned int cahnhilliard3d_form_1::num_cell_domains() const
{
    return 1;
}

/// Return the number of exterior facet domains
unsigned int cahnhilliard3d_form_1::num_exterior_facet_domains() const
{
    return 0;
}

/// Return the number of interior facet domains
unsigned int cahnhilliard3d_form_1::num_interior_facet_domains() const
{
    return 0;
}

/// Create a new finite element for argument function i
ufc::finite_element* cahnhilliard3d_form_1::create_finite_element(unsigned int i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_finite_element_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    case 4:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    case 5:
      {
        return new cahnhilliard3d_finite_element_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new dofmap for argument function i
ufc::dofmap* cahnhilliard3d_form_1::create_dofmap(unsigned int i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 1:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 2:
      {
        return new cahnhilliard3d_dofmap_2();
        break;
      }
    case 3:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    case 4:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    case 5:
      {
        return new cahnhilliard3d_dofmap_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new cell integral on sub domain i
ufc::cell_integral* cahnhilliard3d_form_1::create_cell_integral(unsigned int i) const
{
    switch (i)
    {
    case 0:
      {
        return new cahnhilliard3d_cell_integral_1_0();
        break;
      }
    }
    
    return 0;
}

/// Create a new exterior facet integral on sub domain i
ufc::exterior_facet_integral* cahnhilliard3d_form_1::create_exterior_facet_integral(unsigned int i) const
{
    return 0;
}

/// Create a new interior facet integral on sub domain i
ufc::interior_facet_integral* cahnhilliard3d_form_1::create_interior_facet_integral(unsigned int i) const
{
    return 0;
}

