// This code conforms with the UFC specification version 1.4
// and was automatically generated by FFC version 0.9.2.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   epsilon:                        1e-14
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   optimize:                       False
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __POISSON3D_3_H
#define __POISSON3D_3_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class poisson3d_3_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  poisson3d_3_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_3_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 3)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 20;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    *values = 0.000000000000000;
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[20] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    unsigned int tt = 0;
    double tmp5 = 0.000000000000000;
    double tmp6 = 0.000000000000000;
    double tmp7 = 0.000000000000000;
    double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
    double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
    double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
    double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
    double tmp4 = tmp3*tmp3;
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 1; r < 3; r++)
    {
      rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
      ss = r*(r + 1)*(r + 2)/6;
      tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
      basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 3; r++)
    {
      rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
      ss = r*(r + 1)*(r + 2)/6;
      basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
    }// end loop over 'r'
    for (unsigned int r = 0; r < 2; r++)
    {
      for (unsigned int s = 1; s < 3 - r; s++)
      {
        rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
        tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 3; r++)
    {
      for (unsigned int s = 0; s < 3 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 2; r++)
    {
      for (unsigned int s = 0; s < 2 - r; s++)
      {
        for (unsigned int t = 1; t < 3 - r - s; t++)
        {
          rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
          ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
          tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 0; s < 4 - r; s++)
      {
        for (unsigned int t = 0; t < 4 - r - s; t++)
        {
          rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[20][20] = \
    {{0.028867513459481, 0.013041013273933, 0.007529232524210, 0.005323971374999, 0.018298126367785, 0.014173667737846, 0.011572751247157, 0.008183170883850, 0.006681531047811, 0.004724555912615, -0.028347335475692, -0.023957871187498, -0.020748125068968, -0.018557687223952, -0.016071428571429, -0.013122266479196, -0.010714285714286, -0.009278843611976, -0.007576144084142, -0.005357142857143},
    {0.028867513459481, -0.013041013273933, 0.007529232524210, 0.005323971375000, 0.018298126367785, -0.014173667737846, -0.011572751247157, 0.008183170883850, 0.006681531047811, 0.004724555912615, 0.028347335475692, -0.023957871187498, -0.020748125068968, 0.018557687223952, 0.016071428571429, 0.013122266479196, -0.010714285714286, -0.009278843611976, -0.007576144084142, -0.005357142857143},
    {0.028867513459481, 0.000000000000000, -0.015058465048421, 0.005323971375000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.024549512651549, -0.013363062095621, 0.004724555912615, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.042857142857143, -0.027836530835928, 0.015152288168283, -0.005357142857143},
    {0.028867513459481, 0.000000000000000, 0.000000000000000, -0.015971914124999, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.028347335475692, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.053571428571429},
    {0.000000000000000, 0.000000000000000, 0.112938487863156, -0.063887656499994, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.073648537954647, 0.026726124191242, -0.023622779563077, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.064951905283833, -0.060609152673133, 0.026785714285714},
    {0.000000000000000, 0.000000000000000, -0.022587697572631, 0.127775312999988, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.066815310478106, 0.047245559126153, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.075761440841416, -0.053571428571429},
    {0.000000000000000, 0.097807599554494, -0.056469243931578, -0.063887656499994, 0.054894379103355, -0.042521003213538, 0.023145502494314, 0.024549512651549, -0.013363062095621, -0.023622779563077, 0.000000000000000, 0.000000000000000, 0.048412291827593, 0.000000000000000, -0.037500000000000, -0.052489065916782, 0.000000000000000, 0.021650635094611, 0.030304576336566, 0.026785714285714},
    {0.000000000000000, -0.019561519910899, 0.011293848786316, 0.127775312999988, 0.000000000000000, 0.000000000000000, 0.057863756235784, 0.000000000000000, -0.033407655239053, 0.047245559126153, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.065611332395978, 0.000000000000000, 0.000000000000000, -0.037880720420708, -0.053571428571429},
    {0.000000000000000, 0.097807599554494, -0.079056941504209, -0.031943828249997, 0.054894379103355, 0.014173667737846, -0.046291004988628, -0.024549512651549, 0.013363062095621, 0.023622779563077, 0.000000000000000, 0.047915742374995, -0.006916041689656, -0.061858957413174, -0.016071428571429, 0.008748177652797, 0.042857142857143, 0.015464739353294, 0.000000000000000, -0.005357142857143},
    {0.000000000000000, -0.019561519910899, 0.124232336649472, -0.031943828249997, 0.000000000000000, 0.056694670951384, -0.011572751247157, 0.024549512651549, -0.046770717334674, 0.023622779563077, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.061858957413174, -0.021428571428571, 0.004374088826399, -0.064285714285714, 0.009278843611976, 0.007576144084142, -0.005357142857143},
    {0.000000000000000, -0.097807599554494, -0.056469243931578, -0.063887656499994, 0.054894379103355, 0.042521003213538, -0.023145502494314, 0.024549512651549, -0.013363062095621, -0.023622779563077, 0.000000000000000, 0.000000000000000, 0.048412291827593, 0.000000000000000, 0.037500000000000, 0.052489065916782, 0.000000000000000, 0.021650635094611, 0.030304576336566, 0.026785714285714},
    {0.000000000000000, 0.019561519910899, 0.011293848786316, 0.127775312999988, 0.000000000000000, 0.000000000000000, -0.057863756235785, 0.000000000000000, -0.033407655239053, 0.047245559126153, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.065611332395978, 0.000000000000000, 0.000000000000000, -0.037880720420708, -0.053571428571429},
    {0.000000000000000, -0.097807599554494, -0.079056941504210, -0.031943828249997, 0.054894379103355, -0.014173667737846, 0.046291004988628, -0.024549512651549, 0.013363062095621, 0.023622779563077, 0.000000000000000, 0.047915742374995, -0.006916041689656, 0.061858957413174, 0.016071428571429, -0.008748177652797, 0.042857142857143, 0.015464739353294, 0.000000000000000, -0.005357142857143},
    {0.000000000000000, 0.019561519910899, 0.124232336649472, -0.031943828249997, 0.000000000000000, -0.056694670951384, 0.011572751247157, 0.024549512651549, -0.046770717334674, 0.023622779563077, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.061858957413174, 0.021428571428571, -0.004374088826399, -0.064285714285714, 0.009278843611976, 0.007576144084142, -0.005357142857143},
    {0.000000000000000, -0.117369119465393, -0.045175395145263, -0.031943828249997, -0.018298126367785, 0.042521003213538, 0.034718253741471, 0.040915854419249, 0.033407655239053, 0.023622779563077, 0.085042006427076, 0.023957871187498, 0.020748125068968, -0.006185895741317, -0.005357142857143, -0.004374088826399, -0.010714285714286, -0.009278843611976, -0.007576144084142, -0.005357142857143},
    {0.000000000000000, 0.117369119465393, -0.045175395145263, -0.031943828249997, -0.018298126367785, -0.042521003213538, -0.034718253741471, 0.040915854419249, 0.033407655239053, 0.023622779563077, -0.085042006427076, 0.023957871187498, 0.020748125068968, 0.006185895741317, 0.005357142857143, 0.004374088826399, -0.010714285714286, -0.009278843611976, -0.007576144084142, -0.005357142857143},
    {0.259807621135332, 0.117369119465393, 0.067763092717894, 0.047915742374995, 0.000000000000000, 0.085042006427076, 0.069436507482941, -0.073648537954647, 0.040089186286864, -0.099215674164922, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.075000000000000, -0.026244532958391, 0.000000000000000, -0.064951905283833, -0.015152288168283, 0.026785714285714},
    {0.259807621135332, -0.117369119465393, 0.067763092717894, 0.047915742374995, 0.000000000000000, -0.085042006427076, -0.069436507482941, -0.073648537954647, 0.040089186286864, -0.099215674164922, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.075000000000000, 0.026244532958391, 0.000000000000000, -0.064951905283833, -0.015152288168283, 0.026785714285714},
    {0.259807621135332, 0.000000000000000, -0.135526185435788, 0.047915742374996, -0.109788758206710, 0.000000000000000, 0.000000000000000, 0.024549512651549, -0.080178372573727, -0.099215674164922, 0.000000000000000, 0.000000000000000, -0.096824583655185, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.021650635094611, 0.030304576336566, 0.026785714285714},
    {0.259807621135332, 0.000000000000000, 0.000000000000000, -0.143747227124986, -0.109788758206710, 0.000000000000000, 0.000000000000000, -0.122747563257746, 0.000000000000000, 0.042521003213538, 0.000000000000000, -0.095831484749991, 0.013832083379312, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.042857142857143, 0.015464739353294, 0.000000000000000, -0.005357142857143}};
    
    // Compute value(s).
    for (unsigned int r = 0; r < 20; r++)
    {
      *values += coefficients0[dof][r]*basisvalues[r];
    }// end loop over 'r'
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.000000000000000;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 20; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[20] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    unsigned int tt = 0;
    double tmp5 = 0.000000000000000;
    double tmp6 = 0.000000000000000;
    double tmp7 = 0.000000000000000;
    double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
    double tmp1 = 0.250000000000000*(Y + Z)*(Y + Z);
    double tmp2 = 0.500000000000000*(1.000000000000000 + Z + 2.000000000000000*Y);
    double tmp3 = 0.500000000000000*(1.000000000000000 - Z);
    double tmp4 = tmp3*tmp3;
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 1; r < 3; r++)
    {
      rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
      ss = r*(r + 1)*(r + 2)/6;
      tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
      basisvalues[rr] = (basisvalues[ss]*tmp0*(1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r) - basisvalues[tt]*tmp1*r/(1.000000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 3; r++)
    {
      rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
      ss = r*(r + 1)*(r + 2)/6;
      basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
    }// end loop over 'r'
    for (unsigned int r = 0; r < 2; r++)
    {
      for (unsigned int s = 1; s < 3 - r; s++)
      {
        rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
        tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 3; r++)
    {
      for (unsigned int s = 0; s < 3 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 2; r++)
    {
      for (unsigned int s = 0; s < 2 - r; s++)
      {
        for (unsigned int t = 1; t < 3 - r - s; t++)
        {
          rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
          ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
          tmp5 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)/(2.000000000000000*(1.000000000000000 + t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          tmp6 = (3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(4.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*s*s + 8.000000000000000*r*s + 8.000000000000000*r + 8.000000000000000*s)/(2.000000000000000*(1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          tmp7 = (2.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s)*(4.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*t/((1.000000000000000 + t)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s + 2.000000000000000*t)*(3.000000000000000 + t + 2.000000000000000*r + 2.000000000000000*s));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 0; s < 4 - r; s++)
      {
        for (unsigned int t = 0; t < 4 - r - s; t++)
        {
          rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[20][20] = \
    {{0.028867513459481, 0.013041013273933, 0.007529232524210, 0.005323971374999, 0.018298126367785, 0.014173667737846, 0.011572751247157, 0.008183170883850, 0.006681531047811, 0.004724555912615, -0.028347335475692, -0.023957871187498, -0.020748125068968, -0.018557687223952, -0.016071428571429, -0.013122266479196, -0.010714285714286, -0.009278843611976, -0.007576144084142, -0.005357142857143},
    {0.028867513459481, -0.013041013273933, 0.007529232524210, 0.005323971375000, 0.018298126367785, -0.014173667737846, -0.011572751247157, 0.008183170883850, 0.006681531047811, 0.004724555912615, 0.028347335475692, -0.023957871187498, -0.020748125068968, 0.018557687223952, 0.016071428571429, 0.013122266479196, -0.010714285714286, -0.009278843611976, -0.007576144084142, -0.005357142857143},
    {0.028867513459481, 0.000000000000000, -0.015058465048421, 0.005323971375000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.024549512651549, -0.013363062095621, 0.004724555912615, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.042857142857143, -0.027836530835928, 0.015152288168283, -0.005357142857143},
    {0.028867513459481, 0.000000000000000, 0.000000000000000, -0.015971914124999, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.028347335475692, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.053571428571429},
    {0.000000000000000, 0.000000000000000, 0.112938487863156, -0.063887656499994, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.073648537954647, 0.026726124191242, -0.023622779563077, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.064951905283833, -0.060609152673133, 0.026785714285714},
    {0.000000000000000, 0.000000000000000, -0.022587697572631, 0.127775312999988, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.066815310478106, 0.047245559126153, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.075761440841416, -0.053571428571429},
    {0.000000000000000, 0.097807599554494, -0.056469243931578, -0.063887656499994, 0.054894379103355, -0.042521003213538, 0.023145502494314, 0.024549512651549, -0.013363062095621, -0.023622779563077, 0.000000000000000, 0.000000000000000, 0.048412291827593, 0.000000000000000, -0.037500000000000, -0.052489065916782, 0.000000000000000, 0.021650635094611, 0.030304576336566, 0.026785714285714},
    {0.000000000000000, -0.019561519910899, 0.011293848786316, 0.127775312999988, 0.000000000000000, 0.000000000000000, 0.057863756235784, 0.000000000000000, -0.033407655239053, 0.047245559126153, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.065611332395978, 0.000000000000000, 0.000000000000000, -0.037880720420708, -0.053571428571429},
    {0.000000000000000, 0.097807599554494, -0.079056941504209, -0.031943828249997, 0.054894379103355, 0.014173667737846, -0.046291004988628, -0.024549512651549, 0.013363062095621, 0.023622779563077, 0.000000000000000, 0.047915742374995, -0.006916041689656, -0.061858957413174, -0.016071428571429, 0.008748177652797, 0.042857142857143, 0.015464739353294, 0.000000000000000, -0.005357142857143},
    {0.000000000000000, -0.019561519910899, 0.124232336649472, -0.031943828249997, 0.000000000000000, 0.056694670951384, -0.011572751247157, 0.024549512651549, -0.046770717334674, 0.023622779563077, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.061858957413174, -0.021428571428571, 0.004374088826399, -0.064285714285714, 0.009278843611976, 0.007576144084142, -0.005357142857143},
    {0.000000000000000, -0.097807599554494, -0.056469243931578, -0.063887656499994, 0.054894379103355, 0.042521003213538, -0.023145502494314, 0.024549512651549, -0.013363062095621, -0.023622779563077, 0.000000000000000, 0.000000000000000, 0.048412291827593, 0.000000000000000, 0.037500000000000, 0.052489065916782, 0.000000000000000, 0.021650635094611, 0.030304576336566, 0.026785714285714},
    {0.000000000000000, 0.019561519910899, 0.011293848786316, 0.127775312999988, 0.000000000000000, 0.000000000000000, -0.057863756235785, 0.000000000000000, -0.033407655239053, 0.047245559126153, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.065611332395978, 0.000000000000000, 0.000000000000000, -0.037880720420708, -0.053571428571429},
    {0.000000000000000, -0.097807599554494, -0.079056941504210, -0.031943828249997, 0.054894379103355, -0.014173667737846, 0.046291004988628, -0.024549512651549, 0.013363062095621, 0.023622779563077, 0.000000000000000, 0.047915742374995, -0.006916041689656, 0.061858957413174, 0.016071428571429, -0.008748177652797, 0.042857142857143, 0.015464739353294, 0.000000000000000, -0.005357142857143},
    {0.000000000000000, 0.019561519910899, 0.124232336649472, -0.031943828249997, 0.000000000000000, -0.056694670951384, 0.011572751247157, 0.024549512651549, -0.046770717334674, 0.023622779563077, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.061858957413174, 0.021428571428571, -0.004374088826399, -0.064285714285714, 0.009278843611976, 0.007576144084142, -0.005357142857143},
    {0.000000000000000, -0.117369119465393, -0.045175395145263, -0.031943828249997, -0.018298126367785, 0.042521003213538, 0.034718253741471, 0.040915854419249, 0.033407655239053, 0.023622779563077, 0.085042006427076, 0.023957871187498, 0.020748125068968, -0.006185895741317, -0.005357142857143, -0.004374088826399, -0.010714285714286, -0.009278843611976, -0.007576144084142, -0.005357142857143},
    {0.000000000000000, 0.117369119465393, -0.045175395145263, -0.031943828249997, -0.018298126367785, -0.042521003213538, -0.034718253741471, 0.040915854419249, 0.033407655239053, 0.023622779563077, -0.085042006427076, 0.023957871187498, 0.020748125068968, 0.006185895741317, 0.005357142857143, 0.004374088826399, -0.010714285714286, -0.009278843611976, -0.007576144084142, -0.005357142857143},
    {0.259807621135332, 0.117369119465393, 0.067763092717894, 0.047915742374995, 0.000000000000000, 0.085042006427076, 0.069436507482941, -0.073648537954647, 0.040089186286864, -0.099215674164922, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.075000000000000, -0.026244532958391, 0.000000000000000, -0.064951905283833, -0.015152288168283, 0.026785714285714},
    {0.259807621135332, -0.117369119465393, 0.067763092717894, 0.047915742374995, 0.000000000000000, -0.085042006427076, -0.069436507482941, -0.073648537954647, 0.040089186286864, -0.099215674164922, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -0.075000000000000, 0.026244532958391, 0.000000000000000, -0.064951905283833, -0.015152288168283, 0.026785714285714},
    {0.259807621135332, 0.000000000000000, -0.135526185435788, 0.047915742374996, -0.109788758206710, 0.000000000000000, 0.000000000000000, 0.024549512651549, -0.080178372573727, -0.099215674164922, 0.000000000000000, 0.000000000000000, -0.096824583655185, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.021650635094611, 0.030304576336566, 0.026785714285714},
    {0.259807621135332, 0.000000000000000, 0.000000000000000, -0.143747227124986, -0.109788758206710, 0.000000000000000, 0.000000000000000, -0.122747563257746, 0.000000000000000, 0.042521003213538, 0.000000000000000, -0.095831484749991, 0.013832083379312, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.042857142857143, 0.015464739353294, 0.000000000000000, -0.005357142857143}};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[20][20] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {6.324555320336761, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 11.224972160321823, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {4.582575694955845, 0.000000000000000, 8.366600265340759, -1.183215956619923, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.741657386773944, 0.000000000000000, 0.000000000000000, 8.694826047713667, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.499090833947007, 0.000000000000000, -3.346640106136306, -2.366431913239849, 15.491933384829672, 0.000000000000000, 0.000000000000000, 0.692820323027551, 0.565685424949239, 0.400000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 4.898979485566358, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.198591479439077, -0.828078671210825, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 4.242640687119284, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 14.342743312012724, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.600000000000006, 0.000000000000000, 8.763560920082652, -1.549193338482971, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.524704719832522, -1.481312159636078, 0.261861468283190, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.117691453623982, 0.000000000000000, 3.162277660168381, 4.919349550499534, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.690449676496980, -2.418972627259056, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.545584412271568, 0.000000000000000, 0.000000000000000, 7.668115805072329, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.369185117452579, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
    
    static const double dmats1[20][20] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.477225575051664, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.958039891549807, 5.612486080160910, -1.080123449734641, -0.763762615825973, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.291287847477919, 7.245688373094720, 4.183300132670380, -0.591607978309962, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.870828693386972, 0.000000000000000, 0.000000000000000, 4.347413023856833, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-2.645751311064588, 0.000000000000000, 9.660917830792959, 0.683130051063969, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.240370349203932, 0.000000000000000, 0.000000000000000, 7.529940238806683, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.749545416973501, 5.796550698475777, -1.673320053068151, -1.183215956619925, 7.745966692414836, -1.200000000000001, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.323790007724450, 2.449489742783182, 2.828427124746191, -1.000000000000000, 9.165151389911681, 7.099295739719538, -0.414039335605413, -2.049390153191922, -0.478091443733757, 0.169030850945703, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.012461179749812, 2.121320343559643, -0.408248290463862, 3.175426480542944, 0.000000000000000, 0.000000000000000, 7.171371656006365, 0.000000000000000, -1.380131118684709, -1.561440116717652, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.800000000000006, -5.692099788303086, 4.381780460041326, -0.774596669241483, 0.000000000000000, 10.998181667894018, 0.962140470884730, 4.762352359916261, -0.740656079818039, 0.130930734141594, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.558845726811990, 2.738612787525830, 1.581138830084191, 2.459674775249769, 0.000000000000000, 0.000000000000000, 9.258200997725515, 0.000000000000000, 5.345224838248491, -1.209486313629527, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.272792206135784, 0.000000000000000, 0.000000000000000, 3.834057902536165, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.184592558726290, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.196152422706634, 0.000000000000000, -3.162277660168386, -2.236067977499795, 0.000000000000000, 0.000000000000000, 0.000000000000000, 13.747727084867519, 0.534522483824850, 0.377964473009228, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-1.800000000000001, 0.000000000000000, 3.651483716701107, -2.840187787218779, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.344267996967359, 1.396594497510349, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.204540768504857, 0.000000000000000, 0.000000000000000, 6.640783086353597, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 8.979977728257460, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
    
    static const double dmats2[20][20] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.163977794943225, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.958039891549807, 5.612486080160910, -1.080123449734641, -0.763762615825973, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.291287847477922, 1.449137674618944, 4.183300132670379, -0.591607978309961, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.870828693386970, 7.099295739719540, 0.000000000000000, 4.347413023856832, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.322875655532297, 0.000000000000000, 3.864367132317184, -0.341565025531987, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.080123449734647, 0.000000000000000, 7.099295739719542, 2.509980079602226, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-3.818813079129869, 0.000000000000000, 0.000000000000000, 8.874119674649426, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.749545416973501, 5.796550698475777, -1.673320053068151, -1.183215956619925, 7.745966692414836, -1.200000000000001, -0.979795897113272, 0.346410161513775, 0.282842712474619, 0.200000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.323790007724451, 2.449489742783178, 2.828427124746193, -0.999999999999999, 1.309307341415954, 7.099295739719538, -0.414039335605412, -2.049390153191921, -0.478091443733757, 0.169030850945703, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.012461179749810, 2.121320343559646, -0.408248290463864, 3.175426480542941, 9.071147352221454, 0.000000000000000, 7.171371656006363, 0.000000000000000, -1.380131118684709, -1.561440116717652, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.800000000000003, 0.632455532033676, 4.381780460041328, -0.774596669241486, 0.000000000000000, 3.142337619398290, -0.106904496764971, 4.762352359916262, -0.740656079818039, 0.130930734141595, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.558845726811992, 0.547722557505167, 1.581138830084192, 2.459674775249767, 0.000000000000000, 9.071147352221454, 1.851640199545104, 0.000000000000000, 5.345224838248490, -1.209486313629529, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.272792206135787, -6.260990336999413, 0.000000000000000, 3.834057902536166, 0.000000000000000, 0.000000000000000, 10.583005244258363, 0.000000000000000, 0.000000000000000, 5.184592558726290, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.039230484541328, 0.000000000000000, 3.162277660168376, -0.447213595499960, 0.000000000000000, 0.000000000000000, 0.000000000000000, 5.891883036371793, -0.534522483824847, 0.075592894601845, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.900000000000000, 0.000000000000000, 1.460593486680439, 1.420093893609385, 0.000000000000000, 0.000000000000000, 0.000000000000000, 9.071147352221452, 4.937707198786944, -0.698297248755176, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.734846922834950, 0.000000000000000, -6.260990336999414, 2.213594362117868, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 10.583005244258361, 2.993325909419154, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {5.715767664977296, 0.000000000000000, 0.000000000000000, -4.695742752749561, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 12.699606293110035, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      derivatives[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[20][20] = \
    {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[20][20] = \
    {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 20; t++)
      {
        for (unsigned int u = 0; u < 20; u++)
        {
          dmats[t][u] = 0.000000000000000;
          if (t == u)
          {
          dmats[t][u] = 1.000000000000000;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.000000000000000;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            for (unsigned int tu = 0; tu < 20; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            for (unsigned int tu = 0; tu < 20; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 2)
        {
        for (unsigned int t = 0; t < 20; t++)
        {
          for (unsigned int u = 0; u < 20; u++)
          {
            for (unsigned int tu = 0; tu < 20; tu++)
            {
              dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 20; s++)
      {
        for (unsigned int t = 0; t < 20; t++)
        {
          derivatives[r] += coefficients0[dof][s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] combinations[r];
    }// end loop over 'r'
    delete [] combinations;
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 20; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.666666666666667*x[2][0] + 0.333333333333333*x[3][0];
      y[1] = 0.666666666666667*x[2][1] + 0.333333333333333*x[3][1];
      y[2] = 0.666666666666667*x[2][2] + 0.333333333333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.333333333333333*x[2][0] + 0.666666666666667*x[3][0];
      y[1] = 0.333333333333333*x[2][1] + 0.666666666666667*x[3][1];
      y[2] = 0.333333333333333*x[2][2] + 0.666666666666667*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[3][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[3][1];
      y[2] = 0.666666666666667*x[1][2] + 0.333333333333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[3][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[3][1];
      y[2] = 0.333333333333333*x[1][2] + 0.666666666666667*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      y[2] = 0.666666666666667*x[1][2] + 0.333333333333333*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      y[2] = 0.333333333333333*x[1][2] + 0.666666666666667*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[3][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[3][1];
      y[2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[3][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[3][1];
      y[2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      y[2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      y[2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      y[2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 15:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      y[2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 16:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0] + 0.333333333333333*x[3][0];
      y[1] = 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1] + 0.333333333333333*x[3][1];
      y[2] = 0.333333333333333*x[1][2] + 0.333333333333333*x[2][2] + 0.333333333333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 17:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[2][0] + 0.333333333333333*x[3][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[2][1] + 0.333333333333333*x[3][1];
      y[2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[2][2] + 0.333333333333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 18:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[3][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[3][1];
      y[2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[1][2] + 0.333333333333333*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 19:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      y[2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[1][2] + 0.333333333333333*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.000000000000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.666666666666667*x[2][0] + 0.333333333333333*x[3][0];
    y[1] = 0.666666666666667*x[2][1] + 0.333333333333333*x[3][1];
    y[2] = 0.666666666666667*x[2][2] + 0.333333333333333*x[3][2];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.333333333333333*x[2][0] + 0.666666666666667*x[3][0];
    y[1] = 0.333333333333333*x[2][1] + 0.666666666666667*x[3][1];
    y[2] = 0.333333333333333*x[2][2] + 0.666666666666667*x[3][2];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[3][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[3][1];
    y[2] = 0.666666666666667*x[1][2] + 0.333333333333333*x[3][2];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[3][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[3][1];
    y[2] = 0.333333333333333*x[1][2] + 0.666666666666667*x[3][2];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    y[2] = 0.666666666666667*x[1][2] + 0.333333333333333*x[2][2];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    y[2] = 0.333333333333333*x[1][2] + 0.666666666666667*x[2][2];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[3][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[3][1];
    y[2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[3][2];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[3][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[3][1];
    y[2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[3][2];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    y[2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[2][2];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    y[2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[2][2];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    y[2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[1][2];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    y[2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[1][2];
    f.evaluate(vals, y, c);
    values[15] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0] + 0.333333333333333*x[3][0];
    y[1] = 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1] + 0.333333333333333*x[3][1];
    y[2] = 0.333333333333333*x[1][2] + 0.333333333333333*x[2][2] + 0.333333333333333*x[3][2];
    f.evaluate(vals, y, c);
    values[16] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[2][0] + 0.333333333333333*x[3][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[2][1] + 0.333333333333333*x[3][1];
    y[2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[2][2] + 0.333333333333333*x[3][2];
    f.evaluate(vals, y, c);
    values[17] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[3][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[3][1];
    y[2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[1][2] + 0.333333333333333*x[3][2];
    f.evaluate(vals, y, c);
    values[18] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    y[2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[1][2] + 0.333333333333333*x[2][2];
    f.evaluate(vals, y, c);
    values[19] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class poisson3d_3_dof_map_0: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  poisson3d_3_dof_map_0() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~poisson3d_3_dof_map_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 3)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 2.000000000000000*m.num_entities[1] + m.num_entities[2];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 20;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 20;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 10;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
    dofs[4] = offset + 2*c.entity_indices[1][0];
    dofs[5] = offset + 2*c.entity_indices[1][0] + 1;
    dofs[6] = offset + 2*c.entity_indices[1][1];
    dofs[7] = offset + 2*c.entity_indices[1][1] + 1;
    dofs[8] = offset + 2*c.entity_indices[1][2];
    dofs[9] = offset + 2*c.entity_indices[1][2] + 1;
    dofs[10] = offset + 2*c.entity_indices[1][3];
    dofs[11] = offset + 2*c.entity_indices[1][3] + 1;
    dofs[12] = offset + 2*c.entity_indices[1][4];
    dofs[13] = offset + 2*c.entity_indices[1][4] + 1;
    dofs[14] = offset + 2*c.entity_indices[1][5];
    dofs[15] = offset + 2*c.entity_indices[1][5] + 1;
    offset += 2*m.num_entities[1];
    dofs[16] = offset + c.entity_indices[2][0];
    dofs[17] = offset + c.entity_indices[2][1];
    dofs[18] = offset + c.entity_indices[2][2];
    dofs[19] = offset + c.entity_indices[2][3];
    offset += m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 7;
      dofs[7] = 8;
      dofs[8] = 9;
      dofs[9] = 16;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 10;
      dofs[6] = 11;
      dofs[7] = 12;
      dofs[8] = 13;
      dofs[9] = 17;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 6;
      dofs[4] = 7;
      dofs[5] = 10;
      dofs[6] = 11;
      dofs[7] = 14;
      dofs[8] = 15;
      dofs[9] = 18;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 8;
      dofs[4] = 9;
      dofs[5] = 12;
      dofs[6] = 13;
      dofs[7] = 14;
      dofs[8] = 15;
      dofs[9] = 19;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      throw std::runtime_error("i is larger than number of entities (5)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 4;
        dofs[1] = 5;
          break;
        }
      case 1:
        {
          dofs[0] = 6;
        dofs[1] = 7;
          break;
        }
      case 2:
        {
          dofs[0] = 8;
        dofs[1] = 9;
          break;
        }
      case 3:
        {
          dofs[0] = 10;
        dofs[1] = 11;
          break;
        }
      case 4:
        {
          dofs[0] = 12;
        dofs[1] = 13;
          break;
        }
      case 5:
        {
          dofs[0] = 14;
        dofs[1] = 15;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 16;
          break;
        }
      case 1:
        {
          dofs[0] = 17;
          break;
        }
      case 2:
        {
          dofs[0] = 18;
          break;
        }
      case 3:
        {
          dofs[0] = 19;
          break;
        }
      }
      
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[0][2] = x[0][2];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[1][2] = x[1][2];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[2][2] = x[2][2];
    coordinates[3][0] = x[3][0];
    coordinates[3][1] = x[3][1];
    coordinates[3][2] = x[3][2];
    coordinates[4][0] = 0.666666666666667*x[2][0] + 0.333333333333333*x[3][0];
    coordinates[4][1] = 0.666666666666667*x[2][1] + 0.333333333333333*x[3][1];
    coordinates[4][2] = 0.666666666666667*x[2][2] + 0.333333333333333*x[3][2];
    coordinates[5][0] = 0.333333333333333*x[2][0] + 0.666666666666667*x[3][0];
    coordinates[5][1] = 0.333333333333333*x[2][1] + 0.666666666666667*x[3][1];
    coordinates[5][2] = 0.333333333333333*x[2][2] + 0.666666666666667*x[3][2];
    coordinates[6][0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[3][0];
    coordinates[6][1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[3][1];
    coordinates[6][2] = 0.666666666666667*x[1][2] + 0.333333333333333*x[3][2];
    coordinates[7][0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[3][0];
    coordinates[7][1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[3][1];
    coordinates[7][2] = 0.333333333333333*x[1][2] + 0.666666666666667*x[3][2];
    coordinates[8][0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[8][1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[8][2] = 0.666666666666667*x[1][2] + 0.333333333333333*x[2][2];
    coordinates[9][0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    coordinates[9][1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    coordinates[9][2] = 0.333333333333333*x[1][2] + 0.666666666666667*x[2][2];
    coordinates[10][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[3][0];
    coordinates[10][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[3][1];
    coordinates[10][2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[3][2];
    coordinates[11][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[3][0];
    coordinates[11][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[3][1];
    coordinates[11][2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[3][2];
    coordinates[12][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    coordinates[12][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    coordinates[12][2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[2][2];
    coordinates[13][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    coordinates[13][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    coordinates[13][2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[2][2];
    coordinates[14][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    coordinates[14][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    coordinates[14][2] = 0.666666666666667*x[0][2] + 0.333333333333333*x[1][2];
    coordinates[15][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    coordinates[15][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    coordinates[15][2] = 0.333333333333333*x[0][2] + 0.666666666666667*x[1][2];
    coordinates[16][0] = 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0] + 0.333333333333333*x[3][0];
    coordinates[16][1] = 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1] + 0.333333333333333*x[3][1];
    coordinates[16][2] = 0.333333333333333*x[1][2] + 0.333333333333333*x[2][2] + 0.333333333333333*x[3][2];
    coordinates[17][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[2][0] + 0.333333333333333*x[3][0];
    coordinates[17][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[2][1] + 0.333333333333333*x[3][1];
    coordinates[17][2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[2][2] + 0.333333333333333*x[3][2];
    coordinates[18][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[3][0];
    coordinates[18][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[3][1];
    coordinates[18][2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[1][2] + 0.333333333333333*x[3][2];
    coordinates[19][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[19][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[19][2] = 0.333333333333333*x[0][2] + 0.333333333333333*x[1][2] + 0.333333333333333*x[2][2];
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 0;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class poisson3d_3_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  poisson3d_3_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_3_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      32
    // Number of operations (multiply-add pairs) for geometry tensor:    27
    // Number of operations (multiply-add pairs) for tensor contraction: 1768
    // Total number of operations (multiply-add pairs):                  1827
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K_00*K_00 + K_01*K_01 + K_02*K_02);
    const double G0_0_1 = det*(K_00*K_10 + K_01*K_11 + K_02*K_12);
    const double G0_0_2 = det*(K_00*K_20 + K_01*K_21 + K_02*K_22);
    const double G0_1_0 = det*(K_10*K_00 + K_11*K_01 + K_12*K_02);
    const double G0_1_1 = det*(K_10*K_10 + K_11*K_11 + K_12*K_12);
    const double G0_1_2 = det*(K_10*K_20 + K_11*K_21 + K_12*K_22);
    const double G0_2_0 = det*(K_20*K_00 + K_21*K_01 + K_22*K_02);
    const double G0_2_1 = det*(K_20*K_10 + K_21*K_11 + K_22*K_12);
    const double G0_2_2 = det*(K_20*K_20 + K_21*K_21 + K_22*K_22);
    
    // Compute element tensor
    A[0] = 0.059523809523810*G0_0_0 + 0.059523809523809*G0_0_1 + 0.059523809523809*G0_0_2 + 0.059523809523809*G0_1_0 + 0.059523809523809*G0_1_1 + 0.059523809523809*G0_1_2 + 0.059523809523809*G0_2_0 + 0.059523809523809*G0_2_1 + 0.059523809523809*G0_2_2;
    A[1] = -0.011309523809524*G0_0_0 - 0.011309523809524*G0_1_0 - 0.011309523809524*G0_2_0;
    A[2] = -0.011309523809524*G0_0_1 - 0.011309523809524*G0_1_1 - 0.011309523809524*G0_2_1;
    A[3] = -0.011309523809524*G0_0_2 - 0.011309523809524*G0_1_2 - 0.011309523809524*G0_2_2;
    A[4] = -0.013392857142857*G0_0_1 - 0.013392857142857*G0_0_2 - 0.013392857142857*G0_1_1 - 0.013392857142857*G0_1_2 - 0.013392857142857*G0_2_1 - 0.013392857142857*G0_2_2;
    A[5] = -0.013392857142857*G0_0_1 - 0.013392857142857*G0_0_2 - 0.013392857142857*G0_1_1 - 0.013392857142857*G0_1_2 - 0.013392857142857*G0_2_1 - 0.013392857142857*G0_2_2;
    A[6] = -0.013392857142857*G0_0_0 - 0.013392857142857*G0_0_2 - 0.013392857142857*G0_1_0 - 0.013392857142857*G0_1_2 - 0.013392857142857*G0_2_0 - 0.013392857142857*G0_2_2;
    A[7] = -0.013392857142857*G0_0_0 - 0.013392857142857*G0_0_2 - 0.013392857142857*G0_1_0 - 0.013392857142857*G0_1_2 - 0.013392857142857*G0_2_0 - 0.013392857142857*G0_2_2;
    A[8] = -0.013392857142857*G0_0_0 - 0.013392857142857*G0_0_1 - 0.013392857142857*G0_1_0 - 0.013392857142857*G0_1_1 - 0.013392857142857*G0_2_0 - 0.013392857142857*G0_2_1;
    A[9] = -0.013392857142857*G0_0_0 - 0.013392857142857*G0_0_1 - 0.013392857142857*G0_1_0 - 0.013392857142857*G0_1_1 - 0.013392857142857*G0_2_0 - 0.013392857142857*G0_2_1;
    A[10] = -0.034821428571429*G0_0_0 - 0.034821428571429*G0_0_1 - 0.096428571428571*G0_0_2 - 0.034821428571429*G0_1_0 - 0.034821428571429*G0_1_1 - 0.096428571428571*G0_1_2 - 0.034821428571429*G0_2_0 - 0.034821428571429*G0_2_1 - 0.096428571428571*G0_2_2;
    A[11] = 0.013392857142857*G0_0_0 + 0.013392857142857*G0_0_1 + 0.048214285714286*G0_0_2 + 0.013392857142857*G0_1_0 + 0.013392857142857*G0_1_1 + 0.048214285714286*G0_1_2 + 0.013392857142857*G0_2_0 + 0.013392857142857*G0_2_1 + 0.048214285714286*G0_2_2;
    A[12] = -0.034821428571429*G0_0_0 - 0.096428571428571*G0_0_1 - 0.034821428571429*G0_0_2 - 0.034821428571429*G0_1_0 - 0.096428571428571*G0_1_1 - 0.034821428571429*G0_1_2 - 0.034821428571429*G0_2_0 - 0.096428571428571*G0_2_1 - 0.034821428571429*G0_2_2;
    A[13] = 0.013392857142857*G0_0_0 + 0.048214285714286*G0_0_1 + 0.013392857142857*G0_0_2 + 0.013392857142857*G0_1_0 + 0.048214285714286*G0_1_1 + 0.013392857142857*G0_1_2 + 0.013392857142857*G0_2_0 + 0.048214285714286*G0_2_1 + 0.013392857142857*G0_2_2;
    A[14] = -0.096428571428571*G0_0_0 - 0.034821428571429*G0_0_1 - 0.034821428571429*G0_0_2 - 0.096428571428571*G0_1_0 - 0.034821428571429*G0_1_1 - 0.034821428571429*G0_1_2 - 0.096428571428571*G0_2_0 - 0.034821428571429*G0_2_1 - 0.034821428571429*G0_2_2;
    A[15] = 0.048214285714286*G0_0_0 + 0.013392857142857*G0_0_1 + 0.013392857142857*G0_0_2 + 0.048214285714286*G0_1_0 + 0.013392857142857*G0_1_1 + 0.013392857142857*G0_1_2 + 0.048214285714286*G0_2_0 + 0.013392857142857*G0_2_1 + 0.013392857142857*G0_2_2;
    A[16] = -0.032142857142857*G0_0_0 - 0.032142857142857*G0_0_1 - 0.032142857142857*G0_0_2 - 0.032142857142857*G0_1_0 - 0.032142857142857*G0_1_1 - 0.032142857142857*G0_1_2 - 0.032142857142857*G0_2_0 - 0.032142857142857*G0_2_1 - 0.032142857142857*G0_2_2;
    A[17] = 0.032142857142857*G0_0_0 + 0.048214285714286*G0_0_1 + 0.048214285714286*G0_0_2 + 0.032142857142857*G0_1_0 + 0.048214285714286*G0_1_1 + 0.048214285714286*G0_1_2 + 0.032142857142857*G0_2_0 + 0.048214285714286*G0_2_1 + 0.048214285714286*G0_2_2;
    A[18] = 0.048214285714286*G0_0_0 + 0.032142857142857*G0_0_1 + 0.048214285714286*G0_0_2 + 0.048214285714286*G0_1_0 + 0.032142857142857*G0_1_1 + 0.048214285714286*G0_1_2 + 0.048214285714286*G0_2_0 + 0.032142857142857*G0_2_1 + 0.048214285714286*G0_2_2;
    A[19] = 0.048214285714286*G0_0_0 + 0.048214285714286*G0_0_1 + 0.032142857142857*G0_0_2 + 0.048214285714286*G0_1_0 + 0.048214285714286*G0_1_1 + 0.032142857142857*G0_1_2 + 0.048214285714286*G0_2_0 + 0.048214285714286*G0_2_1 + 0.032142857142857*G0_2_2;
    A[20] = -0.011309523809524*G0_0_0 - 0.011309523809524*G0_0_1 - 0.011309523809524*G0_0_2;
    A[21] = 0.059523809523809*G0_0_0;
    A[22] = 0.011309523809524*G0_0_1;
    A[23] = 0.011309523809524*G0_0_2;
    A[24] = 0.013392857142857*G0_0_1 + 0.013392857142857*G0_0_2;
    A[25] = 0.013392857142857*G0_0_1 + 0.013392857142857*G0_0_2;
    A[26] = -0.034821428571429*G0_0_0 + 0.061607142857143*G0_0_2;
    A[27] = 0.013392857142857*G0_0_0 - 0.034821428571429*G0_0_2;
    A[28] = -0.034821428571429*G0_0_0 + 0.061607142857143*G0_0_1;
    A[29] = 0.013392857142857*G0_0_0 - 0.034821428571429*G0_0_1;
    A[30] = -0.013392857142857*G0_0_0 - 0.013392857142857*G0_0_1;
    A[31] = -0.013392857142857*G0_0_0 - 0.013392857142857*G0_0_1;
    A[32] = -0.013392857142857*G0_0_0 - 0.013392857142857*G0_0_2;
    A[33] = -0.013392857142857*G0_0_0 - 0.013392857142857*G0_0_2;
    A[34] = 0.048214285714286*G0_0_0 + 0.034821428571429*G0_0_1 + 0.034821428571429*G0_0_2;
    A[35] = -0.096428571428571*G0_0_0 - 0.061607142857143*G0_0_1 - 0.061607142857143*G0_0_2;
    A[36] = 0.032142857142857*G0_0_0 - 0.016071428571429*G0_0_1 - 0.016071428571429*G0_0_2;
    A[37] = -0.032142857142857*G0_0_0;
    A[38] = 0.048214285714286*G0_0_0 + 0.016071428571429*G0_0_1;
    A[39] = 0.048214285714286*G0_0_0 + 0.016071428571429*G0_0_2;
    A[40] = -0.011309523809524*G0_1_0 - 0.011309523809524*G0_1_1 - 0.011309523809524*G0_1_2;
    A[41] = 0.011309523809524*G0_1_0;
    A[42] = 0.059523809523809*G0_1_1;
    A[43] = 0.011309523809524*G0_1_2;
    A[44] = -0.034821428571429*G0_1_1 + 0.061607142857143*G0_1_2;
    A[45] = 0.013392857142857*G0_1_1 - 0.034821428571428*G0_1_2;
    A[46] = 0.013392857142857*G0_1_0 + 0.013392857142857*G0_1_2;
    A[47] = 0.013392857142857*G0_1_0 + 0.013392857142857*G0_1_2;
    A[48] = -0.034821428571428*G0_1_0 + 0.013392857142857*G0_1_1;
    A[49] = 0.061607142857143*G0_1_0 - 0.034821428571429*G0_1_1;
    A[50] = -0.013392857142857*G0_1_0 - 0.013392857142857*G0_1_1;
    A[51] = -0.013392857142857*G0_1_0 - 0.013392857142857*G0_1_1;
    A[52] = 0.034821428571428*G0_1_0 + 0.048214285714286*G0_1_1 + 0.034821428571428*G0_1_2;
    A[53] = -0.061607142857143*G0_1_0 - 0.096428571428571*G0_1_1 - 0.061607142857143*G0_1_2;
    A[54] = -0.013392857142857*G0_1_1 - 0.013392857142857*G0_1_2;
    A[55] = -0.013392857142857*G0_1_1 - 0.013392857142857*G0_1_2;
    A[56] = -0.016071428571429*G0_1_0 + 0.032142857142857*G0_1_1 - 0.016071428571428*G0_1_2;
    A[57] = 0.016071428571429*G0_1_0 + 0.048214285714286*G0_1_1;
    A[58] = -0.032142857142857*G0_1_1;
    A[59] = 0.048214285714286*G0_1_1 + 0.016071428571428*G0_1_2;
    A[60] = -0.011309523809524*G0_2_0 - 0.011309523809524*G0_2_1 - 0.011309523809524*G0_2_2;
    A[61] = 0.011309523809524*G0_2_0;
    A[62] = 0.011309523809524*G0_2_1;
    A[63] = 0.059523809523809*G0_2_2;
    A[64] = -0.034821428571429*G0_2_1 + 0.013392857142857*G0_2_2;
    A[65] = 0.061607142857143*G0_2_1 - 0.034821428571429*G0_2_2;
    A[66] = -0.034821428571429*G0_2_0 + 0.013392857142857*G0_2_2;
    A[67] = 0.061607142857143*G0_2_0 - 0.034821428571429*G0_2_2;
    A[68] = 0.013392857142857*G0_2_0 + 0.013392857142857*G0_2_1;
    A[69] = 0.013392857142857*G0_2_0 + 0.013392857142857*G0_2_1;
    A[70] = 0.034821428571428*G0_2_0 + 0.034821428571428*G0_2_1 + 0.048214285714286*G0_2_2;
    A[71] = -0.061607142857143*G0_2_0 - 0.061607142857143*G0_2_1 - 0.096428571428571*G0_2_2;
    A[72] = -0.013392857142857*G0_2_0 - 0.013392857142857*G0_2_2;
    A[73] = -0.013392857142857*G0_2_0 - 0.013392857142857*G0_2_2;
    A[74] = -0.013392857142857*G0_2_1 - 0.013392857142857*G0_2_2;
    A[75] = -0.013392857142857*G0_2_1 - 0.013392857142857*G0_2_2;
    A[76] = -0.016071428571429*G0_2_0 - 0.016071428571429*G0_2_1 + 0.032142857142857*G0_2_2;
    A[77] = 0.016071428571429*G0_2_0 + 0.048214285714286*G0_2_2;
    A[78] = 0.016071428571429*G0_2_1 + 0.048214285714286*G0_2_2;
    A[79] = -0.032142857142857*G0_2_2;
    A[80] = -0.013392857142857*G0_1_0 - 0.013392857142857*G0_1_1 - 0.013392857142857*G0_1_2 - 0.013392857142857*G0_2_0 - 0.013392857142857*G0_2_1 - 0.013392857142857*G0_2_2;
    A[81] = 0.013392857142857*G0_1_0 + 0.013392857142857*G0_2_0;
    A[82] = -0.034821428571429*G0_1_1 + 0.061607142857143*G0_2_1;
    A[83] = -0.034821428571429*G0_1_2 + 0.013392857142857*G0_2_2;
    A[84] = 0.241071428571428*G0_1_1 + 0.096428571428571*G0_1_2 + 0.096428571428571*G0_2_1 + 0.192857142857142*G0_2_2;
    A[85] = -0.072321428571429*G0_1_1 + 0.072321428571428*G0_1_2 - 0.024107142857143*G0_2_1 - 0.072321428571428*G0_2_2;
    A[86] = -0.048214285714286*G0_1_0 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_0 - 0.024107142857143*G0_2_2;
    A[87] = -0.072321428571429*G0_1_0 - 0.048214285714286*G0_1_2 - 0.024107142857143*G0_2_0 - 0.024107142857143*G0_2_2;
    A[88] = -0.048214285714286*G0_1_0 - 0.024107142857143*G0_1_1 - 0.072321428571428*G0_2_0 - 0.024107142857143*G0_2_1;
    A[89] = 0.096428571428571*G0_1_0 + 0.120535714285714*G0_1_1 + 0.192857142857143*G0_2_0 + 0.096428571428571*G0_2_1;
    A[90] = 0.048214285714286*G0_1_0 + 0.048214285714286*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_1;
    A[91] = 0.072321428571429*G0_1_0 + 0.072321428571429*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_1;
    A[92] = 0.048214285714286*G0_1_0 + 0.024107142857143*G0_1_1 + 0.048214285714286*G0_1_2 + 0.072321428571428*G0_2_0 + 0.048214285714286*G0_2_1 + 0.072321428571428*G0_2_2;
    A[93] = -0.096428571428571*G0_1_0 + 0.024107142857143*G0_1_1 - 0.096428571428571*G0_1_2 - 0.192857142857143*G0_2_0 - 0.096428571428571*G0_2_1 - 0.192857142857143*G0_2_2;
    A[94] = 0.024107142857143*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_1 + 0.024107142857143*G0_2_2;
    A[95] = 0.024107142857143*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_1 + 0.024107142857143*G0_2_2;
    A[96] = 0.241071428571429*G0_1_0 - 0.048214285714286*G0_1_1 + 0.120535714285715*G0_1_2 + 0.096428571428571*G0_2_0 - 0.024107142857143*G0_2_1 + 0.096428571428572*G0_2_2;
    A[97] = -0.241071428571429*G0_1_0 - 0.289285714285714*G0_1_1 - 0.120535714285714*G0_1_2 - 0.096428571428572*G0_2_0 - 0.120535714285714*G0_2_1;
    A[98] = 0.048214285714286*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_1;
    A[99] = -0.144642857142857*G0_1_1 - 0.120535714285715*G0_1_2 - 0.120535714285714*G0_2_1 - 0.096428571428572*G0_2_2;
    A[100] = -0.013392857142857*G0_1_0 - 0.013392857142857*G0_1_1 - 0.013392857142857*G0_1_2 - 0.013392857142857*G0_2_0 - 0.013392857142857*G0_2_1 - 0.013392857142857*G0_2_2;
    A[101] = 0.013392857142857*G0_1_0 + 0.013392857142857*G0_2_0;
    A[102] = 0.013392857142857*G0_1_1 - 0.034821428571428*G0_2_1;
    A[103] = 0.061607142857143*G0_1_2 - 0.034821428571429*G0_2_2;
    A[104] = -0.072321428571429*G0_1_1 - 0.024107142857143*G0_1_2 + 0.072321428571428*G0_2_1 - 0.072321428571428*G0_2_2;
    A[105] = 0.192857142857143*G0_1_1 + 0.096428571428571*G0_1_2 + 0.096428571428571*G0_2_1 + 0.241071428571428*G0_2_2;
    A[106] = -0.072321428571428*G0_1_0 - 0.024107142857143*G0_1_2 - 0.048214285714286*G0_2_0 - 0.024107142857143*G0_2_2;
    A[107] = 0.192857142857143*G0_1_0 + 0.096428571428571*G0_1_2 + 0.096428571428571*G0_2_0 + 0.120535714285714*G0_2_2;
    A[108] = -0.024107142857143*G0_1_0 - 0.024107142857143*G0_1_1 - 0.048214285714286*G0_2_0 - 0.024107142857143*G0_2_1;
    A[109] = -0.024107142857143*G0_1_0 - 0.024107142857143*G0_1_1 - 0.072321428571428*G0_2_0 - 0.048214285714286*G0_2_1;
    A[110] = 0.072321428571428*G0_1_0 + 0.072321428571428*G0_1_1 + 0.048214285714286*G0_1_2 + 0.048214285714286*G0_2_0 + 0.048214285714286*G0_2_1 + 0.024107142857143*G0_2_2;
    A[111] = -0.192857142857143*G0_1_0 - 0.192857142857143*G0_1_1 - 0.096428571428571*G0_1_2 - 0.096428571428571*G0_2_0 - 0.096428571428571*G0_2_1 + 0.024107142857143*G0_2_2;
    A[112] = 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_2 + 0.048214285714286*G0_2_0 + 0.024107142857143*G0_2_1 + 0.048214285714286*G0_2_2;
    A[113] = 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_2 + 0.072321428571428*G0_2_0 + 0.024107142857143*G0_2_1 + 0.072321428571428*G0_2_2;
    A[114] = 0.024107142857143*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_1 + 0.024107142857143*G0_2_2;
    A[115] = 0.024107142857143*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_1 + 0.024107142857143*G0_2_2;
    A[116] = 0.096428571428571*G0_1_0 + 0.096428571428571*G0_1_1 - 0.024107142857143*G0_1_2 + 0.241071428571428*G0_2_0 + 0.120535714285714*G0_2_1 - 0.048214285714286*G0_2_2;
    A[117] = -0.096428571428571*G0_1_0 - 0.120535714285714*G0_1_2 - 0.241071428571428*G0_2_0 - 0.120535714285714*G0_2_1 - 0.289285714285714*G0_2_2;
    A[118] = -0.096428571428571*G0_1_1 - 0.120535714285714*G0_1_2 - 0.120535714285714*G0_2_1 - 0.144642857142857*G0_2_2;
    A[119] = 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_1 + 0.048214285714286*G0_2_2;
    A[120] = -0.013392857142857*G0_0_0 - 0.013392857142857*G0_0_1 - 0.013392857142857*G0_0_2 - 0.013392857142857*G0_2_0 - 0.013392857142857*G0_2_1 - 0.013392857142857*G0_2_2;
    A[121] = -0.034821428571429*G0_0_0 + 0.061607142857143*G0_2_0;
    A[122] = 0.013392857142857*G0_0_1 + 0.013392857142857*G0_2_1;
    A[123] = -0.034821428571429*G0_0_2 + 0.013392857142857*G0_2_2;
    A[124] = -0.048214285714286*G0_0_1 - 0.024107142857143*G0_0_2 - 0.024107142857143*G0_2_1 - 0.024107142857143*G0_2_2;
    A[125] = -0.072321428571428*G0_0_1 - 0.048214285714286*G0_0_2 - 0.024107142857143*G0_2_1 - 0.024107142857143*G0_2_2;
    A[126] = 0.241071428571428*G0_0_0 + 0.096428571428571*G0_0_2 + 0.096428571428571*G0_2_0 + 0.192857142857143*G0_2_2;
    A[127] = -0.072321428571428*G0_0_0 + 0.072321428571429*G0_0_2 - 0.024107142857143*G0_2_0 - 0.072321428571428*G0_2_2;
    A[128] = 0.120535714285714*G0_0_0 + 0.096428571428571*G0_0_1 + 0.096428571428571*G0_2_0 + 0.192857142857143*G0_2_1;
    A[129] = -0.024107142857143*G0_0_0 - 0.048214285714286*G0_0_1 - 0.024107142857143*G0_2_0 - 0.072321428571428*G0_2_1;
    A[130] = 0.048214285714286*G0_0_0 + 0.048214285714286*G0_0_1 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_1;
    A[131] = 0.072321428571428*G0_0_0 + 0.072321428571428*G0_0_1 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_1;
    A[132] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_2;
    A[133] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_2;
    A[134] = 0.024107142857143*G0_0_0 + 0.048214285714286*G0_0_1 + 0.048214285714286*G0_0_2 + 0.048214285714286*G0_2_0 + 0.072321428571429*G0_2_1 + 0.072321428571429*G0_2_2;
    A[135] = 0.024107142857143*G0_0_0 - 0.096428571428571*G0_0_1 - 0.096428571428571*G0_0_2 - 0.096428571428571*G0_2_0 - 0.192857142857143*G0_2_1 - 0.192857142857143*G0_2_2;
    A[136] = -0.048214285714285*G0_0_0 + 0.241071428571428*G0_0_1 + 0.120535714285714*G0_0_2 - 0.024107142857143*G0_2_0 + 0.096428571428571*G0_2_1 + 0.096428571428571*G0_2_2;
    A[137] = 0.048214285714285*G0_0_0 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_2_0;
    A[138] = -0.289285714285714*G0_0_0 - 0.241071428571429*G0_0_1 - 0.120535714285714*G0_0_2 - 0.120535714285714*G0_2_0 - 0.096428571428571*G0_2_1;
    A[139] = -0.144642857142857*G0_0_0 - 0.120535714285714*G0_0_2 - 0.120535714285714*G0_2_0 - 0.096428571428571*G0_2_2;
    A[140] = -0.013392857142857*G0_0_0 - 0.013392857142857*G0_0_1 - 0.013392857142857*G0_0_2 - 0.013392857142857*G0_2_0 - 0.013392857142857*G0_2_1 - 0.013392857142857*G0_2_2;
    A[141] = 0.013392857142857*G0_0_0 - 0.034821428571429*G0_2_0;
    A[142] = 0.013392857142857*G0_0_1 + 0.013392857142857*G0_2_1;
    A[143] = 0.061607142857143*G0_0_2 - 0.034821428571429*G0_2_2;
    A[144] = -0.072321428571429*G0_0_1 - 0.024107142857143*G0_0_2 - 0.048214285714286*G0_2_1 - 0.024107142857143*G0_2_2;
    A[145] = 0.192857142857143*G0_0_1 + 0.096428571428571*G0_0_2 + 0.096428571428571*G0_2_1 + 0.120535714285714*G0_2_2;
    A[146] = -0.072321428571428*G0_0_0 - 0.024107142857143*G0_0_2 + 0.072321428571429*G0_2_0 - 0.072321428571428*G0_2_2;
    A[147] = 0.192857142857143*G0_0_0 + 0.096428571428571*G0_0_2 + 0.096428571428571*G0_2_0 + 0.241071428571429*G0_2_2;
    A[148] = -0.024107142857143*G0_0_0 - 0.024107142857143*G0_0_1 - 0.048214285714286*G0_2_0 - 0.072321428571428*G0_2_1;
    A[149] = -0.024107142857143*G0_0_0 - 0.024107142857143*G0_0_1 - 0.024107142857143*G0_2_0 - 0.048214285714286*G0_2_1;
    A[150] = 0.072321428571428*G0_0_0 + 0.072321428571428*G0_0_1 + 0.048214285714286*G0_0_2 + 0.048214285714286*G0_2_0 + 0.048214285714286*G0_2_1 + 0.024107142857143*G0_2_2;
    A[151] = -0.192857142857143*G0_0_0 - 0.192857142857143*G0_0_1 - 0.096428571428571*G0_0_2 - 0.096428571428571*G0_2_0 - 0.096428571428571*G0_2_1 + 0.024107142857143*G0_2_2;
    A[152] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_2;
    A[153] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_2;
    A[154] = 0.024107142857143*G0_0_1 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_2_0 + 0.048214285714286*G0_2_1 + 0.048214285714286*G0_2_2;
    A[155] = 0.024107142857143*G0_0_1 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_2_0 + 0.072321428571429*G0_2_1 + 0.072321428571428*G0_2_2;
    A[156] = 0.096428571428571*G0_0_0 + 0.096428571428571*G0_0_1 - 0.024107142857143*G0_0_2 + 0.120535714285714*G0_2_0 + 0.241071428571429*G0_2_1 - 0.048214285714286*G0_2_2;
    A[157] = -0.096428571428571*G0_0_0 - 0.120535714285714*G0_0_2 - 0.120535714285714*G0_2_0 - 0.144642857142857*G0_2_2;
    A[158] = -0.096428571428571*G0_0_1 - 0.120535714285714*G0_0_2 - 0.120535714285714*G0_2_0 - 0.241071428571429*G0_2_1 - 0.289285714285714*G0_2_2;
    A[159] = 0.024107142857143*G0_0_2 + 0.024107142857143*G0_2_0 + 0.048214285714285*G0_2_2;
    A[160] = -0.013392857142857*G0_0_0 - 0.013392857142857*G0_0_1 - 0.013392857142857*G0_0_2 - 0.013392857142857*G0_1_0 - 0.013392857142857*G0_1_1 - 0.013392857142857*G0_1_2;
    A[161] = -0.034821428571429*G0_0_0 + 0.061607142857143*G0_1_0;
    A[162] = -0.034821428571428*G0_0_1 + 0.013392857142857*G0_1_1;
    A[163] = 0.013392857142857*G0_0_2 + 0.013392857142857*G0_1_2;
    A[164] = -0.048214285714286*G0_0_1 - 0.072321428571428*G0_0_2 - 0.024107142857143*G0_1_1 - 0.024107142857143*G0_1_2;
    A[165] = -0.024107142857143*G0_0_1 - 0.048214285714286*G0_0_2 - 0.024107142857143*G0_1_1 - 0.024107142857143*G0_1_2;
    A[166] = 0.120535714285714*G0_0_0 + 0.096428571428571*G0_0_2 + 0.096428571428571*G0_1_0 + 0.192857142857143*G0_1_2;
    A[167] = -0.024107142857143*G0_0_0 - 0.048214285714286*G0_0_2 - 0.024107142857143*G0_1_0 - 0.072321428571428*G0_1_2;
    A[168] = 0.241071428571428*G0_0_0 + 0.096428571428571*G0_0_1 + 0.096428571428571*G0_1_0 + 0.192857142857143*G0_1_1;
    A[169] = -0.072321428571428*G0_0_0 + 0.072321428571429*G0_0_1 - 0.024107142857143*G0_1_0 - 0.072321428571428*G0_1_1;
    A[170] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_1 + 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_1;
    A[171] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_1 + 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_1;
    A[172] = 0.048214285714286*G0_0_0 + 0.024107142857143*G0_0_1 + 0.048214285714286*G0_0_2 + 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_2;
    A[173] = 0.072321428571428*G0_0_0 + 0.024107142857143*G0_0_1 + 0.072321428571428*G0_0_2 + 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_2;
    A[174] = 0.024107142857143*G0_0_0 + 0.048214285714286*G0_0_1 + 0.048214285714286*G0_0_2 + 0.048214285714286*G0_1_0 + 0.072321428571429*G0_1_1 + 0.072321428571429*G0_1_2;
    A[175] = 0.024107142857143*G0_0_0 - 0.096428571428571*G0_0_1 - 0.096428571428571*G0_0_2 - 0.096428571428571*G0_1_0 - 0.192857142857143*G0_1_1 - 0.192857142857143*G0_1_2;
    A[176] = -0.048214285714286*G0_0_0 + 0.120535714285714*G0_0_1 + 0.241071428571428*G0_0_2 - 0.024107142857143*G0_1_0 + 0.096428571428571*G0_1_1 + 0.096428571428571*G0_1_2;
    A[177] = 0.048214285714285*G0_0_0 + 0.024107142857143*G0_0_1 + 0.024107142857143*G0_1_0;
    A[178] = -0.144642857142857*G0_0_0 - 0.120535714285714*G0_0_1 - 0.120535714285714*G0_1_0 - 0.096428571428571*G0_1_1;
    A[179] = -0.289285714285714*G0_0_0 - 0.120535714285714*G0_0_1 - 0.241071428571428*G0_0_2 - 0.120535714285714*G0_1_0 - 0.096428571428571*G0_1_2;
    A[180] = -0.013392857142857*G0_0_0 - 0.013392857142857*G0_0_1 - 0.013392857142857*G0_0_2 - 0.013392857142857*G0_1_0 - 0.013392857142857*G0_1_1 - 0.013392857142857*G0_1_2;
    A[181] = 0.013392857142857*G0_0_0 - 0.034821428571428*G0_1_0;
    A[182] = 0.061607142857143*G0_0_1 - 0.034821428571429*G0_1_1;
    A[183] = 0.013392857142857*G0_0_2 + 0.013392857142857*G0_1_2;
    A[184] = 0.096428571428571*G0_0_1 + 0.192857142857143*G0_0_2 + 0.120535714285714*G0_1_1 + 0.096428571428571*G0_1_2;
    A[185] = -0.024107142857143*G0_0_1 - 0.072321428571428*G0_0_2 - 0.024107142857143*G0_1_1 - 0.048214285714286*G0_1_2;
    A[186] = -0.024107142857143*G0_0_0 - 0.024107142857143*G0_0_2 - 0.048214285714286*G0_1_0 - 0.072321428571428*G0_1_2;
    A[187] = -0.024107142857143*G0_0_0 - 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_0 - 0.048214285714286*G0_1_2;
    A[188] = -0.072321428571428*G0_0_0 - 0.024107142857143*G0_0_1 + 0.072321428571429*G0_1_0 - 0.072321428571428*G0_1_1;
    A[189] = 0.192857142857142*G0_0_0 + 0.096428571428571*G0_0_1 + 0.096428571428571*G0_1_0 + 0.241071428571429*G0_1_1;
    A[190] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_1 + 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_1;
    A[191] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_1 + 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_1;
    A[192] = 0.072321428571428*G0_0_0 + 0.048214285714286*G0_0_1 + 0.072321428571428*G0_0_2 + 0.048214285714286*G0_1_0 + 0.024107142857143*G0_1_1 + 0.048214285714286*G0_1_2;
    A[193] = -0.192857142857142*G0_0_0 - 0.096428571428571*G0_0_1 - 0.192857142857143*G0_0_2 - 0.096428571428571*G0_1_0 + 0.024107142857143*G0_1_1 - 0.096428571428571*G0_1_2;
    A[194] = 0.024107142857143*G0_0_1 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_1_0 + 0.048214285714286*G0_1_1 + 0.048214285714286*G0_1_2;
    A[195] = 0.024107142857143*G0_0_1 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_1_0 + 0.072321428571428*G0_1_1 + 0.072321428571428*G0_1_2;
    A[196] = 0.096428571428572*G0_0_0 - 0.024107142857143*G0_0_1 + 0.096428571428572*G0_0_2 + 0.120535714285715*G0_1_0 - 0.048214285714286*G0_1_1 + 0.241071428571429*G0_1_2;
    A[197] = -0.096428571428572*G0_0_0 - 0.120535714285714*G0_0_1 - 0.120535714285715*G0_1_0 - 0.144642857142857*G0_1_1;
    A[198] = 0.024107142857143*G0_0_1 + 0.024107142857143*G0_1_0 + 0.048214285714285*G0_1_1;
    A[199] = -0.120535714285714*G0_0_1 - 0.096428571428572*G0_0_2 - 0.120535714285714*G0_1_0 - 0.289285714285714*G0_1_1 - 0.241071428571429*G0_1_2;
    A[200] = -0.034821428571429*G0_0_0 - 0.034821428571429*G0_0_1 - 0.034821428571429*G0_0_2 - 0.034821428571429*G0_1_0 - 0.034821428571429*G0_1_1 - 0.034821428571429*G0_1_2 - 0.096428571428571*G0_2_0 - 0.096428571428571*G0_2_1 - 0.096428571428571*G0_2_2;
    A[201] = -0.013392857142857*G0_0_0 - 0.013392857142857*G0_1_0;
    A[202] = -0.013392857142857*G0_0_1 - 0.013392857142857*G0_1_1;
    A[203] = 0.034821428571428*G0_0_2 + 0.034821428571428*G0_1_2 + 0.048214285714286*G0_2_2;
    A[204] = 0.048214285714286*G0_0_1 + 0.024107142857143*G0_0_2 + 0.048214285714286*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_1;
    A[205] = 0.072321428571428*G0_0_1 + 0.048214285714286*G0_0_2 + 0.072321428571428*G0_1_1 + 0.048214285714286*G0_1_2 + 0.048214285714286*G0_2_1 + 0.024107142857143*G0_2_2;
    A[206] = 0.048214285714286*G0_0_0 + 0.024107142857143*G0_0_2 + 0.048214285714286*G0_1_0 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_0;
    A[207] = 0.072321428571428*G0_0_0 + 0.048214285714286*G0_0_2 + 0.072321428571428*G0_1_0 + 0.048214285714286*G0_1_2 + 0.048214285714286*G0_2_0 + 0.024107142857143*G0_2_2;
    A[208] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_1 + 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_1;
    A[209] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_1 + 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_1;
    A[210] = 0.241071428571428*G0_0_0 + 0.241071428571428*G0_0_1 + 0.144642857142857*G0_0_2 + 0.241071428571428*G0_1_0 + 0.241071428571428*G0_1_1 + 0.144642857142857*G0_1_2 + 0.144642857142857*G0_2_0 + 0.144642857142857*G0_2_1 + 0.241071428571428*G0_2_2;
    A[211] = -0.072321428571428*G0_0_0 - 0.072321428571428*G0_0_1 - 0.144642857142857*G0_0_2 - 0.072321428571428*G0_1_0 - 0.072321428571428*G0_1_1 - 0.144642857142857*G0_1_2 - 0.048214285714286*G0_2_0 - 0.048214285714286*G0_2_1 - 0.192857142857143*G0_2_2;
    A[212] = 0.120535714285714*G0_0_0 + 0.024107142857143*G0_0_1 + 0.120535714285714*G0_0_2 + 0.120535714285714*G0_1_0 + 0.024107142857143*G0_1_1 + 0.120535714285714*G0_1_2 + 0.024107142857143*G0_2_0 + 0.120535714285714*G0_2_1 + 0.024107142857143*G0_2_2;
    A[213] = -0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_1 - 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_1 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_1;
    A[214] = 0.024107142857143*G0_0_0 + 0.120535714285714*G0_0_1 + 0.120535714285714*G0_0_2 + 0.024107142857143*G0_1_0 + 0.120535714285714*G0_1_1 + 0.120535714285714*G0_1_2 + 0.120535714285714*G0_2_0 + 0.024107142857143*G0_2_1 + 0.024107142857143*G0_2_2;
    A[215] = 0.024107142857143*G0_0_0 - 0.024107142857143*G0_0_1 - 0.024107142857143*G0_0_2 + 0.024107142857143*G0_1_0 - 0.024107142857143*G0_1_1 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_0;
    A[216] = 0.048214285714286*G0_0_0 + 0.048214285714286*G0_0_1 + 0.024107142857143*G0_0_2 + 0.048214285714286*G0_1_0 + 0.048214285714286*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_1;
    A[217] = -0.048214285714286*G0_0_0 - 0.289285714285714*G0_0_1 - 0.168750000000000*G0_0_2 - 0.048214285714286*G0_1_0 - 0.289285714285714*G0_1_1 - 0.168750000000000*G0_1_2 - 0.024107142857143*G0_2_0 - 0.168750000000000*G0_2_1 - 0.048214285714286*G0_2_2;
    A[218] = -0.289285714285714*G0_0_0 - 0.048214285714286*G0_0_1 - 0.168750000000000*G0_0_2 - 0.289285714285714*G0_1_0 - 0.048214285714286*G0_1_1 - 0.168750000000000*G0_1_2 - 0.168750000000000*G0_2_0 - 0.024107142857143*G0_2_1 - 0.048214285714286*G0_2_2;
    A[219] = -0.144642857142857*G0_0_0 - 0.144642857142857*G0_0_1 - 0.024107142857143*G0_0_2 - 0.144642857142857*G0_1_0 - 0.144642857142857*G0_1_1 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_0 - 0.024107142857143*G0_2_1;
    A[220] = 0.013392857142857*G0_0_0 + 0.013392857142857*G0_0_1 + 0.013392857142857*G0_0_2 + 0.013392857142857*G0_1_0 + 0.013392857142857*G0_1_1 + 0.013392857142857*G0_1_2 + 0.048214285714286*G0_2_0 + 0.048214285714286*G0_2_1 + 0.048214285714286*G0_2_2;
    A[221] = -0.013392857142857*G0_0_0 - 0.013392857142857*G0_1_0;
    A[222] = -0.013392857142857*G0_0_1 - 0.013392857142857*G0_1_1;
    A[223] = -0.061607142857143*G0_0_2 - 0.061607142857143*G0_1_2 - 0.096428571428571*G0_2_2;
    A[224] = 0.072321428571429*G0_0_1 + 0.024107142857143*G0_0_2 + 0.072321428571429*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_1;
    A[225] = -0.192857142857143*G0_0_1 - 0.096428571428571*G0_0_2 - 0.192857142857143*G0_1_1 - 0.096428571428571*G0_1_2 - 0.096428571428571*G0_2_1 + 0.024107142857143*G0_2_2;
    A[226] = 0.072321428571428*G0_0_0 + 0.024107142857143*G0_0_2 + 0.072321428571428*G0_1_0 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_0;
    A[227] = -0.192857142857143*G0_0_0 - 0.096428571428571*G0_0_2 - 0.192857142857143*G0_1_0 - 0.096428571428571*G0_1_2 - 0.096428571428571*G0_2_0 + 0.024107142857143*G0_2_2;
    A[228] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_1 + 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_1;
    A[229] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_1 + 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_1;
    A[230] = -0.072321428571428*G0_0_0 - 0.072321428571428*G0_0_1 - 0.048214285714286*G0_0_2 - 0.072321428571428*G0_1_0 - 0.072321428571428*G0_1_1 - 0.048214285714286*G0_1_2 - 0.144642857142857*G0_2_0 - 0.144642857142857*G0_2_1 - 0.192857142857143*G0_2_2;
    A[231] = 0.192857142857143*G0_0_0 + 0.192857142857143*G0_0_1 + 0.096428571428571*G0_0_2 + 0.192857142857143*G0_1_0 + 0.192857142857143*G0_1_1 + 0.096428571428571*G0_1_2 + 0.096428571428571*G0_2_0 + 0.096428571428571*G0_2_1 + 0.241071428571428*G0_2_2;
    A[232] = -0.024107142857143*G0_0_0 - 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_0 - 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_0 - 0.024107142857143*G0_2_1 + 0.024107142857143*G0_2_2;
    A[233] = -0.024107142857143*G0_0_0 - 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_0 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_1;
    A[234] = -0.024107142857143*G0_0_1 - 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_1 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_1 + 0.024107142857143*G0_2_2;
    A[235] = -0.024107142857143*G0_0_1 - 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_1 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_0;
    A[236] = -0.096428571428571*G0_0_0 - 0.096428571428572*G0_0_1 + 0.024107142857143*G0_0_2 - 0.096428571428571*G0_1_0 - 0.096428571428572*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_1;
    A[237] = 0.096428571428571*G0_0_0 + 0.120535714285714*G0_0_2 + 0.096428571428571*G0_1_0 + 0.120535714285714*G0_1_2 - 0.024107142857143*G0_2_0 + 0.120535714285714*G0_2_1 - 0.048214285714286*G0_2_2;
    A[238] = 0.096428571428571*G0_0_1 + 0.120535714285714*G0_0_2 + 0.096428571428571*G0_1_1 + 0.120535714285714*G0_1_2 + 0.120535714285714*G0_2_0 - 0.024107142857143*G0_2_1 - 0.048214285714286*G0_2_2;
    A[239] = -0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_0 - 0.024107142857143*G0_2_1;
    A[240] = -0.034821428571429*G0_0_0 - 0.034821428571429*G0_0_1 - 0.034821428571429*G0_0_2 - 0.096428571428571*G0_1_0 - 0.096428571428571*G0_1_1 - 0.096428571428571*G0_1_2 - 0.034821428571429*G0_2_0 - 0.034821428571429*G0_2_1 - 0.034821428571429*G0_2_2;
    A[241] = -0.013392857142857*G0_0_0 - 0.013392857142857*G0_2_0;
    A[242] = 0.034821428571428*G0_0_1 + 0.048214285714286*G0_1_1 + 0.034821428571428*G0_2_1;
    A[243] = -0.013392857142857*G0_0_2 - 0.013392857142857*G0_2_2;
    A[244] = 0.048214285714286*G0_0_1 + 0.072321428571428*G0_0_2 + 0.024107142857143*G0_1_1 + 0.048214285714286*G0_1_2 + 0.048214285714286*G0_2_1 + 0.072321428571428*G0_2_2;
    A[245] = 0.024107142857143*G0_0_1 + 0.048214285714286*G0_0_2 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_1 + 0.048214285714286*G0_2_2;
    A[246] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_2;
    A[247] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_2;
    A[248] = 0.048214285714286*G0_0_0 + 0.024107142857143*G0_0_1 + 0.024107142857143*G0_1_0 + 0.048214285714286*G0_2_0 + 0.024107142857143*G0_2_1;
    A[249] = 0.072321428571428*G0_0_0 + 0.048214285714286*G0_0_1 + 0.048214285714286*G0_1_0 + 0.024107142857143*G0_1_1 + 0.072321428571428*G0_2_0 + 0.048214285714286*G0_2_1;
    A[250] = 0.120535714285714*G0_0_0 + 0.120535714285714*G0_0_1 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_1 + 0.120535714285714*G0_1_2 + 0.120535714285714*G0_2_0 + 0.120535714285714*G0_2_1 + 0.024107142857143*G0_2_2;
    A[251] = -0.024107142857143*G0_0_0 - 0.024107142857143*G0_0_1 + 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_0 - 0.024107142857143*G0_2_1 + 0.024107142857143*G0_2_2;
    A[252] = 0.241071428571428*G0_0_0 + 0.144642857142857*G0_0_1 + 0.241071428571428*G0_0_2 + 0.144642857142857*G0_1_0 + 0.241071428571428*G0_1_1 + 0.144642857142857*G0_1_2 + 0.241071428571428*G0_2_0 + 0.144642857142857*G0_2_1 + 0.241071428571428*G0_2_2;
    A[253] = -0.072321428571428*G0_0_0 - 0.144642857142857*G0_0_1 - 0.072321428571428*G0_0_2 - 0.048214285714286*G0_1_0 - 0.192857142857143*G0_1_1 - 0.048214285714286*G0_1_2 - 0.072321428571428*G0_2_0 - 0.144642857142857*G0_2_1 - 0.072321428571428*G0_2_2;
    A[254] = 0.024107142857143*G0_0_0 + 0.120535714285714*G0_0_1 + 0.120535714285714*G0_0_2 + 0.120535714285714*G0_1_0 + 0.024107142857143*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_0 + 0.120535714285714*G0_2_1 + 0.120535714285714*G0_2_2;
    A[255] = 0.024107142857143*G0_0_0 - 0.024107142857143*G0_0_1 - 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_0 + 0.024107142857143*G0_2_0 - 0.024107142857143*G0_2_1 - 0.024107142857143*G0_2_2;
    A[256] = 0.048214285714286*G0_0_0 + 0.024107142857143*G0_0_1 + 0.048214285714286*G0_0_2 + 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_2 + 0.048214285714286*G0_2_0 + 0.024107142857143*G0_2_1 + 0.048214285714286*G0_2_2;
    A[257] = -0.048214285714286*G0_0_0 - 0.168750000000000*G0_0_1 - 0.289285714285714*G0_0_2 - 0.024107142857143*G0_1_0 - 0.048214285714286*G0_1_1 - 0.168750000000000*G0_1_2 - 0.048214285714286*G0_2_0 - 0.168750000000000*G0_2_1 - 0.289285714285714*G0_2_2;
    A[258] = -0.144642857142857*G0_0_0 - 0.024107142857143*G0_0_1 - 0.144642857142857*G0_0_2 - 0.024107142857143*G0_1_0 - 0.024107142857143*G0_1_2 - 0.144642857142857*G0_2_0 - 0.024107142857143*G0_2_1 - 0.144642857142857*G0_2_2;
    A[259] = -0.289285714285714*G0_0_0 - 0.168750000000000*G0_0_1 - 0.048214285714286*G0_0_2 - 0.168750000000000*G0_1_0 - 0.048214285714286*G0_1_1 - 0.024107142857143*G0_1_2 - 0.289285714285714*G0_2_0 - 0.168750000000000*G0_2_1 - 0.048214285714286*G0_2_2;
    A[260] = 0.013392857142857*G0_0_0 + 0.013392857142857*G0_0_1 + 0.013392857142857*G0_0_2 + 0.048214285714286*G0_1_0 + 0.048214285714286*G0_1_1 + 0.048214285714286*G0_1_2 + 0.013392857142857*G0_2_0 + 0.013392857142857*G0_2_1 + 0.013392857142857*G0_2_2;
    A[261] = -0.013392857142857*G0_0_0 - 0.013392857142857*G0_2_0;
    A[262] = -0.061607142857143*G0_0_1 - 0.096428571428571*G0_1_1 - 0.061607142857143*G0_2_1;
    A[263] = -0.013392857142857*G0_0_2 - 0.013392857142857*G0_2_2;
    A[264] = -0.096428571428571*G0_0_1 - 0.192857142857143*G0_0_2 + 0.024107142857143*G0_1_1 - 0.096428571428571*G0_1_2 - 0.096428571428571*G0_2_1 - 0.192857142857143*G0_2_2;
    A[265] = 0.024107142857143*G0_0_1 + 0.072321428571428*G0_0_2 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_1 + 0.072321428571428*G0_2_2;
    A[266] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_2;
    A[267] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_2;
    A[268] = 0.072321428571428*G0_0_0 + 0.024107142857143*G0_0_1 + 0.024107142857143*G0_1_0 + 0.072321428571428*G0_2_0 + 0.024107142857143*G0_2_1;
    A[269] = -0.192857142857142*G0_0_0 - 0.096428571428571*G0_0_1 - 0.096428571428571*G0_1_0 + 0.024107142857143*G0_1_1 - 0.192857142857143*G0_2_0 - 0.096428571428571*G0_2_1;
    A[270] = -0.024107142857143*G0_0_0 - 0.024107142857143*G0_0_1 + 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_1 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_0 - 0.024107142857143*G0_2_1;
    A[271] = -0.024107142857143*G0_0_0 - 0.024107142857143*G0_0_1 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_0 - 0.024107142857143*G0_2_1;
    A[272] = -0.072321428571428*G0_0_0 - 0.048214285714286*G0_0_1 - 0.072321428571428*G0_0_2 - 0.144642857142857*G0_1_0 - 0.192857142857143*G0_1_1 - 0.144642857142857*G0_1_2 - 0.072321428571428*G0_2_0 - 0.048214285714286*G0_2_1 - 0.072321428571428*G0_2_2;
    A[273] = 0.192857142857142*G0_0_0 + 0.096428571428571*G0_0_1 + 0.192857142857143*G0_0_2 + 0.096428571428571*G0_1_0 + 0.241071428571428*G0_1_1 + 0.096428571428571*G0_1_2 + 0.192857142857143*G0_2_0 + 0.096428571428571*G0_2_1 + 0.192857142857143*G0_2_2;
    A[274] = -0.024107142857143*G0_0_1 - 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_1 + 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_1 - 0.024107142857143*G0_2_2;
    A[275] = -0.024107142857143*G0_0_1 - 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_0 - 0.024107142857143*G0_2_1 - 0.024107142857143*G0_2_2;
    A[276] = -0.096428571428572*G0_0_0 + 0.024107142857143*G0_0_1 - 0.096428571428572*G0_0_2 + 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_2 - 0.096428571428572*G0_2_0 + 0.024107142857143*G0_2_1 - 0.096428571428572*G0_2_2;
    A[277] = 0.096428571428572*G0_0_0 + 0.120535714285714*G0_0_1 - 0.024107142857143*G0_1_0 - 0.048214285714286*G0_1_1 + 0.120535714285714*G0_1_2 + 0.096428571428572*G0_2_0 + 0.120535714285714*G0_2_1;
    A[278] = -0.024107142857143*G0_0_1 - 0.024107142857143*G0_1_0 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_1;
    A[279] = 0.120535714285714*G0_0_1 + 0.096428571428572*G0_0_2 + 0.120535714285714*G0_1_0 - 0.048214285714286*G0_1_1 - 0.024107142857143*G0_1_2 + 0.120535714285714*G0_2_1 + 0.096428571428572*G0_2_2;
    A[280] = -0.096428571428571*G0_0_0 - 0.096428571428571*G0_0_1 - 0.096428571428571*G0_0_2 - 0.034821428571429*G0_1_0 - 0.034821428571429*G0_1_1 - 0.034821428571429*G0_1_2 - 0.034821428571429*G0_2_0 - 0.034821428571429*G0_2_1 - 0.034821428571429*G0_2_2;
    A[281] = 0.048214285714286*G0_0_0 + 0.034821428571429*G0_1_0 + 0.034821428571429*G0_2_0;
    A[282] = -0.013392857142857*G0_1_1 - 0.013392857142857*G0_2_1;
    A[283] = -0.013392857142857*G0_1_2 - 0.013392857142857*G0_2_2;
    A[284] = 0.024107142857143*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_1 + 0.024107142857143*G0_2_2;
    A[285] = 0.024107142857143*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_1 + 0.024107142857143*G0_2_2;
    A[286] = 0.024107142857143*G0_0_0 + 0.048214285714286*G0_0_2 + 0.048214285714286*G0_1_0 + 0.072321428571429*G0_1_2 + 0.048214285714286*G0_2_0 + 0.072321428571429*G0_2_2;
    A[287] = 0.024107142857143*G0_0_2 + 0.024107142857143*G0_1_0 + 0.048214285714286*G0_1_2 + 0.024107142857143*G0_2_0 + 0.048214285714286*G0_2_2;
    A[288] = 0.024107142857143*G0_0_0 + 0.048214285714286*G0_0_1 + 0.048214285714286*G0_1_0 + 0.072321428571429*G0_1_1 + 0.048214285714286*G0_2_0 + 0.072321428571429*G0_2_1;
    A[289] = 0.024107142857143*G0_0_1 + 0.024107142857143*G0_1_0 + 0.048214285714286*G0_1_1 + 0.024107142857143*G0_2_0 + 0.048214285714286*G0_2_1;
    A[290] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_1 + 0.120535714285714*G0_0_2 + 0.120535714285714*G0_1_0 + 0.120535714285714*G0_1_1 + 0.024107142857143*G0_1_2 + 0.120535714285714*G0_2_0 + 0.120535714285714*G0_2_1 + 0.024107142857143*G0_2_2;
    A[291] = -0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_0 - 0.024107142857143*G0_1_1 + 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_0 - 0.024107142857143*G0_2_1 + 0.024107142857143*G0_2_2;
    A[292] = 0.024107142857143*G0_0_0 + 0.120535714285714*G0_0_1 + 0.024107142857143*G0_0_2 + 0.120535714285714*G0_1_0 + 0.024107142857143*G0_1_1 + 0.120535714285714*G0_1_2 + 0.120535714285714*G0_2_0 + 0.024107142857143*G0_2_1 + 0.120535714285714*G0_2_2;
    A[293] = -0.024107142857143*G0_0_1 - 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_1 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_1 - 0.024107142857143*G0_2_2;
    A[294] = 0.241071428571429*G0_0_0 + 0.144642857142857*G0_0_1 + 0.144642857142857*G0_0_2 + 0.144642857142857*G0_1_0 + 0.241071428571428*G0_1_1 + 0.241071428571428*G0_1_2 + 0.144642857142857*G0_2_0 + 0.241071428571428*G0_2_1 + 0.241071428571428*G0_2_2;
    A[295] = -0.192857142857143*G0_0_0 - 0.048214285714286*G0_0_1 - 0.048214285714286*G0_0_2 - 0.144642857142857*G0_1_0 - 0.072321428571429*G0_1_1 - 0.072321428571429*G0_1_2 - 0.144642857142857*G0_2_0 - 0.072321428571429*G0_2_1 - 0.072321428571429*G0_2_2;
    A[296] = 0.024107142857143*G0_0_1 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_1_0 + 0.048214285714286*G0_1_1 + 0.048214285714286*G0_1_2 + 0.024107142857143*G0_2_0 + 0.048214285714286*G0_2_1 + 0.048214285714286*G0_2_2;
    A[297] = -0.024107142857143*G0_0_1 - 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_0 - 0.144642857142857*G0_1_1 - 0.144642857142857*G0_1_2 - 0.024107142857143*G0_2_0 - 0.144642857142857*G0_2_1 - 0.144642857142857*G0_2_2;
    A[298] = -0.048214285714286*G0_0_0 - 0.024107142857143*G0_0_1 - 0.168750000000000*G0_0_2 - 0.168750000000000*G0_1_0 - 0.048214285714286*G0_1_1 - 0.289285714285714*G0_1_2 - 0.168750000000000*G0_2_0 - 0.048214285714286*G0_2_1 - 0.289285714285714*G0_2_2;
    A[299] = -0.048214285714286*G0_0_0 - 0.168750000000000*G0_0_1 - 0.024107142857143*G0_0_2 - 0.168750000000000*G0_1_0 - 0.289285714285714*G0_1_1 - 0.048214285714286*G0_1_2 - 0.168750000000000*G0_2_0 - 0.289285714285714*G0_2_1 - 0.048214285714286*G0_2_2;
    A[300] = 0.048214285714286*G0_0_0 + 0.048214285714286*G0_0_1 + 0.048214285714286*G0_0_2 + 0.013392857142857*G0_1_0 + 0.013392857142857*G0_1_1 + 0.013392857142857*G0_1_2 + 0.013392857142857*G0_2_0 + 0.013392857142857*G0_2_1 + 0.013392857142857*G0_2_2;
    A[301] = -0.096428571428571*G0_0_0 - 0.061607142857143*G0_1_0 - 0.061607142857143*G0_2_0;
    A[302] = -0.013392857142857*G0_1_1 - 0.013392857142857*G0_2_1;
    A[303] = -0.013392857142857*G0_1_2 - 0.013392857142857*G0_2_2;
    A[304] = 0.024107142857143*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_1 + 0.024107142857143*G0_2_2;
    A[305] = 0.024107142857143*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_1 + 0.024107142857143*G0_2_2;
    A[306] = 0.024107142857143*G0_0_0 - 0.096428571428571*G0_0_2 - 0.096428571428571*G0_1_0 - 0.192857142857143*G0_1_2 - 0.096428571428571*G0_2_0 - 0.192857142857143*G0_2_2;
    A[307] = 0.024107142857143*G0_0_2 + 0.024107142857143*G0_1_0 + 0.072321428571429*G0_1_2 + 0.024107142857143*G0_2_0 + 0.072321428571428*G0_2_2;
    A[308] = 0.024107142857143*G0_0_0 - 0.096428571428571*G0_0_1 - 0.096428571428571*G0_1_0 - 0.192857142857143*G0_1_1 - 0.096428571428571*G0_2_0 - 0.192857142857143*G0_2_1;
    A[309] = 0.024107142857143*G0_0_1 + 0.024107142857143*G0_1_0 + 0.072321428571428*G0_1_1 + 0.024107142857143*G0_2_0 + 0.072321428571428*G0_2_1;
    A[310] = 0.024107142857143*G0_0_0 + 0.024107142857143*G0_0_1 - 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_0 - 0.024107142857143*G0_1_1 - 0.024107142857143*G0_2_0 - 0.024107142857143*G0_2_1;
    A[311] = -0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_0 - 0.024107142857143*G0_1_1 - 0.024107142857143*G0_2_0 - 0.024107142857143*G0_2_1;
    A[312] = 0.024107142857143*G0_0_0 - 0.024107142857143*G0_0_1 + 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_0 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_0 - 0.024107142857143*G0_2_2;
    A[313] = -0.024107142857143*G0_0_1 - 0.024107142857143*G0_1_0 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_0 - 0.024107142857143*G0_2_2;
    A[314] = -0.192857142857143*G0_0_0 - 0.144642857142857*G0_0_1 - 0.144642857142857*G0_0_2 - 0.048214285714286*G0_1_0 - 0.072321428571429*G0_1_1 - 0.072321428571429*G0_1_2 - 0.048214285714286*G0_2_0 - 0.072321428571429*G0_2_1 - 0.072321428571429*G0_2_2;
    A[315] = 0.241071428571428*G0_0_0 + 0.096428571428571*G0_0_1 + 0.096428571428571*G0_0_2 + 0.096428571428571*G0_1_0 + 0.192857142857143*G0_1_1 + 0.192857142857143*G0_1_2 + 0.096428571428571*G0_2_0 + 0.192857142857143*G0_2_1 + 0.192857142857143*G0_2_2;
    A[316] = 0.024107142857143*G0_0_1 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_1_0 - 0.096428571428571*G0_1_1 - 0.096428571428571*G0_1_2 + 0.024107142857143*G0_2_0 - 0.096428571428571*G0_2_1 - 0.096428571428571*G0_2_2;
    A[317] = -0.024107142857143*G0_0_1 - 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_0 - 0.024107142857143*G0_2_0;
    A[318] = -0.048214285714286*G0_0_0 - 0.024107142857143*G0_0_1 + 0.120535714285714*G0_0_2 + 0.120535714285714*G0_1_0 + 0.096428571428571*G0_1_1 + 0.120535714285714*G0_2_0 + 0.096428571428571*G0_2_1;
    A[319] = -0.048214285714286*G0_0_0 + 0.120535714285714*G0_0_1 - 0.024107142857143*G0_0_2 + 0.120535714285714*G0_1_0 + 0.096428571428571*G0_1_2 + 0.120535714285714*G0_2_0 + 0.096428571428571*G0_2_2;
    A[320] = -0.032142857142857*G0_0_0 - 0.032142857142857*G0_0_1 - 0.032142857142857*G0_0_2 - 0.032142857142857*G0_1_0 - 0.032142857142857*G0_1_1 - 0.032142857142857*G0_1_2 - 0.032142857142857*G0_2_0 - 0.032142857142857*G0_2_1 - 0.032142857142857*G0_2_2;
    A[321] = 0.032142857142857*G0_0_0 - 0.016071428571429*G0_1_0 - 0.016071428571429*G0_2_0;
    A[322] = -0.016071428571429*G0_0_1 + 0.032142857142857*G0_1_1 - 0.016071428571428*G0_2_1;
    A[323] = -0.016071428571429*G0_0_2 - 0.016071428571429*G0_1_2 + 0.032142857142857*G0_2_2;
    A[324] = 0.241071428571429*G0_0_1 + 0.096428571428571*G0_0_2 - 0.048214285714286*G0_1_1 - 0.024107142857143*G0_1_2 + 0.120535714285715*G0_2_1 + 0.096428571428572*G0_2_2;
    A[325] = 0.096428571428571*G0_0_1 + 0.241071428571428*G0_0_2 + 0.096428571428571*G0_1_1 + 0.120535714285714*G0_1_2 - 0.024107142857143*G0_2_1 - 0.048214285714286*G0_2_2;
    A[326] = -0.048214285714285*G0_0_0 - 0.024107142857143*G0_0_2 + 0.241071428571428*G0_1_0 + 0.096428571428571*G0_1_2 + 0.120535714285714*G0_2_0 + 0.096428571428571*G0_2_2;
    A[327] = 0.096428571428571*G0_0_0 + 0.120535714285714*G0_0_2 + 0.096428571428571*G0_1_0 + 0.241071428571429*G0_1_2 - 0.024107142857143*G0_2_0 - 0.048214285714286*G0_2_2;
    A[328] = -0.048214285714286*G0_0_0 - 0.024107142857143*G0_0_1 + 0.120535714285714*G0_1_0 + 0.096428571428571*G0_1_1 + 0.241071428571428*G0_2_0 + 0.096428571428571*G0_2_1;
    A[329] = 0.096428571428572*G0_0_0 + 0.120535714285715*G0_0_1 - 0.024107142857143*G0_1_0 - 0.048214285714286*G0_1_1 + 0.096428571428572*G0_2_0 + 0.241071428571429*G0_2_1;
    A[330] = 0.048214285714286*G0_0_0 + 0.048214285714286*G0_0_1 + 0.024107142857143*G0_0_2 + 0.048214285714286*G0_1_0 + 0.048214285714286*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_1;
    A[331] = -0.096428571428571*G0_0_0 - 0.096428571428571*G0_0_1 + 0.024107142857143*G0_0_2 - 0.096428571428572*G0_1_0 - 0.096428571428572*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_0 + 0.024107142857143*G0_2_1;
    A[332] = 0.048214285714286*G0_0_0 + 0.024107142857143*G0_0_1 + 0.048214285714286*G0_0_2 + 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_2 + 0.048214285714286*G0_2_0 + 0.024107142857143*G0_2_1 + 0.048214285714286*G0_2_2;
    A[333] = -0.096428571428572*G0_0_0 + 0.024107142857143*G0_0_1 - 0.096428571428572*G0_0_2 + 0.024107142857143*G0_1_0 + 0.024107142857143*G0_1_2 - 0.096428571428572*G0_2_0 + 0.024107142857143*G0_2_1 - 0.096428571428572*G0_2_2;
    A[334] = 0.024107142857143*G0_0_1 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_1_0 + 0.048214285714286*G0_1_1 + 0.048214285714286*G0_1_2 + 0.024107142857143*G0_2_0 + 0.048214285714286*G0_2_1 + 0.048214285714286*G0_2_2;
    A[335] = 0.024107142857143*G0_0_1 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_1_0 - 0.096428571428571*G0_1_1 - 0.096428571428571*G0_1_2 + 0.024107142857143*G0_2_0 - 0.096428571428571*G0_2_1 - 0.096428571428571*G0_2_2;
    A[336] = 0.578571428571428*G0_0_0 + 0.289285714285714*G0_0_1 + 0.289285714285715*G0_0_2 + 0.289285714285714*G0_1_0 + 0.578571428571428*G0_1_1 + 0.289285714285714*G0_1_2 + 0.289285714285715*G0_2_0 + 0.289285714285714*G0_2_1 + 0.578571428571429*G0_2_2;
    A[337] = -0.578571428571429*G0_0_0 - 0.289285714285714*G0_0_1 - 0.289285714285714*G0_0_2 - 0.289285714285714*G0_1_0 - 0.144642857142857*G0_1_2 - 0.289285714285715*G0_2_0 - 0.144642857142857*G0_2_1;
    A[338] = -0.289285714285714*G0_0_1 - 0.144642857142857*G0_0_2 - 0.289285714285714*G0_1_0 - 0.578571428571428*G0_1_1 - 0.289285714285714*G0_1_2 - 0.144642857142857*G0_2_0 - 0.289285714285714*G0_2_1;
    A[339] = -0.144642857142857*G0_0_1 - 0.289285714285715*G0_0_2 - 0.144642857142857*G0_1_0 - 0.289285714285714*G0_1_2 - 0.289285714285714*G0_2_0 - 0.289285714285715*G0_2_1 - 0.578571428571429*G0_2_2;
    A[340] = 0.032142857142857*G0_0_0 + 0.032142857142857*G0_0_1 + 0.032142857142857*G0_0_2 + 0.048214285714286*G0_1_0 + 0.048214285714286*G0_1_1 + 0.048214285714286*G0_1_2 + 0.048214285714286*G0_2_0 + 0.048214285714286*G0_2_1 + 0.048214285714286*G0_2_2;
    A[341] = -0.032142857142857*G0_0_0;
    A[342] = 0.016071428571429*G0_0_1 + 0.048214285714286*G0_1_1;
    A[343] = 0.016071428571429*G0_0_2 + 0.048214285714286*G0_2_2;
    A[344] = -0.241071428571429*G0_0_1 - 0.096428571428572*G0_0_2 - 0.289285714285714*G0_1_1 - 0.120535714285714*G0_1_2 - 0.120535714285714*G0_2_1;
    A[345] = -0.096428571428571*G0_0_1 - 0.241071428571428*G0_0_2 - 0.120535714285714*G0_1_2 - 0.120535714285714*G0_2_1 - 0.289285714285714*G0_2_2;
    A[346] = 0.048214285714285*G0_0_0 + 0.024107142857143*G0_0_2 + 0.024107142857143*G0_2_0;
    A[347] = -0.096428571428571*G0_0_0 - 0.120535714285714*G0_0_2 - 0.120535714285714*G0_2_0 - 0.144642857142857*G0_2_2;
    A[348] = 0.048214285714285*G0_0_0 + 0.024107142857143*G0_0_1 + 0.024107142857143*G0_1_0;
    A[349] = -0.096428571428572*G0_0_0 - 0.120535714285715*G0_0_1 - 0.120535714285714*G0_1_0 - 0.144642857142857*G0_1_1;
    A[350] = -0.048214285714286*G0_0_0 - 0.048214285714286*G0_0_1 - 0.024107142857143*G0_0_2 - 0.289285714285714*G0_1_0 - 0.289285714285714*G0_1_1 - 0.168750000000000*G0_1_2 - 0.168750000000000*G0_2_0 - 0.168750000000000*G0_2_1 - 0.048214285714286*G0_2_2;
    A[351] = 0.096428571428571*G0_0_0 + 0.096428571428571*G0_0_1 - 0.024107142857143*G0_0_2 + 0.120535714285714*G0_1_2 + 0.120535714285714*G0_2_0 + 0.120535714285714*G0_2_1 - 0.048214285714286*G0_2_2;
    A[352] = -0.048214285714286*G0_0_0 - 0.024107142857143*G0_0_1 - 0.048214285714286*G0_0_2 - 0.168750000000000*G0_1_0 - 0.048214285714286*G0_1_1 - 0.168750000000000*G0_1_2 - 0.289285714285714*G0_2_0 - 0.168750000000000*G0_2_1 - 0.289285714285714*G0_2_2;
    A[353] = 0.096428571428572*G0_0_0 - 0.024107142857143*G0_0_1 + 0.096428571428572*G0_0_2 + 0.120535714285714*G0_1_0 - 0.048214285714286*G0_1_1 + 0.120535714285714*G0_1_2 + 0.120535714285714*G0_2_1;
    A[354] = -0.024107142857143*G0_0_1 - 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_0 - 0.144642857142857*G0_1_1 - 0.144642857142857*G0_1_2 - 0.024107142857143*G0_2_0 - 0.144642857142857*G0_2_1 - 0.144642857142857*G0_2_2;
    A[355] = -0.024107142857143*G0_0_1 - 0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_0 - 0.024107142857143*G0_2_0;
    A[356] = -0.578571428571429*G0_0_0 - 0.289285714285714*G0_0_1 - 0.289285714285715*G0_0_2 - 0.289285714285714*G0_1_0 - 0.144642857142857*G0_1_2 - 0.289285714285714*G0_2_0 - 0.144642857142857*G0_2_1;
    A[357] = 0.578571428571429*G0_0_0 + 0.289285714285714*G0_0_1 + 0.289285714285714*G0_0_2 + 0.289285714285714*G0_1_0 + 0.578571428571428*G0_1_1 + 0.289285714285714*G0_1_2 + 0.289285714285714*G0_2_0 + 0.289285714285714*G0_2_1 + 0.578571428571428*G0_2_2;
    A[358] = 0.289285714285714*G0_0_1 + 0.144642857142857*G0_0_2 + 0.289285714285714*G0_1_0 + 0.144642857142857*G0_1_2 + 0.144642857142857*G0_2_0 + 0.144642857142857*G0_2_1 + 0.289285714285714*G0_2_2;
    A[359] = 0.144642857142857*G0_0_1 + 0.289285714285715*G0_0_2 + 0.144642857142857*G0_1_0 + 0.289285714285714*G0_1_1 + 0.144642857142857*G0_1_2 + 0.289285714285714*G0_2_0 + 0.144642857142857*G0_2_1;
    A[360] = 0.048214285714286*G0_0_0 + 0.048214285714286*G0_0_1 + 0.048214285714286*G0_0_2 + 0.032142857142857*G0_1_0 + 0.032142857142857*G0_1_1 + 0.032142857142857*G0_1_2 + 0.048214285714286*G0_2_0 + 0.048214285714286*G0_2_1 + 0.048214285714286*G0_2_2;
    A[361] = 0.048214285714286*G0_0_0 + 0.016071428571429*G0_1_0;
    A[362] = -0.032142857142857*G0_1_1;
    A[363] = 0.016071428571429*G0_1_2 + 0.048214285714286*G0_2_2;
    A[364] = 0.048214285714286*G0_1_1 + 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_1;
    A[365] = -0.096428571428571*G0_1_1 - 0.120535714285714*G0_1_2 - 0.120535714285714*G0_2_1 - 0.144642857142857*G0_2_2;
    A[366] = -0.289285714285714*G0_0_0 - 0.120535714285714*G0_0_2 - 0.241071428571429*G0_1_0 - 0.096428571428571*G0_1_2 - 0.120535714285714*G0_2_0;
    A[367] = -0.120535714285714*G0_0_2 - 0.096428571428571*G0_1_0 - 0.241071428571429*G0_1_2 - 0.120535714285714*G0_2_0 - 0.289285714285714*G0_2_2;
    A[368] = -0.144642857142857*G0_0_0 - 0.120535714285714*G0_0_1 - 0.120535714285714*G0_1_0 - 0.096428571428571*G0_1_1;
    A[369] = 0.024107142857143*G0_0_1 + 0.024107142857143*G0_1_0 + 0.048214285714285*G0_1_1;
    A[370] = -0.289285714285714*G0_0_0 - 0.289285714285714*G0_0_1 - 0.168750000000000*G0_0_2 - 0.048214285714286*G0_1_0 - 0.048214285714286*G0_1_1 - 0.024107142857143*G0_1_2 - 0.168750000000000*G0_2_0 - 0.168750000000000*G0_2_1 - 0.048214285714286*G0_2_2;
    A[371] = 0.120535714285714*G0_0_2 + 0.096428571428571*G0_1_0 + 0.096428571428571*G0_1_1 - 0.024107142857143*G0_1_2 + 0.120535714285714*G0_2_0 + 0.120535714285714*G0_2_1 - 0.048214285714286*G0_2_2;
    A[372] = -0.144642857142857*G0_0_0 - 0.024107142857143*G0_0_1 - 0.144642857142857*G0_0_2 - 0.024107142857143*G0_1_0 - 0.024107142857143*G0_1_2 - 0.144642857142857*G0_2_0 - 0.024107142857143*G0_2_1 - 0.144642857142857*G0_2_2;
    A[373] = -0.024107142857143*G0_0_1 - 0.024107142857143*G0_1_0 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_1;
    A[374] = -0.048214285714286*G0_0_0 - 0.168750000000000*G0_0_1 - 0.168750000000000*G0_0_2 - 0.024107142857143*G0_1_0 - 0.048214285714286*G0_1_1 - 0.048214285714286*G0_1_2 - 0.168750000000000*G0_2_0 - 0.289285714285714*G0_2_1 - 0.289285714285714*G0_2_2;
    A[375] = -0.048214285714286*G0_0_0 + 0.120535714285714*G0_0_1 + 0.120535714285714*G0_0_2 - 0.024107142857143*G0_1_0 + 0.096428571428571*G0_1_1 + 0.096428571428571*G0_1_2 + 0.120535714285714*G0_2_0;
    A[376] = -0.289285714285714*G0_0_1 - 0.144642857142857*G0_0_2 - 0.289285714285714*G0_1_0 - 0.578571428571428*G0_1_1 - 0.289285714285714*G0_1_2 - 0.144642857142857*G0_2_0 - 0.289285714285714*G0_2_1;
    A[377] = 0.289285714285714*G0_0_1 + 0.144642857142857*G0_0_2 + 0.289285714285714*G0_1_0 + 0.144642857142857*G0_1_2 + 0.144642857142857*G0_2_0 + 0.144642857142857*G0_2_1 + 0.289285714285714*G0_2_2;
    A[378] = 0.578571428571428*G0_0_0 + 0.289285714285714*G0_0_1 + 0.289285714285714*G0_0_2 + 0.289285714285714*G0_1_0 + 0.578571428571429*G0_1_1 + 0.289285714285714*G0_1_2 + 0.289285714285714*G0_2_0 + 0.289285714285714*G0_2_1 + 0.578571428571428*G0_2_2;
    A[379] = 0.289285714285714*G0_0_0 + 0.144642857142857*G0_0_1 + 0.144642857142857*G0_0_2 + 0.144642857142857*G0_1_0 + 0.289285714285714*G0_1_2 + 0.144642857142857*G0_2_0 + 0.289285714285714*G0_2_1;
    A[380] = 0.048214285714286*G0_0_0 + 0.048214285714286*G0_0_1 + 0.048214285714286*G0_0_2 + 0.048214285714286*G0_1_0 + 0.048214285714286*G0_1_1 + 0.048214285714286*G0_1_2 + 0.032142857142857*G0_2_0 + 0.032142857142857*G0_2_1 + 0.032142857142857*G0_2_2;
    A[381] = 0.048214285714286*G0_0_0 + 0.016071428571429*G0_2_0;
    A[382] = 0.048214285714286*G0_1_1 + 0.016071428571428*G0_2_1;
    A[383] = -0.032142857142857*G0_2_2;
    A[384] = -0.144642857142857*G0_1_1 - 0.120535714285714*G0_1_2 - 0.120535714285715*G0_2_1 - 0.096428571428572*G0_2_2;
    A[385] = 0.024107142857143*G0_1_2 + 0.024107142857143*G0_2_1 + 0.048214285714286*G0_2_2;
    A[386] = -0.144642857142857*G0_0_0 - 0.120535714285714*G0_0_2 - 0.120535714285714*G0_2_0 - 0.096428571428571*G0_2_2;
    A[387] = 0.024107142857143*G0_0_2 + 0.024107142857143*G0_2_0 + 0.048214285714285*G0_2_2;
    A[388] = -0.289285714285714*G0_0_0 - 0.120535714285714*G0_0_1 - 0.120535714285714*G0_1_0 - 0.241071428571428*G0_2_0 - 0.096428571428571*G0_2_1;
    A[389] = -0.120535714285714*G0_0_1 - 0.120535714285714*G0_1_0 - 0.289285714285714*G0_1_1 - 0.096428571428572*G0_2_0 - 0.241071428571429*G0_2_1;
    A[390] = -0.144642857142857*G0_0_0 - 0.144642857142857*G0_0_1 - 0.024107142857143*G0_0_2 - 0.144642857142857*G0_1_0 - 0.144642857142857*G0_1_1 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_0 - 0.024107142857143*G0_2_1;
    A[391] = -0.024107142857143*G0_0_2 - 0.024107142857143*G0_1_2 - 0.024107142857143*G0_2_0 - 0.024107142857143*G0_2_1;
    A[392] = -0.289285714285714*G0_0_0 - 0.168750000000000*G0_0_1 - 0.289285714285714*G0_0_2 - 0.168750000000000*G0_1_0 - 0.048214285714286*G0_1_1 - 0.168750000000000*G0_1_2 - 0.048214285714286*G0_2_0 - 0.024107142857143*G0_2_1 - 0.048214285714286*G0_2_2;
    A[393] = 0.120535714285714*G0_0_1 + 0.120535714285714*G0_1_0 - 0.048214285714286*G0_1_1 + 0.120535714285714*G0_1_2 + 0.096428571428572*G0_2_0 - 0.024107142857143*G0_2_1 + 0.096428571428572*G0_2_2;
    A[394] = -0.048214285714286*G0_0_0 - 0.168750000000000*G0_0_1 - 0.168750000000000*G0_0_2 - 0.168750000000000*G0_1_0 - 0.289285714285714*G0_1_1 - 0.289285714285714*G0_1_2 - 0.024107142857143*G0_2_0 - 0.048214285714286*G0_2_1 - 0.048214285714286*G0_2_2;
    A[395] = -0.048214285714286*G0_0_0 + 0.120535714285714*G0_0_1 + 0.120535714285714*G0_0_2 + 0.120535714285714*G0_1_0 - 0.024107142857143*G0_2_0 + 0.096428571428571*G0_2_1 + 0.096428571428571*G0_2_2;
    A[396] = -0.144642857142857*G0_0_1 - 0.289285714285714*G0_0_2 - 0.144642857142857*G0_1_0 - 0.289285714285715*G0_1_2 - 0.289285714285715*G0_2_0 - 0.289285714285714*G0_2_1 - 0.578571428571429*G0_2_2;
    A[397] = 0.144642857142857*G0_0_1 + 0.289285714285714*G0_0_2 + 0.144642857142857*G0_1_0 + 0.289285714285714*G0_1_1 + 0.144642857142857*G0_1_2 + 0.289285714285715*G0_2_0 + 0.144642857142857*G0_2_1;
    A[398] = 0.289285714285714*G0_0_0 + 0.144642857142857*G0_0_1 + 0.144642857142857*G0_0_2 + 0.144642857142857*G0_1_0 + 0.289285714285714*G0_1_2 + 0.144642857142857*G0_2_0 + 0.289285714285714*G0_2_1;
    A[399] = 0.578571428571428*G0_0_0 + 0.289285714285714*G0_0_1 + 0.289285714285714*G0_0_2 + 0.289285714285714*G0_1_0 + 0.578571428571428*G0_1_1 + 0.289285714285715*G0_1_2 + 0.289285714285714*G0_2_0 + 0.289285714285715*G0_2_1 + 0.578571428571429*G0_2_2;
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class poisson3d_3_cell_integral_1_0: public ufc::cell_integral
{
public:

  /// Constructor
  poisson3d_3_cell_integral_1_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_3_cell_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      18
    // Number of operations (multiply-add pairs) for geometry tensor:    20
    // Number of operations (multiply-add pairs) for tensor contraction: 270
    // Total number of operations (multiply-add pairs):                  308
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_20 = J_01*J_12 - J_02*J_11;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    const double G0_3 = det*w[0][3]*(1.0);
    const double G0_4 = det*w[0][4]*(1.0);
    const double G0_5 = det*w[0][5]*(1.0);
    const double G0_6 = det*w[0][6]*(1.0);
    const double G0_7 = det*w[0][7]*(1.0);
    const double G0_8 = det*w[0][8]*(1.0);
    const double G0_9 = det*w[0][9]*(1.0);
    const double G0_10 = det*w[0][10]*(1.0);
    const double G0_11 = det*w[0][11]*(1.0);
    const double G0_12 = det*w[0][12]*(1.0);
    const double G0_13 = det*w[0][13]*(1.0);
    const double G0_14 = det*w[0][14]*(1.0);
    const double G0_15 = det*w[0][15]*(1.0);
    const double G0_16 = det*w[0][16]*(1.0);
    const double G0_17 = det*w[0][17]*(1.0);
    const double G0_18 = det*w[0][18]*(1.0);
    const double G0_19 = det*w[0][19]*(1.0);
    
    // Compute element tensor
    A[0] = 0.000595238095238*G0_0 + 0.000074404761905*G0_1 + 0.000074404761905*G0_2 + 0.000074404761905*G0_3 + 0.000111607142857*G0_4 + 0.000111607142857*G0_5 + 0.000111607142857*G0_6 + 0.000111607142857*G0_7 + 0.000111607142857*G0_8 + 0.000111607142857*G0_9 - 0.000446428571429*G0_10 + 0.000223214285714*G0_11 - 0.000446428571429*G0_12 + 0.000223214285714*G0_13 - 0.000446428571429*G0_14 + 0.000223214285714*G0_15 + 0.001339285714286*G0_16 + 0.000669642857143*G0_17 + 0.000669642857143*G0_18 + 0.000669642857143*G0_19;
    A[1] = 0.000074404761905*G0_0 + 0.000595238095238*G0_1 + 0.000074404761905*G0_2 + 0.000074404761905*G0_3 + 0.000111607142857*G0_4 + 0.000111607142857*G0_5 - 0.000446428571429*G0_6 + 0.000223214285714*G0_7 - 0.000446428571429*G0_8 + 0.000223214285714*G0_9 + 0.000111607142857*G0_10 + 0.000111607142857*G0_11 + 0.000111607142857*G0_12 + 0.000111607142857*G0_13 + 0.000223214285714*G0_14 - 0.000446428571429*G0_15 + 0.000669642857143*G0_16 + 0.001339285714286*G0_17 + 0.000669642857143*G0_18 + 0.000669642857143*G0_19;
    A[2] = 0.000074404761905*G0_0 + 0.000074404761905*G0_1 + 0.000595238095238*G0_2 + 0.000074404761905*G0_3 - 0.000446428571429*G0_4 + 0.000223214285714*G0_5 + 0.000111607142857*G0_6 + 0.000111607142857*G0_7 + 0.000223214285714*G0_8 - 0.000446428571429*G0_9 + 0.000111607142857*G0_10 + 0.000111607142857*G0_11 + 0.000223214285714*G0_12 - 0.000446428571429*G0_13 + 0.000111607142857*G0_14 + 0.000111607142857*G0_15 + 0.000669642857143*G0_16 + 0.000669642857143*G0_17 + 0.001339285714286*G0_18 + 0.000669642857143*G0_19;
    A[3] = 0.000074404761905*G0_0 + 0.000074404761905*G0_1 + 0.000074404761905*G0_2 + 0.000595238095238*G0_3 + 0.000223214285714*G0_4 - 0.000446428571429*G0_5 + 0.000223214285714*G0_6 - 0.000446428571429*G0_7 + 0.000111607142857*G0_8 + 0.000111607142857*G0_9 + 0.000223214285714*G0_10 - 0.000446428571429*G0_11 + 0.000111607142857*G0_12 + 0.000111607142857*G0_13 + 0.000111607142857*G0_14 + 0.000111607142857*G0_15 + 0.000669642857143*G0_16 + 0.000669642857143*G0_17 + 0.000669642857143*G0_18 + 0.001339285714286*G0_19;
    A[4] = 0.000111607142857*G0_0 + 0.000111607142857*G0_1 - 0.000446428571429*G0_2 + 0.000223214285714*G0_3 + 0.004017857142857*G0_4 - 0.002008928571429*G0_5 - 0.001004464285714*G0_7 - 0.001004464285714*G0_8 + 0.002008928571429*G0_9 - 0.001004464285714*G0_11 - 0.001004464285714*G0_12 + 0.002008928571429*G0_13 - 0.002008928571429*G0_18;
    A[5] = 0.000111607142857*G0_0 + 0.000111607142857*G0_1 + 0.000223214285714*G0_2 - 0.000446428571429*G0_3 - 0.002008928571429*G0_4 + 0.004017857142857*G0_5 - 0.001004464285714*G0_6 + 0.002008928571429*G0_7 - 0.001004464285714*G0_9 - 0.001004464285714*G0_10 + 0.002008928571429*G0_11 - 0.001004464285714*G0_13 - 0.002008928571429*G0_19;
    A[6] = 0.000111607142857*G0_0 - 0.000446428571429*G0_1 + 0.000111607142857*G0_2 + 0.000223214285714*G0_3 - 0.001004464285714*G0_5 + 0.004017857142857*G0_6 - 0.002008928571429*G0_7 + 0.002008928571429*G0_8 - 0.001004464285714*G0_9 - 0.001004464285714*G0_11 - 0.001004464285714*G0_14 + 0.002008928571429*G0_15 - 0.002008928571429*G0_17;
    A[7] = 0.000111607142857*G0_0 + 0.000223214285714*G0_1 + 0.000111607142857*G0_2 - 0.000446428571429*G0_3 - 0.001004464285714*G0_4 + 0.002008928571429*G0_5 - 0.002008928571429*G0_6 + 0.004017857142857*G0_7 - 0.001004464285714*G0_8 - 0.001004464285714*G0_10 + 0.002008928571429*G0_11 - 0.001004464285714*G0_15 - 0.002008928571429*G0_19;
    A[8] = 0.000111607142857*G0_0 - 0.000446428571429*G0_1 + 0.000223214285714*G0_2 + 0.000111607142857*G0_3 - 0.001004464285714*G0_4 + 0.002008928571429*G0_6 - 0.001004464285714*G0_7 + 0.004017857142857*G0_8 - 0.002008928571429*G0_9 - 0.001004464285714*G0_13 - 0.001004464285714*G0_14 + 0.002008928571429*G0_15 - 0.002008928571429*G0_17;
    A[9] = 0.000111607142857*G0_0 + 0.000223214285714*G0_1 - 0.000446428571429*G0_2 + 0.000111607142857*G0_3 + 0.002008928571429*G0_4 - 0.001004464285714*G0_5 - 0.001004464285714*G0_6 - 0.002008928571429*G0_8 + 0.004017857142857*G0_9 - 0.001004464285714*G0_12 + 0.002008928571429*G0_13 - 0.001004464285714*G0_15 - 0.002008928571429*G0_18;
    A[10] = -0.000446428571429*G0_0 + 0.000111607142857*G0_1 + 0.000111607142857*G0_2 + 0.000223214285714*G0_3 - 0.001004464285714*G0_5 - 0.001004464285714*G0_7 + 0.004017857142857*G0_10 - 0.002008928571429*G0_11 + 0.002008928571429*G0_12 - 0.001004464285714*G0_13 + 0.002008928571429*G0_14 - 0.001004464285714*G0_15 - 0.002008928571429*G0_16;
    A[11] = 0.000223214285714*G0_0 + 0.000111607142857*G0_1 + 0.000111607142857*G0_2 - 0.000446428571429*G0_3 - 0.001004464285714*G0_4 + 0.002008928571429*G0_5 - 0.001004464285714*G0_6 + 0.002008928571429*G0_7 - 0.002008928571429*G0_10 + 0.004017857142857*G0_11 - 0.001004464285714*G0_12 - 0.001004464285714*G0_14 - 0.002008928571429*G0_19;
    A[12] = -0.000446428571429*G0_0 + 0.000111607142857*G0_1 + 0.000223214285714*G0_2 + 0.000111607142857*G0_3 - 0.001004464285714*G0_4 - 0.001004464285714*G0_9 + 0.002008928571429*G0_10 - 0.001004464285714*G0_11 + 0.004017857142857*G0_12 - 0.002008928571429*G0_13 + 0.002008928571429*G0_14 - 0.001004464285714*G0_15 - 0.002008928571429*G0_16;
    A[13] = 0.000223214285714*G0_0 + 0.000111607142857*G0_1 - 0.000446428571429*G0_2 + 0.000111607142857*G0_3 + 0.002008928571429*G0_4 - 0.001004464285714*G0_5 - 0.001004464285714*G0_8 + 0.002008928571429*G0_9 - 0.001004464285714*G0_10 - 0.002008928571429*G0_12 + 0.004017857142857*G0_13 - 0.001004464285714*G0_14 - 0.002008928571429*G0_18;
    A[14] = -0.000446428571429*G0_0 + 0.000223214285714*G0_1 + 0.000111607142857*G0_2 + 0.000111607142857*G0_3 - 0.001004464285714*G0_6 - 0.001004464285714*G0_8 + 0.002008928571429*G0_10 - 0.001004464285714*G0_11 + 0.002008928571429*G0_12 - 0.001004464285714*G0_13 + 0.004017857142857*G0_14 - 0.002008928571429*G0_15 - 0.002008928571429*G0_16;
    A[15] = 0.000223214285714*G0_0 - 0.000446428571429*G0_1 + 0.000111607142857*G0_2 + 0.000111607142857*G0_3 + 0.002008928571429*G0_6 - 0.001004464285714*G0_7 + 0.002008928571429*G0_8 - 0.001004464285714*G0_9 - 0.001004464285714*G0_10 - 0.001004464285714*G0_12 - 0.002008928571429*G0_14 + 0.004017857142857*G0_15 - 0.002008928571429*G0_17;
    A[16] = 0.001339285714286*G0_0 + 0.000669642857143*G0_1 + 0.000669642857143*G0_2 + 0.000669642857143*G0_3 - 0.002008928571429*G0_10 - 0.002008928571429*G0_12 - 0.002008928571429*G0_14 + 0.016071428571429*G0_16 + 0.008035714285714*G0_17 + 0.008035714285714*G0_18 + 0.008035714285714*G0_19;
    A[17] = 0.000669642857143*G0_0 + 0.001339285714286*G0_1 + 0.000669642857143*G0_2 + 0.000669642857143*G0_3 - 0.002008928571429*G0_6 - 0.002008928571429*G0_8 - 0.002008928571429*G0_15 + 0.008035714285714*G0_16 + 0.016071428571429*G0_17 + 0.008035714285714*G0_18 + 0.008035714285714*G0_19;
    A[18] = 0.000669642857143*G0_0 + 0.000669642857143*G0_1 + 0.001339285714286*G0_2 + 0.000669642857143*G0_3 - 0.002008928571429*G0_4 - 0.002008928571429*G0_9 - 0.002008928571429*G0_13 + 0.008035714285714*G0_16 + 0.008035714285714*G0_17 + 0.016071428571429*G0_18 + 0.008035714285714*G0_19;
    A[19] = 0.000669642857143*G0_0 + 0.000669642857143*G0_1 + 0.000669642857143*G0_2 + 0.001339285714286*G0_3 - 0.002008928571429*G0_5 - 0.002008928571429*G0_7 - 0.002008928571429*G0_11 + 0.008035714285714*G0_16 + 0.008035714285714*G0_17 + 0.008035714285714*G0_18 + 0.016071428571429*G0_19;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class poisson3d_3_form_0: public ufc::form
{
public:

  /// Constructor
  poisson3d_3_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_3_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(IndexSum(Product(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 3), 0), MultiIndex((Index(0),), {Index(0): 3})), SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 3), 1), MultiIndex((Index(0),), {Index(0): 3}))), MultiIndex((Index(0),), {Index(0): 3})), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 1;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 0;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_3_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson3d_3_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_3_dof_map_0();
        break;
      }
    case 1:
      {
        return new poisson3d_3_dof_map_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_3_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class poisson3d_3_form_1: public ufc::form
{
public:

  /// Constructor
  poisson3d_3_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_3_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Argument(FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 3), 0), Coefficient(FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 3), 0)), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 1;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 1;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 0;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_3_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson3d_3_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_3_dof_map_0();
        break;
      }
    case 1:
      {
        return new poisson3d_3_dof_map_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson3d_3_cell_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>

namespace Poisson3D_3
{

class CoefficientSpace_f: public dolfin::FunctionSpace
{
public:

  CoefficientSpace_f(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_3_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_f(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_3_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_f(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_3_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace_f(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_3_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace_f()
  {
  }

};

class Form_0_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_3_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_3_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_3_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_3_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_0()
  {
  }

};

class Form_0_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_3_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_3_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_3_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_3_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_1()
  {
  }

};

class Form_0: public dolfin::Form
{
public:

  // Constructor
  Form_0(const dolfin::FunctionSpace& V0, const dolfin::FunctionSpace& V1):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_3_form_0());
  }

  // Constructor
  Form_0(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::FunctionSpace> V1):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_3_form_0());
  }

  // Destructor
  ~Form_0()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {

    dolfin::error("No coefficients.");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {

    dolfin::error("No coefficients.");
    return "unnamed";
  }

  // Typedefs
  typedef Form_0_FunctionSpace_0 TestSpace;
  typedef Form_0_FunctionSpace_1 TrialSpace;

  // Coefficients
};

class Form_1_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_1_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_3_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_3_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_3_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson3d_3_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new poisson3d_3_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_1_FunctionSpace_0()
  {
  }

};

typedef CoefficientSpace_f Form_1_FunctionSpace_1;

class Form_1: public dolfin::Form
{
public:

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_3_form_1());
  }

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_3_form_1());
  }

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0, boost::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = *f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_3_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_3_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    this->f = f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_3_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    this->f = *f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson3d_3_form_1());
  }

  // Destructor
  ~Form_1()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;

    dolfin::error("Invalid coefficient.");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    }

    dolfin::error("Invalid coefficient.");
    return "unnamed";
  }

  // Typedefs
  typedef Form_1_FunctionSpace_0 TestSpace;
  typedef Form_1_FunctionSpace_1 CoefficientSpace_f;

  // Coefficients
  dolfin::CoefficientAssigner f;
};

// Class typedefs
typedef Form_0 BilinearForm;
typedef Form_1 LinearForm;
typedef Form_0::TestSpace FunctionSpace;

}

#endif
