// This code conforms with the UFC specification version 1.4
// and was automatically generated by FFC version 0.9.2.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   epsilon:                        1e-14
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   optimize:                       False
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __BIHARMONIC_H
#define __BIHARMONIC_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class biharmonic_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  biharmonic_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Discontinuous Lagrange', Cell('triangle', 1, Space(2)), 0)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 1;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Compute constants
    
    // Get coordinates and map to the reference (FIAT) element
    
    // Reset values.
    *values = 0.000000000000000;
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[1] = {0.000000000000000};
    
    // Declare helper variables.
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    
    // Table(s) of coefficients.
    static const double coefficients0[1][1] = \
    {{1.000000000000000}};
    
    // Compute value(s).
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[dof][r]*basisvalues[r];
    }// end loop over 'r'
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Element is constant, calling evaluate_basis.
    evaluate_basis(0, values, coordinates, c);
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    
    // Get coordinates and map to the reference (FIAT) element
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[1] = {0.000000000000000};
    
    // Declare helper variables.
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    
    // Table(s) of coefficients.
    static const double coefficients0[1][1] = \
    {{1.000000000000000}};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[1][1] = \
    {{0.000000000000000}};
    
    static const double dmats1[1][1] = \
    {{0.000000000000000}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      derivatives[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[1][1] = \
    {{1.000000000000000}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[1][1] = \
    {{1.000000000000000}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 1; t++)
      {
        for (unsigned int u = 0; u < 1; u++)
        {
          dmats[t][u] = 0.000000000000000;
          if (t == u)
          {
          dmats[t][u] = 1.000000000000000;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.000000000000000;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 1; s++)
      {
        for (unsigned int t = 0; t < 1; t++)
        {
          derivatives[r] += coefficients0[dof][s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] combinations[r];
    }// end loop over 'r'
    delete [] combinations;
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Element is constant, calling evaluate_basis_derivatives.
    evaluate_basis_derivatives(0, n, values, coordinates, c);
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.000000000000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a finite element.

class biharmonic_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  biharmonic_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 6;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.000000000000000;
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[6] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    unsigned int tt = 0;
    double tmp5 = 0.000000000000000;
    double tmp6 = 0.000000000000000;
    double tmp7 = 0.000000000000000;
    double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
    double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
    double tmp2 = tmp1*tmp1;
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 1; r < 2; r++)
    {
      rr = (r + 1)*((r + 1) + 1)/2;
      ss = r*(r + 1)/2;
      tt = (r - 1)*((r - 1) + 1)/2;
      tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
      basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 2; r++)
    {
      rr = (r + 1)*(r + 1 + 1)/2 + 1;
      ss = r*(r + 1)/2;
      basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 1; r++)
    {
      for (unsigned int s = 1; s < 2 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
        ss = (r + s)*(r + s + 1)/2 + s;
        tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
        tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 3; r++)
    {
      for (unsigned int s = 0; s < 3 - r; s++)
      {
        rr = (r + s)*(r + s + 1)/2 + s;
        basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[6][6] = \
    {{0.000000000000000, -0.173205080756888, -0.100000000000000, 0.121716123890037, 0.094280904158206, 0.054433105395182},
    {0.000000000000000, 0.173205080756888, -0.100000000000000, 0.121716123890037, -0.094280904158206, 0.054433105395182},
    {0.000000000000000, 0.000000000000000, 0.200000000000000, 0.000000000000000, 0.000000000000000, 0.163299316185545},
    {0.471404520791032, 0.230940107675850, 0.133333333333333, 0.000000000000000, 0.188561808316413, -0.163299316185545},
    {0.471404520791032, -0.230940107675850, 0.133333333333333, 0.000000000000000, -0.188561808316413, -0.163299316185545},
    {0.471404520791032, 0.000000000000000, -0.266666666666667, -0.243432247780074, 0.000000000000000, 0.054433105395182}};
    
    // Compute value(s).
    for (unsigned int r = 0; r < 6; r++)
    {
      *values += coefficients0[dof][r]*basisvalues[r];
    }// end loop over 'r'
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.000000000000000;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[6] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    unsigned int tt = 0;
    double tmp5 = 0.000000000000000;
    double tmp6 = 0.000000000000000;
    double tmp7 = 0.000000000000000;
    double tmp0 = (1.000000000000000 + Y + 2.000000000000000*X)/2.000000000000000;
    double tmp1 = (1.000000000000000 - Y)/2.000000000000000;
    double tmp2 = tmp1*tmp1;
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 1; r < 2; r++)
    {
      rr = (r + 1)*((r + 1) + 1)/2;
      ss = r*(r + 1)/2;
      tt = (r - 1)*((r - 1) + 1)/2;
      tmp5 = (1.000000000000000 + 2.000000000000000*r)/(1.000000000000000 + r);
      basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.000000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 2; r++)
    {
      rr = (r + 1)*(r + 1 + 1)/2 + 1;
      ss = r*(r + 1)/2;
      basisvalues[rr] = basisvalues[ss]*(0.500000000000000 + r + Y*(1.500000000000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 1; r++)
    {
      for (unsigned int s = 1; s < 2 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
        ss = (r + s)*(r + s + 1)/2 + s;
        tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
        tmp5 = (2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp6 = (1.000000000000000 + 4.000000000000000*r*r + 4.000000000000000*r)*(2.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)/(2.000000000000000*(1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        tmp7 = (1.000000000000000 + s + 2.000000000000000*r)*(3.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*s/((1.000000000000000 + 2.000000000000000*r + 2.000000000000000*s)*(1.000000000000000 + s)*(2.000000000000000 + s + 2.000000000000000*r));
        basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 3; r++)
    {
      for (unsigned int s = 0; s < 3 - r; s++)
      {
        rr = (r + s)*(r + s + 1)/2 + s;
        basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[6][6] = \
    {{0.000000000000000, -0.173205080756888, -0.100000000000000, 0.121716123890037, 0.094280904158206, 0.054433105395182},
    {0.000000000000000, 0.173205080756888, -0.100000000000000, 0.121716123890037, -0.094280904158206, 0.054433105395182},
    {0.000000000000000, 0.000000000000000, 0.200000000000000, 0.000000000000000, 0.000000000000000, 0.163299316185545},
    {0.471404520791032, 0.230940107675850, 0.133333333333333, 0.000000000000000, 0.188561808316413, -0.163299316185545},
    {0.471404520791032, -0.230940107675850, 0.133333333333333, 0.000000000000000, -0.188561808316413, -0.163299316185545},
    {0.471404520791032, 0.000000000000000, -0.266666666666667, -0.243432247780074, 0.000000000000000, 0.054433105395182}};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[6][6] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {4.898979485566355, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 9.486832980505138, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {3.999999999999999, 0.000000000000000, 7.071067811865476, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
    
    static const double dmats1[6][6] = \
    {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.449489742783177, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {4.242640687119285, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {2.581988897471611, 4.743416490252570, -0.912870929175278, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {1.999999999999999, 6.123724356957944, 3.535533905932737, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {-2.309401076758502, 0.000000000000000, 8.164965809277259, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      derivatives[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[6][6] = \
    {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[6][6] = \
    {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
    {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 6; t++)
      {
        for (unsigned int u = 0; u < 6; u++)
        {
          dmats[t][u] = 0.000000000000000;
          if (t == u)
          {
          dmats[t][u] = 1.000000000000000;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.000000000000000;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            for (unsigned int tu = 0; tu < 6; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            for (unsigned int tu = 0; tu < 6; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 6; s++)
      {
        for (unsigned int t = 0; t < 6; t++)
        {
          derivatives[r] += coefficients0[dof][s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] combinations[r];
    }// end loop over 'r'
    delete [] combinations;
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.500000000000000*x[1][0] + 0.500000000000000*x[2][0];
      y[1] = 0.500000000000000*x[1][1] + 0.500000000000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[2][0];
      y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[1][0];
      y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.000000000000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.500000000000000*x[1][0] + 0.500000000000000*x[2][0];
    y[1] = 0.500000000000000*x[1][1] + 0.500000000000000*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[2][0];
    y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[1][0];
    y[1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[1][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class biharmonic_dof_map_0: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  biharmonic_dof_map_0() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~biharmonic_dof_map_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Discontinuous Lagrange', Cell('triangle', 1, Space(2)), 0)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[2];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 1;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 1;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 0;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[2][0];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[0][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 0;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class biharmonic_dof_map_1: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  biharmonic_dof_map_1() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~biharmonic_dof_map_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + m.num_entities[1];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 6;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 6;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + c.entity_indices[1][0];
    dofs[4] = offset + c.entity_indices[1][1];
    dofs[5] = offset + c.entity_indices[1][2];
    offset += m.num_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 4;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 5;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 5;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.500000000000000*x[1][0] + 0.500000000000000*x[2][0];
    coordinates[3][1] = 0.500000000000000*x[1][1] + 0.500000000000000*x[2][1];
    coordinates[4][0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[2][0];
    coordinates[4][1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[2][1];
    coordinates[5][0] = 0.500000000000000*x[0][0] + 0.500000000000000*x[1][0];
    coordinates[5][1] = 0.500000000000000*x[0][1] + 0.500000000000000*x[1][1];
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 0;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class biharmonic_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  biharmonic_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Array of quadrature weights.
    static const double W1 = 0.500000000000000;
    // Quadrature points on the UFC reference element: (0.333333333333333, 0.333333333333333)
    
    // Value of basis functions at quadrature points.
    static const double FE0_D02[1][6] = \
    {{4.000000000000000, 0.000000000000000, 4.000000000000000, 0.000000000000000, -8.000000000000002, 0.000000000000000}};
    
    static const double FE0_D11[1][6] = \
    {{4.000000000000001, 0.000000000000000, 0.000000000000000, 4.000000000000000, -4.000000000000001, -4.000000000000001}};
    
    static const double FE0_D20[1][6] = \
    {{4.000000000000001, 4.000000000000001, 0.000000000000000, 0.000000000000000, 0.000000000000000, -8.000000000000002}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 36; r++)
    {
      A[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('simplify expressions', False), ('ignore zero tables', False), ('non zero columns', False), ('remove zero terms', False), ('ignore ones', False)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 1800
    // Only 1 integration point, omitting IP loop.
    
    // Number of operations for primary indices: 1800
    for (unsigned int j = 0; j < 6; j++)
    {
      for (unsigned int k = 0; k < 6; k++)
      {
        // Number of operations to compute entry: 50
        A[j*6 + k] += (((K_01*K_01*FE0_D20[0][j] + K_01*K_11*FE0_D11[0][j] + K_11*K_01*FE0_D11[0][j] + K_11*K_11*FE0_D02[0][j]) + (K_00*K_00*FE0_D20[0][j] + K_00*K_10*FE0_D11[0][j] + K_10*K_00*FE0_D11[0][j] + K_10*K_10*FE0_D02[0][j])))*(((K_00*K_00*FE0_D20[0][k] + K_00*K_10*FE0_D11[0][k] + K_10*K_00*FE0_D11[0][k] + K_10*K_10*FE0_D02[0][k]) + (K_01*K_01*FE0_D20[0][k] + K_01*K_11*FE0_D11[0][k] + K_11*K_01*FE0_D11[0][k] + K_11*K_11*FE0_D02[0][k])))*W1*det;
      }// end loop over 'k'
    }// end loop over 'j'
  }

};

/// This class defines the interface for the tabulation of the
/// interior facet tensor corresponding to the local contribution to
/// a form from the integral over an interior facet.

class biharmonic_interior_facet_integral_0_0: public ufc::interior_facet_integral
{
public:

  /// Constructor
  biharmonic_interior_facet_integral_0_0() : ufc::interior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_interior_facet_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local interior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c0,
                               const ufc::cell& c1,
                               unsigned int facet0,
                               unsigned int facet1) const
  {
    // Extract vertex coordinates
    const double * const * x0 = c0.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J0_00 = x0[1][0] - x0[0][0];
    const double J0_01 = x0[2][0] - x0[0][0];
    const double J0_10 = x0[1][1] - x0[0][1];
    const double J0_11 = x0[2][1] - x0[0][1];
    
    // Compute determinant of Jacobian
    double detJ0 = J0_00*J0_11 - J0_01*J0_10;
    
    // Compute inverse of Jacobian
    const double K0_00 =  J0_11 / detJ0;
    const double K0_01 = -J0_01 / detJ0;
    const double K0_10 = -J0_10 / detJ0;
    const double K0_11 =  J0_00 / detJ0;
    
    // Extract vertex coordinates
    const double * const * x1 = c1.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J1_00 = x1[1][0] - x1[0][0];
    const double J1_01 = x1[2][0] - x1[0][0];
    const double J1_10 = x1[1][1] - x1[0][1];
    const double J1_11 = x1[2][1] - x1[0][1];
    
    // Compute determinant of Jacobian
    double detJ1 = J1_00*J1_11 - J1_01*J1_10;
    
    // Compute inverse of Jacobian
    const double K1_00 =  J1_11 / detJ1;
    const double K1_01 = -J1_01 / detJ1;
    const double K1_10 = -J1_10 / detJ1;
    const double K1_11 =  J1_00 / detJ1;
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet0][0];
    const unsigned int v1 = edge_vertices[facet0][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = x0[v1][0] - x0[v0][0];
    const double dx1 = x0[v1][1] - x0[v0][1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    const bool direction = dx1*(x0[facet0][0] - x0[v0][0]) - dx0*(x0[facet0][1] - x0[v0][1]) < 0;// Compute facet normals from the facet scale factor constants
    const double n00 = direction ? dx1 / det : -dx1 / det;
    const double n01 = direction ? -dx0 / det : dx0 / det;// Compute facet normals from the facet scale factor constants
    const double n10 = !direction ? dx1 / det : -dx1 / det;
    const double n11 = !direction ? -dx0 / det : dx0 / det;
    
    // Array of quadrature weights.
    static const double W2[2] = {0.500000000000000, 0.500000000000000};
    // Quadrature points on the UFC reference element: (0.211324865405187), (0.788675134594813)
    
    // Value of basis functions at quadrature points.
    static const double FE0_f0_D01[2][6] = \
    {{1.000000000000001, 0.000000000000000, -0.154700538379251, 3.154700538379251, -0.845299461620749, -3.154700538379251},
    {1.000000000000000, 0.000000000000000, 2.154700538379251, 0.845299461620747, -3.154700538379251, -0.845299461620748}};
    
    static const double FE0_f0_D02[2][6] = \
    {{4.000000000000002, 0.000000000000000, 4.000000000000000, 0.000000000000000, -8.000000000000004, 0.000000000000000},
    {3.999999999999999, 0.000000000000000, 3.999999999999999, 0.000000000000000, -7.999999999999996, 0.000000000000000}};
    
    static const double FE0_f0_D10[2][6] = \
    {{1.000000000000000, 2.154700538379251, 0.000000000000000, 0.845299461620748, -0.845299461620749, -3.154700538379252},
    {1.000000000000000, -0.154700538379252, 0.000000000000000, 3.154700538379250, -3.154700538379251, -0.845299461620748}};
    
    static const double FE0_f0_D11[2][6] = \
    {{4.000000000000002, 0.000000000000000, 0.000000000000000, 4.000000000000000, -4.000000000000001, -4.000000000000003},
    {4.000000000000001, 0.000000000000000, 0.000000000000000, 3.999999999999993, -3.999999999999995, -3.999999999999997}};
    
    static const double FE0_f0_D20[2][6] = \
    {{4.000000000000002, 4.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000, -8.000000000000002},
    {4.000000000000000, 3.999999999999998, 0.000000000000000, 0.000000000000000, 0.000000000000000, -7.999999999999998}};
    
    static const double FE0_f1_D01[2][6] = \
    {{-2.154700538379251, 0.000000000000000, -0.154700538379251, 0.000000000000000, 2.309401076758502, 0.000000000000000},
    {0.154700538379251, 0.000000000000000, 2.154700538379251, 0.000000000000000, -2.309401076758502, 0.000000000000000}};
    
    static const double FE0_f1_D10[2][6] = \
    {{-2.154700538379251, -1.000000000000000, 0.000000000000000, 0.845299461620748, -0.845299461620749, 3.154700538379251},
    {0.154700538379251, -1.000000000000000, 0.000000000000000, 3.154700538379250, -3.154700538379251, 0.845299461620749}};
    
    static const double FE0_f2_D01[2][6] = \
    {{-2.154700538379251, 0.000000000000000, -1.000000000000000, 0.845299461620748, 3.154700538379251, -0.845299461620748},
    {0.154700538379252, 0.000000000000000, -1.000000000000000, 3.154700538379250, 0.845299461620750, -3.154700538379251}};
    
    static const double FE0_f2_D10[2][6] = \
    {{-2.154700538379251, -0.154700538379252, 0.000000000000000, 0.000000000000000, 0.000000000000000, 2.309401076758503},
    {0.154700538379251, 2.154700538379251, 0.000000000000000, 0.000000000000000, 0.000000000000000, -2.309401076758502}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 144; r++)
    {
      A[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('simplify expressions', False), ('ignore zero tables', False), ('non zero columns', False), ('remove zero terms', False), ('ignore ones', False)
    switch (facet0)
    {
    case 0:
      {
        switch (facet1)
      {
      case 0:
        {
          // Total number of operations to compute element tensor (from this point): 27648
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 27648
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations for primary indices: 13824
          for (unsigned int j = 0; j < 6; j++)
          {
            for (unsigned int k = 0; k < 6; k++)
            {
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + k] += (((((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f0_D10[ip][j] + K1_10*FE0_f0_D01[ip][j]))*n10 + ((K1_01*FE0_f0_D10[ip][j] + K1_11*FE0_f0_D01[ip][j]))*n11)))*(-1.000000000000000) + (((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f0_D10[ip][k] + K0_11*FE0_f0_D01[ip][k]))*n01 + ((K0_00*FE0_f0_D10[ip][k] + K0_10*FE0_f0_D01[ip][k]))*n00)))*(-1.000000000000000)) + (((((K1_00*FE0_f0_D10[ip][j] + K1_10*FE0_f0_D01[ip][j]))*n10 + ((K1_01*FE0_f0_D10[ip][j] + K1_11*FE0_f0_D01[ip][j]))*n11))*((((K0_01*FE0_f0_D10[ip][k] + K0_11*FE0_f0_D01[ip][k]))*n01 + ((K0_00*FE0_f0_D10[ip][k] + K0_10*FE0_f0_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + (k + 6)] += (((((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f0_D10[ip][j] + K1_10*FE0_f0_D01[ip][j]))*n10 + ((K1_01*FE0_f0_D10[ip][j] + K1_11*FE0_f0_D01[ip][j]))*n11)))*(-1.000000000000000) + (((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_00*FE0_f0_D10[ip][k] + K1_10*FE0_f0_D01[ip][k]))*n10 + ((K1_01*FE0_f0_D10[ip][k] + K1_11*FE0_f0_D01[ip][k]))*n11)))*(-1.000000000000000)) + (((((K1_00*FE0_f0_D10[ip][j] + K1_10*FE0_f0_D01[ip][j]))*n10 + ((K1_01*FE0_f0_D10[ip][j] + K1_11*FE0_f0_D01[ip][j]))*n11))*((((K1_00*FE0_f0_D10[ip][k] + K1_10*FE0_f0_D01[ip][k]))*n10 + ((K1_01*FE0_f0_D10[ip][k] + K1_11*FE0_f0_D01[ip][k]))*n11)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + (k + 6)] += (((((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_01*FE0_f0_D10[ip][j] + K0_11*FE0_f0_D01[ip][j]))*n01 + ((K0_00*FE0_f0_D10[ip][j] + K0_10*FE0_f0_D01[ip][j]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_00*FE0_f0_D10[ip][k] + K1_10*FE0_f0_D01[ip][k]))*n10 + ((K1_01*FE0_f0_D10[ip][k] + K1_11*FE0_f0_D01[ip][k]))*n11)))*(-1.000000000000000)) + (((((K0_01*FE0_f0_D10[ip][j] + K0_11*FE0_f0_D01[ip][j]))*n01 + ((K0_00*FE0_f0_D10[ip][j] + K0_10*FE0_f0_D01[ip][j]))*n00))*((((K1_00*FE0_f0_D10[ip][k] + K1_10*FE0_f0_D01[ip][k]))*n10 + ((K1_01*FE0_f0_D10[ip][k] + K1_11*FE0_f0_D01[ip][k]))*n11)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + k] += (((((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_01*FE0_f0_D10[ip][j] + K0_11*FE0_f0_D01[ip][j]))*n01 + ((K0_00*FE0_f0_D10[ip][j] + K0_10*FE0_f0_D01[ip][j]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f0_D10[ip][k] + K0_11*FE0_f0_D01[ip][k]))*n01 + ((K0_00*FE0_f0_D10[ip][k] + K0_10*FE0_f0_D01[ip][k]))*n00)))*(-1.000000000000000)) + (((((K0_01*FE0_f0_D10[ip][j] + K0_11*FE0_f0_D01[ip][j]))*n01 + ((K0_00*FE0_f0_D10[ip][j] + K0_10*FE0_f0_D01[ip][j]))*n00))*((((K0_01*FE0_f0_D10[ip][k] + K0_11*FE0_f0_D01[ip][k]))*n01 + ((K0_00*FE0_f0_D10[ip][k] + K0_10*FE0_f0_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 1:
        {
          // Total number of operations to compute element tensor (from this point): 27648
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 27648
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations for primary indices: 13824
          for (unsigned int j = 0; j < 6; j++)
          {
            for (unsigned int k = 0; k < 6; k++)
            {
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + k] += (((((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f0_D10[ip][k] + K0_11*FE0_f0_D01[ip][k]))*n01 + ((K0_00*FE0_f0_D10[ip][k] + K0_10*FE0_f0_D01[ip][k]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f1_D10[ip][j] + K1_10*FE0_f1_D01[ip][j]))*n10 + ((K1_01*FE0_f1_D10[ip][j] + K1_11*FE0_f1_D01[ip][j]))*n11)))*(-1.000000000000000)) + (((((K1_00*FE0_f1_D10[ip][j] + K1_10*FE0_f1_D01[ip][j]))*n10 + ((K1_01*FE0_f1_D10[ip][j] + K1_11*FE0_f1_D01[ip][j]))*n11))*((((K0_01*FE0_f0_D10[ip][k] + K0_11*FE0_f0_D01[ip][k]))*n01 + ((K0_00*FE0_f0_D10[ip][k] + K0_10*FE0_f0_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + (k + 6)] += (((((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_01*FE0_f1_D10[ip][k] + K1_11*FE0_f1_D01[ip][k]))*n11 + ((K1_00*FE0_f1_D10[ip][k] + K1_10*FE0_f1_D01[ip][k]))*n10)))*(-1.000000000000000) + (((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f1_D10[ip][j] + K1_10*FE0_f1_D01[ip][j]))*n10 + ((K1_01*FE0_f1_D10[ip][j] + K1_11*FE0_f1_D01[ip][j]))*n11)))*(-1.000000000000000)) + (((((K1_00*FE0_f1_D10[ip][j] + K1_10*FE0_f1_D01[ip][j]))*n10 + ((K1_01*FE0_f1_D10[ip][j] + K1_11*FE0_f1_D01[ip][j]))*n11))*((((K1_01*FE0_f1_D10[ip][k] + K1_11*FE0_f1_D01[ip][k]))*n11 + ((K1_00*FE0_f1_D10[ip][k] + K1_10*FE0_f1_D01[ip][k]))*n10)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + (k + 6)] += (((((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_01*FE0_f0_D10[ip][j] + K0_11*FE0_f0_D01[ip][j]))*n01 + ((K0_00*FE0_f0_D10[ip][j] + K0_10*FE0_f0_D01[ip][j]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_01*FE0_f1_D10[ip][k] + K1_11*FE0_f1_D01[ip][k]))*n11 + ((K1_00*FE0_f1_D10[ip][k] + K1_10*FE0_f1_D01[ip][k]))*n10)))*(-1.000000000000000)) + (((((K0_01*FE0_f0_D10[ip][j] + K0_11*FE0_f0_D01[ip][j]))*n01 + ((K0_00*FE0_f0_D10[ip][j] + K0_10*FE0_f0_D01[ip][j]))*n00))*((((K1_01*FE0_f1_D10[ip][k] + K1_11*FE0_f1_D01[ip][k]))*n11 + ((K1_00*FE0_f1_D10[ip][k] + K1_10*FE0_f1_D01[ip][k]))*n10)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + k] += (((((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_01*FE0_f0_D10[ip][j] + K0_11*FE0_f0_D01[ip][j]))*n01 + ((K0_00*FE0_f0_D10[ip][j] + K0_10*FE0_f0_D01[ip][j]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f0_D10[ip][k] + K0_11*FE0_f0_D01[ip][k]))*n01 + ((K0_00*FE0_f0_D10[ip][k] + K0_10*FE0_f0_D01[ip][k]))*n00)))*(-1.000000000000000)) + (((((K0_01*FE0_f0_D10[ip][j] + K0_11*FE0_f0_D01[ip][j]))*n01 + ((K0_00*FE0_f0_D10[ip][j] + K0_10*FE0_f0_D01[ip][j]))*n00))*((((K0_01*FE0_f0_D10[ip][k] + K0_11*FE0_f0_D01[ip][k]))*n01 + ((K0_00*FE0_f0_D10[ip][k] + K0_10*FE0_f0_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 2:
        {
          // Total number of operations to compute element tensor (from this point): 27648
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 27648
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations for primary indices: 13824
          for (unsigned int j = 0; j < 6; j++)
          {
            for (unsigned int k = 0; k < 6; k++)
            {
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + k] += (((((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f0_D10[ip][k] + K0_11*FE0_f0_D01[ip][k]))*n01 + ((K0_00*FE0_f0_D10[ip][k] + K0_10*FE0_f0_D01[ip][k]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f2_D10[ip][j] + K1_10*FE0_f2_D01[ip][j]))*n10 + ((K1_01*FE0_f2_D10[ip][j] + K1_11*FE0_f2_D01[ip][j]))*n11)))*(-1.000000000000000)) + (((((K1_00*FE0_f2_D10[ip][j] + K1_10*FE0_f2_D01[ip][j]))*n10 + ((K1_01*FE0_f2_D10[ip][j] + K1_11*FE0_f2_D01[ip][j]))*n11))*((((K0_01*FE0_f0_D10[ip][k] + K0_11*FE0_f0_D01[ip][k]))*n01 + ((K0_00*FE0_f0_D10[ip][k] + K0_10*FE0_f0_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + (k + 6)] += (((((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_01*FE0_f2_D10[ip][k] + K1_11*FE0_f2_D01[ip][k]))*n11 + ((K1_00*FE0_f2_D10[ip][k] + K1_10*FE0_f2_D01[ip][k]))*n10)))*(-1.000000000000000) + (((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f2_D10[ip][j] + K1_10*FE0_f2_D01[ip][j]))*n10 + ((K1_01*FE0_f2_D10[ip][j] + K1_11*FE0_f2_D01[ip][j]))*n11)))*(-1.000000000000000)) + (((((K1_00*FE0_f2_D10[ip][j] + K1_10*FE0_f2_D01[ip][j]))*n10 + ((K1_01*FE0_f2_D10[ip][j] + K1_11*FE0_f2_D01[ip][j]))*n11))*((((K1_01*FE0_f2_D10[ip][k] + K1_11*FE0_f2_D01[ip][k]))*n11 + ((K1_00*FE0_f2_D10[ip][k] + K1_10*FE0_f2_D01[ip][k]))*n10)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + (k + 6)] += (((((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_01*FE0_f0_D10[ip][j] + K0_11*FE0_f0_D01[ip][j]))*n01 + ((K0_00*FE0_f0_D10[ip][j] + K0_10*FE0_f0_D01[ip][j]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_01*FE0_f2_D10[ip][k] + K1_11*FE0_f2_D01[ip][k]))*n11 + ((K1_00*FE0_f2_D10[ip][k] + K1_10*FE0_f2_D01[ip][k]))*n10)))*(-1.000000000000000)) + (((((K0_01*FE0_f0_D10[ip][j] + K0_11*FE0_f0_D01[ip][j]))*n01 + ((K0_00*FE0_f0_D10[ip][j] + K0_10*FE0_f0_D01[ip][j]))*n00))*((((K1_01*FE0_f2_D10[ip][k] + K1_11*FE0_f2_D01[ip][k]))*n11 + ((K1_00*FE0_f2_D10[ip][k] + K1_10*FE0_f2_D01[ip][k]))*n10)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + k] += (((((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_01*FE0_f0_D10[ip][j] + K0_11*FE0_f0_D01[ip][j]))*n01 + ((K0_00*FE0_f0_D10[ip][j] + K0_10*FE0_f0_D01[ip][j]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f0_D10[ip][k] + K0_11*FE0_f0_D01[ip][k]))*n01 + ((K0_00*FE0_f0_D10[ip][k] + K0_10*FE0_f0_D01[ip][k]))*n00)))*(-1.000000000000000)) + (((((K0_01*FE0_f0_D10[ip][j] + K0_11*FE0_f0_D01[ip][j]))*n01 + ((K0_00*FE0_f0_D10[ip][j] + K0_10*FE0_f0_D01[ip][j]))*n00))*((((K0_01*FE0_f0_D10[ip][k] + K0_11*FE0_f0_D01[ip][k]))*n01 + ((K0_00*FE0_f0_D10[ip][k] + K0_10*FE0_f0_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        switch (facet1)
      {
      case 0:
        {
          // Total number of operations to compute element tensor (from this point): 27648
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 27648
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations for primary indices: 13824
          for (unsigned int j = 0; j < 6; j++)
          {
            for (unsigned int k = 0; k < 6; k++)
            {
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + k] += (((((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f1_D10[ip][k] + K0_11*FE0_f1_D01[ip][k]))*n01 + ((K0_00*FE0_f1_D10[ip][k] + K0_10*FE0_f1_D01[ip][k]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f0_D10[ip][j] + K1_10*FE0_f0_D01[ip][j]))*n10 + ((K1_01*FE0_f0_D10[ip][j] + K1_11*FE0_f0_D01[ip][j]))*n11)))*(-1.000000000000000)) + (((((K1_00*FE0_f0_D10[ip][j] + K1_10*FE0_f0_D01[ip][j]))*n10 + ((K1_01*FE0_f0_D10[ip][j] + K1_11*FE0_f0_D01[ip][j]))*n11))*((((K0_01*FE0_f1_D10[ip][k] + K0_11*FE0_f1_D01[ip][k]))*n01 + ((K0_00*FE0_f1_D10[ip][k] + K0_10*FE0_f1_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + (k + 6)] += (((((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f0_D10[ip][j] + K1_10*FE0_f0_D01[ip][j]))*n10 + ((K1_01*FE0_f0_D10[ip][j] + K1_11*FE0_f0_D01[ip][j]))*n11)))*(-1.000000000000000) + (((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_00*FE0_f0_D10[ip][k] + K1_10*FE0_f0_D01[ip][k]))*n10 + ((K1_01*FE0_f0_D10[ip][k] + K1_11*FE0_f0_D01[ip][k]))*n11)))*(-1.000000000000000)) + (((((K1_00*FE0_f0_D10[ip][j] + K1_10*FE0_f0_D01[ip][j]))*n10 + ((K1_01*FE0_f0_D10[ip][j] + K1_11*FE0_f0_D01[ip][j]))*n11))*((((K1_00*FE0_f0_D10[ip][k] + K1_10*FE0_f0_D01[ip][k]))*n10 + ((K1_01*FE0_f0_D10[ip][k] + K1_11*FE0_f0_D01[ip][k]))*n11)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + (k + 6)] += (((((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_00*FE0_f0_D10[ip][k] + K1_10*FE0_f0_D01[ip][k]))*n10 + ((K1_01*FE0_f0_D10[ip][k] + K1_11*FE0_f0_D01[ip][k]))*n11)))*(-1.000000000000000) + (((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_00*FE0_f1_D10[ip][j] + K0_10*FE0_f1_D01[ip][j]))*n00 + ((K0_01*FE0_f1_D10[ip][j] + K0_11*FE0_f1_D01[ip][j]))*n01)))*(-1.000000000000000)) + (((((K0_00*FE0_f1_D10[ip][j] + K0_10*FE0_f1_D01[ip][j]))*n00 + ((K0_01*FE0_f1_D10[ip][j] + K0_11*FE0_f1_D01[ip][j]))*n01))*((((K1_00*FE0_f0_D10[ip][k] + K1_10*FE0_f0_D01[ip][k]))*n10 + ((K1_01*FE0_f0_D10[ip][k] + K1_11*FE0_f0_D01[ip][k]))*n11)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + k] += (((((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f1_D10[ip][k] + K0_11*FE0_f1_D01[ip][k]))*n01 + ((K0_00*FE0_f1_D10[ip][k] + K0_10*FE0_f1_D01[ip][k]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_00*FE0_f1_D10[ip][j] + K0_10*FE0_f1_D01[ip][j]))*n00 + ((K0_01*FE0_f1_D10[ip][j] + K0_11*FE0_f1_D01[ip][j]))*n01)))*(-1.000000000000000)) + (((((K0_00*FE0_f1_D10[ip][j] + K0_10*FE0_f1_D01[ip][j]))*n00 + ((K0_01*FE0_f1_D10[ip][j] + K0_11*FE0_f1_D01[ip][j]))*n01))*((((K0_01*FE0_f1_D10[ip][k] + K0_11*FE0_f1_D01[ip][k]))*n01 + ((K0_00*FE0_f1_D10[ip][k] + K0_10*FE0_f1_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 1:
        {
          // Total number of operations to compute element tensor (from this point): 27648
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 27648
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations for primary indices: 13824
          for (unsigned int j = 0; j < 6; j++)
          {
            for (unsigned int k = 0; k < 6; k++)
            {
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + k] += (((((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f1_D10[ip][k] + K0_11*FE0_f1_D01[ip][k]))*n01 + ((K0_00*FE0_f1_D10[ip][k] + K0_10*FE0_f1_D01[ip][k]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f1_D10[ip][j] + K1_10*FE0_f1_D01[ip][j]))*n10 + ((K1_01*FE0_f1_D10[ip][j] + K1_11*FE0_f1_D01[ip][j]))*n11)))*(-1.000000000000000)) + (((((K1_00*FE0_f1_D10[ip][j] + K1_10*FE0_f1_D01[ip][j]))*n10 + ((K1_01*FE0_f1_D10[ip][j] + K1_11*FE0_f1_D01[ip][j]))*n11))*((((K0_01*FE0_f1_D10[ip][k] + K0_11*FE0_f1_D01[ip][k]))*n01 + ((K0_00*FE0_f1_D10[ip][k] + K0_10*FE0_f1_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + (k + 6)] += (((((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_01*FE0_f1_D10[ip][k] + K1_11*FE0_f1_D01[ip][k]))*n11 + ((K1_00*FE0_f1_D10[ip][k] + K1_10*FE0_f1_D01[ip][k]))*n10)))*(-1.000000000000000) + (((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f1_D10[ip][j] + K1_10*FE0_f1_D01[ip][j]))*n10 + ((K1_01*FE0_f1_D10[ip][j] + K1_11*FE0_f1_D01[ip][j]))*n11)))*(-1.000000000000000)) + (((((K1_00*FE0_f1_D10[ip][j] + K1_10*FE0_f1_D01[ip][j]))*n10 + ((K1_01*FE0_f1_D10[ip][j] + K1_11*FE0_f1_D01[ip][j]))*n11))*((((K1_01*FE0_f1_D10[ip][k] + K1_11*FE0_f1_D01[ip][k]))*n11 + ((K1_00*FE0_f1_D10[ip][k] + K1_10*FE0_f1_D01[ip][k]))*n10)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + (k + 6)] += (((((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_01*FE0_f1_D10[ip][k] + K1_11*FE0_f1_D01[ip][k]))*n11 + ((K1_00*FE0_f1_D10[ip][k] + K1_10*FE0_f1_D01[ip][k]))*n10)))*(-1.000000000000000) + (((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_00*FE0_f1_D10[ip][j] + K0_10*FE0_f1_D01[ip][j]))*n00 + ((K0_01*FE0_f1_D10[ip][j] + K0_11*FE0_f1_D01[ip][j]))*n01)))*(-1.000000000000000)) + (((((K0_00*FE0_f1_D10[ip][j] + K0_10*FE0_f1_D01[ip][j]))*n00 + ((K0_01*FE0_f1_D10[ip][j] + K0_11*FE0_f1_D01[ip][j]))*n01))*((((K1_01*FE0_f1_D10[ip][k] + K1_11*FE0_f1_D01[ip][k]))*n11 + ((K1_00*FE0_f1_D10[ip][k] + K1_10*FE0_f1_D01[ip][k]))*n10)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + k] += (((((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f1_D10[ip][k] + K0_11*FE0_f1_D01[ip][k]))*n01 + ((K0_00*FE0_f1_D10[ip][k] + K0_10*FE0_f1_D01[ip][k]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_00*FE0_f1_D10[ip][j] + K0_10*FE0_f1_D01[ip][j]))*n00 + ((K0_01*FE0_f1_D10[ip][j] + K0_11*FE0_f1_D01[ip][j]))*n01)))*(-1.000000000000000)) + (((((K0_00*FE0_f1_D10[ip][j] + K0_10*FE0_f1_D01[ip][j]))*n00 + ((K0_01*FE0_f1_D10[ip][j] + K0_11*FE0_f1_D01[ip][j]))*n01))*((((K0_01*FE0_f1_D10[ip][k] + K0_11*FE0_f1_D01[ip][k]))*n01 + ((K0_00*FE0_f1_D10[ip][k] + K0_10*FE0_f1_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 2:
        {
          // Total number of operations to compute element tensor (from this point): 27648
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 27648
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations for primary indices: 13824
          for (unsigned int j = 0; j < 6; j++)
          {
            for (unsigned int k = 0; k < 6; k++)
            {
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + k] += (((((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f1_D10[ip][k] + K0_11*FE0_f1_D01[ip][k]))*n01 + ((K0_00*FE0_f1_D10[ip][k] + K0_10*FE0_f1_D01[ip][k]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f2_D10[ip][j] + K1_10*FE0_f2_D01[ip][j]))*n10 + ((K1_01*FE0_f2_D10[ip][j] + K1_11*FE0_f2_D01[ip][j]))*n11)))*(-1.000000000000000)) + (((((K1_00*FE0_f2_D10[ip][j] + K1_10*FE0_f2_D01[ip][j]))*n10 + ((K1_01*FE0_f2_D10[ip][j] + K1_11*FE0_f2_D01[ip][j]))*n11))*((((K0_01*FE0_f1_D10[ip][k] + K0_11*FE0_f1_D01[ip][k]))*n01 + ((K0_00*FE0_f1_D10[ip][k] + K0_10*FE0_f1_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + (k + 6)] += (((((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_01*FE0_f2_D10[ip][k] + K1_11*FE0_f2_D01[ip][k]))*n11 + ((K1_00*FE0_f2_D10[ip][k] + K1_10*FE0_f2_D01[ip][k]))*n10)))*(-1.000000000000000) + (((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f2_D10[ip][j] + K1_10*FE0_f2_D01[ip][j]))*n10 + ((K1_01*FE0_f2_D10[ip][j] + K1_11*FE0_f2_D01[ip][j]))*n11)))*(-1.000000000000000)) + (((((K1_00*FE0_f2_D10[ip][j] + K1_10*FE0_f2_D01[ip][j]))*n10 + ((K1_01*FE0_f2_D10[ip][j] + K1_11*FE0_f2_D01[ip][j]))*n11))*((((K1_01*FE0_f2_D10[ip][k] + K1_11*FE0_f2_D01[ip][k]))*n11 + ((K1_00*FE0_f2_D10[ip][k] + K1_10*FE0_f2_D01[ip][k]))*n10)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + (k + 6)] += (((((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_01*FE0_f2_D10[ip][k] + K1_11*FE0_f2_D01[ip][k]))*n11 + ((K1_00*FE0_f2_D10[ip][k] + K1_10*FE0_f2_D01[ip][k]))*n10)))*(-1.000000000000000) + (((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_00*FE0_f1_D10[ip][j] + K0_10*FE0_f1_D01[ip][j]))*n00 + ((K0_01*FE0_f1_D10[ip][j] + K0_11*FE0_f1_D01[ip][j]))*n01)))*(-1.000000000000000)) + (((((K0_00*FE0_f1_D10[ip][j] + K0_10*FE0_f1_D01[ip][j]))*n00 + ((K0_01*FE0_f1_D10[ip][j] + K0_11*FE0_f1_D01[ip][j]))*n01))*((((K1_01*FE0_f2_D10[ip][k] + K1_11*FE0_f2_D01[ip][k]))*n11 + ((K1_00*FE0_f2_D10[ip][k] + K1_10*FE0_f2_D01[ip][k]))*n10)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + k] += (((((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f1_D10[ip][k] + K0_11*FE0_f1_D01[ip][k]))*n01 + ((K0_00*FE0_f1_D10[ip][k] + K0_10*FE0_f1_D01[ip][k]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_00*FE0_f1_D10[ip][j] + K0_10*FE0_f1_D01[ip][j]))*n00 + ((K0_01*FE0_f1_D10[ip][j] + K0_11*FE0_f1_D01[ip][j]))*n01)))*(-1.000000000000000)) + (((((K0_00*FE0_f1_D10[ip][j] + K0_10*FE0_f1_D01[ip][j]))*n00 + ((K0_01*FE0_f1_D10[ip][j] + K0_11*FE0_f1_D01[ip][j]))*n01))*((((K0_01*FE0_f1_D10[ip][k] + K0_11*FE0_f1_D01[ip][k]))*n01 + ((K0_00*FE0_f1_D10[ip][k] + K0_10*FE0_f1_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        switch (facet1)
      {
      case 0:
        {
          // Total number of operations to compute element tensor (from this point): 27648
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 27648
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations for primary indices: 13824
          for (unsigned int j = 0; j < 6; j++)
          {
            for (unsigned int k = 0; k < 6; k++)
            {
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + k] += (((((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f2_D10[ip][k] + K0_11*FE0_f2_D01[ip][k]))*n01 + ((K0_00*FE0_f2_D10[ip][k] + K0_10*FE0_f2_D01[ip][k]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f0_D10[ip][j] + K1_10*FE0_f0_D01[ip][j]))*n10 + ((K1_01*FE0_f0_D10[ip][j] + K1_11*FE0_f0_D01[ip][j]))*n11)))*(-1.000000000000000)) + (((((K1_00*FE0_f0_D10[ip][j] + K1_10*FE0_f0_D01[ip][j]))*n10 + ((K1_01*FE0_f0_D10[ip][j] + K1_11*FE0_f0_D01[ip][j]))*n11))*((((K0_01*FE0_f2_D10[ip][k] + K0_11*FE0_f2_D01[ip][k]))*n01 + ((K0_00*FE0_f2_D10[ip][k] + K0_10*FE0_f2_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + (k + 6)] += (((((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f0_D10[ip][j] + K1_10*FE0_f0_D01[ip][j]))*n10 + ((K1_01*FE0_f0_D10[ip][j] + K1_11*FE0_f0_D01[ip][j]))*n11)))*(-1.000000000000000) + (((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_00*FE0_f0_D10[ip][k] + K1_10*FE0_f0_D01[ip][k]))*n10 + ((K1_01*FE0_f0_D10[ip][k] + K1_11*FE0_f0_D01[ip][k]))*n11)))*(-1.000000000000000)) + (((((K1_00*FE0_f0_D10[ip][j] + K1_10*FE0_f0_D01[ip][j]))*n10 + ((K1_01*FE0_f0_D10[ip][j] + K1_11*FE0_f0_D01[ip][j]))*n11))*((((K1_00*FE0_f0_D10[ip][k] + K1_10*FE0_f0_D01[ip][k]))*n10 + ((K1_01*FE0_f0_D10[ip][k] + K1_11*FE0_f0_D01[ip][k]))*n11)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + (k + 6)] += (((((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_00*FE0_f0_D10[ip][k] + K1_10*FE0_f0_D01[ip][k]))*n10 + ((K1_01*FE0_f0_D10[ip][k] + K1_11*FE0_f0_D01[ip][k]))*n11)))*(-1.000000000000000) + (((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_00*FE0_f2_D10[ip][j] + K0_10*FE0_f2_D01[ip][j]))*n00 + ((K0_01*FE0_f2_D10[ip][j] + K0_11*FE0_f2_D01[ip][j]))*n01)))*(-1.000000000000000)) + (((((K0_00*FE0_f2_D10[ip][j] + K0_10*FE0_f2_D01[ip][j]))*n00 + ((K0_01*FE0_f2_D10[ip][j] + K0_11*FE0_f2_D01[ip][j]))*n01))*((((K1_00*FE0_f0_D10[ip][k] + K1_10*FE0_f0_D01[ip][k]))*n10 + ((K1_01*FE0_f0_D10[ip][k] + K1_11*FE0_f0_D01[ip][k]))*n11)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + k] += (((((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f2_D10[ip][k] + K0_11*FE0_f2_D01[ip][k]))*n01 + ((K0_00*FE0_f2_D10[ip][k] + K0_10*FE0_f2_D01[ip][k]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_00*FE0_f2_D10[ip][j] + K0_10*FE0_f2_D01[ip][j]))*n00 + ((K0_01*FE0_f2_D10[ip][j] + K0_11*FE0_f2_D01[ip][j]))*n01)))*(-1.000000000000000)) + (((((K0_00*FE0_f2_D10[ip][j] + K0_10*FE0_f2_D01[ip][j]))*n00 + ((K0_01*FE0_f2_D10[ip][j] + K0_11*FE0_f2_D01[ip][j]))*n01))*((((K0_01*FE0_f2_D10[ip][k] + K0_11*FE0_f2_D01[ip][k]))*n01 + ((K0_00*FE0_f2_D10[ip][k] + K0_10*FE0_f2_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 1:
        {
          // Total number of operations to compute element tensor (from this point): 27648
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 27648
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations for primary indices: 13824
          for (unsigned int j = 0; j < 6; j++)
          {
            for (unsigned int k = 0; k < 6; k++)
            {
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + k] += (((((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f2_D10[ip][k] + K0_11*FE0_f2_D01[ip][k]))*n01 + ((K0_00*FE0_f2_D10[ip][k] + K0_10*FE0_f2_D01[ip][k]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f1_D10[ip][j] + K1_10*FE0_f1_D01[ip][j]))*n10 + ((K1_01*FE0_f1_D10[ip][j] + K1_11*FE0_f1_D01[ip][j]))*n11)))*(-1.000000000000000)) + (((((K1_00*FE0_f1_D10[ip][j] + K1_10*FE0_f1_D01[ip][j]))*n10 + ((K1_01*FE0_f1_D10[ip][j] + K1_11*FE0_f1_D01[ip][j]))*n11))*((((K0_01*FE0_f2_D10[ip][k] + K0_11*FE0_f2_D01[ip][k]))*n01 + ((K0_00*FE0_f2_D10[ip][k] + K0_10*FE0_f2_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + (k + 6)] += (((((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_01*FE0_f1_D10[ip][k] + K1_11*FE0_f1_D01[ip][k]))*n11 + ((K1_00*FE0_f1_D10[ip][k] + K1_10*FE0_f1_D01[ip][k]))*n10)))*(-1.000000000000000) + (((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f1_D10[ip][j] + K1_10*FE0_f1_D01[ip][j]))*n10 + ((K1_01*FE0_f1_D10[ip][j] + K1_11*FE0_f1_D01[ip][j]))*n11)))*(-1.000000000000000)) + (((((K1_00*FE0_f1_D10[ip][j] + K1_10*FE0_f1_D01[ip][j]))*n10 + ((K1_01*FE0_f1_D10[ip][j] + K1_11*FE0_f1_D01[ip][j]))*n11))*((((K1_01*FE0_f1_D10[ip][k] + K1_11*FE0_f1_D01[ip][k]))*n11 + ((K1_00*FE0_f1_D10[ip][k] + K1_10*FE0_f1_D01[ip][k]))*n10)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + (k + 6)] += (((((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_01*FE0_f1_D10[ip][k] + K1_11*FE0_f1_D01[ip][k]))*n11 + ((K1_00*FE0_f1_D10[ip][k] + K1_10*FE0_f1_D01[ip][k]))*n10)))*(-1.000000000000000) + (((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_00*FE0_f2_D10[ip][j] + K0_10*FE0_f2_D01[ip][j]))*n00 + ((K0_01*FE0_f2_D10[ip][j] + K0_11*FE0_f2_D01[ip][j]))*n01)))*(-1.000000000000000)) + (((((K0_00*FE0_f2_D10[ip][j] + K0_10*FE0_f2_D01[ip][j]))*n00 + ((K0_01*FE0_f2_D10[ip][j] + K0_11*FE0_f2_D01[ip][j]))*n01))*((((K1_01*FE0_f1_D10[ip][k] + K1_11*FE0_f1_D01[ip][k]))*n11 + ((K1_00*FE0_f1_D10[ip][k] + K1_10*FE0_f1_D01[ip][k]))*n10)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + k] += (((((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f2_D10[ip][k] + K0_11*FE0_f2_D01[ip][k]))*n01 + ((K0_00*FE0_f2_D10[ip][k] + K0_10*FE0_f2_D01[ip][k]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_00*FE0_f2_D10[ip][j] + K0_10*FE0_f2_D01[ip][j]))*n00 + ((K0_01*FE0_f2_D10[ip][j] + K0_11*FE0_f2_D01[ip][j]))*n01)))*(-1.000000000000000)) + (((((K0_00*FE0_f2_D10[ip][j] + K0_10*FE0_f2_D01[ip][j]))*n00 + ((K0_01*FE0_f2_D10[ip][j] + K0_11*FE0_f2_D01[ip][j]))*n01))*((((K0_01*FE0_f2_D10[ip][k] + K0_11*FE0_f2_D01[ip][k]))*n01 + ((K0_00*FE0_f2_D10[ip][k] + K0_10*FE0_f2_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 2:
        {
          // Total number of operations to compute element tensor (from this point): 27648
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 27648
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations for primary indices: 13824
          for (unsigned int j = 0; j < 6; j++)
          {
            for (unsigned int k = 0; k < 6; k++)
            {
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + k] += (((((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f2_D10[ip][k] + K0_11*FE0_f2_D01[ip][k]))*n01 + ((K0_00*FE0_f2_D10[ip][k] + K0_10*FE0_f2_D01[ip][k]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f2_D10[ip][j] + K1_10*FE0_f2_D01[ip][j]))*n10 + ((K1_01*FE0_f2_D10[ip][j] + K1_11*FE0_f2_D01[ip][j]))*n11)))*(-1.000000000000000)) + (((((K1_00*FE0_f2_D10[ip][j] + K1_10*FE0_f2_D01[ip][j]))*n10 + ((K1_01*FE0_f2_D10[ip][j] + K1_11*FE0_f2_D01[ip][j]))*n11))*((((K0_01*FE0_f2_D10[ip][k] + K0_11*FE0_f2_D01[ip][k]))*n01 + ((K0_00*FE0_f2_D10[ip][k] + K0_10*FE0_f2_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[(j + 6)*12 + (k + 6)] += (((((((K1_01*K1_01*FE0_f0_D20[ip][j] + K1_01*K1_11*FE0_f0_D11[ip][j] + K1_11*K1_01*FE0_f0_D11[ip][j] + K1_11*K1_11*FE0_f0_D02[ip][j]) + (K1_00*K1_00*FE0_f0_D20[ip][j] + K1_00*K1_10*FE0_f0_D11[ip][j] + K1_10*K1_00*FE0_f0_D11[ip][j] + K1_10*K1_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_01*FE0_f2_D10[ip][k] + K1_11*FE0_f2_D01[ip][k]))*n11 + ((K1_00*FE0_f2_D10[ip][k] + K1_10*FE0_f2_D01[ip][k]))*n10)))*(-1.000000000000000) + (((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K1_00*FE0_f2_D10[ip][j] + K1_10*FE0_f2_D01[ip][j]))*n10 + ((K1_01*FE0_f2_D10[ip][j] + K1_11*FE0_f2_D01[ip][j]))*n11)))*(-1.000000000000000)) + (((((K1_00*FE0_f2_D10[ip][j] + K1_10*FE0_f2_D01[ip][j]))*n10 + ((K1_01*FE0_f2_D10[ip][j] + K1_11*FE0_f2_D01[ip][j]))*n11))*((((K1_01*FE0_f2_D10[ip][k] + K1_11*FE0_f2_D01[ip][k]))*n11 + ((K1_00*FE0_f2_D10[ip][k] + K1_10*FE0_f2_D01[ip][k]))*n10)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + (k + 6)] += (((((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K1_01*FE0_f2_D10[ip][k] + K1_11*FE0_f2_D01[ip][k]))*n11 + ((K1_00*FE0_f2_D10[ip][k] + K1_10*FE0_f2_D01[ip][k]))*n10)))*(-1.000000000000000) + (((((K1_01*K1_01*FE0_f0_D20[ip][k] + K1_01*K1_11*FE0_f0_D11[ip][k] + K1_11*K1_01*FE0_f0_D11[ip][k] + K1_11*K1_11*FE0_f0_D02[ip][k]) + (K1_00*K1_00*FE0_f0_D20[ip][k] + K1_00*K1_10*FE0_f0_D11[ip][k] + K1_10*K1_00*FE0_f0_D11[ip][k] + K1_10*K1_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_00*FE0_f2_D10[ip][j] + K0_10*FE0_f2_D01[ip][j]))*n00 + ((K0_01*FE0_f2_D10[ip][j] + K0_11*FE0_f2_D01[ip][j]))*n01)))*(-1.000000000000000)) + (((((K0_00*FE0_f2_D10[ip][j] + K0_10*FE0_f2_D01[ip][j]))*n00 + ((K0_01*FE0_f2_D10[ip][j] + K0_11*FE0_f2_D01[ip][j]))*n01))*((((K1_01*FE0_f2_D10[ip][k] + K1_11*FE0_f2_D01[ip][k]))*n11 + ((K1_00*FE0_f2_D10[ip][k] + K1_10*FE0_f2_D01[ip][k]))*n10)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
              // Number of operations to compute entry: 96
              A[j*12 + k] += (((((((K0_01*K0_01*FE0_f0_D20[ip][j] + K0_01*K0_11*FE0_f0_D11[ip][j] + K0_11*K0_01*FE0_f0_D11[ip][j] + K0_11*K0_11*FE0_f0_D02[ip][j]) + (K0_00*K0_00*FE0_f0_D20[ip][j] + K0_00*K0_10*FE0_f0_D11[ip][j] + K0_10*K0_00*FE0_f0_D11[ip][j] + K0_10*K0_10*FE0_f0_D02[ip][j])))*0.500000000000000)*((((K0_01*FE0_f2_D10[ip][k] + K0_11*FE0_f2_D01[ip][k]))*n01 + ((K0_00*FE0_f2_D10[ip][k] + K0_10*FE0_f2_D01[ip][k]))*n00)))*(-1.000000000000000) + (((((K0_01*K0_01*FE0_f0_D20[ip][k] + K0_01*K0_11*FE0_f0_D11[ip][k] + K0_11*K0_01*FE0_f0_D11[ip][k] + K0_11*K0_11*FE0_f0_D02[ip][k]) + (K0_00*K0_00*FE0_f0_D20[ip][k] + K0_00*K0_10*FE0_f0_D11[ip][k] + K0_10*K0_00*FE0_f0_D11[ip][k] + K0_10*K0_10*FE0_f0_D02[ip][k])))*0.500000000000000)*((((K0_00*FE0_f2_D10[ip][j] + K0_10*FE0_f2_D01[ip][j]))*n00 + ((K0_01*FE0_f2_D10[ip][j] + K0_11*FE0_f2_D01[ip][j]))*n01)))*(-1.000000000000000)) + (((((K0_00*FE0_f2_D10[ip][j] + K0_10*FE0_f2_D01[ip][j]))*n00 + ((K0_01*FE0_f2_D10[ip][j] + K0_11*FE0_f2_D01[ip][j]))*n01))*((((K0_01*FE0_f2_D10[ip][k] + K0_11*FE0_f2_D01[ip][k]))*n01 + ((K0_00*FE0_f2_D10[ip][k] + K0_10*FE0_f2_D01[ip][k]))*n00)))*(w[1][0]/((w[0][0] + w[0][1])/(2.000000000000000))))*W2[ip]*det;
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      }
      
        break;
      }
    }
    
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class biharmonic_cell_integral_1_0: public ufc::cell_integral
{
public:

  /// Constructor
  biharmonic_cell_integral_1_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_cell_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      9
    // Number of operations (multiply-add pairs) for geometry tensor:    6
    // Number of operations (multiply-add pairs) for tensor contraction: 21
    // Total number of operations (multiply-add pairs):                  36
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    const double G0_3 = det*w[0][3]*(1.0);
    const double G0_4 = det*w[0][4]*(1.0);
    const double G0_5 = det*w[0][5]*(1.0);
    
    // Compute element tensor
    A[0] = 0.016666666666667*G0_0 - 0.002777777777778*G0_1 - 0.002777777777778*G0_2 - 0.011111111111111*G0_3;
    A[1] = -0.002777777777778*G0_0 + 0.016666666666667*G0_1 - 0.002777777777778*G0_2 - 0.011111111111111*G0_4;
    A[2] = -0.002777777777778*G0_0 - 0.002777777777778*G0_1 + 0.016666666666667*G0_2 - 0.011111111111111*G0_5;
    A[3] = -0.011111111111111*G0_0 + 0.088888888888889*G0_3 + 0.044444444444444*G0_4 + 0.044444444444444*G0_5;
    A[4] = -0.011111111111111*G0_1 + 0.044444444444444*G0_3 + 0.088888888888889*G0_4 + 0.044444444444444*G0_5;
    A[5] = -0.011111111111111*G0_2 + 0.044444444444444*G0_3 + 0.044444444444444*G0_4 + 0.088888888888889*G0_5;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class biharmonic_form_0: public ufc::form
{
public:

  /// Constructor
  biharmonic_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(IndexSum(Indexed(ComponentTensor(SpatialDerivative(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 0), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), MultiIndex((Index(1),), {Index(1): 2})), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(0),), {Index(0): 2})), IndexSum(Indexed(ComponentTensor(SpatialDerivative(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 1), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(3),), {Index(3): 2})), MultiIndex((Index(3),), {Index(3): 2})), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(2),), {Index(2): 2}))), Measure('cell', 0, None)), Integral(Sum(Product(Division(PositiveRestricted(Constant(Cell('triangle', 1, Space(2)), 1)), Division(Sum(NegativeRestricted(Constant(Cell('triangle', 1, Space(2)), 0)), PositiveRestricted(Constant(Cell('triangle', 1, Space(2)), 0))), IntValue(2, (), (), {}))), Product(Sum(IndexSum(Product(Indexed(NegativeRestricted(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 0), MultiIndex((Index(4),), {Index(4): 2})), MultiIndex((Index(4),), {Index(4): 2}))), MultiIndex((Index(5),), {Index(5): 2})), Indexed(NegativeRestricted(FacetNormal(Cell('triangle', 1, Space(2)))), MultiIndex((Index(5),), {Index(5): 2}))), MultiIndex((Index(5),), {Index(5): 2})), IndexSum(Product(Indexed(PositiveRestricted(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 0), MultiIndex((Index(6),), {Index(6): 2})), MultiIndex((Index(6),), {Index(6): 2}))), MultiIndex((Index(7),), {Index(7): 2})), Indexed(PositiveRestricted(FacetNormal(Cell('triangle', 1, Space(2)))), MultiIndex((Index(7),), {Index(7): 2}))), MultiIndex((Index(7),), {Index(7): 2}))), Sum(IndexSum(Product(Indexed(NegativeRestricted(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 1), MultiIndex((Index(8),), {Index(8): 2})), MultiIndex((Index(8),), {Index(8): 2}))), MultiIndex((Index(9),), {Index(9): 2})), Indexed(NegativeRestricted(FacetNormal(Cell('triangle', 1, Space(2)))), MultiIndex((Index(9),), {Index(9): 2}))), MultiIndex((Index(9),), {Index(9): 2})), IndexSum(Product(Indexed(PositiveRestricted(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 1), MultiIndex((Index(10),), {Index(10): 2})), MultiIndex((Index(10),), {Index(10): 2}))), MultiIndex((Index(11),), {Index(11): 2})), Indexed(PositiveRestricted(FacetNormal(Cell('triangle', 1, Space(2)))), MultiIndex((Index(11),), {Index(11): 2}))), MultiIndex((Index(11),), {Index(11): 2}))))), Sum(Product(IntValue(-1, (), (), {}), Product(Product(FloatValue(0.5, (), (), {}), Sum(NegativeRestricted(IndexSum(Indexed(ComponentTensor(SpatialDerivative(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 0), MultiIndex((Index(12),), {Index(12): 2})), MultiIndex((Index(13),), {Index(13): 2})), MultiIndex((Index(13),), {Index(13): 2})), MultiIndex((Index(12),), {Index(12): 2})), MultiIndex((Index(12),), {Index(12): 2}))), PositiveRestricted(IndexSum(Indexed(ComponentTensor(SpatialDerivative(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 0), MultiIndex((Index(14),), {Index(14): 2})), MultiIndex((Index(15),), {Index(15): 2})), MultiIndex((Index(15),), {Index(15): 2})), MultiIndex((Index(14),), {Index(14): 2})), MultiIndex((Index(14),), {Index(14): 2}))))), Sum(IndexSum(Product(Indexed(NegativeRestricted(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 1), MultiIndex((Index(16),), {Index(16): 2})), MultiIndex((Index(16),), {Index(16): 2}))), MultiIndex((Index(17),), {Index(17): 2})), Indexed(NegativeRestricted(FacetNormal(Cell('triangle', 1, Space(2)))), MultiIndex((Index(17),), {Index(17): 2}))), MultiIndex((Index(17),), {Index(17): 2})), IndexSum(Product(Indexed(PositiveRestricted(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 1), MultiIndex((Index(18),), {Index(18): 2})), MultiIndex((Index(18),), {Index(18): 2}))), MultiIndex((Index(19),), {Index(19): 2})), Indexed(PositiveRestricted(FacetNormal(Cell('triangle', 1, Space(2)))), MultiIndex((Index(19),), {Index(19): 2}))), MultiIndex((Index(19),), {Index(19): 2}))))), Product(IntValue(-1, (), (), {}), Product(Product(FloatValue(0.5, (), (), {}), Sum(NegativeRestricted(IndexSum(Indexed(ComponentTensor(SpatialDerivative(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 1), MultiIndex((Index(20),), {Index(20): 2})), MultiIndex((Index(21),), {Index(21): 2})), MultiIndex((Index(21),), {Index(21): 2})), MultiIndex((Index(20),), {Index(20): 2})), MultiIndex((Index(20),), {Index(20): 2}))), PositiveRestricted(IndexSum(Indexed(ComponentTensor(SpatialDerivative(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 1), MultiIndex((Index(22),), {Index(22): 2})), MultiIndex((Index(23),), {Index(23): 2})), MultiIndex((Index(23),), {Index(23): 2})), MultiIndex((Index(22),), {Index(22): 2})), MultiIndex((Index(22),), {Index(22): 2}))))), Sum(IndexSum(Product(Indexed(NegativeRestricted(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 0), MultiIndex((Index(24),), {Index(24): 2})), MultiIndex((Index(24),), {Index(24): 2}))), MultiIndex((Index(25),), {Index(25): 2})), Indexed(NegativeRestricted(FacetNormal(Cell('triangle', 1, Space(2)))), MultiIndex((Index(25),), {Index(25): 2}))), MultiIndex((Index(25),), {Index(25): 2})), IndexSum(Product(Indexed(PositiveRestricted(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 0), MultiIndex((Index(26),), {Index(26): 2})), MultiIndex((Index(26),), {Index(26): 2}))), MultiIndex((Index(27),), {Index(27): 2})), Indexed(PositiveRestricted(FacetNormal(Cell('triangle', 1, Space(2)))), MultiIndex((Index(27),), {Index(27): 2}))), MultiIndex((Index(27),), {Index(27): 2}))))))), Measure('interior_facet', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 2;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 1;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 0;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 1;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_finite_element_1();
        break;
      }
    case 1:
      {
        return new biharmonic_finite_element_1();
        break;
      }
    case 2:
      {
        return new biharmonic_finite_element_0();
        break;
      }
    case 3:
      {
        return new biharmonic_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_dof_map_1();
        break;
      }
    case 1:
      {
        return new biharmonic_dof_map_1();
        break;
      }
    case 2:
      {
        return new biharmonic_dof_map_0();
        break;
      }
    case 3:
      {
        return new biharmonic_dof_map_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_interior_facet_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class biharmonic_form_1: public ufc::form
{
public:

  /// Constructor
  biharmonic_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 0)), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 1;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 1;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 0;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_finite_element_1();
        break;
      }
    case 1:
      {
        return new biharmonic_finite_element_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_dof_map_1();
        break;
      }
    case 1:
      {
        return new biharmonic_dof_map_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_cell_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>

namespace Biharmonic
{

class CoefficientSpace_alpha: public dolfin::FunctionSpace
{
public:

  CoefficientSpace_alpha(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_alpha(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_alpha(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace_alpha(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace_alpha()
  {
  }

};

class CoefficientSpace_f: public dolfin::FunctionSpace
{
public:

  CoefficientSpace_f(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_1()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_f(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_1()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_f(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_1()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace_f(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_1()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace_f()
  {
  }

};

class CoefficientSpace_h: public dolfin::FunctionSpace
{
public:

  CoefficientSpace_h(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_h(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_h(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace_h(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace_h()
  {
  }

};

class Form_0_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_1()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_1()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_1()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_1()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_0()
  {
  }

};

class Form_0_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_1()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_1()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_1()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_1()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_1()
  {
  }

};

typedef CoefficientSpace_h Form_0_FunctionSpace_2;

typedef CoefficientSpace_alpha Form_0_FunctionSpace_3;

class Form_0: public dolfin::Form
{
public:

  // Constructor
  Form_0(const dolfin::FunctionSpace& V0, const dolfin::FunctionSpace& V1):
    dolfin::Form(2, 2), h(*this, 0), alpha(*this, 1)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_0());
  }

  // Constructor
  Form_0(const dolfin::FunctionSpace& V0, const dolfin::FunctionSpace& V1, const dolfin::GenericFunction& h, const dolfin::GenericFunction& alpha):
    dolfin::Form(2, 2), h(*this, 0), alpha(*this, 1)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    this->h = h;
    this->alpha = alpha;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_0());
  }

  // Constructor
  Form_0(const dolfin::FunctionSpace& V0, const dolfin::FunctionSpace& V1, boost::shared_ptr<const dolfin::GenericFunction> h, boost::shared_ptr<const dolfin::GenericFunction> alpha):
    dolfin::Form(2, 2), h(*this, 0), alpha(*this, 1)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    this->h = *h;
    this->alpha = *alpha;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_0());
  }

  // Constructor
  Form_0(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::FunctionSpace> V1):
    dolfin::Form(2, 2), h(*this, 0), alpha(*this, 1)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_0());
  }

  // Constructor
  Form_0(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::FunctionSpace> V1, const dolfin::GenericFunction& h, const dolfin::GenericFunction& alpha):
    dolfin::Form(2, 2), h(*this, 0), alpha(*this, 1)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->h = h;
    this->alpha = alpha;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_0());
  }

  // Constructor
  Form_0(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::GenericFunction> h, boost::shared_ptr<const dolfin::GenericFunction> alpha):
    dolfin::Form(2, 2), h(*this, 0), alpha(*this, 1)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->h = *h;
    this->alpha = *alpha;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_0());
  }

  // Destructor
  ~Form_0()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {
    if (name == "h")
      return 0;
    else if (name == "alpha")
      return 1;

    dolfin::error("Invalid coefficient.");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {
    switch (i)
    {
    case 0:
      return "h";
    case 1:
      return "alpha";
    }

    dolfin::error("Invalid coefficient.");
    return "unnamed";
  }

  // Typedefs
  typedef Form_0_FunctionSpace_0 TestSpace;
  typedef Form_0_FunctionSpace_1 TrialSpace;
  typedef Form_0_FunctionSpace_2 CoefficientSpace_h;
  typedef Form_0_FunctionSpace_3 CoefficientSpace_alpha;

  // Coefficients
  dolfin::CoefficientAssigner h;
  dolfin::CoefficientAssigner alpha;
};

class Form_1_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_1_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_1()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_1()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_1()), *mesh)))
  {
      // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new biharmonic_dof_map_1()), *mesh)))
  {
      // Do nothing
  }

  ~Form_1_FunctionSpace_0()
  {
  }

};

typedef CoefficientSpace_f Form_1_FunctionSpace_1;

class Form_1: public dolfin::Form
{
public:

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_1());
  }

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_1());
  }

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0, boost::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = *f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    this->f = f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    this->f = *f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_1());
  }

  // Destructor
  ~Form_1()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;

    dolfin::error("Invalid coefficient.");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    }

    dolfin::error("Invalid coefficient.");
    return "unnamed";
  }

  // Typedefs
  typedef Form_1_FunctionSpace_0 TestSpace;
  typedef Form_1_FunctionSpace_1 CoefficientSpace_f;

  // Coefficients
  dolfin::CoefficientAssigner f;
};

// Class typedefs
typedef Form_0 BilinearForm;
typedef Form_1 LinearForm;
typedef Form_0::TestSpace FunctionSpace;

}

#endif
