"""This module provides a simple way to compute the interpolation of
a Function (discrete or user-defined) onto a finite element space."""

__author__ = "Anders Logg (logg@simula.no)"
__date__ = "2009-08-29 -- 2009-12-11"
__copyright__ = "Copyright (C) 2009 Anders Logg"
__license__  = "GNU LGPL Version 2.1"

# Local imports
import dolfin.cpp as cpp

from dolfin.function.functionspace import FunctionSpaceBase
from dolfin.function.function import Function

def interpolate(v, V):
    """Return interpolation of given Function v into the finite element space V.
    Example usage:

        V = FunctionSpace(mesh, "Lagrange", 1)

        Pv = interpolate(v, V)
    """

    # Check arguments
    if not isinstance(V, FunctionSpaceBase):
        cpp.error("Illegal function space for interpolation, not a FunctionSpace: " + str(v))

    # Compute interpolation
    Pv = Function(V)
    Pv.interpolate(v)

    return Pv
