"""Main module for PyDOLFIN"""

# Import DOLFIN wrapper module as well as additional utility entities
__version__ = "0.9.8"

# Try to load the mpi library before anything else
try:
    import dolfin.common.dynamicloadmpi
except OSError:
    pass

#--- Imports from SWIG-generated Python code (C++ interface) ---
import dolfin.cpp as cpp

## # For some reason PyTrilinos needs to be loaded before the assemble module or
## # else strange things happen.
## try:
##     from PyTrilinos import Epetra, AztecOO, TriUtils, ML
## except:
##     pass

# Import UFL form language
from ufl import *

# Import UFL color printing
from ufl.log import info_red, info_green, info_blue

# Imports from Python code
from dolfin.common.globalparameters import *
from dolfin.common.constants import *
from dolfin.common.logger import *
from dolfin.common.plot import *
from dolfin.common.time import *
from dolfin.common.memory import *

from dolfin.compilemodules import compile_extension_module
from dolfin.compilemodules.expressions import compile_expressions
from dolfin.compilemodules.subdomains import compile_subdomains
from dolfin.compilemodules.jit import jit

from dolfin.function.functionspace import *
from dolfin.function.function import *
from dolfin.function.constant import *
from dolfin.function.expression import *
from dolfin.function.specialfunctions import *

from dolfin.fem.form import *
from dolfin.fem.assemble import *
from dolfin.fem.variationalproblem import *
from dolfin.fem.norm import *
from dolfin.fem.project import *
from dolfin.fem.interpolate import *
from dolfin.fem.errornorm import *
from dolfin.fem.bcs import *

from dolfin.mesh.ale import *
from dolfin.mesh.refine import *

from dolfin.adaptivity.adaptive import *

# Classes
from dolfin.cpp import Matrix, Vector, Scalar, GenericMatrix, GenericVector
from dolfin.cpp import LinearSolver, KrylovSolver, LUSolver, SingularSolver
from dolfin.cpp import BlockMatrix, BlockVector

#from dolfin.cpp import Graph, GraphEditor, GraphPartition
#from dolfin.cpp import UndirectedClique, DirectedClique
from dolfin.cpp import File
#from dolfin.cpp import Lagrange, Legendre
#from dolfin.cpp import Quadrature, Variable
#from dolfin.cpp import GaussQuadrature
from dolfin.cpp import GaussQuadrature, RadauQuadrature, LobattoQuadrature
from dolfin.cpp import Mesh, MeshEditor, MeshFunction, BoundaryMesh, SubMesh
#from dolfin.cpp import MeshEntity, MeshTopology, MeshGeometry
#from dolfin.cpp import MeshConnectivity, MPIMeshCommunicator, BoundaryMesh
from dolfin.cpp import Vertex, Edge, Face, Facet, Cell, Point
from dolfin.cpp import vertices, edges, faces, facets, cells
from dolfin.cpp import SubDomain, DomainBoundary
from dolfin.cpp import (UnitInterval, Interval, UnitSquare,
                       Rectangle, UnitCircle, UnitCube, Box, UnitSphere)
#from dolfin.cpp import DofMap, DofMapSet
from dolfin.cpp import IntersectionOperator
from dolfin.cpp import PrimitiveIntersector_do_intersect as do_intersect
from dolfin.cpp import PrimitiveIntersector_do_intersect_exact as do_intersect_exact
#from dolfin.cpp import BoundaryCondition
#from dolfin.cpp import DirichletBC, PeriodicBC
#from dolfin.cpp import Form, Assembler
from dolfin.cpp import Assembler
from dolfin.cpp import SystemAssembler
from dolfin.cpp import SubSpace
#from dolfin.cpp import MatrixFactory
from dolfin.cpp import NewtonSolver, NonlinearProblem
from dolfin.cpp import ODE
#from dolfin.cpp import ComplexODE
from dolfin.cpp import Progress, Timer, Table, Event
from dolfin.cpp import MPI
#from dolfin.cpp import STLVectorUInt, STLVectorDouble
from dolfin.cpp import Parameters
from dolfin.cpp import TimeSeries

# Free functions
from dolfin.cpp import tic, toc, summary
from dolfin.cpp import solve, residual, normalize
from dolfin.cpp import down_cast

# Enums
from dolfin.cpp import lagrange, hermite, harmonic

# Linear algebra backend related imports
from dolfin.cpp import (has_la_backend, has_mpi, has_slepc,
                        has_scotch, has_cgal,
                        has_umfpack, has_cholmod, has_parmetis,
                        has_gmp, has_zlib)

from dolfin.cpp import DefaultFactory

# Optional package uBLAS
if has_la_backend("uBLAS"):
    from dolfin.cpp import uBLASVector, uBLASSparseMatrix, uBLASDenseMatrix
    from dolfin.cpp import uBLASSparseFactory, uBLASDenseFactory
    from dolfin.cpp import (uBLASSparseFactory_instance,
                            uBLASDenseFactory_instance)
    from dolfin.cpp import uBLASKrylovMatrix, uBLASKrylovSolver

# Optional package petsc
if has_la_backend("PETSc"):
    from dolfin.cpp import (PETScMatrix, PETScVector, PETScFactory,
                            PETScFactory_instance)
    from dolfin.cpp import PETScKrylovMatrix, PETScKrylovSolver, PETScPreconditioner
    from dolfin.cpp import PETScLUSolver

# Optional package Epetra
if has_la_backend("Epetra"):
    from dolfin.cpp import (EpetraMatrix, EpetraVector, EpetraFactory,
                            EpetraFactory_instance)
    from dolfin.cpp import EpetraKrylovSolver, TrilinosPreconditioner
    from dolfin.cpp import EpetraLUSolver

# Optional package MTL4
if has_la_backend("MTL4"):
    from dolfin.cpp import (MTL4Matrix, MTL4Vector, MTL4Factory,
                            MTL4Factory_instance)

# Optional package slepc
try:
    from dolfin.cpp import SLEPcEigenSolver
except:
    pass

