__author__ = "Anders Logg (logg@simula.no)"
__date__ = "2009-02-12 -- 2009-12-11"
__copyright__ = "Copyright (C) 2009 Anders Logg"
__license__  = "GNU LGPL Version 2.1"

__all__ = ["compute_vertex_map"]

from dolfin.cpp import Mesh
from dolfin.common.logger import error

def compute_vertex_map(mesh0, mesh1):
    """Compute map from vertices of mesh0 to vertices of mesh1. It is
    assumed that both meshes have a MeshFunction over the vertices
    named "global vertex indices" which contain a mapping from the
    local vertices to a common global vertex numbering."""

    # Check arguments
    if not isinstance(mesh0,Mesh):
        raise TypeError, "expected 'Mesh' as arguments"

    if not isinstance(mesh1,Mesh):
        raise TypeError, "expected 'Mesh' as arguments"

    # Get global vertex numbers
    vertices0 = mesh0.data().mesh_function("global vertex indices")
    vertices1 = mesh1.data().mesh_function("global vertex indices")
    

    # Check mappings
    if vertices0 is None or vertices1 is None:
        error("Unable to computed vertex map, global vertex indices are missing.")

    # Compute global-to-local mapping for mesh1
    global_to_local_mesh1 = {}
    for i in range(vertices1.size()):
        global_to_local_mesh1[vertices1[i]] = i

    # Compute local-to-local mapping
    vertex_map = {}
    for i in range(vertices0.size()):
        global_vertex = vertices0[i]  
        if global_vertex in global_to_local_mesh1:
            vertex_map[i] = global_to_local_mesh1[global_vertex]

    return vertex_map

