// Auto generated SWIG file for Python interface of DOLFIN
//
// Copyright (C) 2012 Kristian B. Oelgaard
//
// This file is part of DOLFIN.
//
// DOLFIN is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DOLFIN is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
//

// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=generation, header=BoxMesh.h)
%feature("docstring")  dolfin::BoxMesh "
Tetrahedral mesh of the 3D rectangular prism [x0, x1] x [y0, y1]
x [z0, z1].  Given the number of cells (nx, ny, nz) in each
direction, the total number of tetrahedra will be 6*nx*ny*nz and
the total number of vertices will be (nx + 1)*(ny + 1)*(nz + 1).
";

%feature("docstring")  dolfin::BoxMesh::BoxMesh "
**Overloaded versions**

* BoxMesh\ (x0, y0, z0, x1, y1, z1, nx, ny, nz)

  Create a uniform finite element :py:class:`Mesh` over the rectangular prism
  [x0, x1] x [y0, y1] x [z0, z1].
  
  *Arguments*
      x0 (float)
          :math:`x`-min.
      y0 (float)
          :math:`y`-min.
      z0 (float)
          :math:`z`-min.
      x1 (float)
          :math:`x`-max.
      y1 (float)
          :math:`y`-max.
      z1 (float)
          :math:`z`-max.
      xn (float)
          Number of cells in :math:`x`-direction.
      yn (float)
          Number of cells in :math:`y`-direction.
      zn (float)
          Number of cells in :math:`z`-direction.
  
  *Example*
      .. note::
      
          No example code available for this function.

* BoxMesh\ (comm, x0, y0, z0, x1, y1, z1, nx, ny, nz)

  Create a uniform finite element :py:class:`Mesh` over the rectangular prism
  [x0, x1] x [y0, y1] x [z0, z1].
  
  *Arguments*
      comm (:py:class:`MPI`)
          MPI communicator
      x0 (float)
          :math:`x`-min.
      y0 (float)
          :math:`y`-min.
      z0 (float)
          :math:`z`-min.
      x1 (float)
          :math:`x`-max.
      y1 (float)
          :math:`y`-max.
      z1 (float)
          :math:`z`-max.
      xn (float)
          Number of cells in :math:`x`-direction.
      yn (float)
          Number of cells in :math:`y`-direction.
      zn (float)
          Number of cells in :math:`z`-direction.
  
  *Example*
      .. note::
      
          No example code available for this function.
";

// Documentation extracted from: (module=generation, header=IntervalMesh.h)
%feature("docstring")  dolfin::IntervalMesh "
Interval mesh of the 1D line [a,b].  Given the number of cells
(nx) in the axial direction, the total number of intervals will
be nx and the total number of vertices will be (nx + 1).
";

%feature("docstring")  dolfin::IntervalMesh::IntervalMesh "
**Overloaded versions**

* IntervalMesh\ (nx, a, b)

  Constructor
  
  *Arguments*
      nx (int)
          The number of cells.
      a (float)
          The minimum point (inclusive).
      b (float)
          The maximum point (inclusive).
  
  *Example*
      .. note::
      
          No example code available for this function.

* IntervalMesh\ (comm, nx, a, b)

  Constructor
  
  *Arguments*
      comm (:py:class:`MPI`)
          MPI communicator
      nx (int)
          The number of cells.
      a (float)
          The minimum point (inclusive).
      b (float)
          The maximum point (inclusive).
  
  *Example*
      .. note::
      
          No example code available for this function.
";

// Documentation extracted from: (module=generation, header=RectangleMesh.h)
%feature("docstring")  dolfin::RectangleMesh "
Triangular mesh of the 2D rectangle (x0, y0) x (x1, y1).
Given the number of cells (nx, ny) in each direction,
the total number of triangles will be 2*nx*ny and the
total number of vertices will be (nx + 1)*(ny + 1).
";

%feature("docstring")  dolfin::RectangleMesh::RectangleMesh "
**Overloaded versions**

* RectangleMesh\ (x0, y0, x1, y1, nx, ny, diagonal=\"right\")

  *Arguments*
      x0 (float)
          :math:`x`-min.
      y0 (float)
          :math:`y`-min.
      x1 (float)
          :math:`x`-max.
      y1 (float)
          :math:`y`-max.
      xn (float)
          Number of cells in :math:`x`-direction.
      yn (float)
          Number of cells in :math:`y`-direction.
      diagonal (str)
          Direction of diagonals: \"left\", \"right\", \"left/right\", \"crossed\"
  
  *Example*
      .. note::
      
          No example code available for this function.

* RectangleMesh\ (comm, x0, y0, x1, y1, nx, ny, diagonal=\"right\")

  *Arguments*
      comm (:py:class:`MPI`)
          MPI communicator
      x0 (float)
          :math:`x`-min.
      y0 (float)
          :math:`y`-min.
      x1 (float)
          :math:`x`-max.
      y1 (float)
          :math:`y`-max.
      xn (float)
          Number of cells in :math:`x`-direction.
      yn (float)
          Number of cells in :math:`y`-direction.
      diagonal (str)
          Direction of diagonals: \"left\", \"right\", \"left/right\", \"crossed\"
  
  *Example*
      .. note::
      
          No example code available for this function.
";

// Documentation extracted from: (module=generation, header=UnitTetrahedronMesh.h)
%feature("docstring")  dolfin::UnitTetrahedronMesh "
A mesh consisting of a single tetrahedron with vertices at

  (0, 0, 0)
  (1, 0, 0)
  (0, 1, 0)
  (0, 0, 1)

This class is useful for testing.
";

%feature("docstring")  dolfin::UnitTetrahedronMesh::UnitTetrahedronMesh "
Create mesh of unit tetrahedron
";

// Documentation extracted from: (module=generation, header=UnitCubeMesh.h)
%feature("docstring")  dolfin::UnitCubeMesh "
Tetrahedral mesh of the 3D unit cube [0,1] x [0,1] x [0,1].
Given the number of cells (nx, ny, nz) in each direction,
the total number of tetrahedra will be 6*nx*ny*nz and the
total number of vertices will be (nx + 1)*(ny + 1)*(nz + 1).
";

%feature("docstring")  dolfin::UnitCubeMesh::UnitCubeMesh "
**Overloaded versions**

* UnitCubeMesh\ (nx, ny, nz)

  Create a uniform finite element :py:class:`Mesh` over the unit cube
  [0,1] x [0,1] x [0,1].
  
  *Arguments*
      nx (int)
          Number of cells in :math:`x` direction.
      ny (int)
          Number of cells in :math:`y` direction.
      nz (int)
          Number of cells in :math:`z` direction.
  
  *Example*
      .. note::
      
          No example code available for this function.

* UnitCubeMesh\ (comm, nx, ny, nz)

  Create a uniform finite element :py:class:`Mesh` over the unit cube
  [0,1] x [0,1] x [0,1].
  
  *Arguments*
      comm (:py:class:`MPI`)
          MPI communicator
      nx (int)
          Number of cells in :math:`x` direction.
      ny (int)
          Number of cells in :math:`y` direction.
      nz (int)
          Number of cells in :math:`z` direction.
  
  *Example*
      .. note::
      
          No example code available for this function.
";

// Documentation extracted from: (module=generation, header=UnitIntervalMesh.h)
%feature("docstring")  dolfin::UnitIntervalMesh "
A mesh of the unit interval (0, 1) with a given number of cells
(nx) in the axial direction. The total number of intervals will
be nx and the total number of vertices will be (nx + 1).
";

%feature("docstring")  dolfin::UnitIntervalMesh::UnitIntervalMesh "
**Overloaded versions**

* UnitIntervalMesh\ (nx)

  Constructor
  
  *Arguments*
      nx (int)
          The number of cells.
  
  *Example*
      .. note::
      
          No example code available for this function.

* UnitIntervalMesh\ (comm, nx)

  Constructor
  
  *Arguments*
      comm (:py:class:`MPI`)
          MPI communicator
      nx (int)
          The number of cells.
  
  *Example*
      .. note::
      
          No example code available for this function.
";

// Documentation extracted from: (module=generation, header=UnitTriangleMesh.h)
%feature("docstring")  dolfin::UnitTriangleMesh "
A mesh consisting of a single triangle with vertices at

  (0, 0)
  (1, 0)
  (0, 1)

This class is useful for testing.
";

%feature("docstring")  dolfin::UnitTriangleMesh::UnitTriangleMesh "
Create mesh of unit triangle
";

// Documentation extracted from: (module=generation, header=UnitSquareMesh.h)
%feature("docstring")  dolfin::UnitSquareMesh "
Triangular mesh of the 2D unit square [0,1] x [0,1].
Given the number of cells (nx, ny) in each direction,
the total number of triangles will be 2*nx*ny and the
total number of vertices will be (nx + 1)*(ny + 1).

std::string diagonal (\"left\", \"right\", \"right/left\", \"left/right\",
or \"crossed\") indicates the direction of the diagonals.
";

%feature("docstring")  dolfin::UnitSquareMesh::UnitSquareMesh "
**Overloaded versions**

* UnitSquareMesh\ (nx, ny, diagonal=\"right\")

  Create a uniform finite element :py:class:`Mesh` over the unit square
  [0,1] x [0,1].
  
  *Arguments*
      nx (int)
          Number of cells in horizontal direction.
      ny (int)
          Number of cells in vertical direction.
      diagonal (str)
          Optional argument: A std::string indicating
          the direction of the diagonals.
  
  *Example*
      .. note::
      
          No example code available for this function.

* UnitSquareMesh\ (comm, nx, ny, diagonal=\"right\")

  Create a uniform finite element :py:class:`Mesh` over the unit square
  [0,1] x [0,1].
  
  *Arguments*
      comm (:py:class:`MPI`)
          MPI communicator
      nx (int)
          Number of cells in horizontal direction.
      ny (int)
          Number of cells in vertical direction.
      diagonal (str)
          Optional argument: A std::string indicating
          the direction of the diagonals.
  
  *Example*
      .. note::
      
          No example code available for this function.
";

