// This code conforms with the UFC specification version 2016.1.0
// and was automatically generated by FFC version 2016.1.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   optimize:                       True
//   precision:                      15
//   quadrature_degree:              -1
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __ELASTODYNAMICS_H
#define __ELASTODYNAMICS_H
#include <stdexcept>
#include <ufc.h>

class elastodynamics_finite_element_0: public ufc::finite_element
{
public:

  elastodynamics_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  ~elastodynamics_finite_element_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Lagrange', triangle, 1)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::triangle;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t geometric_dimension() const final override
  {
    return 2;
  }

  std::size_t space_dimension() const final override
  {
    return 3;
  }

  std::size_t value_rank() const final override
  {
    return 0;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t value_size() const final override
  {
    return 1;
  }

  std::size_t reference_value_rank() const final override
  {
    return 0;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t reference_value_size() const final override
  {
    return 1;
  }

  std::size_t degree() const final override
  {
    return 1;
  }

  const char * family() const final override
  {
    return "Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 3; r++)
    {
      _evaluate_basis(r, &dof_values, x, coordinate_dofs, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[2][1];
    for (unsigned int row = 0; row < 2; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[2][2];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 3; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[2];
    for (unsigned int r = 0; r < 2; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 3; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new elastodynamics_finite_element_0();
  }

};


class elastodynamics_finite_element_1: public ufc::finite_element
{
public:

  elastodynamics_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  ~elastodynamics_finite_element_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "VectorElement(FiniteElement('Lagrange', triangle, 1), dim=2)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::triangle;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t geometric_dimension() const final override
  {
    return 2;
  }

  std::size_t space_dimension() const final override
  {
    return 6;
  }

  std::size_t value_rank() const final override
  {
    return 1;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  std::size_t value_size() const final override
  {
    return 2;
  }

  std::size_t reference_value_rank() const final override
  {
    return 1;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  std::size_t reference_value_size() const final override
  {
    return 2;
  }

  std::size_t degree() const final override
  {
    return 1;
  }

  const char * family() const final override
  {
    return "Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis(r, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[2] + coordinate_dofs[4];
    const double C1 = coordinate_dofs[3] + coordinate_dofs[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[2][1];
    for (unsigned int row = 0; row < 2; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[2][2];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, -0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.288675134594813, -0.166666666666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.471404520791032, 0.0, 0.333333333333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[2];
      for (unsigned int r = 0; r < 2; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 6; r++)
    {
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[4];
    for (unsigned int r = 0; r < 4; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 4:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[3] = vals[1];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[4] = vals[1];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[5] = vals[1];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[2] = dof_values[1];
    vertex_values[4] = dof_values[2];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[3];
    vertex_values[3] = dof_values[4];
    vertex_values[5] = dof_values[5];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[0];
    dof_coordinates[7] = coordinate_dofs[1];
    dof_coordinates[8] = coordinate_dofs[2];
    dof_coordinates[9] = coordinate_dofs[3];
    dof_coordinates[10] = coordinate_dofs[4];
    dof_coordinates[11] = coordinate_dofs[5];
  }

  std::size_t num_sub_elements() const final override
  {
    return 2;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new elastodynamics_finite_element_0();
        break;
      }
    case 1:
      {
        return new elastodynamics_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new elastodynamics_finite_element_1();
  }

};


class elastodynamics_finite_element_2: public ufc::finite_element
{
public:

  elastodynamics_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  ~elastodynamics_finite_element_2() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Discontinuous Lagrange', triangle, 0)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::triangle;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t geometric_dimension() const final override
  {
    return 2;
  }

  std::size_t space_dimension() const final override
  {
    return 1;
  }

  std::size_t value_rank() const final override
  {
    return 0;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t value_size() const final override
  {
    return 1;
  }

  std::size_t reference_value_rank() const final override
  {
    return 0;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t reference_value_size() const final override
  {
    return 1;
  }

  std::size_t degree() const final override
  {
    return 0;
  }

  const char * family() const final override
  {
    return "Discontinuous Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    
    // Get coordinates and map to the reference (FIAT) element
    
    // Reset values
    *values = 0.0;
    
    // Array of basisvalues
    double basisvalues[1] = {0.0};
    
    // Declare helper variables
    
    // Compute basisvalues
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients
    static const double coefficients0[1] = \
    {1.0};
    
    // Compute value(s)
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    } // end loop over 'r'
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Element is constant, calling evaluate_basis.
    _evaluate_basis(0, values, x, coordinate_dofs, cell_orientation);
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 0)
    {
    return ;
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Element is constant, calling evaluate_basis_derivatives.
    _evaluate_basis_derivatives(0, n, values, x, coordinate_dofs, cell_orientation);
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = 0.333333333333333*coordinate_dofs[0] + 0.333333333333333*coordinate_dofs[2] + 0.333333333333333*coordinate_dofs[4];
      y[1] = 0.333333333333333*coordinate_dofs[1] + 0.333333333333333*coordinate_dofs[3] + 0.333333333333333*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = 0.333333333333333*coordinate_dofs[0] + 0.333333333333333*coordinate_dofs[2] + 0.333333333333333*coordinate_dofs[4];
    y[1] = 0.333333333333333*coordinate_dofs[1] + 0.333333333333333*coordinate_dofs[3] + 0.333333333333333*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = 0.333333333333333*coordinate_dofs[0] + 0.333333333333333*coordinate_dofs[2] + 0.333333333333333*coordinate_dofs[4];
    dof_coordinates[1] = 0.333333333333333*coordinate_dofs[1] + 0.333333333333333*coordinate_dofs[3] + 0.333333333333333*coordinate_dofs[5];
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new elastodynamics_finite_element_2();
  }

};


class elastodynamics_dofmap_0: public ufc::dofmap
{
public:

  elastodynamics_dofmap_0() : ufc::dofmap()
  {
    // Do nothing
  }

  ~elastodynamics_dofmap_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Lagrange', triangle, 1)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return num_global_entities[0];
  }

  std::size_t num_element_dofs() const final override
  {
    return 3;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 2;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    dofs[0] = entity_indices[0][0];
    dofs[1] = entity_indices[0][1];
    dofs[2] = entity_indices[0][2];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new elastodynamics_dofmap_0();
  }

};


class elastodynamics_dofmap_1: public ufc::dofmap
{
public:

  elastodynamics_dofmap_1() : ufc::dofmap()
  {
    // Do nothing
  }

  ~elastodynamics_dofmap_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for VectorElement(FiniteElement('Lagrange', triangle, 1), dim=2)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return 2*num_global_entities[0];
  }

  std::size_t num_element_dofs() const final override
  {
    return 6;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 4;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    unsigned int offset = 0;
    dofs[0] = offset + entity_indices[0][0];
    dofs[1] = offset + entity_indices[0][1];
    dofs[2] = offset + entity_indices[0][2];
    offset += num_global_entities[0];
    dofs[3] = offset + entity_indices[0][0];
    dofs[4] = offset + entity_indices[0][1];
    dofs[5] = offset + entity_indices[0][2];
    offset += num_global_entities[0];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 4;
      dofs[3] = 5;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 5;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 2;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new elastodynamics_dofmap_0();
        break;
      }
    case 1:
      {
        return new elastodynamics_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new elastodynamics_dofmap_1();
  }

};


class elastodynamics_dofmap_2: public ufc::dofmap
{
public:

  elastodynamics_dofmap_2() : ufc::dofmap()
  {
    // Do nothing
  }

  ~elastodynamics_dofmap_2() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Discontinuous Lagrange', triangle, 0)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 2;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return num_global_entities[2];
  }

  std::size_t num_element_dofs() const final override
  {
    return 1;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 0;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    dofs[0] = entity_indices[2][0];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new elastodynamics_dofmap_2();
  }

};


class elastodynamics_cell_integral_0_otherwise: public ufc::cell_integral
{
public:

  elastodynamics_cell_integral_0_otherwise() : ufc::cell_integral()
  {
    
  }

  ~elastodynamics_cell_integral_0_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({true, true, true, true, true, true, true, true, true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute cell volume
    
    
    // Compute circumradius of triangle in 2D
    
    
    // Array of quadrature weights.
    static const double W3[3] = {0.166666666666667, 0.166666666666667, 0.166666666666667};
    // Quadrature points on the UFC reference element: (0.166666666666667, 0.166666666666667), (0.166666666666667, 0.666666666666667), (0.666666666666667, 0.166666666666667)
    
    // Values of basis functions at quadrature points.
    static const double FE1_C0[3][3] = \
    {{0.666666666666667, 0.166666666666667, 0.166666666666667},
    {0.166666666666667, 0.166666666666667, 0.666666666666667},
    {0.166666666666667, 0.666666666666667, 0.166666666666667}};
    
    // Array of non-zero columns
    static const unsigned int nzc0[3] = {0, 1, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc3[3] = {3, 4, 5};
    
    static const double FE1_C0_D01[3][2] = \
    {{-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc2[2] = {0, 1};
    
    // Array of non-zero columns
    static const unsigned int nzc4[2] = {3, 5};
    
    // Array of non-zero columns
    static const unsigned int nzc5[2] = {3, 4};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 36; r++)
    {
      A[r] = 0.0;
    } // end loop over 'r'
    // Number of operations to compute geometry constants: 137.
    double G[11];
    G[0] = (K[2]*K[2]*det*(w[2][0] + 2.0*w[3][0] + w[5][0]*( - w[2][0]-2.0*w[3][0])) + K[3]*K[3]*det*w[3][0]*(1.0 - w[5][0]));
    G[1] = (K[0]*K[2]*det*(w[2][0] + 2.0*w[3][0] + w[5][0]*( - w[2][0]-2.0*w[3][0])) + K[1]*K[3]*det*w[3][0]*(1.0 - w[5][0]));
    G[2] = K[2]*K[3]*det*(w[2][0] + w[3][0] - w[5][0]*(w[2][0] + w[3][0]));
    G[3] = det*(K[0]*K[3]*w[3][0]*(1.0 - w[5][0]) + K[1]*K[2]*w[2][0]*(1.0 - w[5][0]));
    G[4] = (K[0]*K[0]*det*(w[2][0] + 2.0*w[3][0] + w[5][0]*( - w[2][0]-2.0*w[3][0])) + K[1]*K[1]*det*w[3][0]*(1.0 - w[5][0]));
    G[5] = det*(K[0]*K[3]*w[2][0]*(1.0 - w[5][0]) + K[1]*K[2]*w[3][0]*(1.0 - w[5][0]));
    G[6] = K[0]*K[1]*det*(w[2][0] + w[3][0] - w[5][0]*(w[2][0] + w[3][0]));
    G[7] = (K[2]*K[2]*det*w[3][0]*(1.0 - w[5][0]) + K[3]*K[3]*det*(w[2][0] + 2.0*w[3][0] + w[5][0]*( - w[2][0]-2.0*w[3][0])));
    G[8] = (K[0]*K[2]*det*w[3][0]*(1.0 - w[5][0]) + K[1]*K[3]*det*(w[2][0] + 2.0*w[3][0] + w[5][0]*( - w[2][0]-2.0*w[3][0])));
    G[9] = (K[0]*K[0]*det*w[3][0]*(1.0 - w[5][0]) + K[1]*K[1]*det*(w[2][0] + 2.0*w[3][0] + w[5][0]*( - w[2][0]-2.0*w[3][0])));
    G[10] = det*((w[1][0]*w[7][0] - w[1][0]*w[5][0]*w[7][0])/(w[6][0]*w[8][0]) + (w[0][0] - w[0][0]*w[4][0])/(w[6][0]*w[8][0]*w[8][0]));
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 771
    for (unsigned int ip = 0; ip < 3; ip++)
    {
      
      // Number of operations to compute ip constants: 11
      double I[11];
      // Number of operations: 1
      I[0] = G[0]*W3[ip];
      
      // Number of operations: 1
      I[1] = G[1]*W3[ip];
      
      // Number of operations: 1
      I[2] = G[2]*W3[ip];
      
      // Number of operations: 1
      I[3] = G[3]*W3[ip];
      
      // Number of operations: 1
      I[4] = G[4]*W3[ip];
      
      // Number of operations: 1
      I[5] = G[5]*W3[ip];
      
      // Number of operations: 1
      I[6] = G[6]*W3[ip];
      
      // Number of operations: 1
      I[7] = G[7]*W3[ip];
      
      // Number of operations: 1
      I[8] = G[8]*W3[ip];
      
      // Number of operations: 1
      I[9] = G[9]*W3[ip];
      
      // Number of operations: 1
      I[10] = G[10]*W3[ip];
      
      
      // Number of operations for primary indices: 192
      for (unsigned int j = 0; j < 2; j++)
      {
        for (unsigned int k = 0; k < 2; k++)
        {
          // Number of operations to compute entry: 3
          A[nzc1[j]*6 + nzc1[k]] += FE1_C0_D01[ip][j]*FE1_C0_D01[ip][k]*I[0];
          // Number of operations to compute entry: 3
          A[nzc1[j]*6 + nzc2[k]] += FE1_C0_D01[ip][j]*FE1_C0_D01[ip][k]*I[1];
          // Number of operations to compute entry: 3
          A[nzc1[j]*6 + nzc4[k]] += FE1_C0_D01[ip][j]*FE1_C0_D01[ip][k]*I[2];
          // Number of operations to compute entry: 3
          A[nzc1[j]*6 + nzc5[k]] += FE1_C0_D01[ip][j]*FE1_C0_D01[ip][k]*I[3];
          // Number of operations to compute entry: 3
          A[nzc2[j]*6 + nzc1[k]] += FE1_C0_D01[ip][j]*FE1_C0_D01[ip][k]*I[1];
          // Number of operations to compute entry: 3
          A[nzc2[j]*6 + nzc2[k]] += FE1_C0_D01[ip][j]*FE1_C0_D01[ip][k]*I[4];
          // Number of operations to compute entry: 3
          A[nzc2[j]*6 + nzc4[k]] += FE1_C0_D01[ip][j]*FE1_C0_D01[ip][k]*I[5];
          // Number of operations to compute entry: 3
          A[nzc2[j]*6 + nzc5[k]] += FE1_C0_D01[ip][j]*FE1_C0_D01[ip][k]*I[6];
          // Number of operations to compute entry: 3
          A[nzc4[j]*6 + nzc1[k]] += FE1_C0_D01[ip][j]*FE1_C0_D01[ip][k]*I[2];
          // Number of operations to compute entry: 3
          A[nzc4[j]*6 + nzc2[k]] += FE1_C0_D01[ip][j]*FE1_C0_D01[ip][k]*I[5];
          // Number of operations to compute entry: 3
          A[nzc4[j]*6 + nzc4[k]] += FE1_C0_D01[ip][j]*FE1_C0_D01[ip][k]*I[7];
          // Number of operations to compute entry: 3
          A[nzc4[j]*6 + nzc5[k]] += FE1_C0_D01[ip][j]*FE1_C0_D01[ip][k]*I[8];
          // Number of operations to compute entry: 3
          A[nzc5[j]*6 + nzc1[k]] += FE1_C0_D01[ip][j]*FE1_C0_D01[ip][k]*I[3];
          // Number of operations to compute entry: 3
          A[nzc5[j]*6 + nzc2[k]] += FE1_C0_D01[ip][j]*FE1_C0_D01[ip][k]*I[6];
          // Number of operations to compute entry: 3
          A[nzc5[j]*6 + nzc4[k]] += FE1_C0_D01[ip][j]*FE1_C0_D01[ip][k]*I[8];
          // Number of operations to compute entry: 3
          A[nzc5[j]*6 + nzc5[k]] += FE1_C0_D01[ip][j]*FE1_C0_D01[ip][k]*I[9];
        } // end loop over 'k'
      } // end loop over 'j'
      
      // Number of operations for primary indices: 54
      for (unsigned int j = 0; j < 3; j++)
      {
        for (unsigned int k = 0; k < 3; k++)
        {
          // Number of operations to compute entry: 3
          A[nzc0[j]*6 + nzc0[k]] += FE1_C0[ip][j]*FE1_C0[ip][k]*I[10];
          // Number of operations to compute entry: 3
          A[nzc3[j]*6 + nzc3[k]] += FE1_C0[ip][j]*FE1_C0[ip][k]*I[10];
        } // end loop over 'k'
      } // end loop over 'j'
    } // end loop over 'ip'
  }

};


class elastodynamics_cell_integral_1_otherwise: public ufc::cell_integral
{
public:

  elastodynamics_cell_integral_1_otherwise() : ufc::cell_integral()
  {
    
  }

  ~elastodynamics_cell_integral_1_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({true, true, true, false, true, false, true, true, true, true, true, true, true, true, true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute cell volume
    
    
    // Compute circumradius of triangle in 2D
    
    
    // Array of quadrature weights.
    static const double W3[3] = {0.166666666666667, 0.166666666666667, 0.166666666666667};
    // Quadrature points on the UFC reference element: (0.166666666666667, 0.166666666666667), (0.166666666666667, 0.666666666666667), (0.666666666666667, 0.166666666666667)
    
    // Values of basis functions at quadrature points.
    static const double FE1_C0[3][3] = \
    {{0.666666666666667, 0.166666666666667, 0.166666666666667},
    {0.166666666666667, 0.166666666666667, 0.666666666666667},
    {0.166666666666667, 0.666666666666667, 0.166666666666667}};
    
    // Array of non-zero columns
    static const unsigned int nzc0[3] = {0, 1, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc3[3] = {3, 4, 5};
    
    static const double FE1_C0_D01[3][2] = \
    {{-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc2[2] = {0, 1};
    
    // Array of non-zero columns
    static const unsigned int nzc4[2] = {3, 5};
    
    // Array of non-zero columns
    static const unsigned int nzc5[2] = {3, 4};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 6; r++)
    {
      A[r] = 0.0;
    } // end loop over 'r'
    // Number of operations to compute geometry constants: 122.
    double G[13];
    G[0] = det*w[11][0]*(K[0]*K[2]*( - w[8][0]-2.0*w[9][0]) - K[1]*K[3]*w[9][0]);
    G[1] = det*w[11][0]*(K[2]*K[2]*( - w[8][0]-2.0*w[9][0]) - K[3]*K[3]*w[9][0]);
    G[2] =  - det*w[11][0]*(K[0]*K[3]*w[9][0] + K[1]*K[2]*w[8][0]);
    G[3] =  - K[2]*K[3]*det*w[11][0]*(w[8][0] + w[9][0]);
    G[4] = det*w[11][0]*(K[0]*K[0]*( - w[8][0]-2.0*w[9][0]) - K[1]*K[1]*w[9][0]);
    G[5] =  - K[0]*K[1]*det*w[11][0]*(w[8][0] + w[9][0]);
    G[6] =  - det*w[11][0]*(K[0]*K[3]*w[8][0] + K[1]*K[2]*w[9][0]);
    G[7] = det*w[11][0]*(K[1]*K[3]*( - w[8][0]-2.0*w[9][0]) - K[0]*K[2]*w[9][0]);
    G[8] = det*w[11][0]*(K[3]*K[3]*( - w[8][0]-2.0*w[9][0]) - K[2]*K[2]*w[9][0]);
    G[9] = det*w[11][0]*(K[1]*K[1]*( - w[8][0]-2.0*w[9][0]) - K[0]*K[0]*w[9][0]);
    G[10] = det*((w[13][0]*w[7][0] - w[11][0]*w[13][0]*w[7][0])/(w[12][0]*w[14][0]) + (w[6][0] - w[10][0]*w[6][0])/(w[12][0]*w[14][0]*w[14][0]));
    G[11] = det*(w[7][0]*((w[13][0] - w[11][0]*w[13][0])/w[12][0]-1.0) + (w[6][0] - w[10][0]*w[6][0])/(w[12][0]*w[14][0]));
    G[12] = det*(w[14][0]*w[7][0]*(w[11][0]-1.0) + (0.5*w[13][0]*w[14][0]*w[7][0] + 0.5*w[6][0]-0.5*w[10][0]*w[6][0]-0.5*w[11][0]*w[13][0]*w[14][0]*w[7][0])/w[12][0] - w[6][0]);
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 420
    for (unsigned int ip = 0; ip < 3; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      double F1 = 0.0;
      double F2 = 0.0;
      double F3 = 0.0;
      double F4 = 0.0;
      double F5 = 0.0;
      double F6 = 0.0;
      double F7 = 0.0;
      double F8 = 0.0;
      double F9 = 0.0;
      double F10 = 0.0;
      double F11 = 0.0;
      
      // Total number of operations to compute function values = 16
      for (unsigned int r = 0; r < 2; r++)
      {
        F0 += FE1_C0_D01[ip][r]*w[0][nzc2[r]];
        F1 += FE1_C0_D01[ip][r]*w[0][nzc1[r]];
        F2 += FE1_C0_D01[ip][r]*w[0][nzc5[r]];
        F3 += FE1_C0_D01[ip][r]*w[0][nzc4[r]];
      } // end loop over 'r'
      
      // Total number of operations to compute function values = 48
      for (unsigned int r = 0; r < 3; r++)
      {
        F4 += FE1_C0[ip][r]*w[0][nzc0[r]];
        F5 += FE1_C0[ip][r]*w[0][nzc3[r]];
        F6 += FE1_C0[ip][r]*w[1][nzc0[r]];
        F7 += FE1_C0[ip][r]*w[1][nzc3[r]];
        F8 += FE1_C0[ip][r]*w[2][nzc0[r]];
        F9 += FE1_C0[ip][r]*w[2][nzc3[r]];
        F10 += FE1_C0[ip][r]*w[4][nzc0[r]];
        F11 += FE1_C0[ip][r]*w[4][nzc3[r]];
      } // end loop over 'r'
      
      // Number of operations to compute ip constants: 48
      double I[6];
      // Number of operations: 8
      I[0] = W3[ip]*(F0*G[0] + F1*G[1] + F2*G[2] + F3*G[3]);
      
      // Number of operations: 8
      I[1] = W3[ip]*(F0*G[4] + F1*G[0] + F2*G[5] + F3*G[6]);
      
      // Number of operations: 8
      I[2] = W3[ip]*(F0*G[6] + F1*G[3] + F2*G[7] + F3*G[8]);
      
      // Number of operations: 8
      I[3] = W3[ip]*(F0*G[5] + F1*G[2] + F2*G[9] + F3*G[7]);
      
      // Number of operations: 8
      I[4] = W3[ip]*(F10*det + F4*G[10] + F6*G[11] + F8*G[12]);
      
      // Number of operations: 8
      I[5] = W3[ip]*(F11*det + F5*G[10] + F7*G[11] + F9*G[12]);
      
      
      // Number of operations for primary indices: 16
      for (unsigned int j = 0; j < 2; j++)
      {
        // Number of operations to compute entry: 2
        A[nzc1[j]] += FE1_C0_D01[ip][j]*I[0];
        // Number of operations to compute entry: 2
        A[nzc2[j]] += FE1_C0_D01[ip][j]*I[1];
        // Number of operations to compute entry: 2
        A[nzc4[j]] += FE1_C0_D01[ip][j]*I[2];
        // Number of operations to compute entry: 2
        A[nzc5[j]] += FE1_C0_D01[ip][j]*I[3];
      } // end loop over 'j'
      
      // Number of operations for primary indices: 12
      for (unsigned int j = 0; j < 3; j++)
      {
        // Number of operations to compute entry: 2
        A[nzc0[j]] += FE1_C0[ip][j]*I[4];
        // Number of operations to compute entry: 2
        A[nzc3[j]] += FE1_C0[ip][j]*I[5];
      } // end loop over 'j'
    } // end loop over 'ip'
  }

};


class elastodynamics_exterior_facet_integral_1_3: public ufc::exterior_facet_integral
{
public:

  elastodynamics_exterior_facet_integral_1_3() : ufc::exterior_facet_integral()
  {
    
  }

  ~elastodynamics_exterior_facet_integral_1_3() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({false, false, false, true, false, true, false, false, false, false, false, true, false, false, false});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       std::size_t facet,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      10
    // Number of operations (multiply-add pairs) for geometry tensor:    24
    // Number of operations (multiply-add pairs) for tensor contraction: 66
    // Total number of operations (multiply-add pairs):                  100
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet][0];
    const unsigned int v1 = edge_vertices[facet][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = coordinate_dofs[2*v1 + 0] - coordinate_dofs[2*v0 + 0];
    const double dx1 = coordinate_dofs[2*v1 + 1] - coordinate_dofs[2*v0 + 1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    
    // Compute geometry tensor
    const double G0_0_0 = det*w[11][0]*w[3][0]*(1.0);
    const double G0_0_1 = det*w[11][0]*w[3][1]*(1.0);
    const double G0_0_2 = det*w[11][0]*w[3][2]*(1.0);
    const double G0_0_3 = det*w[11][0]*w[3][3]*(1.0);
    const double G0_0_4 = det*w[11][0]*w[3][4]*(1.0);
    const double G0_0_5 = det*w[11][0]*w[3][5]*(1.0);
    const double G1_0 = det*w[5][0]*(1.0);
    const double G1_1 = det*w[5][1]*(1.0);
    const double G1_2 = det*w[5][2]*(1.0);
    const double G1_3 = det*w[5][3]*(1.0);
    const double G1_4 = det*w[5][4]*(1.0);
    const double G1_5 = det*w[5][5]*(1.0);
    const double G2_0_0 = det*w[11][0]*w[5][0]*(1.0);
    const double G2_0_1 = det*w[11][0]*w[5][1]*(1.0);
    const double G2_0_2 = det*w[11][0]*w[5][2]*(1.0);
    const double G2_0_3 = det*w[11][0]*w[5][3]*(1.0);
    const double G2_0_4 = det*w[11][0]*w[5][4]*(1.0);
    const double G2_0_5 = det*w[11][0]*w[5][5]*(1.0);
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.0;
      A[1] = 0.333333333333333*G0_0_1 + 0.166666666666667*G0_0_2 + 0.333333333333333*G1_1 + 0.166666666666667*G1_2 - 0.333333333333333*G2_0_1 - 0.166666666666667*G2_0_2;
      A[2] = 0.166666666666667*G0_0_1 + 0.333333333333333*G0_0_2 + 0.166666666666667*G1_1 + 0.333333333333333*G1_2 - 0.166666666666667*G2_0_1 - 0.333333333333333*G2_0_2;
      A[3] = 0.0;
      A[4] = 0.333333333333333*G0_0_4 + 0.166666666666667*G0_0_5 + 0.333333333333333*G1_4 + 0.166666666666667*G1_5 - 0.333333333333333*G2_0_4 - 0.166666666666667*G2_0_5;
      A[5] = 0.166666666666667*G0_0_4 + 0.333333333333333*G0_0_5 + 0.166666666666667*G1_4 + 0.333333333333333*G1_5 - 0.166666666666667*G2_0_4 - 0.333333333333333*G2_0_5;
        break;
      }
    case 1:
      {
        A[0] = 0.333333333333333*G0_0_0 + 0.166666666666667*G0_0_2 + 0.333333333333333*G1_0 + 0.166666666666667*G1_2 - 0.333333333333333*G2_0_0 - 0.166666666666667*G2_0_2;
      A[1] = 0.0;
      A[2] = 0.166666666666667*G0_0_0 + 0.333333333333333*G0_0_2 + 0.166666666666667*G1_0 + 0.333333333333333*G1_2 - 0.166666666666667*G2_0_0 - 0.333333333333333*G2_0_2;
      A[3] = 0.333333333333333*G0_0_3 + 0.166666666666667*G0_0_5 + 0.333333333333333*G1_3 + 0.166666666666667*G1_5 - 0.333333333333333*G2_0_3 - 0.166666666666667*G2_0_5;
      A[4] = 0.0;
      A[5] = 0.166666666666667*G0_0_3 + 0.333333333333333*G0_0_5 + 0.166666666666667*G1_3 + 0.333333333333333*G1_5 - 0.166666666666667*G2_0_3 - 0.333333333333333*G2_0_5;
        break;
      }
    case 2:
      {
        A[0] = 0.333333333333333*G0_0_0 + 0.166666666666667*G0_0_1 + 0.333333333333333*G1_0 + 0.166666666666667*G1_1 - 0.333333333333333*G2_0_0 - 0.166666666666667*G2_0_1;
      A[1] = 0.166666666666667*G0_0_0 + 0.333333333333333*G0_0_1 + 0.166666666666667*G1_0 + 0.333333333333333*G1_1 - 0.166666666666667*G2_0_0 - 0.333333333333333*G2_0_1;
      A[2] = 0.0;
      A[3] = 0.333333333333333*G0_0_3 + 0.166666666666667*G0_0_4 + 0.333333333333333*G1_3 + 0.166666666666667*G1_4 - 0.333333333333333*G2_0_3 - 0.166666666666667*G2_0_4;
      A[4] = 0.166666666666667*G0_0_3 + 0.333333333333333*G0_0_4 + 0.166666666666667*G1_3 + 0.333333333333333*G1_4 - 0.166666666666667*G2_0_3 - 0.333333333333333*G2_0_4;
      A[5] = 0.0;
        break;
      }
    }
    
  }

};


class elastodynamics_form_0: public ufc::form
{
public:

  elastodynamics_form_0() : ufc::form()
  {
    // Do nothing
  }

  ~elastodynamics_form_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "6c541f7759460b402a04f1560b655fdd887174999e90c7f0a0f42d512c75f07888110533868bc2d904e908c147e67001c02b9dd29c9ba26ded18f995c8b1b65d";
  }

  std::size_t rank() const final override
  {
    return 2;
  }

  std::size_t num_coefficients() const final override
  {
    return 9;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({0, 1, 2, 3, 4, 5, 6, 7, 8});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new elastodynamics_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new elastodynamics_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new elastodynamics_finite_element_1();
        break;
      }
    case 1:
      {
        return new elastodynamics_finite_element_1();
        break;
      }
    case 2:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    case 3:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    case 4:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    case 5:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    case 6:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    case 7:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    case 8:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    case 9:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    case 10:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new elastodynamics_dofmap_1();
        break;
      }
    case 1:
      {
        return new elastodynamics_dofmap_1();
        break;
      }
    case 2:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    case 3:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    case 4:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    case 5:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    case 6:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    case 7:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    case 8:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    case 9:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    case 10:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return false;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new elastodynamics_cell_integral_0_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};


class elastodynamics_form_1: public ufc::form
{
public:

  elastodynamics_form_1() : ufc::form()
  {
    // Do nothing
  }

  ~elastodynamics_form_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "d31ef110ea7a4f202b23fd18d4e630d0ae94523b57e863773903d64db2ae88aa3e72cd0bf208c3c932211164a093874304c6fa43955a3b1eac3e0188dc6a73f7";
  }

  std::size_t rank() const final override
  {
    return 1;
  }

  std::size_t num_coefficients() const final override
  {
    return 15;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new elastodynamics_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new elastodynamics_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new elastodynamics_finite_element_1();
        break;
      }
    case 1:
      {
        return new elastodynamics_finite_element_1();
        break;
      }
    case 2:
      {
        return new elastodynamics_finite_element_1();
        break;
      }
    case 3:
      {
        return new elastodynamics_finite_element_1();
        break;
      }
    case 4:
      {
        return new elastodynamics_finite_element_1();
        break;
      }
    case 5:
      {
        return new elastodynamics_finite_element_1();
        break;
      }
    case 6:
      {
        return new elastodynamics_finite_element_1();
        break;
      }
    case 7:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    case 8:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    case 9:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    case 10:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    case 11:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    case 12:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    case 13:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    case 14:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    case 15:
      {
        return new elastodynamics_finite_element_2();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new elastodynamics_dofmap_1();
        break;
      }
    case 1:
      {
        return new elastodynamics_dofmap_1();
        break;
      }
    case 2:
      {
        return new elastodynamics_dofmap_1();
        break;
      }
    case 3:
      {
        return new elastodynamics_dofmap_1();
        break;
      }
    case 4:
      {
        return new elastodynamics_dofmap_1();
        break;
      }
    case 5:
      {
        return new elastodynamics_dofmap_1();
        break;
      }
    case 6:
      {
        return new elastodynamics_dofmap_1();
        break;
      }
    case 7:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    case 8:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    case 9:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    case 10:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    case 11:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    case 12:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    case 13:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    case 14:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    case 15:
      {
        return new elastodynamics_dofmap_2();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 4;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return true;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    switch (subdomain_id)
    {
    case 3:
      {
        return new elastodynamics_exterior_facet_integral_1_3();
        break;
      }
    }
    
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new elastodynamics_cell_integral_1_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/mesh/Mesh.h>
#include <dolfin/mesh/MultiMesh.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/fem/MultiMeshForm.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/MultiMeshFunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>
#include <dolfin/function/MultiMeshCoefficientAssigner.h>
#include <dolfin/adaptivity/ErrorControl.h>
#include <dolfin/adaptivity/GoalFunctional.h>
#include <dolfin/la/GenericVector.h>

namespace ElastoDynamics
{

class CoefficientSpace_a0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_a0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_a0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_alpha_f: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_alpha_f(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_alpha_f(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_alpha_m: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_alpha_m(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_alpha_m(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_beta: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_beta(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_beta(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_dt: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_dt(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_dt(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_eta: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_eta(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_eta(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_f: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_f(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_f(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_gamma: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_gamma(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_gamma(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_lmbda: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_lmbda(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_lmbda(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_mu: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_mu(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_mu(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_p: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_p(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_p(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_p0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_p0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_p0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_rho: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_rho(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_rho(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_u0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_u0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_u0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class CoefficientSpace_v0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_v0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_v0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_a_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_a_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_a_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_a_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_a_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_a_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_a_MultiMeshFunctionSpace_0: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_a_MultiMeshFunctionSpace_0(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_a_FunctionSpace_0(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

class Form_a_MultiMeshFunctionSpace_1: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_a_MultiMeshFunctionSpace_1(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_a_FunctionSpace_1(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

typedef CoefficientSpace_rho Form_a_FunctionSpace_2;

typedef CoefficientSpace_eta Form_a_FunctionSpace_3;

typedef CoefficientSpace_lmbda Form_a_FunctionSpace_4;

typedef CoefficientSpace_mu Form_a_FunctionSpace_5;

typedef CoefficientSpace_alpha_m Form_a_FunctionSpace_6;

typedef CoefficientSpace_alpha_f Form_a_FunctionSpace_7;

typedef CoefficientSpace_beta Form_a_FunctionSpace_8;

typedef CoefficientSpace_gamma Form_a_FunctionSpace_9;

typedef CoefficientSpace_dt Form_a_FunctionSpace_10;

class Form_a: public dolfin::Form
{
public:

  // Constructor
  Form_a(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 9), rho(*this, 0), eta(*this, 1), lmbda(*this, 2), mu(*this, 3), alpha_m(*this, 4), alpha_f(*this, 5), beta(*this, 6), gamma(*this, 7), dt(*this, 8)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = std::make_shared<const elastodynamics_form_0>();
  }

  // Constructor
  Form_a(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> rho, std::shared_ptr<const dolfin::GenericFunction> eta, std::shared_ptr<const dolfin::GenericFunction> lmbda, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> alpha_m, std::shared_ptr<const dolfin::GenericFunction> alpha_f, std::shared_ptr<const dolfin::GenericFunction> beta, std::shared_ptr<const dolfin::GenericFunction> gamma, std::shared_ptr<const dolfin::GenericFunction> dt):
    dolfin::Form(2, 9), rho(*this, 0), eta(*this, 1), lmbda(*this, 2), mu(*this, 3), alpha_m(*this, 4), alpha_f(*this, 5), beta(*this, 6), gamma(*this, 7), dt(*this, 8)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->rho = rho;
    this->eta = eta;
    this->lmbda = lmbda;
    this->mu = mu;
    this->alpha_m = alpha_m;
    this->alpha_f = alpha_f;
    this->beta = beta;
    this->gamma = gamma;
    this->dt = dt;

    _ufc_form = std::make_shared<const elastodynamics_form_0>();
  }

  // Destructor
  ~Form_a()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "rho")
      return 0;
    else if (name == "eta")
      return 1;
    else if (name == "lmbda")
      return 2;
    else if (name == "mu")
      return 3;
    else if (name == "alpha_m")
      return 4;
    else if (name == "alpha_f")
      return 5;
    else if (name == "beta")
      return 6;
    else if (name == "gamma")
      return 7;
    else if (name == "dt")
      return 8;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "rho";
    case 1:
      return "eta";
    case 2:
      return "lmbda";
    case 3:
      return "mu";
    case 4:
      return "alpha_m";
    case 5:
      return "alpha_f";
    case 6:
      return "beta";
    case 7:
      return "gamma";
    case 8:
      return "dt";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_a_FunctionSpace_0 TestSpace;
  typedef Form_a_FunctionSpace_1 TrialSpace;
  typedef Form_a_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_a_MultiMeshFunctionSpace_1 MultiMeshTrialSpace;
  typedef Form_a_FunctionSpace_2 CoefficientSpace_rho;
  typedef Form_a_FunctionSpace_3 CoefficientSpace_eta;
  typedef Form_a_FunctionSpace_4 CoefficientSpace_lmbda;
  typedef Form_a_FunctionSpace_5 CoefficientSpace_mu;
  typedef Form_a_FunctionSpace_6 CoefficientSpace_alpha_m;
  typedef Form_a_FunctionSpace_7 CoefficientSpace_alpha_f;
  typedef Form_a_FunctionSpace_8 CoefficientSpace_beta;
  typedef Form_a_FunctionSpace_9 CoefficientSpace_gamma;
  typedef Form_a_FunctionSpace_10 CoefficientSpace_dt;

  // Coefficients
  dolfin::CoefficientAssigner rho;
  dolfin::CoefficientAssigner eta;
  dolfin::CoefficientAssigner lmbda;
  dolfin::CoefficientAssigner mu;
  dolfin::CoefficientAssigner alpha_m;
  dolfin::CoefficientAssigner alpha_f;
  dolfin::CoefficientAssigner beta;
  dolfin::CoefficientAssigner gamma;
  dolfin::CoefficientAssigner dt;
};

class MultiMeshForm_a: public dolfin::MultiMeshForm
{
public:

  // Constructor
  MultiMeshForm_a(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V1, std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0):
    dolfin::MultiMeshForm(V1, V0), rho(*this, 0), eta(*this, 1), lmbda(*this, 2), mu(*this, 3), alpha_m(*this, 4), alpha_f(*this, 5), beta(*this, 6), gamma(*this, 7), dt(*this, 8)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<const dolfin::Form> a(new Form_a(V1->part(part), V0->part(part)));
      add(a);
    }

    // Build multimesh form
    build();

    /// Assign coefficients

  }

  // Constructor
  MultiMeshForm_a(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V1, std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> rho, std::shared_ptr<const dolfin::GenericFunction> eta, std::shared_ptr<const dolfin::GenericFunction> lmbda, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> alpha_m, std::shared_ptr<const dolfin::GenericFunction> alpha_f, std::shared_ptr<const dolfin::GenericFunction> beta, std::shared_ptr<const dolfin::GenericFunction> gamma, std::shared_ptr<const dolfin::GenericFunction> dt):
    dolfin::MultiMeshForm(V1, V0), rho(*this, 0), eta(*this, 1), lmbda(*this, 2), mu(*this, 3), alpha_m(*this, 4), alpha_f(*this, 5), beta(*this, 6), gamma(*this, 7), dt(*this, 8)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<const dolfin::Form> a(new Form_a(V1->part(part), V0->part(part)));
      add(a);
    }

    // Build multimesh form
    build();

    /// Assign coefficients
    this->rho = rho;
    this->eta = eta;
    this->lmbda = lmbda;
    this->mu = mu;
    this->alpha_m = alpha_m;
    this->alpha_f = alpha_f;
    this->beta = beta;
    this->gamma = gamma;
    this->dt = dt;

  }

  // Destructor
  ~MultiMeshForm_a()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "rho")
      return 0;
    else if (name == "eta")
      return 1;
    else if (name == "lmbda")
      return 2;
    else if (name == "mu")
      return 3;
    else if (name == "alpha_m")
      return 4;
    else if (name == "alpha_f")
      return 5;
    else if (name == "beta")
      return 6;
    else if (name == "gamma")
      return 7;
    else if (name == "dt")
      return 8;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "rho";
    case 1:
      return "eta";
    case 2:
      return "lmbda";
    case 3:
      return "mu";
    case 4:
      return "alpha_m";
    case 5:
      return "alpha_f";
    case 6:
      return "beta";
    case 7:
      return "gamma";
    case 8:
      return "dt";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_a_FunctionSpace_0 TestSpace;
  typedef Form_a_FunctionSpace_1 TrialSpace;
  typedef Form_a_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_a_MultiMeshFunctionSpace_1 MultiMeshTrialSpace;
  typedef Form_a_FunctionSpace_2 CoefficientSpace_rho;
  typedef Form_a_FunctionSpace_3 CoefficientSpace_eta;
  typedef Form_a_FunctionSpace_4 CoefficientSpace_lmbda;
  typedef Form_a_FunctionSpace_5 CoefficientSpace_mu;
  typedef Form_a_FunctionSpace_6 CoefficientSpace_alpha_m;
  typedef Form_a_FunctionSpace_7 CoefficientSpace_alpha_f;
  typedef Form_a_FunctionSpace_8 CoefficientSpace_beta;
  typedef Form_a_FunctionSpace_9 CoefficientSpace_gamma;
  typedef Form_a_FunctionSpace_10 CoefficientSpace_dt;

  // Coefficients
  dolfin::MultiMeshCoefficientAssigner rho;
  dolfin::MultiMeshCoefficientAssigner eta;
  dolfin::MultiMeshCoefficientAssigner lmbda;
  dolfin::MultiMeshCoefficientAssigner mu;
  dolfin::MultiMeshCoefficientAssigner alpha_m;
  dolfin::MultiMeshCoefficientAssigner alpha_f;
  dolfin::MultiMeshCoefficientAssigner beta;
  dolfin::MultiMeshCoefficientAssigner gamma;
  dolfin::MultiMeshCoefficientAssigner dt;
};

class Form_L_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_L_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_L_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<elastodynamics_finite_element_1>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<elastodynamics_dofmap_1>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_L_MultiMeshFunctionSpace_0: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_L_MultiMeshFunctionSpace_0(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_L_FunctionSpace_0(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

typedef CoefficientSpace_u0 Form_L_FunctionSpace_1;

typedef CoefficientSpace_v0 Form_L_FunctionSpace_2;

typedef CoefficientSpace_a0 Form_L_FunctionSpace_3;

typedef CoefficientSpace_p0 Form_L_FunctionSpace_4;

typedef CoefficientSpace_f Form_L_FunctionSpace_5;

typedef CoefficientSpace_p Form_L_FunctionSpace_6;

typedef CoefficientSpace_rho Form_L_FunctionSpace_7;

typedef CoefficientSpace_eta Form_L_FunctionSpace_8;

typedef CoefficientSpace_lmbda Form_L_FunctionSpace_9;

typedef CoefficientSpace_mu Form_L_FunctionSpace_10;

typedef CoefficientSpace_alpha_m Form_L_FunctionSpace_11;

typedef CoefficientSpace_alpha_f Form_L_FunctionSpace_12;

typedef CoefficientSpace_beta Form_L_FunctionSpace_13;

typedef CoefficientSpace_gamma Form_L_FunctionSpace_14;

typedef CoefficientSpace_dt Form_L_FunctionSpace_15;

class Form_L: public dolfin::Form
{
public:

  // Constructor
  Form_L(std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 15), u0(*this, 0), v0(*this, 1), a0(*this, 2), p0(*this, 3), f(*this, 4), p(*this, 5), rho(*this, 6), eta(*this, 7), lmbda(*this, 8), mu(*this, 9), alpha_m(*this, 10), alpha_f(*this, 11), beta(*this, 12), gamma(*this, 13), dt(*this, 14)
  {
    _function_spaces[0] = V0;

    _ufc_form = std::make_shared<const elastodynamics_form_1>();
  }

  // Constructor
  Form_L(std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u0, std::shared_ptr<const dolfin::GenericFunction> v0, std::shared_ptr<const dolfin::GenericFunction> a0, std::shared_ptr<const dolfin::GenericFunction> p0, std::shared_ptr<const dolfin::GenericFunction> f, std::shared_ptr<const dolfin::GenericFunction> p, std::shared_ptr<const dolfin::GenericFunction> rho, std::shared_ptr<const dolfin::GenericFunction> eta, std::shared_ptr<const dolfin::GenericFunction> lmbda, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> alpha_m, std::shared_ptr<const dolfin::GenericFunction> alpha_f, std::shared_ptr<const dolfin::GenericFunction> beta, std::shared_ptr<const dolfin::GenericFunction> gamma, std::shared_ptr<const dolfin::GenericFunction> dt):
    dolfin::Form(1, 15), u0(*this, 0), v0(*this, 1), a0(*this, 2), p0(*this, 3), f(*this, 4), p(*this, 5), rho(*this, 6), eta(*this, 7), lmbda(*this, 8), mu(*this, 9), alpha_m(*this, 10), alpha_f(*this, 11), beta(*this, 12), gamma(*this, 13), dt(*this, 14)
  {
    _function_spaces[0] = V0;

    this->u0 = u0;
    this->v0 = v0;
    this->a0 = a0;
    this->p0 = p0;
    this->f = f;
    this->p = p;
    this->rho = rho;
    this->eta = eta;
    this->lmbda = lmbda;
    this->mu = mu;
    this->alpha_m = alpha_m;
    this->alpha_f = alpha_f;
    this->beta = beta;
    this->gamma = gamma;
    this->dt = dt;

    _ufc_form = std::make_shared<const elastodynamics_form_1>();
  }

  // Destructor
  ~Form_L()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u0")
      return 0;
    else if (name == "v0")
      return 1;
    else if (name == "a0")
      return 2;
    else if (name == "p0")
      return 3;
    else if (name == "f")
      return 4;
    else if (name == "p")
      return 5;
    else if (name == "rho")
      return 6;
    else if (name == "eta")
      return 7;
    else if (name == "lmbda")
      return 8;
    else if (name == "mu")
      return 9;
    else if (name == "alpha_m")
      return 10;
    else if (name == "alpha_f")
      return 11;
    else if (name == "beta")
      return 12;
    else if (name == "gamma")
      return 13;
    else if (name == "dt")
      return 14;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u0";
    case 1:
      return "v0";
    case 2:
      return "a0";
    case 3:
      return "p0";
    case 4:
      return "f";
    case 5:
      return "p";
    case 6:
      return "rho";
    case 7:
      return "eta";
    case 8:
      return "lmbda";
    case 9:
      return "mu";
    case 10:
      return "alpha_m";
    case 11:
      return "alpha_f";
    case 12:
      return "beta";
    case 13:
      return "gamma";
    case 14:
      return "dt";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_L_FunctionSpace_0 TestSpace;
  typedef Form_L_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_L_FunctionSpace_1 CoefficientSpace_u0;
  typedef Form_L_FunctionSpace_2 CoefficientSpace_v0;
  typedef Form_L_FunctionSpace_3 CoefficientSpace_a0;
  typedef Form_L_FunctionSpace_4 CoefficientSpace_p0;
  typedef Form_L_FunctionSpace_5 CoefficientSpace_f;
  typedef Form_L_FunctionSpace_6 CoefficientSpace_p;
  typedef Form_L_FunctionSpace_7 CoefficientSpace_rho;
  typedef Form_L_FunctionSpace_8 CoefficientSpace_eta;
  typedef Form_L_FunctionSpace_9 CoefficientSpace_lmbda;
  typedef Form_L_FunctionSpace_10 CoefficientSpace_mu;
  typedef Form_L_FunctionSpace_11 CoefficientSpace_alpha_m;
  typedef Form_L_FunctionSpace_12 CoefficientSpace_alpha_f;
  typedef Form_L_FunctionSpace_13 CoefficientSpace_beta;
  typedef Form_L_FunctionSpace_14 CoefficientSpace_gamma;
  typedef Form_L_FunctionSpace_15 CoefficientSpace_dt;

  // Coefficients
  dolfin::CoefficientAssigner u0;
  dolfin::CoefficientAssigner v0;
  dolfin::CoefficientAssigner a0;
  dolfin::CoefficientAssigner p0;
  dolfin::CoefficientAssigner f;
  dolfin::CoefficientAssigner p;
  dolfin::CoefficientAssigner rho;
  dolfin::CoefficientAssigner eta;
  dolfin::CoefficientAssigner lmbda;
  dolfin::CoefficientAssigner mu;
  dolfin::CoefficientAssigner alpha_m;
  dolfin::CoefficientAssigner alpha_f;
  dolfin::CoefficientAssigner beta;
  dolfin::CoefficientAssigner gamma;
  dolfin::CoefficientAssigner dt;
};

class MultiMeshForm_L: public dolfin::MultiMeshForm
{
public:

  // Constructor
  MultiMeshForm_L(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0):
    dolfin::MultiMeshForm(V0), u0(*this, 0), v0(*this, 1), a0(*this, 2), p0(*this, 3), f(*this, 4), p(*this, 5), rho(*this, 6), eta(*this, 7), lmbda(*this, 8), mu(*this, 9), alpha_m(*this, 10), alpha_f(*this, 11), beta(*this, 12), gamma(*this, 13), dt(*this, 14)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<const dolfin::Form> a(new Form_L(V0->part(part)));
      add(a);
    }

    // Build multimesh form
    build();

    /// Assign coefficients

  }

  // Constructor
  MultiMeshForm_L(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u0, std::shared_ptr<const dolfin::GenericFunction> v0, std::shared_ptr<const dolfin::GenericFunction> a0, std::shared_ptr<const dolfin::GenericFunction> p0, std::shared_ptr<const dolfin::GenericFunction> f, std::shared_ptr<const dolfin::GenericFunction> p, std::shared_ptr<const dolfin::GenericFunction> rho, std::shared_ptr<const dolfin::GenericFunction> eta, std::shared_ptr<const dolfin::GenericFunction> lmbda, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> alpha_m, std::shared_ptr<const dolfin::GenericFunction> alpha_f, std::shared_ptr<const dolfin::GenericFunction> beta, std::shared_ptr<const dolfin::GenericFunction> gamma, std::shared_ptr<const dolfin::GenericFunction> dt):
    dolfin::MultiMeshForm(V0), u0(*this, 0), v0(*this, 1), a0(*this, 2), p0(*this, 3), f(*this, 4), p(*this, 5), rho(*this, 6), eta(*this, 7), lmbda(*this, 8), mu(*this, 9), alpha_m(*this, 10), alpha_f(*this, 11), beta(*this, 12), gamma(*this, 13), dt(*this, 14)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<const dolfin::Form> a(new Form_L(V0->part(part)));
      add(a);
    }

    // Build multimesh form
    build();

    /// Assign coefficients
    this->u0 = u0;
    this->v0 = v0;
    this->a0 = a0;
    this->p0 = p0;
    this->f = f;
    this->p = p;
    this->rho = rho;
    this->eta = eta;
    this->lmbda = lmbda;
    this->mu = mu;
    this->alpha_m = alpha_m;
    this->alpha_f = alpha_f;
    this->beta = beta;
    this->gamma = gamma;
    this->dt = dt;

  }

  // Destructor
  ~MultiMeshForm_L()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u0")
      return 0;
    else if (name == "v0")
      return 1;
    else if (name == "a0")
      return 2;
    else if (name == "p0")
      return 3;
    else if (name == "f")
      return 4;
    else if (name == "p")
      return 5;
    else if (name == "rho")
      return 6;
    else if (name == "eta")
      return 7;
    else if (name == "lmbda")
      return 8;
    else if (name == "mu")
      return 9;
    else if (name == "alpha_m")
      return 10;
    else if (name == "alpha_f")
      return 11;
    else if (name == "beta")
      return 12;
    else if (name == "gamma")
      return 13;
    else if (name == "dt")
      return 14;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u0";
    case 1:
      return "v0";
    case 2:
      return "a0";
    case 3:
      return "p0";
    case 4:
      return "f";
    case 5:
      return "p";
    case 6:
      return "rho";
    case 7:
      return "eta";
    case 8:
      return "lmbda";
    case 9:
      return "mu";
    case 10:
      return "alpha_m";
    case 11:
      return "alpha_f";
    case 12:
      return "beta";
    case 13:
      return "gamma";
    case 14:
      return "dt";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_L_FunctionSpace_0 TestSpace;
  typedef Form_L_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_L_FunctionSpace_1 CoefficientSpace_u0;
  typedef Form_L_FunctionSpace_2 CoefficientSpace_v0;
  typedef Form_L_FunctionSpace_3 CoefficientSpace_a0;
  typedef Form_L_FunctionSpace_4 CoefficientSpace_p0;
  typedef Form_L_FunctionSpace_5 CoefficientSpace_f;
  typedef Form_L_FunctionSpace_6 CoefficientSpace_p;
  typedef Form_L_FunctionSpace_7 CoefficientSpace_rho;
  typedef Form_L_FunctionSpace_8 CoefficientSpace_eta;
  typedef Form_L_FunctionSpace_9 CoefficientSpace_lmbda;
  typedef Form_L_FunctionSpace_10 CoefficientSpace_mu;
  typedef Form_L_FunctionSpace_11 CoefficientSpace_alpha_m;
  typedef Form_L_FunctionSpace_12 CoefficientSpace_alpha_f;
  typedef Form_L_FunctionSpace_13 CoefficientSpace_beta;
  typedef Form_L_FunctionSpace_14 CoefficientSpace_gamma;
  typedef Form_L_FunctionSpace_15 CoefficientSpace_dt;

  // Coefficients
  dolfin::MultiMeshCoefficientAssigner u0;
  dolfin::MultiMeshCoefficientAssigner v0;
  dolfin::MultiMeshCoefficientAssigner a0;
  dolfin::MultiMeshCoefficientAssigner p0;
  dolfin::MultiMeshCoefficientAssigner f;
  dolfin::MultiMeshCoefficientAssigner p;
  dolfin::MultiMeshCoefficientAssigner rho;
  dolfin::MultiMeshCoefficientAssigner eta;
  dolfin::MultiMeshCoefficientAssigner lmbda;
  dolfin::MultiMeshCoefficientAssigner mu;
  dolfin::MultiMeshCoefficientAssigner alpha_m;
  dolfin::MultiMeshCoefficientAssigner alpha_f;
  dolfin::MultiMeshCoefficientAssigner beta;
  dolfin::MultiMeshCoefficientAssigner gamma;
  dolfin::MultiMeshCoefficientAssigner dt;
};

// Class typedefs
typedef Form_a BilinearForm;
typedef MultiMeshForm_a MultiMeshBilinearForm;
typedef Form_a JacobianForm;
typedef MultiMeshForm_a MultiMeshJacobianForm;
typedef Form_L LinearForm;
typedef MultiMeshForm_L MultiMeshLinearForm;
typedef Form_L ResidualForm;
typedef MultiMeshForm_L MultiMeshResidualForm;
typedef Form_a::TestSpace FunctionSpace;
typedef Form_a::MultiMeshTestSpace MultiMeshFunctionSpace;

}

#endif
