// This code conforms with the UFC specification version 2016.1.0
// and was automatically generated by FFC version 2016.1.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   optimize:                       True
//   precision:                      15
//   quadrature_degree:              -1
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __PROJECTION_H
#define __PROJECTION_H
#include <stdexcept>
#include <ufc.h>

class projection_finite_element_0: public ufc::finite_element
{
public:

  projection_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  ~projection_finite_element_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Lagrange', tetrahedron, 1)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::tetrahedron;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t geometric_dimension() const final override
  {
    return 3;
  }

  std::size_t space_dimension() const final override
  {
    return 4;
  }

  std::size_t value_rank() const final override
  {
    return 0;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t value_size() const final override
  {
    return 1;
  }

  std::size_t reference_value_rank() const final override
  {
    return 0;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t reference_value_size() const final override
  {
    return 1;
  }

  std::size_t degree() const final override
  {
    return 1;
  }

  const char * family() const final override
  {
    return "Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 4; r++)
    {
      _evaluate_basis(r, &dof_values, x, coordinate_dofs, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[3][1];
    for (unsigned int row = 0; row < 3; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[3][3];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[3];
    for (unsigned int r = 0; r < 3; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 4; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[6];
    dof_coordinates[7] = coordinate_dofs[7];
    dof_coordinates[8] = coordinate_dofs[8];
    dof_coordinates[9] = coordinate_dofs[9];
    dof_coordinates[10] = coordinate_dofs[10];
    dof_coordinates[11] = coordinate_dofs[11];
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new projection_finite_element_0();
  }

};


class projection_finite_element_1: public ufc::finite_element
{
public:

  projection_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  ~projection_finite_element_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "VectorElement(FiniteElement('Lagrange', tetrahedron, 1), dim=3)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::tetrahedron;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t geometric_dimension() const final override
  {
    return 3;
  }

  std::size_t space_dimension() const final override
  {
    return 12;
  }

  std::size_t value_rank() const final override
  {
    return 1;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  std::size_t value_size() const final override
  {
    return 3;
  }

  std::size_t reference_value_rank() const final override
  {
    return 1;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  std::size_t reference_value_size() const final override
  {
    return 3;
  }

  std::size_t degree() const final override
  {
    return 1;
  }

  const char * family() const final override
  {
    return "Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    values[2] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values[3] = {0.0, 0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 12; r++)
    {
      _evaluate_basis(r, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 3; s++)
      {
        values[r*3 + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[3][1];
    for (unsigned int row = 0; row < 3; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[3][3];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 12; r++)
    {
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[9];
    for (unsigned int r = 0; r < 9; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 12; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 6:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 7:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 8:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 9:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 10:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 11:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[4] = vals[1];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[5] = vals[1];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[6] = vals[1];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[7] = vals[1];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[8] = vals[2];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[9] = vals[2];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[10] = vals[2];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[11] = vals[2];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[3] = dof_values[1];
    vertex_values[6] = dof_values[2];
    vertex_values[9] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[4];
    vertex_values[4] = dof_values[5];
    vertex_values[7] = dof_values[6];
    vertex_values[10] = dof_values[7];
    // Evaluate function and change variables
    vertex_values[2] = dof_values[8];
    vertex_values[5] = dof_values[9];
    vertex_values[8] = dof_values[10];
    vertex_values[11] = dof_values[11];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[6];
    dof_coordinates[7] = coordinate_dofs[7];
    dof_coordinates[8] = coordinate_dofs[8];
    dof_coordinates[9] = coordinate_dofs[9];
    dof_coordinates[10] = coordinate_dofs[10];
    dof_coordinates[11] = coordinate_dofs[11];
    dof_coordinates[12] = coordinate_dofs[0];
    dof_coordinates[13] = coordinate_dofs[1];
    dof_coordinates[14] = coordinate_dofs[2];
    dof_coordinates[15] = coordinate_dofs[3];
    dof_coordinates[16] = coordinate_dofs[4];
    dof_coordinates[17] = coordinate_dofs[5];
    dof_coordinates[18] = coordinate_dofs[6];
    dof_coordinates[19] = coordinate_dofs[7];
    dof_coordinates[20] = coordinate_dofs[8];
    dof_coordinates[21] = coordinate_dofs[9];
    dof_coordinates[22] = coordinate_dofs[10];
    dof_coordinates[23] = coordinate_dofs[11];
    dof_coordinates[24] = coordinate_dofs[0];
    dof_coordinates[25] = coordinate_dofs[1];
    dof_coordinates[26] = coordinate_dofs[2];
    dof_coordinates[27] = coordinate_dofs[3];
    dof_coordinates[28] = coordinate_dofs[4];
    dof_coordinates[29] = coordinate_dofs[5];
    dof_coordinates[30] = coordinate_dofs[6];
    dof_coordinates[31] = coordinate_dofs[7];
    dof_coordinates[32] = coordinate_dofs[8];
    dof_coordinates[33] = coordinate_dofs[9];
    dof_coordinates[34] = coordinate_dofs[10];
    dof_coordinates[35] = coordinate_dofs[11];
  }

  std::size_t num_sub_elements() const final override
  {
    return 3;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new projection_finite_element_0();
        break;
      }
    case 1:
      {
        return new projection_finite_element_0();
        break;
      }
    case 2:
      {
        return new projection_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new projection_finite_element_1();
  }

};


class projection_finite_element_2: public ufc::finite_element
{
public:

  projection_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  ~projection_finite_element_2() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FiniteElement('Lagrange', tetrahedron, 2)";
  }

  ufc::shape cell_shape() const final override
  {
    return ufc::shape::tetrahedron;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t geometric_dimension() const final override
  {
    return 3;
  }

  std::size_t space_dimension() const final override
  {
    return 10;
  }

  std::size_t value_rank() const final override
  {
    return 0;
  }

  std::size_t value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t value_size() const final override
  {
    return 1;
  }

  std::size_t reference_value_rank() const final override
  {
    return 0;
  }

  std::size_t reference_value_dimension(std::size_t i) const final override
  {
    return 1;
  }

  std::size_t reference_value_size() const final override
  {
    return 1;
  }

  std::size_t degree() const final override
  {
    return 2;
  }

  const char * family() const final override
  {
    return "Lagrange";
  }

  static void _evaluate_basis(std::size_t i,
                              double * values,
                              const double * x,
                              const double * coordinate_dofs,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.0577350269189625, -0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, 0.050395263067897, 0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.0577350269189625, 0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, -0.050395263067897, -0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0702728368926307, -0.0248451997499977, 0.0, 0.0, 0.0, 0.0872871560943969, -0.0475131096733199, 0.0167984210226323};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0, 0.074535599249993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.100790526135794};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, 0.140545673785261, 0.0993807989999907, 0.0, 0.0, 0.0, 0.0, 0.1187827741833, -0.0671936840905293};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, -0.0702728368926307, 0.0993807989999907, 0.0, 0.0, 0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, 0.0702728368926307, -0.0993807989999906, 0.0, 0.100790526135794, -0.0205737799949456, -0.087287156094397, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, -0.0702728368926306, 0.0993807989999906, 0.0, 0.0, -0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, 0.0702728368926306, -0.0993807989999906, 0.0, -0.100790526135794, 0.0205737799949456, -0.0872871560943969, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, -0.140545673785261, -0.0993807989999906, -0.130120009726471, 0.0, 0.0, 0.0290957186981323, 0.02375655483666, 0.0167984210226323};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis(std::size_t i,
                      double * values,
                      const double * x,
                      const double * coordinate_dofs,
                      int cell_orientation) const final override
  {
    _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_all(double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 10; r++)
    {
      _evaluate_basis(r, &dof_values, x, coordinate_dofs, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
  }

  void evaluate_basis_all(double * values,
                          const double * x,
                          const double * coordinate_dofs,
                          int cell_orientation) const final override
  {
    _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double * values,
                                          const double * x,
                                          const double * coordinate_dofs,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 2)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = coordinate_dofs[9]  + coordinate_dofs[6] + coordinate_dofs[3]  - coordinate_dofs[0];
    const double C1 = coordinate_dofs[10] + coordinate_dofs[7] + coordinate_dofs[4]  - coordinate_dofs[1];
    const double C2 = coordinate_dofs[11] + coordinate_dofs[8] + coordinate_dofs[5]  - coordinate_dofs[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[9][2];
    for (unsigned int row = 0; row < 9; row++)
    {
      for (unsigned int col = 0; col < 2; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[9][9];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.0577350269189625, -0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, 0.050395263067897, 0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.59160797830997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267037, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.0577350269189625, 0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, -0.050395263067897, -0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.59160797830997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267037, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0702728368926307, -0.0248451997499977, 0.0, 0.0, 0.0, 0.0872871560943969, -0.0475131096733199, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.59160797830997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267037, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0, 0.074535599249993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.100790526135794};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.59160797830997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267037, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, 0.140545673785261, 0.0993807989999907, 0.0, 0.0, 0.0, 0.0, 0.1187827741833, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.59160797830997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267037, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, -0.0702728368926307, 0.0993807989999907, 0.0, 0.0, 0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.59160797830997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267037, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, 0.0702728368926307, -0.0993807989999906, 0.0, 0.100790526135794, -0.0205737799949456, -0.087287156094397, -0.01187827741833, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.59160797830997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267037, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, -0.0702728368926306, 0.0993807989999906, 0.0, 0.0, -0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.59160797830997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267037, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, 0.0702728368926306, -0.0993807989999906, 0.0, -0.100790526135794, 0.0205737799949456, -0.0872871560943969, -0.01187827741833, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.59160797830997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267037, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, -0.140545673785261, -0.0993807989999906, -0.130120009726471, 0.0, 0.0, 0.0290957186981323, 0.02375655483666, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, 0.0, 8.36660026534076, -1.18321595661993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, 0.0, 0.0, 8.69482604771367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747796, 7.24568837309473, 4.18330013267038, -0.59160797830997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338698, 0.0, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106462, 0.0, 9.66091783079296, 0.683130051063982, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267037, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338701, 7.09929573971955, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553231, 0.0, 3.86436713231719, -0.34156502553199, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973463, 0.0, 7.09929573971954, 2.50998007960221, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912991, 0.0, 0.0, 8.87411967464943, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[9];
      for (unsigned int r = 0; r < 9; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  void evaluate_basis_derivatives(std::size_t i,
                                  std::size_t n,
                                  double * values,
                                  const double * x,
                                  const double * coordinate_dofs,
                                  int cell_orientation) const final override
  {
    _evaluate_basis_derivatives(i, n, values, x, coordinate_dofs, cell_orientation);
  }

  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double * values,
                                              const double * x,
                                              const double * coordinate_dofs,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 10; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 2)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[9];
    for (unsigned int r = 0; r < 9; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  void evaluate_basis_derivatives_all(std::size_t n,
                                      double * values,
                                      const double * x,
                                      const double * coordinate_dofs,
                                      int cell_orientation) const final override
  {
    _evaluate_basis_derivatives_all(n, values, x, coordinate_dofs, cell_orientation);
  }

  double evaluate_dof(std::size_t i,
                      const ufc::function& f,
                      const double * coordinate_dofs,
                      int cell_orientation,
                      const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      y[2] = coordinate_dofs[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[3];
      y[1] = coordinate_dofs[4];
      y[2] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[6];
      y[1] = coordinate_dofs[7];
      y[2] = coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[9];
      y[1] = coordinate_dofs[10];
      y[2] = coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*coordinate_dofs[6] + 0.5*coordinate_dofs[9];
      y[1] = 0.5*coordinate_dofs[7] + 0.5*coordinate_dofs[10];
      y[2] = 0.5*coordinate_dofs[8] + 0.5*coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*coordinate_dofs[3] + 0.5*coordinate_dofs[9];
      y[1] = 0.5*coordinate_dofs[4] + 0.5*coordinate_dofs[10];
      y[2] = 0.5*coordinate_dofs[5] + 0.5*coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.5*coordinate_dofs[3] + 0.5*coordinate_dofs[6];
      y[1] = 0.5*coordinate_dofs[4] + 0.5*coordinate_dofs[7];
      y[2] = 0.5*coordinate_dofs[5] + 0.5*coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[9];
      y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[10];
      y[2] = 0.5*coordinate_dofs[2] + 0.5*coordinate_dofs[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[6];
      y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[7];
      y[2] = 0.5*coordinate_dofs[2] + 0.5*coordinate_dofs[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[3];
      y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[4];
      y[2] = 0.5*coordinate_dofs[2] + 0.5*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  void evaluate_dofs(double * values,
                             const ufc::function& f,
                             const double * coordinate_dofs,
                             int cell_orientation,
                             const ufc::cell& c) const final override
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    y[2] = coordinate_dofs[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[3];
    y[1] = coordinate_dofs[4];
    y[2] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[6];
    y[1] = coordinate_dofs[7];
    y[2] = coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = coordinate_dofs[9];
    y[1] = coordinate_dofs[10];
    y[2] = coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*coordinate_dofs[6] + 0.5*coordinate_dofs[9];
    y[1] = 0.5*coordinate_dofs[7] + 0.5*coordinate_dofs[10];
    y[2] = 0.5*coordinate_dofs[8] + 0.5*coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*coordinate_dofs[3] + 0.5*coordinate_dofs[9];
    y[1] = 0.5*coordinate_dofs[4] + 0.5*coordinate_dofs[10];
    y[2] = 0.5*coordinate_dofs[5] + 0.5*coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.5*coordinate_dofs[3] + 0.5*coordinate_dofs[6];
    y[1] = 0.5*coordinate_dofs[4] + 0.5*coordinate_dofs[7];
    y[2] = 0.5*coordinate_dofs[5] + 0.5*coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[9];
    y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[10];
    y[2] = 0.5*coordinate_dofs[2] + 0.5*coordinate_dofs[11];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[6];
    y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[7];
    y[2] = 0.5*coordinate_dofs[2] + 0.5*coordinate_dofs[8];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[3];
    y[1] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[4];
    y[2] = 0.5*coordinate_dofs[2] + 0.5*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
  }

  void interpolate_vertex_values(double * vertex_values,
                                 const double * dof_values,
                                 const double * coordinate_dofs,
                                 int cell_orientation,
                                 const ufc::cell& c) const final override
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  void tabulate_dof_coordinates(double * dof_coordinates,
                                const double * coordinate_dofs) const final override
  {
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[6];
    dof_coordinates[7] = coordinate_dofs[7];
    dof_coordinates[8] = coordinate_dofs[8];
    dof_coordinates[9] = coordinate_dofs[9];
    dof_coordinates[10] = coordinate_dofs[10];
    dof_coordinates[11] = coordinate_dofs[11];
    dof_coordinates[12] = 0.5*coordinate_dofs[6] + 0.5*coordinate_dofs[9];
    dof_coordinates[13] = 0.5*coordinate_dofs[7] + 0.5*coordinate_dofs[10];
    dof_coordinates[14] = 0.5*coordinate_dofs[8] + 0.5*coordinate_dofs[11];
    dof_coordinates[15] = 0.5*coordinate_dofs[3] + 0.5*coordinate_dofs[9];
    dof_coordinates[16] = 0.5*coordinate_dofs[4] + 0.5*coordinate_dofs[10];
    dof_coordinates[17] = 0.5*coordinate_dofs[5] + 0.5*coordinate_dofs[11];
    dof_coordinates[18] = 0.5*coordinate_dofs[3] + 0.5*coordinate_dofs[6];
    dof_coordinates[19] = 0.5*coordinate_dofs[4] + 0.5*coordinate_dofs[7];
    dof_coordinates[20] = 0.5*coordinate_dofs[5] + 0.5*coordinate_dofs[8];
    dof_coordinates[21] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[9];
    dof_coordinates[22] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[10];
    dof_coordinates[23] = 0.5*coordinate_dofs[2] + 0.5*coordinate_dofs[11];
    dof_coordinates[24] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[6];
    dof_coordinates[25] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[7];
    dof_coordinates[26] = 0.5*coordinate_dofs[2] + 0.5*coordinate_dofs[8];
    dof_coordinates[27] = 0.5*coordinate_dofs[0] + 0.5*coordinate_dofs[3];
    dof_coordinates[28] = 0.5*coordinate_dofs[1] + 0.5*coordinate_dofs[4];
    dof_coordinates[29] = 0.5*coordinate_dofs[2] + 0.5*coordinate_dofs[5];
  }

  std::size_t num_sub_elements() const final override
  {
    return 0;
  }

  ufc::finite_element * create_sub_element(std::size_t i) const final override
  {
    return 0;
  }

  ufc::finite_element * create() const final override
  {
    return new projection_finite_element_2();
  }

};


class projection_dofmap_0: public ufc::dofmap
{
public:

  projection_dofmap_0() : ufc::dofmap()
  {
    // Do nothing
  }

  ~projection_dofmap_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Lagrange', tetrahedron, 1)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return num_global_entities[0];
  }

  std::size_t num_element_dofs() const final override
  {
    return 4;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 3;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    dofs[0] = entity_indices[0][0];
    dofs[1] = entity_indices[0][1];
    dofs[2] = entity_indices[0][2];
    dofs[3] = entity_indices[0][3];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new projection_dofmap_0();
  }

};


class projection_dofmap_1: public ufc::dofmap
{
public:

  projection_dofmap_1() : ufc::dofmap()
  {
    // Do nothing
  }

  ~projection_dofmap_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for VectorElement(FiniteElement('Lagrange', tetrahedron, 1), dim=3)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return 3*num_global_entities[0];
  }

  std::size_t num_element_dofs() const final override
  {
    return 12;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 9;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 3;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    unsigned int offset = 0;
    dofs[0] = offset + entity_indices[0][0];
    dofs[1] = offset + entity_indices[0][1];
    dofs[2] = offset + entity_indices[0][2];
    dofs[3] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[4] = offset + entity_indices[0][0];
    dofs[5] = offset + entity_indices[0][1];
    dofs[6] = offset + entity_indices[0][2];
    dofs[7] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[8] = offset + entity_indices[0][0];
    dofs[9] = offset + entity_indices[0][1];
    dofs[10] = offset + entity_indices[0][2];
    dofs[11] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 9;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 11;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 10;
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 4;
        dofs[2] = 8;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 5;
        dofs[2] = 9;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 6;
        dofs[2] = 10;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 7;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 3;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new projection_dofmap_0();
        break;
      }
    case 1:
      {
        return new projection_dofmap_0();
        break;
      }
    case 2:
      {
        return new projection_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new projection_dofmap_1();
  }

};


class projection_dofmap_2: public ufc::dofmap
{
public:

  projection_dofmap_2() : ufc::dofmap()
  {
    // Do nothing
  }

  ~projection_dofmap_2() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "FFC dofmap for FiniteElement('Lagrange', tetrahedron, 2)";
  }

  bool needs_mesh_entities(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  std::size_t topological_dimension() const final override
  {
    return 3;
  }

  std::size_t global_dimension(const std::vector<std::size_t>&
                               num_global_entities) const final override
  {
    return num_global_entities[0] + num_global_entities[1];
  }

  std::size_t num_element_dofs() const final override
  {
    return 10;
  }

  std::size_t num_facet_dofs() const final override
  {
    return 6;
  }

  std::size_t num_entity_dofs(std::size_t d) const final override
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  void tabulate_dofs(std::size_t * dofs,
                     const std::vector<std::size_t>& num_global_entities,
                     const std::vector<std::vector<std::size_t>>& entity_indices) const final override
  {
    unsigned int offset = 0;
    dofs[0] = offset + entity_indices[0][0];
    dofs[1] = offset + entity_indices[0][1];
    dofs[2] = offset + entity_indices[0][2];
    dofs[3] = offset + entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[4] = offset + entity_indices[1][0];
    dofs[5] = offset + entity_indices[1][1];
    dofs[6] = offset + entity_indices[1][2];
    dofs[7] = offset + entity_indices[1][3];
    dofs[8] = offset + entity_indices[1][4];
    dofs[9] = offset + entity_indices[1][5];
    offset += num_global_entities[1];
  }

  void tabulate_facet_dofs(std::size_t * dofs,
                           std::size_t facet) const final override
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 7;
      dofs[5] = 8;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 7;
      dofs[5] = 9;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 6;
      dofs[4] = 8;
      dofs[5] = 9;
        break;
      }
    }
    
  }

  void tabulate_entity_dofs(std::size_t * dofs,
                            std::size_t d, std::size_t i) const final override
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      throw std::runtime_error("i is larger than number of entities (5)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 6;
          break;
        }
      case 3:
        {
          dofs[0] = 7;
          break;
        }
      case 4:
        {
          dofs[0] = 8;
          break;
        }
      case 5:
        {
          dofs[0] = 9;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }


  std::size_t num_sub_dofmaps() const final override
  {
    return 0;
  }

  ufc::dofmap * create_sub_dofmap(std::size_t i) const final override
  {
    return 0;
  }

  ufc::dofmap * create() const final override
  {
    return new projection_dofmap_2();
  }

};


class projection_cell_integral_0_otherwise: public ufc::cell_integral
{
public:

  projection_cell_integral_0_otherwise() : ufc::cell_integral()
  {
    
  }

  ~projection_cell_integral_0_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    0
    // Number of operations (multiply-add pairs) for tensor contraction: 50
    // Total number of operations (multiply-add pairs):                  53
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_ = det;
    
    // Compute element tensor
    A[0] = 0.00238095238095238*G0_;
    A[1] = 0.000396825396825395*G0_;
    A[2] = 0.000396825396825396*G0_;
    A[3] = 0.000396825396825396*G0_;
    A[4] = -0.00238095238095238*G0_;
    A[5] = -0.00238095238095238*G0_;
    A[6] = -0.00238095238095238*G0_;
    A[7] = -0.00158730158730158*G0_;
    A[8] = -0.00158730158730158*G0_;
    A[9] = -0.00158730158730158*G0_;
    A[10] = 0.000396825396825395*G0_;
    A[11] = 0.00238095238095238*G0_;
    A[12] = 0.000396825396825396*G0_;
    A[13] = 0.000396825396825396*G0_;
    A[14] = -0.00238095238095238*G0_;
    A[15] = -0.00158730158730158*G0_;
    A[16] = -0.00158730158730158*G0_;
    A[17] = -0.00238095238095238*G0_;
    A[18] = -0.00238095238095238*G0_;
    A[19] = -0.00158730158730158*G0_;
    A[20] = 0.000396825396825396*G0_;
    A[21] = 0.000396825396825396*G0_;
    A[22] = 0.00238095238095238*G0_;
    A[23] = 0.000396825396825396*G0_;
    A[24] = -0.00158730158730159*G0_;
    A[25] = -0.00238095238095238*G0_;
    A[26] = -0.00158730158730158*G0_;
    A[27] = -0.00238095238095238*G0_;
    A[28] = -0.00158730158730159*G0_;
    A[29] = -0.00238095238095238*G0_;
    A[30] = 0.000396825396825396*G0_;
    A[31] = 0.000396825396825396*G0_;
    A[32] = 0.000396825396825396*G0_;
    A[33] = 0.00238095238095238*G0_;
    A[34] = -0.00158730158730159*G0_;
    A[35] = -0.00158730158730159*G0_;
    A[36] = -0.00238095238095238*G0_;
    A[37] = -0.00158730158730159*G0_;
    A[38] = -0.00238095238095238*G0_;
    A[39] = -0.00238095238095238*G0_;
    A[40] = -0.00238095238095238*G0_;
    A[41] = -0.00238095238095238*G0_;
    A[42] = -0.00158730158730159*G0_;
    A[43] = -0.00158730158730159*G0_;
    A[44] = 0.0126984126984127*G0_;
    A[45] = 0.00634920634920635*G0_;
    A[46] = 0.00634920634920635*G0_;
    A[47] = 0.00634920634920635*G0_;
    A[48] = 0.00634920634920634*G0_;
    A[49] = 0.00317460317460317*G0_;
    A[50] = -0.00238095238095238*G0_;
    A[51] = -0.00158730158730158*G0_;
    A[52] = -0.00238095238095238*G0_;
    A[53] = -0.00158730158730159*G0_;
    A[54] = 0.00634920634920635*G0_;
    A[55] = 0.0126984126984127*G0_;
    A[56] = 0.00634920634920635*G0_;
    A[57] = 0.00634920634920635*G0_;
    A[58] = 0.00317460317460317*G0_;
    A[59] = 0.00634920634920635*G0_;
    A[60] = -0.00238095238095238*G0_;
    A[61] = -0.00158730158730158*G0_;
    A[62] = -0.00158730158730159*G0_;
    A[63] = -0.00238095238095238*G0_;
    A[64] = 0.00634920634920635*G0_;
    A[65] = 0.00634920634920635*G0_;
    A[66] = 0.0126984126984127*G0_;
    A[67] = 0.00317460317460317*G0_;
    A[68] = 0.00634920634920634*G0_;
    A[69] = 0.00634920634920635*G0_;
    A[70] = -0.00158730158730158*G0_;
    A[71] = -0.00238095238095238*G0_;
    A[72] = -0.00238095238095238*G0_;
    A[73] = -0.00158730158730159*G0_;
    A[74] = 0.00634920634920635*G0_;
    A[75] = 0.00634920634920635*G0_;
    A[76] = 0.00317460317460317*G0_;
    A[77] = 0.0126984126984127*G0_;
    A[78] = 0.00634920634920635*G0_;
    A[79] = 0.00634920634920635*G0_;
    A[80] = -0.00158730158730158*G0_;
    A[81] = -0.00238095238095238*G0_;
    A[82] = -0.00158730158730159*G0_;
    A[83] = -0.00238095238095238*G0_;
    A[84] = 0.00634920634920634*G0_;
    A[85] = 0.00317460317460317*G0_;
    A[86] = 0.00634920634920634*G0_;
    A[87] = 0.00634920634920635*G0_;
    A[88] = 0.0126984126984127*G0_;
    A[89] = 0.00634920634920634*G0_;
    A[90] = -0.00158730158730158*G0_;
    A[91] = -0.00158730158730158*G0_;
    A[92] = -0.00238095238095238*G0_;
    A[93] = -0.00238095238095238*G0_;
    A[94] = 0.00317460317460317*G0_;
    A[95] = 0.00634920634920635*G0_;
    A[96] = 0.00634920634920635*G0_;
    A[97] = 0.00634920634920635*G0_;
    A[98] = 0.00634920634920634*G0_;
    A[99] = 0.0126984126984127*G0_;
  }

};


class projection_cell_integral_1_otherwise: public ufc::cell_integral
{
public:

  projection_cell_integral_1_otherwise() : ufc::cell_integral()
  {
    
  }

  ~projection_cell_integral_1_otherwise() override
  {
    
  }

  const std::vector<bool> & enabled_coefficients() const final override
  {
    static const std::vector<bool> enabled({true});
    return enabled;
  }

  void tabulate_tensor(double * A,
                       const double * const * w,
                       const double * coordinate_dofs,
                       int cell_orientation) const final override
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    10
    // Number of operations (multiply-add pairs) for tensor contraction: 95
    // Total number of operations (multiply-add pairs):                  108
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    const double G0_3 = det*w[0][3]*(1.0);
    const double G0_4 = det*w[0][4]*(1.0);
    const double G0_5 = det*w[0][5]*(1.0);
    const double G0_6 = det*w[0][6]*(1.0);
    const double G0_7 = det*w[0][7]*(1.0);
    const double G0_8 = det*w[0][8]*(1.0);
    const double G0_9 = det*w[0][9]*(1.0);
    
    // Compute element tensor
    A[0] = 0.00238095238095238*G0_0 + 0.000396825396825395*G0_1 + 0.000396825396825396*G0_2 + 0.000396825396825396*G0_3 - 0.00238095238095238*G0_4 - 0.00238095238095238*G0_5 - 0.00238095238095238*G0_6 - 0.00158730158730158*G0_7 - 0.00158730158730158*G0_8 - 0.00158730158730158*G0_9;
    A[1] = 0.000396825396825395*G0_0 + 0.00238095238095238*G0_1 + 0.000396825396825396*G0_2 + 0.000396825396825396*G0_3 - 0.00238095238095238*G0_4 - 0.00158730158730158*G0_5 - 0.00158730158730158*G0_6 - 0.00238095238095238*G0_7 - 0.00238095238095238*G0_8 - 0.00158730158730158*G0_9;
    A[2] = 0.000396825396825396*G0_0 + 0.000396825396825396*G0_1 + 0.00238095238095238*G0_2 + 0.000396825396825396*G0_3 - 0.00158730158730159*G0_4 - 0.00238095238095238*G0_5 - 0.00158730158730158*G0_6 - 0.00238095238095238*G0_7 - 0.00158730158730159*G0_8 - 0.00238095238095238*G0_9;
    A[3] = 0.000396825396825396*G0_0 + 0.000396825396825396*G0_1 + 0.000396825396825396*G0_2 + 0.00238095238095238*G0_3 - 0.00158730158730159*G0_4 - 0.00158730158730159*G0_5 - 0.00238095238095238*G0_6 - 0.00158730158730159*G0_7 - 0.00238095238095238*G0_8 - 0.00238095238095238*G0_9;
    A[4] = -0.00238095238095238*G0_0 - 0.00238095238095238*G0_1 - 0.00158730158730159*G0_2 - 0.00158730158730159*G0_3 + 0.0126984126984127*G0_4 + 0.00634920634920635*G0_5 + 0.00634920634920635*G0_6 + 0.00634920634920635*G0_7 + 0.00634920634920634*G0_8 + 0.00317460317460317*G0_9;
    A[5] = -0.00238095238095238*G0_0 - 0.00158730158730158*G0_1 - 0.00238095238095238*G0_2 - 0.00158730158730159*G0_3 + 0.00634920634920635*G0_4 + 0.0126984126984127*G0_5 + 0.00634920634920635*G0_6 + 0.00634920634920635*G0_7 + 0.00317460317460317*G0_8 + 0.00634920634920635*G0_9;
    A[6] = -0.00238095238095238*G0_0 - 0.00158730158730158*G0_1 - 0.00158730158730159*G0_2 - 0.00238095238095238*G0_3 + 0.00634920634920635*G0_4 + 0.00634920634920635*G0_5 + 0.0126984126984127*G0_6 + 0.00317460317460317*G0_7 + 0.00634920634920634*G0_8 + 0.00634920634920635*G0_9;
    A[7] = -0.00158730158730158*G0_0 - 0.00238095238095238*G0_1 - 0.00238095238095238*G0_2 - 0.00158730158730159*G0_3 + 0.00634920634920635*G0_4 + 0.00634920634920635*G0_5 + 0.00317460317460317*G0_6 + 0.0126984126984127*G0_7 + 0.00634920634920635*G0_8 + 0.00634920634920635*G0_9;
    A[8] = -0.00158730158730158*G0_0 - 0.00238095238095238*G0_1 - 0.00158730158730159*G0_2 - 0.00238095238095238*G0_3 + 0.00634920634920634*G0_4 + 0.00317460317460317*G0_5 + 0.00634920634920634*G0_6 + 0.00634920634920635*G0_7 + 0.0126984126984127*G0_8 + 0.00634920634920634*G0_9;
    A[9] = -0.00158730158730158*G0_0 - 0.00158730158730158*G0_1 - 0.00238095238095238*G0_2 - 0.00238095238095238*G0_3 + 0.00317460317460317*G0_4 + 0.00634920634920635*G0_5 + 0.00634920634920635*G0_6 + 0.00634920634920635*G0_7 + 0.00634920634920634*G0_8 + 0.0126984126984127*G0_9;
  }

};


class projection_form_0: public ufc::form
{
public:

  projection_form_0() : ufc::form()
  {
    // Do nothing
  }

  ~projection_form_0() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "a51045c932d5633d5d0ff6cdd2e7ce24aa471d34d3138fa9f6ef66a34ea4b26e9ebbb1cd35672bdfa134dda3b16c96171fd390bdf703e731853c65e7b1cbc57a";
  }

  std::size_t rank() const final override
  {
    return 2;
  }

  std::size_t num_coefficients() const final override
  {
    return 0;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new projection_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new projection_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new projection_finite_element_2();
        break;
      }
    case 1:
      {
        return new projection_finite_element_2();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new projection_dofmap_2();
        break;
      }
    case 1:
      {
        return new projection_dofmap_2();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return false;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new projection_cell_integral_0_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};


class projection_form_1: public ufc::form
{
public:

  projection_form_1() : ufc::form()
  {
    // Do nothing
  }

  ~projection_form_1() override
  {
    // Do nothing
  }

  const char * signature() const final override
  {
    return "b46f48f12472849460aaeef75428df45f03cbf7e5e71982657486800128cac564af2c7e6859be4ca7806acf21213e185a39ae9199ece9584b2159606163cd264";
  }

  std::size_t rank() const final override
  {
    return 1;
  }

  std::size_t num_coefficients() const final override
  {
    return 1;
  }

  std::size_t original_coefficient_position(std::size_t i) const final override
  {
    static const std::vector<std::size_t> position({0});
    return position[i];
  }

  ufc::finite_element * create_coordinate_finite_element() const final override
  {
    return new projection_finite_element_1();
  }

  ufc::dofmap * create_coordinate_dofmap() const final override
  {
    return new projection_dofmap_1();
   }

  ufc::coordinate_mapping * create_coordinate_mapping() const final override
  {
    return nullptr;
  }

  ufc::finite_element * create_finite_element(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new projection_finite_element_2();
        break;
      }
    case 1:
      {
        return new projection_finite_element_2();
        break;
      }
    }
    
    return 0;
  }

  ufc::dofmap * create_dofmap(std::size_t i) const final override
  {
    switch (i)
    {
    case 0:
      {
        return new projection_dofmap_2();
        break;
      }
    case 1:
      {
        return new projection_dofmap_2();
        break;
      }
    }
    
    return 0;
  }

  std::size_t max_cell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_exterior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interior_facet_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_vertex_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_custom_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_cutcell_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_interface_subdomain_id() const final override
  {
    return 0;
  }

  std::size_t max_overlap_subdomain_id() const final override
  {
    return 0;
  }

  bool has_cell_integrals() const final override
  {
    return true;
  }

  bool has_exterior_facet_integrals() const final override
  {
    return false;
  }

  bool has_interior_facet_integrals() const final override
  {
    return false;
  }

  bool has_vertex_integrals() const final override
  {
    return false;
  }

  bool has_custom_integrals() const final override
  {
    return false;
  }

  bool has_cutcell_integrals() const final override
  {
    return false;
  }

  bool has_interface_integrals() const final override
  {
    return false;
  }

  bool has_overlap_integrals() const final override
  {
    return false;
  }

  ufc::cell_integral * create_cell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::exterior_facet_integral * create_exterior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_interior_facet_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_vertex_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::custom_integral * create_custom_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_cutcell_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::interface_integral * create_interface_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_overlap_integral(std::size_t subdomain_id) const final override
  {
    return 0;
  }

  ufc::cell_integral * create_default_cell_integral() const final override
  {
    return new projection_cell_integral_1_otherwise();
  }

  ufc::exterior_facet_integral * create_default_exterior_facet_integral() const final override
  {
    return 0;
  }

  ufc::interior_facet_integral * create_default_interior_facet_integral() const final override
  {
    return 0;
  }

  ufc::vertex_integral * create_default_vertex_integral() const final override
  {
    return 0;
  }

  ufc::custom_integral * create_default_custom_integral() const final override
  {
    return 0;
  }

  ufc::cutcell_integral * create_default_cutcell_integral() const final override
  {
    return 0;
  }

  ufc::interface_integral * create_default_interface_integral() const final override
  {
    return 0;
  }

  ufc::overlap_integral * create_default_overlap_integral() const final override
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/mesh/Mesh.h>
#include <dolfin/mesh/MultiMesh.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/fem/MultiMeshForm.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/MultiMeshFunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>
#include <dolfin/function/MultiMeshCoefficientAssigner.h>
#include <dolfin/adaptivity/ErrorControl.h>
#include <dolfin/adaptivity/GoalFunctional.h>
#include <dolfin/la/GenericVector.h>

namespace Projection
{

class CoefficientSpace_f: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  CoefficientSpace_f(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<projection_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<projection_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  CoefficientSpace_f(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<projection_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<projection_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_a_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_a_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<projection_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<projection_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_a_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<projection_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<projection_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_a_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_a_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<projection_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<projection_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_a_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<projection_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<projection_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_a_MultiMeshFunctionSpace_0: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_a_MultiMeshFunctionSpace_0(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_a_FunctionSpace_0(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

class Form_a_MultiMeshFunctionSpace_1: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_a_MultiMeshFunctionSpace_1(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_a_FunctionSpace_1(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

class Form_a: public dolfin::Form
{
public:

  // Constructor
  Form_a(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = std::make_shared<const projection_form_0>();
  }

  // Destructor
  ~Form_a()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return "unnamed";
  }

  // Typedefs
  typedef Form_a_FunctionSpace_0 TestSpace;
  typedef Form_a_FunctionSpace_1 TrialSpace;
  typedef Form_a_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_a_MultiMeshFunctionSpace_1 MultiMeshTrialSpace;

  // Coefficients
};

class MultiMeshForm_a: public dolfin::MultiMeshForm
{
public:

  // Constructor
  MultiMeshForm_a(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V1, std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0):
    dolfin::MultiMeshForm(V1, V0)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<const dolfin::Form> a(new Form_a(V1->part(part), V0->part(part)));
      add(a);
    }

    // Build multimesh form
    build();

    /// Assign coefficients

  }

  // Destructor
  ~MultiMeshForm_a()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "There are no coefficients");
    return "unnamed";
  }

  // Typedefs
  typedef Form_a_FunctionSpace_0 TestSpace;
  typedef Form_a_FunctionSpace_1 TrialSpace;
  typedef Form_a_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_a_MultiMeshFunctionSpace_1 MultiMeshTrialSpace;

  // Coefficients
};

class Form_L_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  // Constructor for standard function space
  Form_L_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<projection_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<projection_dofmap_2>(), *mesh))
  {
    // Do nothing
  }

  // Constructor for constrained function space
  Form_L_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::make_shared<const dolfin::FiniteElement>(std::make_shared<projection_finite_element_2>()),
                          std::make_shared<const dolfin::DofMap>(std::make_shared<projection_dofmap_2>(), *mesh, constrained_domain))
  {
    // Do nothing
  }

};

class Form_L_MultiMeshFunctionSpace_0: public dolfin::MultiMeshFunctionSpace
{
public:

  // Constructor for multimesh function space
  Form_L_MultiMeshFunctionSpace_0(std::shared_ptr<const dolfin::MultiMesh> multimesh): dolfin::MultiMeshFunctionSpace(multimesh)
  {
    // Create and add standard function spaces
    for (std::size_t part = 0; part < multimesh->num_parts(); part++)
    {
      std::shared_ptr<const dolfin::FunctionSpace> V(new Form_L_FunctionSpace_0(multimesh->part(part)));
      add(V);
    }

    // Build multimesh function space
    build();
  }

};

typedef CoefficientSpace_f Form_L_FunctionSpace_1;

class Form_L: public dolfin::Form
{
public:

  // Constructor
  Form_L(std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    _ufc_form = std::make_shared<const projection_form_1>();
  }

  // Constructor
  Form_L(std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    this->f = f;

    _ufc_form = std::make_shared<const projection_form_1>();
  }

  // Destructor
  ~Form_L()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_L_FunctionSpace_0 TestSpace;
  typedef Form_L_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_L_FunctionSpace_1 CoefficientSpace_f;

  // Coefficients
  dolfin::CoefficientAssigner f;
};

class MultiMeshForm_L: public dolfin::MultiMeshForm
{
public:

  // Constructor
  MultiMeshForm_L(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0):
    dolfin::MultiMeshForm(V0), f(*this, 0)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<const dolfin::Form> a(new Form_L(V0->part(part)));
      add(a);
    }

    // Build multimesh form
    build();

    /// Assign coefficients

  }

  // Constructor
  MultiMeshForm_L(std::shared_ptr<const dolfin::MultiMeshFunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::MultiMeshForm(V0), f(*this, 0)
  {
    // Create and add standard forms
    std::size_t num_parts = V0->num_parts(); // assume all equal and pick first
    for (std::size_t part = 0; part < num_parts; part++)
    {
      std::shared_ptr<const dolfin::Form> a(new Form_L(V0->part(part)));
      add(a);
    }

    // Build multimesh form
    build();

    /// Assign coefficients
    this->f = f;

  }

  // Destructor
  ~MultiMeshForm_L()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_L_FunctionSpace_0 TestSpace;
  typedef Form_L_MultiMeshFunctionSpace_0 MultiMeshTestSpace;
  typedef Form_L_FunctionSpace_1 CoefficientSpace_f;

  // Coefficients
  dolfin::MultiMeshCoefficientAssigner f;
};

// Class typedefs
typedef Form_a BilinearForm;
typedef MultiMeshForm_a MultiMeshBilinearForm;
typedef Form_a JacobianForm;
typedef MultiMeshForm_a MultiMeshJacobianForm;
typedef Form_L LinearForm;
typedef MultiMeshForm_L MultiMeshLinearForm;
typedef Form_L ResidualForm;
typedef MultiMeshForm_L MultiMeshResidualForm;
typedef Form_a::TestSpace FunctionSpace;
typedef Form_a::MultiMeshTestSpace MultiMeshFunctionSpace;

}

#endif
