# -*- coding: utf-8 -*-
"""The function module of dolfin"""

from dolfin.functions import functionspace
from dolfin.functions import function
from dolfin.functions import constant
from dolfin.functions import expression
from dolfin.functions import specialfunctions

from .functionspace import *
from .function import *
from .constant import *
from .expression import *
from .specialfunctions  import *

# NOTE: The automatic documentation system in DOLFIN requires to _not_ define
# NOTE: classes or functions within this file. Use separate modules for that
# NOTE: purpose.

__all__ = functionspace.__all__ + function.__all__ + constant.__all__ + \
          expression.__all__ + specialfunctions.__all__
